/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.container.portlet.impl;

import com.iplanet.sso.SSOToken;
import com.sun.portal.common.logging.Level;
import com.sun.portal.common.logging.Logger;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.portlet.CacheManager;
import com.sun.portal.container.portlet.PortletCacheEntry;
import com.sun.portal.container.portlet.PreferenceManager;
import com.sun.portal.container.portlet.impl.DispatcherState;
import com.sun.portal.container.portlet.impl.PAERequestWrapper;
import com.sun.portal.container.portlet.impl.PortletContainerUtility;
import com.sun.portal.portletcontainercommon.PortletContainerActionRequest;
import com.sun.portal.portletcontainercommon.PortletContainerActionResponse;
import com.sun.portal.portletcontainercommon.PortletContainerErrorCode;
import com.sun.portal.portletcontainercommon.PortletContainerRenderRequest;
import com.sun.portal.portletcontainercommon.PortletContainerRenderResponse;
import com.sun.portal.portletcontainercommon.PortletContainerResponse;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletPreferences;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortletContainer
implements Container {
    private PreferenceManager _preferenceManager;
    private CacheManager _cacheManager;
    private Logger _logger;
    private ServletContext sctx;
    private boolean serializeAll;
    private String sessionInvalid;
    private static ArrayList actionList;
    private static ArrayList renderList;
    private static final String PAE_NAME = "/servlet/PortletAppEngineServlet";
    private static final String DISPATCHER_STATE = "__dispatcherState__";
    private static String HTTP_SESSION_ID;
    private static final String FIRST_THREAD = "javax.portlet.pc.first_thread";
    private static final String SESSION_INVALID = "javax.portlet.session_invalid";

    void init(ServletContext sc) {
        this._logger = (Logger)sc.getAttribute("logger");
        this._preferenceManager = (PreferenceManager)sc.getAttribute("preference_manager");
        this._cacheManager = (CacheManager)sc.getAttribute("cache_manager");
        this.sctx = sc;
        String serverInfo = sc.getServerInfo();
        if (serverInfo != null && serverInfo.indexOf("Sun ONE") >= 0) {
            this.serializeAll = false;
            this.sessionInvalid = "true";
        } else {
            this.serializeAll = true;
            this.sessionInvalid = "false";
        }
    }

    public void getMarkup(GetMarkupRequest request, GetMarkupResponse response) throws ContainerException, ContentException {
        String entityID = request.getEntityID();
        PortletContainerRenderResponse pcr = null;
        ContentException contentException = null;
        boolean authlessUser = request.getUserID() == null;
        boolean isInViewMode = request.getChannelMode().equals((Object)ChannelMode.VIEW);
        PortletCacheEntry pce = null;
        if (!authlessUser && isInViewMode) {
            if (request.getIsTarget()) {
                this._cacheManager.removeCachedPortlet((ContainerRequest)request);
            } else {
                pce = this._cacheManager.getCachedPortlet((ContainerRequest)request);
            }
        }
        try {
            if (pce == null) {
                pcr = (PortletContainerRenderResponse)this.invokePAE("RENDER", (ContainerRequest)request, (ContainerResponse)response);
                PortletContainerErrorCode errorCode = pcr.getErrorCode();
                if (errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                    int expiration_cache;
                    if (!authlessUser && isInViewMode && ((expiration_cache = pcr.getExpiration()) > 0 || expiration_cache == -1)) {
                        pce = new PortletCacheEntry(1, pcr.getMarkup(), pcr.getTitle(), expiration_cache);
                        this._cacheManager.putCachedPortlet((ContainerRequest)request, pce);
                    }
                } else {
                    if (this._logger.isLoggable(Level.SEVERE)) {
                        this._logger.log(Level.SEVERE, "PortletContainer:getMarkup(): Exception thrown from render() of " + entityID + " with error code " + errorCode);
                    }
                    contentException = new ContentException("PortletContainer.getMarkup(): Exception thrown from render() of " + entityID, (ErrorCode)errorCode);
                }
            } else {
                response.setMarkup(pce.getCachedContent());
                response.setTitle(pce.getTitleResource());
            }
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.getMarkup():getting content ", (Throwable)e);
        }
        if (contentException != null) {
            throw contentException;
        }
    }

    public void executeAction(ExecuteActionRequest request, ExecuteActionResponse response) throws ContainerException, ContentException {
        String entityID = request.getEntityID();
        PortletContainerActionResponse pcres = null;
        ContentException contentException = null;
        this._cacheManager.removeCachedPortlet((ContainerRequest)request);
        try {
            pcres = (PortletContainerActionResponse)this.invokePAE("ACTION", (ContainerRequest)request, (ContainerResponse)response);
            PortletContainerErrorCode errorCode = pcres.getErrorCode();
            if (!errorCode.equals((Object)PortletContainerErrorCode.NO_ERROR)) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, "PortletContainer:executeAction(): Exception thrown from processAction() of " + entityID + " with error code " + errorCode);
                }
                contentException = new ContentException("PortletContainer.executeAction(): Exception thrown from processAction() of " + entityID, (ErrorCode)errorCode);
            }
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.executeAction(): ", (Throwable)e);
        }
        if (contentException != null) {
            throw contentException;
        }
    }

    public void getResources(GetResourceRequest request, GetResourceResponse response) throws ContainerException {
        String entityID = request.getEntityID();
        String appName = PortletContainerUtility.getAppNameFromEntityID(entityID);
        String portletName = PortletContainerUtility.getPortletNameFromEntityID(entityID);
        ServletContext context = this.sctx.getContext(appName);
        try {
            Map resources = (Map)context.getAttribute("portlet_resources");
            ResourceBundle bundle = this.getResourceBundle(resources, portletName, request.getLocale());
            response.setResource(bundle);
        }
        catch (Exception e) {
            throw new ContainerException("PortletContainer.getResources(): ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortletContainerResponse invokePAE(String action, ContainerRequest request, ContainerResponse response) throws IOException, ServletException {
        PortletContainerRenderResponse pcres;
        PortletContainerRenderRequest pcreq;
        HttpServletRequest req = request.getHttpServletRequest();
        HttpServletResponse res = response.getHttpServletResponse();
        String entityID = request.getEntityID();
        String appName = PortletContainerUtility.getAppNameFromEntityID(entityID);
        String portletName = PortletContainerUtility.getPortletNameFromEntityID(entityID);
        if (this._logger.isLoggable(Level.INFO)) {
            StringBuffer sb = new StringBuffer("PortletContainer.invokePAE(): invoking:\n");
            sb.append("app name ");
            sb.append(appName);
            sb.append("\nportlet name ");
            sb.append(portletName);
            sb.append("\naction ");
            sb.append(action);
            this._logger.log(Level.INFO, sb.toString());
        }
        PortletPreferences pp = this._preferenceManager.getPortletPreferences(request);
        if (action.equals("RENDER")) {
            pcreq = new PortletContainerRenderRequest((GetMarkupRequest)request);
            pcres = new PortletContainerRenderResponse((GetMarkupResponse)response);
            pcreq.setActions((List)renderList);
        } else {
            pcreq = new PortletContainerActionRequest((ExecuteActionRequest)request);
            pcres = new PortletContainerActionResponse((ExecuteActionResponse)response);
            pcreq.setActions((List)actionList);
        }
        ProviderContext pc = this.getProviderContext(request);
        SSOToken token = (SSOToken)req.getAttribute("sso_token");
        pcreq.setSSOToken(token);
        pcreq.setPortletPreferences(pp);
        pcreq.setPortletName(portletName);
        pcreq.setLocale(pc.getLocale());
        PAERequestWrapper reqWrapper = new PAERequestWrapper(req);
        reqWrapper.setAttribute("portlet_container_request", pcreq);
        reqWrapper.setAttribute("portlet_container_response", pcres);
        DispatcherState ds = null;
        boolean sessionEnabled = true;
        String channel = PortletContainerUtility.getChannelNameFromEntityID(entityID);
        try {
            sessionEnabled = pc.getBooleanProperty(channel, "sessionEnabled");
        }
        catch (ProviderContextException pce) {
            // empty catch block
        }
        boolean authlessUser = request.getUserID() == null;
        while (true) {
            HttpServletRequest httpServletRequest = req;
            synchronized (httpServletRequest) {
                ds = (DispatcherState)req.getAttribute(DISPATCHER_STATE);
                if (ds == null) {
                    ds = new DispatcherState();
                    req.setAttribute(DISPATCHER_STATE, (Object)ds);
                }
                if (!ds.canEnter(appName, sessionEnabled, this.serializeAll)) {
                    try {
                        req.wait();
                    }
                    catch (InterruptedException e) {}
                } else {
                    this.handleSession(request, authlessUser);
                    reqWrapper.setAttribute(HTTP_SESSION_ID, this.getSessionId(pc, authlessUser));
                    break;
                }
            }
        }
        ServletContext context = this.sctx.getContext(appName);
        RequestDispatcher rd = context.getRequestDispatcher(PAE_NAME);
        rd.include((ServletRequest)reqWrapper, (ServletResponse)res);
        HttpServletRequest httpServletRequest = req;
        synchronized (httpServletRequest) {
            if (ds.exit()) {
                req.notifyAll();
            }
        }
        return pcres;
    }

    private void handleSession(ContainerRequest request, boolean authlessUser) {
        HttpServletRequest req = request.getHttpServletRequest();
        req.setAttribute(SESSION_INVALID, (Object)this.sessionInvalid);
        ProviderContext pc = this.getProviderContext(request);
        HttpSession hs = null;
        if (!this.isSessionIdExist(pc, authlessUser) && (hs = req.getSession(false)) != null) {
            hs.invalidate();
            req.setAttribute(SESSION_INVALID, (Object)"true");
        }
        if (req.getAttribute(FIRST_THREAD) == null) {
            hs = req.getSession(true);
            this.setSessionId(pc, authlessUser, hs.getId());
            req.setAttribute(FIRST_THREAD, (Object)Boolean.TRUE);
        } else {
            hs = req.getSession(false);
        }
    }

    private boolean isSessionIdExist(ProviderContext pc, boolean authlessUser) {
        boolean retValue = false;
        retValue = authlessUser ? pc.getClientProperty(HTTP_SESSION_ID) != null : pc.getSessionProperty(HTTP_SESSION_ID) != null;
        return retValue;
    }

    private void setSessionId(ProviderContext pc, boolean authlessUser, String sessionID) {
        if (authlessUser) {
            pc.setClientProperty(HTTP_SESSION_ID, sessionID);
        } else {
            pc.setSessionProperty(HTTP_SESSION_ID, (Object)sessionID);
        }
    }

    private String getSessionId(ProviderContext pc, boolean authlessUser) {
        String sID = null;
        sID = authlessUser ? pc.getClientProperty(HTTP_SESSION_ID) : (String)pc.getSessionProperty(HTTP_SESSION_ID);
        return sID;
    }

    protected ProviderContext getProviderContext(ContainerRequest request) {
        HttpServletRequest req = request.getHttpServletRequest();
        return (ProviderContext)req.getAttribute("provider_context");
    }

    private ResourceBundle getResourceBundle(Map resourceMap, String portlet, Locale locale) {
        ResourceBundle retval = null;
        if (resourceMap != null && portlet != null) {
            Map resBundleMap;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((resBundleMap = (Map)resourceMap.get(portlet)) != null) {
                retval = (ResourceBundle)resBundleMap.get(locale.toString());
            }
        }
        return retval;
    }

    static {
        HTTP_SESSION_ID = "javax.portlet.http_session_id";
        actionList = new ArrayList();
        renderList = new ArrayList();
        actionList.add("ACTION");
        renderList.add("RENDER");
    }
}

