/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.containers.jsp.table;

import com.sun.portal.desktop.util.Integers;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.containers.JSPContainerProviderAdapter;
import com.sun.portal.providers.containers.UnsupportedWindowStateException;
import com.sun.portal.providers.context.ContainerProviderContext;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.util.PropertyUtil;
import com.sun.portal.providers.util.ProviderOrder;
import com.sun.portal.providers.util.ProviderProperties;
import com.sun.portal.providers.util.UnknownLayoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSPTableContainerProvider
extends JSPContainerProviderAdapter
implements ProviderProperties {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 3;
    public static final int TOP = 4;
    public static final int BOTTOM = 5;
    private static int[] supportedStates = new int[3];

    public void init(String n, HttpServletRequest httpreq) throws ProviderException {
        super.init(n, httpreq);
        ContainerProviderContext cpc = this.getContainerProviderContext();
        boolean parallelChannelsInit = false;
        try {
            parallelChannelsInit = cpc.getBooleanProperty(this.getName(), "parallelChannelsInit");
        }
        catch (ProviderContextException pce) {
            cpc.debugError("JSPTableContainerProvider.init(): count not get parallelChannelsInit");
        }
        if (parallelChannelsInit) {
            cpc.initProviders(httpreq, n, this.getSelectedChannels(), 0);
        }
    }

    public int getLayout() throws ProviderException {
        int layout = this.getIntegerProperty("layout");
        if (layout < 1 || layout > 4) {
            throw new UnknownLayoutException("TableContainerProvider:getLayout");
        }
        return layout;
    }

    public void setLayout(int lo) throws ProviderException {
        this.setIntegerProperty("layout", lo);
    }

    public int getTimeout() throws ProviderException {
        int timeout = this.getIntegerProperty("timeout");
        return timeout;
    }

    public Map setupColumns(HttpServletRequest req) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        List selectedChannels = this.getSelectedChannels();
        List providerOrder = ProviderOrder.order(selectedChannels, this.getName(), cpc, req);
        ArrayList<String> leftList = new ArrayList<String>();
        ArrayList<String> centerList = new ArrayList<String>();
        ArrayList<String> rightList = new ArrayList<String>();
        ArrayList<String> fullTopList = new ArrayList<String>();
        ArrayList<String> fullBottomList = new ArrayList<String>();
        Map channelsColumn = null;
        String defaultChannelColumn = null;
        try {
            channelsColumn = pc.getCollectionProperty(this.getName(), "channelsColumn");
            defaultChannelColumn = pc.getStringProperty(this.getName(), "defaultChannelColumn");
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.setupColumns(): Could not get channelsColumn", pce);
        }
        int layout = this.getLayout();
        List allProviders = this.getAvailableChannels();
        Iterator i = providerOrder.iterator();
        block21: while (i.hasNext()) {
            String providerName = (String)i.next();
            if (!allProviders.contains(providerName)) continue;
            Provider p = null;
            p = cpc.getProvider(req, this.getName(), providerName);
            if (p == null || !p.isPresentable(req)) continue;
            int column = -1;
            int width = -1;
            try {
                width = p.getWidth();
                String val = PropertyUtil.getStringValueFromMap(channelsColumn, providerName, defaultChannelColumn);
                column = Integer.parseInt(val);
                if (pc.isDebugMessageEnabled()) {
                    pc.debugMessage("TableContainerProvider.setupColumns(): got column: " + column);
                }
            }
            catch (NumberFormatException e) {
                pc.debugError("TableContainerProvider.setupColumns(): got NumberFormatException for column");
            }
            catch (Throwable e) {
                pc.debugError("TableContainerProvider.setupColumns(): width property is not found for: " + p.getName());
            }
            if (width == -1) continue;
            switch (width) {
                case 1: {
                    switch (layout) {
                        case 1: {
                            leftList.add(providerName);
                            continue block21;
                        }
                        case 2: {
                            rightList.add(providerName);
                            continue block21;
                        }
                        case 3: {
                            if (column == 1) {
                                leftList.add(providerName);
                                continue block21;
                            }
                            rightList.add(providerName);
                            continue block21;
                        }
                    }
                    leftList.add(providerName);
                    continue block21;
                }
                case 0: {
                    switch (layout) {
                        case 1: {
                            rightList.add(providerName);
                            continue block21;
                        }
                        case 2: {
                            leftList.add(providerName);
                            continue block21;
                        }
                        case 3: {
                            centerList.add(providerName);
                            continue block21;
                        }
                    }
                    rightList.add(providerName);
                    continue block21;
                }
                case 2: {
                    fullTopList.add(providerName);
                    continue block21;
                }
                case 3: {
                    fullBottomList.add(providerName);
                    continue block21;
                }
            }
            pc.debugError("TableContainerProvider.setupColumns(): unknown width for channel:" + providerName);
        }
        HashMap<Integer, ArrayList<String>> columnMap = new HashMap<Integer, ArrayList<String>>();
        columnMap.put(Integers.get(1), leftList);
        columnMap.put(Integers.get(2), rightList);
        columnMap.put(Integers.get(3), centerList);
        columnMap.put(Integers.get(4), fullTopList);
        columnMap.put(Integers.get(5), fullBottomList);
        return columnMap;
    }

    public int getWidths(int column) throws ProviderException {
        int centerWidth = -1;
        int rightWidth = -1;
        int leftWidth = -1;
        ProviderContext pc = this.getProviderContext();
        int layout = this.getLayout();
        switch (layout) {
            case 1: {
                leftWidth = 30;
                rightWidth = 70;
                break;
            }
            case 2: {
                rightWidth = 30;
                leftWidth = 70;
                break;
            }
            case 3: {
                rightWidth = 25;
                centerWidth = 50;
                leftWidth = 25;
                break;
            }
            default: {
                rightWidth = 30;
                leftWidth = 70;
            }
        }
        switch (column) {
            case 1: {
                return leftWidth;
            }
            case 2: {
                return rightWidth;
            }
            case 3: {
                return centerWidth;
            }
        }
        pc.debugError("TableContainerProvider.setupColumns(): unknown column");
        return -1;
    }

    public String getColumn(HttpServletRequest req, String channel) throws ProviderException {
        return this.getChStringAttrFromMap(req, channel, "channelsColumn", null, "1");
    }

    public String getRow(HttpServletRequest req, String channel) throws ProviderException {
        return this.getChStringAttrFromMap(req, channel, "channelsRow", null, "1");
    }

    private String getChStringAttrFromMap(HttpServletRequest req, String channel, String mapKey, String defKey, String def) throws ProviderException {
        String defVal = null;
        Map mapVal = new HashMap();
        String val = def;
        ProviderContext pc = this.getProviderContext();
        try {
            mapVal = pc.getCollectionProperty(this.getName(), mapKey);
            if (defKey != null && pc.existsStringProperty(this.getName(), defKey)) {
                defVal = pc.getStringProperty(this.getName(), defKey);
                val = PropertyUtil.getStringValueFromMap(mapVal, channel, defVal);
            } else {
                val = PropertyUtil.getStringValueFromMap(mapVal, channel, def);
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.getChStringAttrFromMap() ", pce);
        }
        return val;
    }

    public void setColumn(HttpServletRequest req, String channel, int column) throws ProviderException {
        this.setChStringAttrInMap(req, channel, "channelsColumn", Integer.toString(column));
    }

    public void setRow(HttpServletRequest req, String channel, int row) throws ProviderException {
        this.setChStringAttrInMap(req, channel, "channelsRow", new Integer(row).toString());
    }

    private void setChStringAttrInMap(HttpServletRequest req, String channel, String mapKey, String value) throws ProviderException {
        ProviderContext pc = this.getProviderContext();
        try {
            Map mapVal = pc.getCollectionProperty(this.getName(), mapKey);
            String val = (String)mapVal.get(channel);
            if (val != null) {
                mapVal.remove(channel);
            }
            mapVal.put(channel, value);
            pc.setCollectionProperty(this.getName(), mapKey, mapVal);
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.setChStringAttrInMap() ", pce);
        }
    }

    private void setupEmptyPage(HttpServletRequest req) throws ProviderException {
        StringBuffer content = new StringBuffer();
        ResourceBundle bundle = this.getResourceBundle();
        String warning = "WARNING: No provider is available!!";
        if (bundle != null) {
            warning = bundle.getString("warning_no_providers_available");
        }
        req.setAttribute("emptyPage", (Object)"true");
        req.setAttribute("errorMsg", (Object)warning);
    }

    public URL processEdit(HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        Map channelsIsDetached = null;
        Object channelsIsMinimized = null;
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        String channelAction = req.getParameter(this.getName() + ".channelAction");
        String targetProvider = req.getParameter(this.getName() + ".targetProvider");
        URL url = null;
        try {
            if (channelAction != null) {
                channelsIsDetached = pc.getCollectionProperty(this.getName(), "channelsIsDetached");
            }
            if (channelAction.equals("detach")) {
                Boolean detach_value = new Boolean(true);
                channelsIsDetached.put(targetProvider, detach_value);
                pc.setCollectionProperty(this.getName(), "channelsIsDetached", channelsIsDetached);
            } else if (channelAction.equals("attach")) {
                Boolean detach_value = new Boolean(false);
                channelsIsDetached.put(targetProvider, detach_value);
                pc.setCollectionProperty(this.getName(), "channelsIsDetached", channelsIsDetached);
            } else if (channelAction.equals("minimize")) {
                this.setWindowState(targetProvider, 1);
            } else if (channelAction.equals("maximize")) {
                this.setWindowState(targetProvider, 2);
            } else if (channelAction.equals("truemaximize")) {
                this.setWindowState(targetProvider, 3);
            } else if (channelAction.equals("remove")) {
                String maximizedChannel;
                List userProviders = this.getSelectedChannels();
                userProviders.remove(targetProvider);
                this.setSelectedChannels(userProviders);
                if (channelsIsDetached.containsKey(targetProvider)) {
                    Boolean detach_value = new Boolean(false);
                    channelsIsDetached.put(targetProvider, detach_value);
                    pc.setCollectionProperty(this.getName(), "channelsIsDetached", channelsIsDetached);
                }
                if (pc.getProviderVersion(this.getName()) > 1 && (maximizedChannel = this.getStringProperty("maximizedChannel")).equalsIgnoreCase(targetProvider)) {
                    this.setStringProperty("maximizedChannel", "");
                }
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.processEdit(): ", pce);
        }
        return url;
    }

    public String getWindowName(String channelName) {
        String window_name = this.getName() + channelName + "_detached";
        String new_window_name = PropertyUtil.replaceChannelName(URLEncoder.encode(window_name));
        return new_window_name;
    }

    public int getPopupWindowWidth(HttpServletRequest req, String channelName) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        int pwidth = 0;
        Provider p = null;
        p = cpc.getProvider(req, this.getName(), channelName);
        int width = p.getWidth();
        try {
            if (width != -1) {
                switch (width) {
                    case 2: {
                        pwidth = pc.getIntegerProperty(this.getName(), "fullwidth_popup_width");
                        break;
                    }
                    case 3: {
                        pwidth = pc.getIntegerProperty(this.getName(), "fullwidth_popup_width");
                        break;
                    }
                    case 1: {
                        pwidth = pc.getIntegerProperty(this.getName(), "thin_popup_width");
                        break;
                    }
                    case 0: {
                        pwidth = pc.getIntegerProperty(this.getName(), "thick_popup_width");
                        break;
                    }
                    default: {
                        pc.debugError("TableContainerProvider.buildPage(): unknown width=" + width);
                    }
                }
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.getPopupWindowWidth(): ", pce);
        }
        return pwidth;
    }

    public int getPopupWindowHeight(HttpServletRequest req, String channelName) throws ProviderException {
        ContainerProviderContext cpc = this.getContainerProviderContext();
        ProviderContext pc = this.getProviderContext();
        Provider p = null;
        int pheight = 0;
        p = cpc.getProvider(req, this.getName(), channelName);
        int width = p.getWidth();
        try {
            if (width != -1) {
                switch (width) {
                    case 2: {
                        pheight = pc.getIntegerProperty(this.getName(), "fullwidth_popup_height");
                        break;
                    }
                    case 3: {
                        pheight = pc.getIntegerProperty(this.getName(), "fullwidth_popup_height");
                        break;
                    }
                    case 1: {
                        pheight = pc.getIntegerProperty(this.getName(), "thin_popup_height");
                        break;
                    }
                    case 0: {
                        pheight = pc.getIntegerProperty(this.getName(), "thick_popup_height");
                        break;
                    }
                    default: {
                        pc.debugError("TableContainerProvider.buildPage(): unknown width=" + width);
                    }
                }
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.getPopupWindowHeight(): ", pce);
        }
        return pheight;
    }

    public void genMinimizedContent(Map channelsIsMinimized, List nonMinimizedList, Map content, boolean dIsMinimized) throws ProviderException {
        List pList = this.getSelectedChannels();
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            String provider = (String)i.next();
            boolean isMinimized = PropertyUtil.getBooleanValueFromMap(channelsIsMinimized, provider, dIsMinimized);
            if (!isMinimized) continue;
            nonMinimizedList.remove(provider);
            content.put(provider, new StringBuffer(""));
        }
    }

    public int getWindowState(String channelName) throws ProviderException {
        try {
            Map channelsIsMinimized = this.getProviderContext().getCollectionProperty(this.getName(), "channelsIsMinimized");
            String maximizedChannel = "";
            if (this.getProviderContext().getProviderVersion(this.getName()) > 1) {
                maximizedChannel = this.getStringProperty("maximizedChannel");
            }
            if (channelsIsMinimized.containsKey(channelName) && ((Boolean)channelsIsMinimized.get(channelName)).booleanValue()) {
                return 1;
            }
            if (maximizedChannel.equalsIgnoreCase(channelName)) {
                return 3;
            }
            return 2;
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("JSPTableContainerProvider.getWindowState: ", pce);
        }
    }

    public void setWindowState(String channelName, int windowState) throws UnsupportedWindowStateException {
        block10: {
            try {
                Map channelsIsMinimized = this.getProviderContext().getCollectionProperty(this.getName(), "channelsIsMinimized");
                String maximizedChannel = "";
                if (this.getProviderContext().getProviderVersion(this.getName()) > 1) {
                    maximizedChannel = this.getStringProperty("maximizedChannel");
                }
                if (windowState == 1) {
                    Boolean minimize_value = Boolean.TRUE;
                    channelsIsMinimized.put(channelName, minimize_value);
                    this.getProviderContext().setCollectionProperty(this.getName(), "channelsIsMinimized", channelsIsMinimized);
                    if (maximizedChannel.equalsIgnoreCase(channelName)) {
                        this.setStringProperty("maximizedChannel", "");
                    }
                    break block10;
                }
                if (windowState == 2) {
                    Boolean maximize_value = Boolean.FALSE;
                    channelsIsMinimized.put(channelName, maximize_value);
                    this.getProviderContext().setCollectionProperty(this.getName(), "channelsIsMinimized", channelsIsMinimized);
                    if (maximizedChannel.equalsIgnoreCase(channelName)) {
                        this.setStringProperty("maximizedChannel", "");
                    }
                    break block10;
                }
                if (windowState == 3) {
                    if (this.getProviderContext().getProviderVersion(this.getName()) <= 1) {
                        throw new UnsupportedWindowStateException("window state MAXIMIZE is not supported");
                    }
                    this.setStringProperty("maximizedChannel", channelName);
                    Boolean minimize_value = Boolean.FALSE;
                    channelsIsMinimized.put(channelName, minimize_value);
                    this.getProviderContext().setCollectionProperty(this.getName(), "channelsIsMinimized", channelsIsMinimized);
                    break block10;
                }
                throw new UnsupportedWindowStateException("window state passed in is not supported");
            }
            catch (ProviderContextException pce) {
                throw new UnsupportedWindowStateException("JSPTableContainerProvider.setWindowState: ", pce);
            }
            catch (ProviderException pe) {
                throw new UnsupportedWindowStateException("JSPTableContainerProvider.setWindowState: ", pe);
            }
        }
    }

    public int[] getSupportedWindowStates() throws ProviderException {
        return supportedStates;
    }

    static {
        JSPTableContainerProvider.supportedStates[0] = 1;
        JSPTableContainerProvider.supportedStates[1] = 2;
        JSPTableContainerProvider.supportedStates[2] = 3;
    }
}

