/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.dp.xml;

import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPPropertyHolder;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPProperties;
import com.sun.portal.desktop.dp.xml.XMLDPPropertyHolder;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPTags;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDPProvider
extends XMLDPPropertyHolder
implements DPProvider,
DPTypes,
XMLDPTags {
    static long ccount = 0L;

    XMLDPProvider(DPContext dpc, DPRoot r, Element e) {
        super(dpc, r, e);
        this.getProviderVersion();
        if (this.isPerfMessageEnabled()) {
            this.perfMessage("XMLDPProvider.XMLDPProvider(): ccount=" + ++ccount);
        }
    }

    XMLDPProvider(DPContext dpc, DPRoot r, Document d, String name, String className, int providerVersion) {
        this(dpc, r, XMLDPProvider.createElement(dpc, d, name, className, providerVersion, XMLDPProperties.createElement(dpc, d)));
    }

    public void checkType() {
        if (!this.getElement().getTagName().equals(this.getTag())) {
            throw new DPError("XMLDPProvider.checkType(): wrong type tagName=" + this.getElement().getTagName());
        }
    }

    public DPPropertyHolder getParentPropertyHolder() {
        return this.getRoot();
    }

    public String getTag() {
        return "Provider";
    }

    public short getType() {
        return 12;
    }

    public String getClassName() {
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPProvider dpp = (DPProvider)i.next();
            if (!dpp.isLocked()) continue;
            if (dpp.isRemove()) {
                return null;
            }
            return dpp.getClassName();
        }
        if (this.isDummy()) {
            return ((DPProvider)this.getLastMerger()).getClassName();
        }
        return this.getClassNameFromThis();
    }

    String getClassNameFromThis() {
        return this.getElement().getAttribute("class");
    }

    public void setClassName(String className) {
        this.getElement().setAttribute("class", className);
    }

    public int getProviderVersion() {
        Iterator i = this.getMergers().iterator();
        while (i.hasNext()) {
            DPProvider dpp = (DPProvider)i.next();
            if (!dpp.isLocked()) continue;
            if (dpp.isRemove()) {
                return -1;
            }
            return dpp.getProviderVersion();
        }
        if (this.isDummy()) {
            return ((DPProvider)this.getLastMerger()).getProviderVersion();
        }
        return this.getProviderVersionFromThis();
    }

    public int getProviderVersionFromThis() {
        int version = -1;
        String versionStr = this.getElement().getAttribute("version");
        if (versionStr == null || versionStr.length() == 0) {
            version = 1;
        } else {
            try {
                version = Integer.parseInt(versionStr);
            }
            catch (NumberFormatException nfe) {
                throw new DPError("XMLDPProvider.getProviderVersionFromThis(): not a valid version number = " + versionStr);
            }
        }
        return version;
    }

    public void setProviderVersion(int version) {
        this.getElement().setAttribute("version", Integer.toString(version));
    }

    public DPProvider copy(DPRoot dpr, boolean deep) {
        XMLDPRoot xmldpr = (XMLDPRoot)dpr;
        Document ownerDocument = xmldpr.getElement().getOwnerDocument();
        Element copyElement = (Element)ownerDocument.importNode(this.getElement(), deep);
        if (!deep) {
            copyElement.appendChild(ownerDocument.importNode(XMLDPProvider.getChildElement(this.getElement(), "Properties", null), false));
        }
        return XMLDPFactory.getInstance().getProvider(this.getContext(), dpr, copyElement);
    }

    public DPProvider createDummy(DPRoot dpr) {
        DPProvider dpp = this.copy(dpr, false);
        dpp.setDummy(true);
        dpp.setDefaults();
        return dpp;
    }

    protected Element getMergedElement() {
        XMLDPProperties xp = (XMLDPProperties)this.getProperties();
        Element e = XMLDPProvider.createElement(this.getContext(), this.getDocument(), this.getName(), this.getClassName(), this.getProviderVersion(), xp.getMergedElement());
        return e;
    }

    static Element createElement(DPContext dpc, Document d, String name, String className, int providerVersion, Element propertiesElement) {
        Element e = XMLDPProvider.createElement(dpc, d, "Provider", name);
        e.setAttribute("class", className);
        e.setAttribute("version", Integer.toString(providerVersion));
        e.appendChild(propertiesElement);
        return e;
    }

    public void appendProviderVersionAttr(StringBuffer b) {
        if (this.getProviderVersionFromThis() != 1) {
            b.append(" version=\"").append(this.getProviderVersionFromThis()).append("\"");
        }
    }

    public void toXML(StringBuffer b, int indent) {
        if (this.isDummy()) {
            return;
        }
        this.indentBuffer(b, indent);
        this.appendStartTag(b);
        b.append(" name=\"").append(this.getName()).append("\"").append(" class=\"").append(this.getClassNameFromThis()).append("\"");
        this.appendMergeAttr(b);
        this.appendLockAttr(b);
        this.appendAdvancedAttr(b);
        this.appendProviderVersionAttr(b);
        b.append(">\n");
        this.getPropertiesFromThis().toXML(b, indent + 1);
        this.indentBuffer(b, indent);
        this.appendEndTag(b);
    }
}

