/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PropertiesDPUserContext
implements DPUserContext {
    protected static final String DEFAULT_FILENAME = "/etc/opt/SUNWps/dp-user-context.properties";
    protected static final String DOCUMENTPATH_KEY = "documentPath";
    protected DesktopContext desktopContext = null;
    protected Properties properties = new Properties();
    protected static FilenameFilter dpFilenameFilter = new DPDocumentFilenameFilter();

    public PropertiesDPUserContext() {
        this(DEFAULT_FILENAME);
    }

    public PropertiesDPUserContext(String filename) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(filename));
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.PropertiesDPContext()", ioe);
        }
    }

    public void init(HttpServletRequest req) {
        this.desktopContext = DesktopContextThreadLocalizer.get();
        if (this.desktopContext == null) {
            throw new ContextError("PropertiesDPContext.init(): desktop context was null");
        }
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.desktopContext = DesktopContextThreadLocalizer.get();
        if (this.desktopContext == null) {
            throw new ContextError("PropertiesDPContext.init(): desktop context was null");
        }
    }

    protected DesktopContext getDesktopContext() {
        return this.desktopContext;
    }

    public Set getDPDocumentNames() {
        File docPath = new File(this.getDPDocumentPath());
        File[] dpDocuments = docPath.listFiles(dpFilenameFilter);
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < dpDocuments.length; ++i) {
            File f = dpDocuments[i];
            names.add(f.toString());
        }
        return names;
    }

    public String getDPDocument(String name) {
        File f = new File(name);
        return this.readFile(f).toString();
    }

    public byte[] getDPUserDocument() {
        String path = this.getDPDocumentPath();
        if (path == null) {
            throw new ContextError("DPContext.getDPUserDocument(): path was null");
        }
        File f = new File(path, "dp-user.xml");
        if (!f.exists()) {
            return null;
        }
        if (!f.canRead()) {
            return null;
        }
        StringBuffer buf = this.readFile(f);
        return buf.toString().getBytes();
    }

    public void storeDPUserDocument(String dp) {
        String path = this.getDPDocumentPath();
        if (path == null) {
            throw new ContextError("DPContext.getDPUserDocument(): path was null");
        }
        File f = new File(path, "dp-user.xml");
        this.writeFile(f, dp);
    }

    protected StringBuffer readFile(File f) {
        if (!f.canRead()) {
            throw new ContextError("PropertiesDPContext.readFile(): cannot read file: " + f);
        }
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                buf.append(line);
            }
            br.close();
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.readFile(): ", ioe);
        }
        return buf;
    }

    protected void writeFile(File f, String s) {
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ioe) {
                throw new ContextError("PropertiesDPContext.writeFile(): failed to create file: " + f, ioe);
            }
        }
        if (!f.canWrite()) {
            throw new ContextError("PropertiesDPContext.writeFile(): cannot write to file: " + f);
        }
        try {
            BufferedReader br = new BufferedReader(new StringReader(s));
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
            bw.close();
            br.close();
        }
        catch (IOException ioe) {
            throw new ContextError("PropertiesDPContext.writeFile(): ", ioe);
        }
    }

    public long getDPUserDocumentLastModified() {
        return -1L;
    }

    public long getDPDocumentLastModified(String name) {
        return -1L;
    }

    public long getDPUserDocumentLastRead() {
        return -1L;
    }

    public long getDPDocumentLastRead(String name) {
        return -1L;
    }

    protected String getDPDocumentPath() {
        String filename = this.properties.getProperty(DOCUMENTPATH_KEY);
        return filename;
    }

    public short getDebugLevel() {
        return this.desktopContext.getDebugLevel();
    }

    public void setDebugLevel(short level) {
        this.desktopContext.setDebugLevel(level);
    }

    public boolean isDebugWarningEnabled() {
        return this.desktopContext.isDebugWarningEnabled();
    }

    public boolean isDebugMessageEnabled() {
        return this.desktopContext.isDebugMessageEnabled();
    }

    public void debugMessage(Object o) {
        this.desktopContext.debugMessage(o);
    }

    public void debugWarning(Object o) {
        this.desktopContext.debugWarning(o);
    }

    public void debugError(Object o) {
        this.desktopContext.debugError(o);
    }

    public void debugMessage(Object o, Throwable t) {
        this.desktopContext.debugMessage(o, t);
    }

    public void debugWarning(Object o, Throwable t) {
        this.desktopContext.debugWarning(o, t);
    }

    public void debugError(Object o, Throwable t) {
        this.desktopContext.debugError(o, t);
    }

    public boolean isPerfMessageEnabled() {
        return this.desktopContext.isDebugMessageEnabled();
    }

    public boolean isPerfWarningEnabled() {
        return this.desktopContext.isDebugWarningEnabled();
    }

    public void perfMessage(Object o) {
        this.desktopContext.debugMessage(o);
    }

    public void perfWarning(Object o) {
        this.desktopContext.debugWarning(o);
    }

    protected void setDPUserDocumentLastModified() {
    }

    protected void setDPUserDocumentLastRead() {
    }

    protected void setDPDocumentLastRead(String name) {
    }

    private static class DPDocumentFilenameFilter
    implements FilenameFilter {
        private DPDocumentFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name.equals("dp-user.xml")) {
                return false;
            }
            if (!name.startsWith("dp-")) {
                return false;
            }
            return name.endsWith(".xml");
        }
    }
}

