/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop;

import com.sun.portal.desktop.DesktopError;
import com.sun.portal.desktop.PerfData;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.util.Iterator;
import java.util.Map;

public class PerfThreadLocalizer {
    private static ThreadLocal perfDataThreadLocal = new ThreadLocal();
    private static int index = 0;
    private static DesktopAppContext desktopAppContext = null;
    private static boolean enabled = false;

    private PerfThreadLocalizer() {
    }

    public static PerfData getPerfData() {
        if (!enabled) {
            return null;
        }
        PerfData pd = (PerfData)perfDataThreadLocal.get();
        if (pd == null) {
            throw new DesktopError("PerfThreadLocalizer.getPerfData(): no thread local set for this thread");
        }
        return pd;
    }

    public static int mark() {
        if (!enabled) {
            return -1;
        }
        Long l = new Long(System.currentTimeMillis());
        PerfData pd = PerfThreadLocalizer.getPerfData();
        Map m = pd.getMarksMap();
        int i = index++;
        m.put(Integer.toString(i), l);
        return i;
    }

    public static void add(int i, String key) {
        if (!enabled) {
            return;
        }
        PerfData pd = PerfThreadLocalizer.getPerfData();
        Map p = pd.getPerfMap();
        PerfStat pf = (PerfStat)p.get(key);
        Map m = pd.getMarksMap();
        Long mark = (Long)m.get(Integer.toString(i));
        if (mark == null) {
            throw new DesktopError("PerfThreadLocalizer.add(): no mark for index=" + i + ", key=" + key);
        }
        long elapsed = System.currentTimeMillis() - mark;
        if (pf == null) {
            pf = new PerfStat(elapsed);
            p.put(key, pf);
        } else {
            ++pf.count;
            pf.total += elapsed;
        }
        m.remove(key);
    }

    public static void add(int i, String key, long elapsed) {
        if (!enabled) {
            return;
        }
        PerfData pd = PerfThreadLocalizer.getPerfData();
        Map p = pd.getPerfMap();
        PerfStat pf = (PerfStat)p.get(key);
        if (pf == null) {
            pf = new PerfStat(elapsed);
            p.put(key, pf);
        } else {
            ++pf.count;
            pf.total += elapsed;
        }
    }

    public static void set(PerfData pd) {
        desktopAppContext = DesktopAppContextThreadLocalizer.get();
        enabled = desktopAppContext.isPerfErrorEnabled();
        if (!enabled) {
            return;
        }
        if (pd == null) {
            pd = new PerfData();
        }
        perfDataThreadLocal.set(pd);
    }

    public static void clear() {
        if (!enabled) {
            return;
        }
        perfDataThreadLocal.set(null);
    }

    public static String results() {
        if (!enabled) {
            return null;
        }
        PerfData pd = PerfThreadLocalizer.getPerfData();
        Map p = pd.getPerfMap();
        StringBuffer b = new StringBuffer();
        Iterator i = p.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            PerfStat pf = (PerfStat)p.get(key);
            b.append(key + "=" + pf + "\n");
        }
        return b.toString();
    }

    private static class PerfStat {
        long total = 0L;
        long count = 1L;

        public PerfStat(long elapsed) {
            this.total = elapsed;
        }

        public String toString() {
            double avg = (double)this.total / (double)this.count;
            return "{ count=" + this.count + ", total=" + this.total + ", avg=" + avg + " }";
        }
    }
}

