/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.servlet;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.sun.portal.netmail.servlet.NetMailContext;
import com.sun.portal.netmail.servlet.NetMailSession;
import com.sun.portal.netmail.servlet.ParseQueryString;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NetMailServlet
extends HttpServlet {
    private final String packageName = "com.sun.portal.netmail.servlet";
    private Hashtable sessions = new Hashtable();
    private String title = "";
    private String badContextMsg = "";
    private long lastSessionCheck = System.currentTimeMillis();
    private static final long sessionCheckInterval = 300000L;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n;
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getQueryString();
        if (string2 != null && string2.length() > 0) {
            string = string + "?" + string2;
        }
        if ((n = string.indexOf("NetMailServlet")) == -1 || string.length() <= n + 16) {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setContentType("text/html");
            servletOutputStream.println("<html><body text=#000000 bgcolor=#FFFFFF><p>Welcome to NetMail.</body></html>");
            return;
        }
        if (string.charAt(n + 14) == '?') {
            string2 = string.substring(n + 15);
        } else {
            int n2 = string.lastIndexOf("/");
            string2 = string.substring(n + 15, n2);
        }
        Hashtable hashtable = ParseQueryString.parse(string2);
        NetMailSession netMailSession = this.getSession(httpServletRequest, hashtable, httpServletResponse);
        if (netMailSession != null) {
            netMailSession.doGet(httpServletRequest, hashtable, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Hashtable hashtable = ParseQueryString.parse(httpServletRequest.getQueryString());
        NetMailSession netMailSession = this.getSession(httpServletRequest, hashtable, httpServletResponse);
        if (netMailSession != null) {
            netMailSession.doPost(httpServletRequest, hashtable, httpServletResponse);
        }
    }

    synchronized NetMailSession getSession(HttpServletRequest httpServletRequest, Hashtable hashtable, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray = (String[])hashtable.get("nsid");
        if (stringArray == null || stringArray.length != 1) {
            throw new ServletException("bad request query string: " + httpServletRequest.getQueryString());
        }
        httpServletResponse.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        String string = stringArray[0];
        hashtable.remove("nsid");
        NetMailSession netMailSession = null;
        if (!string.startsWith("new")) {
            this.checkForExpiredSessions();
            netMailSession = (NetMailSession)this.sessions.get(string);
            if (netMailSession == null || !netMailSession.updateContext(httpServletRequest)) {
                String string2 = this.determineHTMLCharset(httpServletRequest);
                if (httpServletRequest.getMethod().equalsIgnoreCase("POST") && httpServletRequest.getContentType().equals("application/x-netmail-data")) {
                    httpServletResponse.setContentType("application/x-netmail-timeout");
                } else {
                    httpServletResponse.setContentType("text/html; charset=" + string2);
                }
                this.writeInvalidSessionMessage(httpServletResponse, string2);
                return null;
            }
            netMailSession.setLastAccessed(System.currentTimeMillis());
            return netMailSession;
        }
        try {
            this.checkForExpiredSessions();
            String string3 = string.substring(3);
            Class<?> clazz = Class.forName("com.sun.portal.netmail.servlet." + string3);
            netMailSession = (NetMailSession)clazz.newInstance();
            netMailSession.setOwner(this);
            String[] stringArray2 = (String[])hashtable.get("context");
            if (stringArray2 == null) {
                stringArray2 = new String[]{"PortalServerContext"};
            }
            Class<?> clazz2 = Class.forName("com.sun.portal.netmail.servlet." + stringArray2[0]);
            netMailSession.setContext((NetMailContext)clazz2.newInstance());
            boolean bl = netMailSession.updateContext(httpServletRequest);
            netMailSession.determineHTMLCharset(httpServletRequest);
            if (this.title.equals("")) {
                this.title = netMailSession.getString("ns.a");
                this.badContextMsg = netMailSession.getString("ns.b");
            }
            if (!bl) {
                String string4 = this.determineHTMLCharset(httpServletRequest);
                httpServletResponse.setContentType("text/html; charset=" + string4);
                this.writeInvalidSessionMessage(httpServletResponse, string4);
                return null;
            }
            netMailSession.setLastAccessed(System.currentTimeMillis());
            this.sessions.put(netMailSession.getId(), netMailSession);
            return netMailSession;
        }
        catch (Exception exception) {
            System.out.println("NetMailServlet.getSession: " + exception);
            exception.printStackTrace();
            throw new ServletException("NetMailServlet.getSession" + exception);
        }
    }

    private void writeInvalidSessionMessage(HttpServletResponse httpServletResponse, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), string)));
        printWriter.println("<html><head><title>" + this.title + "</title></head>");
        printWriter.println("<body text=#000000 bgcolor=#FFFFFF>");
        printWriter.println(this.badContextMsg);
        printWriter.println("</body></html>");
        printWriter.close();
    }

    private String determineHTMLCharset(HttpServletRequest httpServletRequest) {
        String string = "UTF-8";
        try {
            Locale locale = Locale.getDefault();
            AMClientDetector aMClientDetector = new AMClientDetector();
            String string2 = aMClientDetector.getClientType(httpServletRequest);
            Client client = Client.getInstance((String)string2);
            string = client.getCharset(locale);
        }
        catch (ClientException clientException) {
            clientException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    synchronized void removeSession(NetMailSession netMailSession) {
        if (this.sessions.containsKey(netMailSession.getId())) {
            netMailSession.close();
            this.sessions.remove(netMailSession.getId());
        }
    }

    void checkForExpiredSessions() {
        if (System.currentTimeMillis() - this.lastSessionCheck < 300000L) {
            return;
        }
        this.lastSessionCheck = System.currentTimeMillis();
        Hashtable hashtable = (Hashtable)this.sessions.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            NetMailSession netMailSession = (NetMailSession)enumeration.nextElement();
            if (!netMailSession.isValid()) {
                netMailSession.debug("removing session " + netMailSession.getId() + " because it is no longer valid");
                this.removeSession(netMailSession);
                continue;
            }
            if (System.currentTimeMillis() - netMailSession.getLastAccessed() <= 300000L) continue;
            netMailSession.close();
        }
    }
}

