/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.xml.bind.validator.Locator;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerToEventHandler
implements ErrorHandler {
    private ValidationEventHandler veh = null;
    private Locator locator = null;

    private void propagateEvent(int severity, SAXParseException saxException) throws SAXException {
        boolean result;
        ValidationEventLocator vel = this.locator.getLocation(saxException);
        ValidationEventImpl ve = new ValidationEventImpl(severity, saxException.getMessage(), vel);
        Exception e = saxException.getException();
        if (e != null) {
            ve.setLinkedException((Throwable)e);
        } else {
            ve.setLinkedException((Throwable)saxException);
        }
        try {
            result = this.veh.handleEvent((ValidationEvent)ve);
        }
        catch (RuntimeException re) {
            result = false;
        }
        if (!result) {
            throw saxException;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.propagateEvent(1, exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.propagateEvent(2, exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.propagateEvent(0, exception);
    }

    public ErrorHandlerToEventHandler(ValidationEventHandler handler, Locator locator) {
        this.veh = handler;
        this.locator = locator;
    }
}

