/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.jsp.jasper3.jasper.compiler;

import com.sun.portal.providers.jsp.jasper3.jasper.Constants;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class EscapeUnicodeWriter
extends Writer {
    private OutputStream out = null;
    private byte[] bytes = new byte[6];

    public EscapeUnicodeWriter(OutputStream out) {
        this.out = out;
    }

    public void write(char[] buf, int off, int len) throws IOException {
        if (this.out == null) {
            throw new IOException(Constants.getString("jsp.error.stream.closed"));
        }
        int ci = off;
        int end = off + len;
        while (--len >= 0) {
            int ch;
            if (((ch = buf[off++] & 0xFFFF) < 32 || ch > 126) && ch != 10 && ch != 13 && ch != 9) {
                this.bytes[0] = 92;
                this.bytes[1] = 117;
                this.bytes[2] = (byte)Character.forDigit((ch & 0xF000) >> 12, 16);
                this.bytes[3] = (byte)Character.forDigit((ch & 0xF00) >> 8, 16);
                this.bytes[4] = (byte)Character.forDigit((ch & 0xF0) >> 4, 16);
                this.bytes[5] = (byte)Character.forDigit((ch & 0xF) >> 0, 16);
                this.out.write(this.bytes);
                continue;
            }
            this.out.write((byte)ch);
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
    }
}

