/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.writer;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.writer.LiteralSerializerWriterBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.wsdl.document.schema.BuiltInTypes;
import com.sun.xml.rpc.wsdl.document.soap.SOAP12Constants;
import com.sun.xml.rpc.wsdl.document.soap.SOAPConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class LiteralSimpleSerializerWriter
extends LiteralSerializerWriterBase
implements GeneratorConstants {
    private String encoder = null;
    private String serializerMemberName;
    private LiteralType dataType;
    private static Map encoderMap = null;

    static {
        encoderMap = new HashMap();
        encoderMap.put(BuiltInTypes.BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(BuiltInTypes.BYTE, "XSDByteEncoder");
        encoderMap.put(BuiltInTypes.BASE64_BINARY, null);
        encoderMap.put(BuiltInTypes.HEX_BINARY, null);
        encoderMap.put(BuiltInTypes.DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(BuiltInTypes.FLOAT, "XSDFloatEncoder");
        encoderMap.put(BuiltInTypes.INT, "XSDIntEncoder");
        encoderMap.put(BuiltInTypes.INTEGER, "XSDIntegerEncoder");
        encoderMap.put(BuiltInTypes.LONG, "XSDLongEncoder");
        encoderMap.put(BuiltInTypes.SHORT, "XSDShortEncoder");
        encoderMap.put(BuiltInTypes.DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(BuiltInTypes.DATE_TIME, null);
        encoderMap.put(BuiltInTypes.STRING, "XSDStringEncoder");
        encoderMap.put(BuiltInTypes.QNAME, "XSDQNameEncoder");
        encoderMap.put(BuiltInTypes.TIME, "XSDTimeEncoder");
        encoderMap.put(BuiltInTypes.NMTOKENS, "XSDListTypeEncoder");
        encoderMap.put(BuiltInTypes.IDREFS, "XSDListTypeEncoder");
        encoderMap.put(BuiltInTypes.POSITIVE_INTEGER, "XSDPositiveIntegerEncoder");
        encoderMap.put(BuiltInTypes.NON_POSITIVE_INTEGER, "XSDNonPositiveIntegerEncoder");
        encoderMap.put(BuiltInTypes.NEGATIVE_INTEGER, "XSDNegativeIntegerEncoder");
        encoderMap.put(BuiltInTypes.NON_NEGATIVE_INTEGER, "XSDNonNegativeIntegerEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_LONG, "XSDUnsignedLongEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_INT, "XSDUnsignedIntEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_SHORT, "XSDUnsignedShortEncoder");
        encoderMap.put(BuiltInTypes.UNSIGNED_BYTE, "XSDUnsignedByteEncoder");
        encoderMap.put(BuiltInTypes.DATE, "XSDDateTimeCalendarEncoder");
        encoderMap.put(BuiltInTypes.LIST, "XSDListTypeEncoder");
        encoderMap.put(BuiltInTypes.ANY_SIMPLE_URTYPE, "XSDStringEncoder");
        if (!VersionUtil.isJavaVersionGreaterThan1_3()) {
            encoderMap.put(BuiltInTypes.ANY_URI, "XSDStringEncoder");
        } else {
            encoderMap.put(BuiltInTypes.ANY_URI, "XSDAnyURIEncoder");
        }
        encoderMap.put(SOAPConstants.QNAME_TYPE_BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_BYTE, "XSDByteEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_FLOAT, "XSDFloatEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_INT, "XSDIntEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_LONG, "XSDLongEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_SHORT, "XSDShortEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAPConstants.QNAME_TYPE_STRING, "XSDStringEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_QNAME, "XSDQNameEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_TIME, "XSDTimeEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_NMTOKENS, "XSDListTypeEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_IDREFS, "XSDListTypeEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_POSITIVE_INTEGER, "XSDPositiveIntegerEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_NON_POSITIVE_INTEGER, "XSDNonPositiveIntegerEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_NEGATIVE_INTEGER, "XSDNegativeIntegerEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_NON_NEGATIVE_INTEGER, "XSDNonNegativeIntegerEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_UNSIGNED_LONG, "XSDUnsignedLongEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_UNSIGNED_INT, "XSDUnsignedIntEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_UNSIGNED_SHORT, "XSDUnsignedShortEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_UNSIGNED_BYTE, "XSDUnsignedByteEncoder");
        encoderMap.put(SOAPConstants.QNAME_TYPE_DATE, "XSDDateTimeCalendarEncoder");
        if (!VersionUtil.isJavaVersionGreaterThan1_3()) {
            encoderMap.put(SOAPConstants.QNAME_TYPE_ANY_URI, "XSDStringEncoder");
        } else {
            encoderMap.put(SOAPConstants.QNAME_TYPE_ANY_URI, "XSDAnyURIEncoder");
        }
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BOOLEAN, "XSDBooleanEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BYTE, "XSDByteEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_BASE64_BINARY, null);
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DOUBLE, "XSDDoubleEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_FLOAT, "XSDFloatEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_INT, "XSDIntEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_LONG, "XSDLongEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_SHORT, "XSDShortEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DECIMAL, "XSDDecimalEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DATE_TIME, null);
        encoderMap.put(SOAP12Constants.QNAME_TYPE_STRING, "XSDStringEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_QNAME, "XSDQNameEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_TIME, "XSDTimeEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_NMTOKENS, "XSDListTypeEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_IDREFS, "XSDListTypeEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_POSITIVE_INTEGER, "XSDPositiveIntegerEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_NON_POSITIVE_INTEGER, "XSDNonPositiveIntegerEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_NEGATIVE_INTEGER, "XSDNegativeIntegerEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_NON_NEGATIVE_INTEGER, "XSDNonNegativeIntegerEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_UNSIGNED_LONG, "XSDUnsignedLongEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_UNSIGNED_INT, "XSDUnsignedIntEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_UNSIGNED_SHORT, "XSDUnsignedShortEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_UNSIGNED_BYTE, "XSDUnsignedByteEncoder");
        encoderMap.put(SOAP12Constants.QNAME_TYPE_DATE, "XSDDateTimeCalendarEncoder");
        if (!VersionUtil.isJavaVersionGreaterThan1_3()) {
            encoderMap.put(SOAP12Constants.QNAME_TYPE_ANY_URI, "XSDStringEncoder");
        } else {
            encoderMap.put(SOAP12Constants.QNAME_TYPE_ANY_URI, "XSDAnyURIEncoder");
        }
    }

    public void declareSerializer(IndentingWriter p, boolean isStatic, boolean isFinal) throws IOException {
        String modifier = this.getPrivateModifier(isStatic, isFinal);
        p.pln(modifier + this.serializerName() + " " + this.serializerMemberName() + ";");
    }

    public String deserializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getEncoder() {
        return LiteralSimpleSerializerWriter.getTypeEncoder(this.type);
    }

    protected String getItemType() {
        String strType = null;
        LiteralListType lt = (LiteralListType)this.type;
        strType = lt.getItemType() instanceof LiteralEnumerationType ? new String(lt.getItemType().getJavaType().getName() + "_Encoder.getInstance(), " + lt.getItemType().getJavaType().getName() + ".class") : LiteralSimpleSerializerWriter.getTypeEncoder(lt.getItemType()) + ".getInstance(), " + lt.getItemType().getJavaType().getName() + ".class";
        if (strType == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.invalidType", new Object[]{lt.getItemType().getName().toString(), lt.getItemType().getJavaType().getName()});
        }
        return strType;
    }

    public String serializerMemberName() {
        return this.getPrefix(this.dataType) + "_" + this.serializerMemberName;
    }

    protected String getPrivateModifier(boolean isStatic, boolean isFinal) {
        return "private " + super.getModifier(isStatic, isFinal);
    }

    public LiteralSimpleSerializerWriter(LiteralType type, Names names) {
        super(type, names);
        this.dataType = type;
        this.encoder = LiteralSimpleSerializerWriter.getTypeEncoder(type);
        if (this.encoder == null) {
            throw new GeneratorException("generator.simpleTypeSerializerWriter.no.encoder.for.type", new Object[]{type.getName().toString(), type.getJavaType().getName()});
        }
        String partialSerializerName = this.encoder.substring(3, this.encoder.lastIndexOf("Encoder"));
        String serializerName = partialSerializerName + "_Serializer";
        this.serializerMemberName = names.getClassMemberName(partialSerializerName, type, "_Serializer");
    }

    public static String getTypeEncoder(AbstractType type) {
        QName name = type.getName();
        String encoder = null;
        encoder = type instanceof LiteralListType ? "XSDListTypeEncoder" : (String)encoderMap.get(name);
        if (encoder == null) {
            String javaName = type.getJavaType().getName();
            if (name.equals(BuiltInTypes.DATE_TIME) || name.equals(SOAP12Constants.QNAME_TYPE_DATE_TIME) || name.equals(SOAPConstants.QNAME_TYPE_DATE_TIME)) {
                if (javaName.equals(ModelerConstants.DATE_CLASSNAME)) {
                    encoder = "XSDDateTimeDateEncoder";
                } else if (javaName.equals(ModelerConstants.CALENDAR_CLASSNAME)) {
                    encoder = "XSDDateTimeCalendarEncoder";
                }
            } else if (name.equals(BuiltInTypes.BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64_BINARY) || name.equals(SOAP12Constants.QNAME_TYPE_BASE64_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_BASE64) || name.equals(SOAP12Constants.QNAME_TYPE_BASE64)) {
                if (javaName.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                    encoder = "XSDBase64BinaryEncoder";
                }
            } else if (name.equals(BuiltInTypes.HEX_BINARY) || name.equals(SOAPConstants.QNAME_TYPE_HEX_BINARY) || name.equals(SOAP12Constants.QNAME_TYPE_HEX_BINARY)) {
                if (javaName.equals(ModelerConstants.BYTE_ARRAY_CLASSNAME)) {
                    encoder = "XSDHexBinaryEncoder";
                }
            } else if (javaName.equals(ModelerConstants.STRING_CLASSNAME)) {
                encoder = "XSDStringEncoder";
            } else if (name.equals(BuiltInTypes.IDREF)) {
                encoder = "XSDStringEncoder";
            }
        }
        return encoder;
    }

    public void createSerializer(IndentingWriter p, StringBuffer typeName, String serName, boolean encodeTypes, boolean multiRefEncoding, String typeMapping) throws IOException {
        LiteralType type = (LiteralType)this.type;
        this.declareType(p, typeName, type.getName(), false, false);
        QName typeQName = type.getName();
        p.plnI(this.serializerName() + " " + serName + " = new " + "LiteralSimpleTypeSerializer" + "(" + typeName + ",");
        if (type instanceof LiteralListType) {
            p.pln("\"\", " + this.encoder + ".getInstance(" + this.getItemType() + "));");
        } else {
            p.pln("\"\", " + this.encoder + ".getInstance());");
        }
        p.pO();
    }
}

