/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator.nodes;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.generator.nodes.JaxRpcMappingNode;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Request;
import com.sun.xml.rpc.processor.model.Response;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralWildcardMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceEndpointInterfaceMappingNode
extends JaxRpcMappingNode {
    private static final String MYNAME = "ServiceEndpointInterfaceMappingNode";

    private String getJavaTypeName(JavaType type) {
        String typeName = type instanceof JavaStructureType && ((JavaStructureType)type).getOwner() instanceof LiteralArrayWrapperType ? ((LiteralArrayWrapperType)((JavaStructureType)type).getOwner()).getJavaArrayType().getName() : type.getName();
        this.debug(MYNAME, "getting JavaTypeName: " + type.getName() + " returned: " + typeName);
        return typeName;
    }

    public Node write(Node parent, String nodeName, Configuration config, Port port) throws Exception {
        Element node = JaxRpcMappingNode.appendChild(parent, nodeName);
        ProcessorEnvironment env = (ProcessorEnvironment)config.getEnvironment();
        JavaInterface intf = port.getJavaInterface();
        String className = env.getNames().customJavaTypeClassName(intf);
        QName portTypeQName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortTypeName");
        QName bindingQName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLBindingName");
        JaxRpcMappingNode.appendTextChild((Node)node, "service-endpoint-interface", className);
        Element wsdlPortTypeNode = (Element)JaxRpcMappingNode.appendTextChild((Node)node, "wsdl-port-type", "portTypeNS:" + portTypeQName.getLocalPart());
        wsdlPortTypeNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:portTypeNS", portTypeQName.getNamespaceURI());
        Element wsdlBindingNode = (Element)JaxRpcMappingNode.appendTextChild((Node)node, "wsdl-binding", "bindingNS:" + bindingQName.getLocalPart());
        wsdlBindingNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bindingNS", bindingQName.getNamespaceURI());
        Iterator iter = port.getOperations();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            boolean isDocument = operation.getStyle() != null && operation.getStyle().equals(SOAPStyle.DOCUMENT);
            JavaMethod method = operation.getJavaMethod();
            String methodName = method.getName();
            Request request = operation.getRequest();
            this.debug(MYNAME, "0000 request.class = " + request.getClass().getName());
            Iterator blocks = request.getBodyBlocks();
            int i = 0;
            while (blocks.hasNext()) {
                Block b = (Block)blocks.next();
                this.debug(MYNAME, "int i = " + b.getName() + "; type = " + b.getLocation());
                ++i;
            }
            QName inputMsgQName = (QName)request.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
            Response response = operation.getResponse();
            QName outputMsgQName = null;
            if (response != null) {
                outputMsgQName = (QName)response.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
            }
            boolean isWrapped = false;
            Block requestBlock = null;
            AbstractType requestType = null;
            if (request.getBodyBlockCount() > 0) {
                requestBlock = (Block)request.getBodyBlocks().next();
                requestType = requestBlock.getType();
            }
            if (isDocument && request.getBodyBlockCount() > 0 && requestType instanceof LiteralSequenceType) {
                isWrapped = ((LiteralSequenceType)requestType).isUnwrapped();
            }
            Element semNode = JaxRpcMappingNode.appendChild(node, "service-endpoint-method-mapping");
            JaxRpcMappingNode.appendTextChild((Node)semNode, "java-method-name", methodName);
            JaxRpcMappingNode.appendTextChild((Node)semNode, "wsdl-operation", operation.getName().getLocalPart());
            if (isWrapped) {
                JaxRpcMappingNode.forceAppendTextChild(semNode, "wrapped-element", null);
            }
            int paramPos = 0;
            Iterator iter2 = method.getParameters();
            while (iter2.hasNext()) {
                JavaParameter javaParam = (JavaParameter)iter2.next();
                Parameter param = javaParam.getParameter();
                Block paramBlock = param.getBlock();
                boolean soapHeader = paramBlock.getLocation() == 2;
                String paramType = null;
                String paramMode = null;
                QName wsdlMsgQName = null;
                if (javaParam.isHolder()) {
                    paramType = javaParam.getType().getName();
                    if (param.getLinkedParameter() != null) {
                        paramMode = "INOUT";
                        wsdlMsgQName = inputMsgQName;
                        this.debug(MYNAME, "0100 prameMode INOUT");
                    } else {
                        paramMode = "OUT";
                        wsdlMsgQName = outputMsgQName;
                        this.debug(MYNAME, "0200 prameMode OUT");
                    }
                } else {
                    paramMode = "IN";
                    paramType = this.getJavaTypeName(javaParam.getType());
                    wsdlMsgQName = inputMsgQName;
                    this.debug(MYNAME, "0300 prameMode IN");
                }
                if (soapHeader) {
                    wsdlMsgQName = (QName)paramBlock.getProperty("com.sun.xml.rpc.processor.model.WSDLMessageName");
                }
                this.debug(MYNAME, "0301 paramName = " + javaParam.getName() + "; soapHeader = " + soapHeader);
                String partName = null;
                partName = (String)param.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName");
                this.debug(MYNAME, "0206 property partName = " + partName);
                if (partName == null) {
                    if (soapHeader) {
                        partName = paramBlock.getType().getName().getLocalPart();
                        this.debug(MYNAME, "0302 header partName = " + partName);
                    } else {
                        JavaStructureMember javaStructMember = StubTieGeneratorBase.getJavaMember(param);
                        if (javaStructMember == null) {
                            partName = javaParam.getName();
                        } else {
                            Object owner = javaStructMember.getOwner();
                            this.debug(MYNAME, "0400 owner.class = " + owner.getClass().getName());
                            if (owner instanceof SOAPStructureMember) {
                                SOAPStructureMember soapStructMember = (SOAPStructureMember)owner;
                                partName = soapStructMember.getName().getLocalPart();
                            } else if (owner instanceof LiteralElementMember) {
                                LiteralElementMember litMember = (LiteralElementMember)owner;
                                this.debug(MYNAME, "0500 LiteralElementMember litMember.getName = " + litMember.getName());
                                this.debug(MYNAME, "0600 partName= " + (String)param.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName"));
                                partName = owner instanceof LiteralWildcardMember ? (String)param.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName") : litMember.getName().getLocalPart();
                                this.debug(MYNAME, "0700 LiteralElementMember partName = " + partName);
                            } else {
                                partName = (String)param.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName");
                                this.debug(MYNAME, "0800 partName = " + partName);
                            }
                            this.debug(MYNAME, "0303 not header partName = " + partName);
                        }
                    }
                }
                if (wsdlMsgQName == null) {
                    this.debug(MYNAME, "0900 wsdlMsgQName NULL");
                } else {
                    this.debug(MYNAME, "1000 wsdlMsgQName NOT NULL" + wsdlMsgQName);
                }
                this.debug(MYNAME, "1101 param-position = " + paramPos);
                this.debug(MYNAME, "1102 param-type = " + paramType);
                this.debug(MYNAME, "1103 partname = " + partName);
                this.debug(MYNAME, "1104 paramMode = " + paramMode);
                Element methodParamPartsNode = JaxRpcMappingNode.appendChild(semNode, "method-param-parts-mapping");
                JaxRpcMappingNode.appendTextChild((Node)methodParamPartsNode, "param-position", paramPos);
                JaxRpcMappingNode.appendTextChild((Node)methodParamPartsNode, "param-type", paramType);
                Element wsdlMsgMappingNode = JaxRpcMappingNode.appendChild(methodParamPartsNode, "wsdl-message-mapping");
                Element wsdlMsg = (Element)JaxRpcMappingNode.appendTextChild((Node)wsdlMsgMappingNode, "wsdl-message", "wsdlMsgNS:" + wsdlMsgQName.getLocalPart());
                wsdlMsg.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsdlMsgNS", wsdlMsgQName.getNamespaceURI());
                JaxRpcMappingNode.appendTextChild((Node)wsdlMsgMappingNode, "wsdl-message-part-name", partName);
                JaxRpcMappingNode.appendTextChild((Node)wsdlMsgMappingNode, "parameter-mode", paramMode);
                if (soapHeader) {
                    JaxRpcMappingNode.forceAppendTextChild(wsdlMsgMappingNode, "soap-header", null);
                }
                ++paramPos;
            }
            JavaType returnType = method.getReturnType();
            boolean hasReturn = returnType != null && !returnType.getName().equals(ModelerConstants.VOID_CLASSNAME);
            String retType = !hasReturn ? "void" : this.getJavaTypeName(method.getReturnType());
            if (hasReturn) {
                Element wsdlReturnValueNode = JaxRpcMappingNode.appendChild(semNode, "wsdl-return-value-mapping");
                JaxRpcMappingNode.appendTextChild((Node)wsdlReturnValueNode, "method-return-value", retType);
                Parameter resultParam = (Parameter)response.getParameters().next();
                JavaStructureMember resultJavaStructMember = StubTieGeneratorBase.getJavaMember(resultParam);
                String retPartName = null;
                retPartName = (String)resultParam.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName");
                this.debug(MYNAME, "RET.  partName = " + retPartName);
                if (retPartName == null) {
                    if (resultJavaStructMember == null) {
                        retPartName = resultParam.getName();
                    } else {
                        Object owner = resultJavaStructMember.getOwner();
                        this.debug(MYNAME, "return.owner.class = " + owner.getClass().getName());
                        if (owner instanceof SOAPStructureMember) {
                            retPartName = ((SOAPStructureMember)owner).getName().getLocalPart();
                        } else if (owner instanceof LiteralElementMember) {
                            LiteralElementMember litMember = (LiteralElementMember)owner;
                            retPartName = litMember.getName().getLocalPart();
                            this.debug(MYNAME, "RET. LiteralElementMember partName = " + retPartName);
                        } else {
                            retPartName = (String)resultParam.getProperty("com.sun.xml.rpc.processor.model.ParamMessagePartName");
                            this.debug(MYNAME, "RET. doc lit partName = " + retPartName);
                        }
                    }
                }
                Element wsdlMsgNode = (Element)JaxRpcMappingNode.appendTextChild((Node)wsdlReturnValueNode, "wsdl-message", "wsdlMsgNS:" + outputMsgQName.getLocalPart());
                wsdlMsgNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsdlMsgNS", outputMsgQName.getNamespaceURI());
                JaxRpcMappingNode.appendTextChild((Node)wsdlReturnValueNode, "wsdl-message-part-name", retPartName);
            }
            Iterator exceptions = method.getExceptions();
            while (exceptions.hasNext()) {
                String exception = (String)exceptions.next();
            }
        }
        return node;
    }
}

