/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.StubTieGeneratorBase;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.HeaderFault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaMethod;
import com.sun.xml.rpc.processor.model.java.JavaParameter;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.modeler.ModelerConstants;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class StubGenerator
extends StubTieGeneratorBase {
    private static final String prefix = "_";
    private String dirPath = "";

    public StubGenerator() {
    }

    protected boolean superClassHasInitialize() {
        return true;
    }

    protected boolean needsReadFirstBodyElementFor(Operation operation) {
        return operation.getResponse() != null;
    }

    public void writeGenericMethods(IndentingWriter p) throws IOException {
        super.writeGenericMethods(p);
        p.pln();
        p.plnI("public String _getEncodingStyle() {");
        p.pln("return " + this.getEncodingStyle() + ";");
        p.pOln("}");
        p.pln();
        p.plnI("public void _setEncodingStyle(String encodingStyle) {");
        p.pln("throw new UnsupportedOperationException(\"cannot set encoding style\");");
        p.pOln("}");
    }

    protected void writeImports(IndentingWriter p) throws IOException {
        super.writeImports(p);
        p.pln("import com.sun.xml.rpc.client.SenderException;");
        p.pln("import com.sun.xml.rpc.client.*;");
        p.pln("import com.sun.xml.rpc.client.http.*;");
        p.pln("import javax.xml.rpc.handler.*;");
        p.pln("import javax.xml.rpc.JAXRPCException;");
        p.pln("import javax.xml.rpc.soap.SOAPFaultException;");
    }

    protected void writeReadBodyFaultElement(IndentingWriter p) throws IOException {
        Operation operation;
        boolean hasFaults = false;
        Iterator operationsIter = this.operations.iterator();
        while (!hasFaults && operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            hasFaults = operation.getFaults().hasNext();
        }
        if (!hasFaults) {
            return;
        }
        p.pln("/*");
        p.pln(" *  this method deserializes fault responses");
        p.pln(" */");
        p.plnI("protected Object _readBodyFaultElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        p.pln("Object faultInfo = null;");
        p.pln("int opcode = state.getRequest().getOperationCode();");
        p.plnI("switch (opcode) {");
        operationsIter = this.operations.iterator();
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            if (!operation.getFaults().hasNext()) continue;
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln("faultInfo = " + this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.servicePackage, this.port, operation)) + ".deserialize(null, bodyReader, deserializationContext);");
            p.pln("break;");
            p.pO();
        }
        p.plnI("default:");
        p.pln("return super._readBodyFaultElement(bodyReader, deserializationContext, state);");
        p.pO();
        p.pOln("}");
        p.pln("return faultInfo;");
        p.pOln("}");
    }

    public StubGenerator(SOAPVersion ver) {
        super(ver);
    }

    protected String getClassName() {
        return this.env.getNames().stubFor(this.port);
    }

    protected String getInitializeAccess() {
        return "public";
    }

    protected String getPrefix() {
        return prefix;
    }

    protected String getSOAPVersion() {
        if (this.port.getSOAPVersion().equals(SOAPVersion.SOAP_12.toString())) {
            return "SOAPVersion.SOAP_12";
        }
        return "SOAPVersion.SOAP_11";
    }

    protected String getStateGetRequestResponseString() {
        return "getResponse";
    }

    protected String getStateType() {
        return "StreamingSenderState";
    }

    protected Message getMessageToDeserialize(Operation operation) {
        return operation.getResponse();
    }

    private void declareOperationMethod(IndentingWriter p, Operation operation) throws IOException {
        JavaMethod javaMethod = operation.getJavaMethod();
        String methodName = javaMethod.getName();
        JavaType resultType = javaMethod.getReturnType();
        p.pln("/*");
        p.pln(" *  implementation of " + methodName);
        p.pln(" */");
        String resultName = "void";
        if (resultType != null) {
            AbstractType literalResultType;
            resultName = resultType instanceof JavaStructureType ? ((literalResultType = (AbstractType)((JavaStructureType)resultType).getOwner()) instanceof LiteralArrayWrapperType && operation.getStyle().equals(SOAPStyle.RPC) ? ((LiteralArrayWrapperType)literalResultType).getJavaArrayType().getName() : resultType.getName()) : resultType.getName();
        }
        p.p("public " + resultName + " " + methodName + "(");
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            if (i > 0) {
                p.p(", ");
            }
            if ((javaParameter = (JavaParameter)iterator.next()).isHolder()) {
                if (javaParameter.getHolderName() == null) {
                    p.p(this.env.getNames().holderClassName(this.port, javaParameter.getType()) + " " + javaParameter.getName());
                } else {
                    p.p(javaParameter.getHolderName() + " " + javaParameter.getName());
                }
            } else {
                AbstractType paramType = javaParameter.getParameter().getType();
                if (paramType instanceof LiteralArrayWrapperType && operation.getStyle().equals(SOAPStyle.RPC)) {
                    p.p(((LiteralArrayWrapperType)paramType).getJavaArrayType().getName() + " " + javaParameter.getName());
                } else {
                    p.p(javaParameter.getType().getName() + " " + javaParameter.getName());
                }
            }
            ++i;
        }
        p.plnI(")");
        iterator = javaMethod.getExceptions();
        if (iterator.hasNext()) {
            p.p("throws ");
            int i2 = 0;
            while (iterator.hasNext()) {
                if (i2 > 0) {
                    p.p(", ");
                }
                p.p((String)iterator.next());
                ++i2;
            }
            p.p(", ");
        } else {
            p.p("throws ");
        }
        p.p("java.rmi.RemoteException");
        p.pln(" {");
        p.pln();
    }

    protected void writeHandleEmptyBody(IndentingWriter p, Operation operation) throws IOException {
        p.pln("/*");
        p.pln(" * This method handles the case of an empty SOAP body.");
        p.pln(" */");
        p.plnI("protected void _handleEmptyBody(XMLReader reader, SOAPDeserializationContext deserializationContext, StreamingSenderState state) throws Exception {");
        p.pOln("}");
    }

    private void writeOperationCatchBlock(IndentingWriter p, Operation operation) throws IOException {
        TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
        faultSet.addAll(operation.getFaultsSet());
        Iterator faults = faultSet.iterator();
        boolean hasIOException = false;
        if (faults != null) {
            while (faults.hasNext()) {
                Fault fault = (Fault)faults.next();
                if (this.env.getNames().customExceptionClassName(fault).equals(ModelerConstants.IOEXCEPTION_CLASSNAME)) {
                    hasIOException = true;
                    continue;
                }
                p.plnI("} catch (" + this.env.getNames().customExceptionClassName(fault) + " e) {");
                p.pln("throw e;");
                p.pO();
            }
        }
        p.plnI("} catch (RemoteException e) {");
        Iterator faultsIter = faultSet.iterator();
        if (faultsIter.hasNext()) {
            p.plnI("if (e.detail instanceof com.sun.xml.rpc.util.HeaderFaultException) {");
            p.pln("com.sun.xml.rpc.util.HeaderFaultException hfe = (com.sun.xml.rpc.util.HeaderFaultException) e.detail;");
            p.pln("SOAPHeaderBlockInfo headerBlock = (SOAPHeaderBlockInfo) hfe.getObject();");
            p.pln("Object obj = headerBlock.getValue();");
            while (faultsIter.hasNext()) {
                Fault fault = (Fault)faultsIter.next();
                if (!(fault instanceof HeaderFault)) continue;
                p.plnI("if (obj instanceof " + this.env.getNames().customExceptionClassName(fault) + ") {");
                p.pln("throw (" + this.env.getNames().customExceptionClassName(fault) + ") obj;");
                p.pOln("}");
            }
            p.pOln("}");
        }
        p.pln("// let this one through unchanged");
        p.pln("throw e;");
        if (hasIOException) {
            p.pOlnI("} catch (java.io.IOException e) {");
            p.pln("throw e;");
        }
        p.pOlnI("} catch (JAXRPCException e) {");
        p.pln("throw new RemoteException(e.getMessage(), e);");
        p.pOlnI("} catch (Exception e) {");
        p.plnI("if (e instanceof RuntimeException) {");
        p.pln("throw (RuntimeException)e;");
        p.pOlnI("} else {");
        p.pln("throw new RemoteException(e.getMessage(), e);");
        p.pOln("}");
        p.pOln("}");
    }

    protected void writeClassDecl(IndentingWriter p, String stubClassName) throws IOException {
        JavaInterface javaInterface = this.port.getJavaInterface();
        File classFile = this.env.getNames().sourceFileForClass(stubClassName, stubClassName, new File(this.dirPath), this.env);
        GeneratedFileInfo fi = new GeneratedFileInfo();
        fi.setFile(classFile);
        fi.setType("Stub");
        this.env.addGeneratedFile(fi);
        p.plnI("public class " + Names.stripQualifier(stubClassName));
        p.pln("extends com.sun.xml.rpc.client.StubBase");
        p.p("implements " + javaInterface.getName());
        Iterator remoteInterfaces = javaInterface.getInterfaces();
        if (remoteInterfaces.hasNext()) {
            while (remoteInterfaces.hasNext()) {
                p.p(", ");
                p.p((String)remoteInterfaces.next());
            }
        }
        p.pln(" {");
        p.pln();
    }

    protected void writeConstructor(IndentingWriter p, String stubClassName) throws IOException {
        p.pln("/*");
        p.pln(" *  public constructor");
        p.pln(" */");
        p.plnI("public " + Names.stripQualifier(stubClassName) + "(HandlerChain handlerChain) {");
        p.pln("super(handlerChain);");
        String address = this.port.getAddress();
        if (address != null && address.length() > 0) {
            p.pln("_setProperty(ENDPOINT_ADDRESS_PROPERTY, \"" + address + "\");");
        }
        p.pOln("}");
        p.pln("");
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String opCode) throws IOException {
        p.pln("throw new SenderException(\"sender.response.unrecognizedOperation\", Integer.toString(" + opCode + "));");
    }

    protected void writeUnderstoodHeadersMember(IndentingWriter p, Map headerMap) throws IOException {
        p.p("private static final QName[] understoodHeaderNames = new QName[] { ");
        boolean first = true;
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (operation.getResponse() != null) {
                Iterator blocks = operation.getResponse().getHeaderBlocks();
                while (blocks.hasNext()) {
                    Block block = (Block)blocks.next();
                    String qname = this.env.getNames().getBlockQNameName(operation, block);
                    if (!first) {
                        p.p(", ");
                    }
                    p.p(qname);
                    first = false;
                }
            }
            ++i;
        }
        p.pln(" };");
    }

    protected void writeDocumentLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
        JavaStructureMember javaMember;
        String serializer;
        String memberName;
        Block paramBlock;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        this.declareOperationMethod(p, operation);
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                p.plnI("if (" + javaParameter.getName() + " == null) {");
                p.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                p.pOln("}");
            }
            ++i;
        }
        p.plnI("try {");
        Message message = operation.getRequest();
        Block block = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        p.pln();
        p.pln("StreamingSenderState _state = _start(_handlerChain);");
        p.pln();
        p.pln("InternalSOAPMessage _request = _state.getRequest();");
        p.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.pln();
        LiteralType type = block == null ? null : (LiteralType)block.getType();
        String objType = type == null ? null : type.getJavaType().getName();
        String objName = type == null ? null : prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
        int embeddedParameterCount = 0;
        int nonEmbeddedParameterCount = 0;
        boolean declaredHeaderBlockInfo = false;
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                if (parameter.isEmbedded()) {
                    ++embeddedParameterCount;
                    continue;
                }
                objName = parameter.getJavaParameter().getName();
                ++nonEmbeddedParameterCount;
                continue;
            }
            if (!declaredHeaderBlockInfo) {
                p.pln("SOAPHeaderBlockInfo _headerInfo;");
                declaredHeaderBlockInfo = true;
            }
            javaParameter = parameter.getJavaParameter();
            String qname = this.env.getNames().getBlockQNameName(null, paramBlock);
            memberName = parameter.getName();
            String varName = null;
            varName = javaParameter.isHolder() ? memberName + ".value" : memberName;
            serializer = this.writerFactory.createWriter(this.servicePackage, (LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
            p.pln("_headerInfo.setValue(" + varName + ");");
            p.pln("_headerInfo.setSerializer(" + serializer + ");");
            p.pln("_request.add(_headerInfo);");
        }
        if (nonEmbeddedParameterCount > 1 || nonEmbeddedParameterCount > 0 && embeddedParameterCount > 0) {
            throw new GeneratorException("generator.internal.error.should.not.happen", "stub.generator.002");
        }
        if ((embeddedParameterCount > 0 || embeddedParameterCount == 0 && nonEmbeddedParameterCount == 0) && objName != null && objType != null) {
            p.pln(objType + " " + objName + " = new " + objType + "();");
        }
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() != 1 || !parameter.isEmbedded()) continue;
            javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (parameter.getJavaParameter() == null) continue;
            memberName = parameter.getName();
            if (javaMember.isPublic()) {
                p.pln(objName + "." + javaMember.getName() + " = " + memberName + ";");
                continue;
            }
            p.pln(objName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
        }
        p.pln();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            paramBlock = (Block)iterator.next();
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
            String valueStr = objName;
            if (SimpleToBoxedUtil.isPrimitive(objType)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, objType);
            }
            p.pln("_bodyBlock.setValue(" + valueStr + ");");
            serializer = this.writerFactory.createWriter(this.servicePackage, (LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_bodyBlock.setSerializer(" + serializer + ");");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        } else {
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(null);");
            p.pln("_bodyBlock.setSerializer(DummySerializer.getInstance());");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        }
        String soapAction = operation.getSOAPAction() != null ? operation.getSOAPAction() : "";
        p.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + soapAction + "\");");
        p.pln();
        if (operation.getResponse() != null) {
            p.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        } else {
            p.pln("_sendOneWay((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        }
        p.pln();
        message = operation.getResponse();
        if (message != null) {
            iterator = message.getBodyBlocks();
            if (iterator.hasNext()) {
                block = (Block)iterator.next();
            }
            type = block == null ? null : (LiteralType)block.getType();
            boolean hasResponseHeaders = false;
            iterator = operation.getResponse().getHeaderBlocks();
            hasResponseHeaders = iterator.hasNext();
            iterator = operation.getResponse().getParameters();
            if (hasResponseHeaders && iterator.hasNext()) {
                p.pln("Iterator _headers = _state.getResponse().headers();");
                p.pln("SOAPHeaderBlockInfo _curHeader;");
                p.pln("Object _headerObj;");
                p.plnI("while (_headers.hasNext()) {");
                p.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
                boolean startedHeaders = false;
                while (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    if (parameter.getBlock().getLocation() != 2) continue;
                    if (startedHeaders) {
                        p.p(" else ");
                    }
                    startedHeaders = true;
                    String paramName = parameter.getName();
                    String paramType = parameter.getType().getJavaType().getName();
                    String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                    String varName = parameter.getType().getJavaType().isHolder() ? paramName + ".value" : paramName;
                    p.plnI("if (_curHeader.getName().equals(" + qname + ")) {");
                    p.pln("_headerObj = _curHeader.getValue();");
                    p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                    p.pln(paramName + ".value = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                    p.pOlnI("} else {");
                    p.pln(varName + " = (" + paramType + ")_headerObj;");
                    p.pOln("}");
                    p.pO("}");
                }
                if (startedHeaders) {
                    p.pln();
                }
                p.pOln("}");
            }
            if ((iterator = message.getParameters()).hasNext()) {
                String boxName;
                parameter = (Parameter)iterator.next();
                if (parameter.isEmbedded()) {
                    objName = "_result";
                    objType = type.getJavaType().getName();
                } else {
                    objName = "_result";
                    objType = parameter.getType().getJavaType().getName();
                }
                String initString = type == null ? "null" : type.getJavaType().getInitString();
                p.pln(objType + " " + objName + " = " + initString + ";");
                p.pln("Object _responseObj = _state.getResponse().getBody().getValue();");
                p.plnI("if (_responseObj instanceof SOAPDeserializationState) {");
                String valueStr = "((SOAPDeserializationState) _responseObj).getInstance()";
                if (SimpleToBoxedUtil.isPrimitive(objType)) {
                    boxName = SimpleToBoxedUtil.getBoxedClassName(objType);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + valueStr, objType);
                } else {
                    valueStr = "(" + objType + ")" + valueStr;
                }
                p.pln(objName + " = " + valueStr + ";");
                p.pOlnI("} else {");
                valueStr = "_responseObj";
                if (SimpleToBoxedUtil.isPrimitive(objType)) {
                    boxName = SimpleToBoxedUtil.getBoxedClassName(objType);
                    valueStr = SimpleToBoxedUtil.getUnboxedExpressionOfType("(" + boxName + ")" + valueStr, objType);
                } else {
                    valueStr = "(" + objType + ")" + valueStr;
                }
                p.pln(objName + " = " + valueStr + ";");
                p.pOln("}");
                p.pln();
                if (parameter.isEmbedded()) {
                    javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                    if (javaMember.isPublic()) {
                        p.pln("return " + objName + "." + parameter.getName() + ";");
                    } else {
                        p.pln("return " + objName + "." + javaMember.getReadMethod() + "();");
                    }
                } else {
                    p.pln("return " + objName + ";");
                }
            }
            p.pln();
            p.pO();
        }
        this.writeOperationCatchBlock(p, operation);
        p.pOln("}");
    }

    protected void writeRpcEncodedOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
        JavaStructureMember javaMember;
        Block paramBlock;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        this.declareOperationMethod(p, operation);
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                p.plnI("if (" + javaParameter.getName() + " == null) {");
                p.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                p.pOln("}");
            }
            ++i;
        }
        p.plnI("try {");
        Message message = operation.getRequest();
        Block block = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        SOAPType type = (SOAPType)block.getType();
        String objType = type.getJavaType().getName();
        String objName = prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
        p.pln();
        QName name = this.port.getName();
        p.pln("StreamingSenderState _state = _start(_handlerChain);");
        p.pln();
        p.pln("InternalSOAPMessage _request = _state.getRequest();");
        p.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.plnI(objType + " " + objName + " =");
        p.pln("new " + objType + "();");
        p.pO();
        p.pln();
        iterator = message.getParameters();
        boolean declaredHeaderBlockInfo = false;
        while (iterator.hasNext()) {
            String memberName;
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) {
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                memberName = parameter.getJavaParameter() != null && parameter.getJavaParameter().isHolder() ? parameter.getName() + ".value" : parameter.getName();
                if (javaMember.isPublic()) {
                    p.pln(objName + "." + javaMember.getName() + " = " + memberName + ";");
                    continue;
                }
                p.pln(objName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
                continue;
            }
            if (!declaredHeaderBlockInfo) {
                p.pln("SOAPHeaderBlockInfo _headerInfo;");
                declaredHeaderBlockInfo = true;
            }
            javaParameter = parameter.getJavaParameter();
            String qname = this.env.getNames().getBlockQNameName(null, paramBlock);
            memberName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? parameter.getName() + ".value" : parameter.getName();
            String serializer = this.writerFactory.createWriter(this.servicePackage, (SOAPType)paramBlock.getType()).serializerMemberName();
            p.pln("_headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
            p.pln("_headerInfo.setValue(" + memberName + ");");
            p.pln("_headerInfo.setSerializer(" + serializer + ");");
            p.pln("_request.add(_headerInfo);");
        }
        p.pln();
        p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
        p.pln("_bodyBlock.setValue(" + objName + ");");
        p.pln("_bodyBlock.setSerializer(" + this.writerFactory.createWriter(this.servicePackage, type).serializerMemberName() + ");");
        p.pln("_request.setBody(_bodyBlock);");
        p.pln();
        String soapAction = operation.getSOAPAction() != null ? operation.getSOAPAction() : "";
        p.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + soapAction + "\");");
        p.pln();
        if (operation.getResponse() != null) {
            p.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        } else {
            p.pln("_sendOneWay((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        }
        p.pln();
        message = operation.getResponse();
        if (message != null) {
            iterator = message.getBodyBlocks();
            objName = null;
            objType = null;
            block = null;
            while (iterator.hasNext()) {
                block = (Block)iterator.next();
                if (!block.getName().getLocalPart().equals(this.env.getNames().getResponseName(operation.getName().getLocalPart()))) continue;
                type = (SOAPType)block.getType();
                objType = type.getJavaType().getName();
                objName = prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
                break;
            }
            String initString = type == null ? "null" : type.getJavaType().getInitString();
            p.pln(objType + " " + objName + " = " + initString + ";");
            String objMemberName = "_responseObj";
            p.pln("Object " + objMemberName + " = _state.getResponse().getBody().getValue();");
            p.plnI("if (" + objMemberName + " instanceof SOAPDeserializationState) {");
            p.plnI(objName + " =");
            p.pln("(" + objType + ")((SOAPDeserializationState)" + objMemberName + ").getInstance();");
            p.pO();
            p.pOlnI("} else {");
            p.plnI(objName + " =");
            p.pln("(" + objType + ")" + objMemberName + ";");
            p.pO();
            p.pOln("}");
            p.pln();
            iterator = message.getParameters();
            boolean hasReturn = resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME);
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                javaParameter = parameter.getJavaParameter();
                paramBlock = parameter.getBlock();
                if (javaParameter == null || !javaParameter.isHolder() || paramBlock.getLocation() != 1) continue;
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                p.plnI(javaParameter.getName() + ".value =");
                if (javaMember.isPublic()) {
                    p.pln(objName + "." + javaMember.getName() + ";");
                } else {
                    p.pln(objName + "." + javaMember.getReadMethod() + "();");
                }
                p.pO();
            }
            boolean hasResponseHeaders = false;
            iterator = operation.getResponse().getHeaderBlocks();
            hasResponseHeaders = iterator.hasNext();
            iterator = operation.getResponse().getParameters();
            if (hasResponseHeaders && iterator.hasNext()) {
                p.pln("Iterator _headers = _state.getResponse().headers();");
                p.pln("SOAPHeaderBlockInfo _curHeader;");
                p.pln("Object _headerObj;");
                p.plnI("while (_headers.hasNext()) {");
                p.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
                boolean startedHeaders = false;
                while (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    if (parameter.getBlock().getLocation() != 2) continue;
                    if (startedHeaders) {
                        p.p(" else ");
                    }
                    startedHeaders = true;
                    String paramName = parameter.getName();
                    String paramType = parameter.getType().getJavaType().getName();
                    String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                    String varName = parameter.getType().getJavaType().isHolder() ? paramName + ".value" : paramName;
                    p.plnI("if (_curHeader.getName().equals(" + qname + ")) {");
                    p.pln("_headerObj = _curHeader.getValue();");
                    p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                    p.pln(paramName + ".value = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                    p.pOlnI("} else {");
                    p.pln(varName + " = (" + paramType + ")_headerObj;");
                    p.pOln("}");
                    p.pO("}");
                }
                if (startedHeaders) {
                    p.pln();
                }
                p.pOln("}");
            }
            if (hasReturn && (parameter = (Parameter)(iterator = message.getParameters()).next()).getBlock() == block) {
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                if (javaMember.isPublic()) {
                    p.pln("return " + parameter.getName() + ";");
                } else {
                    p.pln("return " + objName + "." + javaMember.getReadMethod() + "();");
                }
            }
            p.pO();
        }
        this.writeOperationCatchBlock(p, operation);
        p.pOln("}");
    }

    protected void writeRpcLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
        JavaStructureMember javaMember;
        String serializer;
        String memberName;
        Block paramBlock;
        Parameter parameter;
        JavaParameter javaParameter;
        JavaMethod javaMethod = operation.getJavaMethod();
        JavaType resultType = javaMethod.getReturnType();
        this.declareOperationMethod(p, operation);
        Iterator iterator = javaMethod.getParameters();
        int i = 0;
        while (iterator.hasNext()) {
            javaParameter = (JavaParameter)iterator.next();
            if (javaParameter.isHolder()) {
                p.plnI("if (" + javaParameter.getName() + " == null) {");
                p.pln("throw new IllegalArgumentException(\"" + javaParameter.getName() + " cannot be null\");");
                p.pOln("}");
            }
            ++i;
        }
        p.plnI("try {");
        Message message = operation.getRequest();
        Block block = null;
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            block = (Block)iterator.next();
        }
        p.pln();
        p.pln("StreamingSenderState _state = _start(_handlerChain);");
        p.pln();
        p.pln("InternalSOAPMessage _request = _state.getRequest();");
        p.pln("_request.setOperationCode(" + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ");");
        p.pln();
        LiteralType type = block == null ? null : (LiteralType)block.getType();
        String objType = type == null ? null : type.getJavaType().getName();
        String objName = type == null ? null : prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
        boolean declaredHeaderBlockInfo = false;
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() == 1) continue;
            if (!declaredHeaderBlockInfo) {
                p.pln("SOAPHeaderBlockInfo _headerInfo;");
                declaredHeaderBlockInfo = true;
            }
            javaParameter = parameter.getJavaParameter();
            String qname = this.env.getNames().getBlockQNameName(null, paramBlock);
            memberName = parameter.getName();
            String varName = null;
            varName = parameter.getLinkedParameter() != null || javaParameter != null && javaParameter.isHolder() ? memberName + ".value" : memberName;
            serializer = this.writerFactory.createWriter(this.servicePackage, (LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_headerInfo = new SOAPHeaderBlockInfo(" + qname + ", null, false);");
            p.pln("_headerInfo.setValue(" + varName + ");");
            p.pln("_headerInfo.setSerializer(" + serializer + ");");
            p.pln("_request.add(_headerInfo);");
        }
        if (objName != null && objType != null) {
            p.pln(objType + " " + objName + " = new " + objType + "();");
        }
        iterator = message.getParameters();
        while (iterator.hasNext()) {
            parameter = (Parameter)iterator.next();
            paramBlock = parameter.getBlock();
            if (paramBlock.getLocation() != 1 || !parameter.isEmbedded()) continue;
            javaMember = StubTieGeneratorBase.getJavaMember(parameter);
            if (parameter.getJavaParameter() == null) continue;
            memberName = parameter.getJavaParameter().isHolder() ? parameter.getName() + ".value" : parameter.getName();
            if (parameter.getType() instanceof LiteralArrayWrapperType) {
                memberName = "new " + ((LiteralArrayWrapperType)parameter.getType()).getJavaType().getName() + "(" + memberName + ")";
            }
            if (javaMember.isPublic()) {
                p.pln(objName + "." + javaMember.getName() + " = " + memberName + ";");
                continue;
            }
            p.pln(objName + "." + javaMember.getWriteMethod() + "(" + memberName + ");");
        }
        p.pln();
        iterator = message.getBodyBlocks();
        if (iterator.hasNext()) {
            paramBlock = (Block)iterator.next();
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, block) + ");");
            String valueStr = objName;
            if (SimpleToBoxedUtil.isPrimitive(objType)) {
                valueStr = SimpleToBoxedUtil.getBoxedExpressionOfType(valueStr, objType);
            }
            p.pln("_bodyBlock.setValue(" + valueStr + ");");
            serializer = this.writerFactory.createWriter(this.servicePackage, (LiteralType)paramBlock.getType()).serializerMemberName();
            p.pln("_bodyBlock.setSerializer(" + serializer + ");");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        } else {
            p.pln("SOAPBlockInfo _bodyBlock = new SOAPBlockInfo(null);");
            p.pln("_bodyBlock.setSerializer(DummySerializer.getInstance());");
            p.pln("_request.setBody(_bodyBlock);");
            p.pln();
        }
        String soapAction = operation.getSOAPAction() != null ? operation.getSOAPAction() : "";
        p.pln("_state.getMessageContext().setProperty(HttpClientTransport.HTTP_SOAPACTION_PROPERTY, \"" + soapAction + "\");");
        p.pln();
        if (operation.getResponse() != null) {
            p.pln("_send((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        } else {
            p.pln("_sendOneWay((String) _getProperty(ENDPOINT_ADDRESS_PROPERTY), _state);");
        }
        p.pln();
        message = operation.getResponse();
        if (message != null) {
            iterator = message.getBodyBlocks();
            objName = null;
            objType = null;
            block = null;
            while (iterator.hasNext()) {
                block = (Block)iterator.next();
                if (!block.getName().getLocalPart().equals(this.env.getNames().getResponseName(operation.getName().getLocalPart()))) continue;
                type = (LiteralType)block.getType();
                objType = type.getJavaType().getName();
                objName = prefix + this.env.getNames().getTypeMemberName(type.getJavaType());
                break;
            }
            boolean hasReturn = resultType != null && !resultType.getName().equals(ModelerConstants.VOID_CLASSNAME);
            String initString = type == null ? "null" : type.getJavaType().getInitString();
            p.pln(objType + " " + objName + " = " + initString + ";");
            String objMemberName = "_responseObj";
            p.pln("Object " + objMemberName + " = _state.getResponse().getBody().getValue();");
            p.plnI("if (" + objMemberName + " instanceof SOAPDeserializationState) {");
            p.plnI(objName + " =");
            p.pln("(" + objType + ")((SOAPDeserializationState)" + objMemberName + ").getInstance();");
            p.pO();
            p.pOlnI("} else {");
            p.plnI(objName + " =");
            p.pln("(" + objType + ")" + objMemberName + ";");
            p.pO();
            p.pOln("}");
            p.pln();
            iterator = message.getParameters();
            while (iterator.hasNext()) {
                parameter = (Parameter)iterator.next();
                javaParameter = parameter.getJavaParameter();
                paramBlock = parameter.getBlock();
                if (javaParameter == null || !javaParameter.isHolder() || paramBlock.getLocation() != 1) continue;
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                p.plnI(javaParameter.getName() + ".value =");
                if (javaMember.isPublic()) {
                    p.pln(objName + "." + javaMember.getName() + ";");
                } else if (javaMember.getType() instanceof JavaStructureType && ((JavaStructureType)javaMember.getType()).getOwner() instanceof LiteralArrayWrapperType) {
                    LiteralArrayWrapperType owner = (LiteralArrayWrapperType)((JavaStructureType)javaMember.getType()).getOwner();
                    JavaStructureMember tmpMember = (JavaStructureMember)((JavaStructureType)owner.getJavaType()).getMembers().next();
                    p.pln("(" + objName + "." + javaMember.getReadMethod() + "() != null) ?");
                    p.pln(objName + "." + javaMember.getReadMethod() + "()." + tmpMember.getReadMethod() + "() : null;");
                } else {
                    p.pln(objName + "." + javaMember.getReadMethod() + "();");
                }
                p.pO();
            }
            boolean hasResponseHeaders = false;
            iterator = operation.getResponse().getHeaderBlocks();
            hasResponseHeaders = iterator.hasNext();
            iterator = operation.getResponse().getParameters();
            if (hasResponseHeaders && iterator.hasNext()) {
                p.pln("Iterator _headers = _state.getResponse().headers();");
                p.pln("SOAPHeaderBlockInfo _curHeader;");
                p.pln("Object _headerObj;");
                p.plnI("while (_headers.hasNext()) {");
                p.pln("_curHeader = (SOAPHeaderBlockInfo)_headers.next();");
                boolean startedHeaders = false;
                while (iterator.hasNext()) {
                    parameter = (Parameter)iterator.next();
                    if (parameter.getBlock().getLocation() != 2) continue;
                    if (startedHeaders) {
                        p.p(" else ");
                    }
                    startedHeaders = true;
                    String paramName = parameter.getName();
                    String paramType = parameter.getType().getJavaType().getName();
                    String qname = this.env.getNames().getBlockQNameName(null, parameter.getBlock());
                    String varName = parameter.getType().getJavaType().isHolder() ? paramName + ".value" : paramName;
                    p.plnI("if (_curHeader.getName().equals(" + qname + ")) {");
                    p.pln("_headerObj = _curHeader.getValue();");
                    p.plnI("if (_headerObj instanceof SOAPDeserializationState) {");
                    p.pln(paramName + ".value = (" + paramType + ")((SOAPDeserializationState)" + "_headerObj).getInstance();");
                    p.pOlnI("} else {");
                    p.pln(varName + " = (" + paramType + ")_headerObj;");
                    p.pOln("}");
                    p.pO("}");
                }
                if (startedHeaders) {
                    p.pln();
                }
                p.pOln("}");
            }
            if (hasReturn && (parameter = (Parameter)(iterator = message.getParameters()).next()).getBlock() == block) {
                javaMember = StubTieGeneratorBase.getJavaMember(parameter);
                String unWrapMethod = "";
                if (parameter.getType() instanceof LiteralArrayWrapperType) {
                    unWrapMethod = ".toArray()";
                }
                if (javaMember.isPublic()) {
                    p.pln("return " + parameter.getName() + unWrapMethod + ";");
                } else {
                    p.pln("return " + objName + "." + javaMember.getReadMethod() + "()" + unWrapMethod + ";");
                }
            }
            p.pO();
        }
        this.writeOperationCatchBlock(p, operation);
        p.pOln("}");
    }

    private StubGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        String key = "sourceDirectory";
        this.dirPath = properties.getProperty(key);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new StubGenerator(model, config, properties);
    }

    private StubGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        super(model, config, properties, ver);
        String key = "sourceDirectory";
        this.dirPath = properties.getProperty(key);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new StubGenerator(model, config, properties, ver);
    }
}

