/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.ProcessorAction;
import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.util.GeneratedFileInfo;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Properties;

public class ServiceInterfaceGenerator
implements ProcessorAction {
    private File sourceDir;
    private ProcessorEnvironment env;
    private String JAXRPCVersion;
    private boolean donotOverride;
    private String targetVersion;

    private void process(Service service) {
        try {
            JavaInterface intf = service.getJavaInterface();
            String className = this.env.getNames().customJavaTypeClassName(intf);
            if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
                this.log("Class " + className + " exists. Not overriding.");
                return;
            }
            this.log("creating service interface: " + className);
            File classFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
            GeneratedFileInfo fi = new GeneratedFileInfo();
            fi.setFile(classFile);
            fi.setType("Service");
            this.env.addGeneratedFile(fi);
            IndentingWriter out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(classFile)));
            GeneratorBase.writePackage(out, className, this.JAXRPCVersion, this.targetVersion);
            out.pln("import javax.xml.rpc.*;");
            out.pln();
            out.plnI("public interface " + Names.stripQualifier(className) + " extends javax.xml.rpc.Service {");
            Iterator ports = service.getPorts();
            while (ports.hasNext()) {
                Port port = (Port)ports.next();
                String portClass = port.getJavaInterface().getName();
                String portName = Names.getPortName(port);
                portName = this.env.getNames().validJavaClassName(portName);
                String getPortMethodStr = "public " + portClass + " get" + portName + "()";
                getPortMethodStr = VersionUtil.isVersion101(this.targetVersion) || VersionUtil.isVersion103(this.targetVersion) ? getPortMethodStr + ";" : getPortMethodStr + " throws ServiceException;";
                out.pln(getPortMethodStr);
            }
            out.pOln("}");
            out.close();
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", new LocalizableExceptionAdapter(e));
        }
    }

    private void log(String msg) {
        if (this.env.verbose()) {
            System.out.println("[" + Names.stripQualifier(this.getClass().getName()) + ": " + msg + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Model model, Configuration config, Properties options) {
        try {
            this.env = (ProcessorEnvironment)config.getEnvironment();
            this.env.getNames().resetPrefixFactory();
            String key = "sourceDirectory";
            String dirPath = options.getProperty(key);
            key = "donotOverride";
            this.donotOverride = Boolean.valueOf(options.getProperty(key));
            this.sourceDir = new File(dirPath);
            this.JAXRPCVersion = options.getProperty("JAXRPC Version");
            key = "sourceVersion";
            this.targetVersion = options.getProperty(key);
            Iterator iter = model.getServices();
            while (iter.hasNext()) {
                Service service = (Service)iter.next();
                this.process(service);
            }
            Object var9_8 = null;
            this.sourceDir = null;
            this.env = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.sourceDir = null;
            this.env = null;
            throw throwable;
        }
    }
}

