/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntries;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.messaging.exchange.cdo.AddressEntriesProxy;
import com.aligo.messaging.exchange.cdo.AddressEntryProxy;
import com.aligo.messaging.exchange.cdo.Recipient;
import com.aligo.messaging.exchange.cdo.RecipientsProxy;
import java.util.Date;

public final class ExchangeRecipient {
    private Recipient _ocxRecipient;

    ExchangeRecipient(Recipient recipientHandle) {
        this._ocxRecipient = recipientHandle;
    }

    Recipient getRecipientHandle() {
        return this._ocxRecipient;
    }

    public void resolve() throws AligoExchangeException {
        try {
            this._ocxRecipient.resolve(new Boolean(false));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getAddress() throws AligoExchangeException {
        try {
            return (String)this._ocxRecipient.getAddress();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setAddress(String name) throws AligoExchangeException {
        try {
            this._ocxRecipient.setAddress(name);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntry getAddressEntry() throws AligoExchangeException {
        try {
            AddressEntryProxy resultHandle = new AddressEntryProxy(this._ocxRecipient.getAddressEntry());
            return new ExchangeAddressEntry(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setAddressEntry(ExchangeAddressEntry entry) throws AligoExchangeException {
        try {
            this._ocxRecipient.setAddressEntry(entry.getAddressEntryHandle());
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAddressEntries getAmbiguousNames() throws AligoExchangeException {
        try {
            AddressEntriesProxy resultHandle = new AddressEntriesProxy(this._ocxRecipient.getAmbiguousNames());
            return new ExchangeAddressEntries(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        try {
            this._ocxRecipient.delete();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getDisplayType() throws AligoExchangeException {
        try {
            return (Integer)this._ocxRecipient.getDisplayType();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getFreeBusy(Date startTime, Date endTime, long interval) throws AligoExchangeException {
        try {
            return (String)this._ocxRecipient.getFreeBusy(startTime, endTime, new Long(interval));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getId() throws AligoExchangeException {
        try {
            return (String)this._ocxRecipient.getID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setId(String value) throws AligoExchangeException {
        if (value == null || value.trim().equals("")) {
            throw new AligoExchangeException("Invalid ID value provided!");
        }
        try {
            this._ocxRecipient.setID(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getIndex() throws AligoExchangeException {
        try {
            return (Integer)this._ocxRecipient.getIndex();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isSameAs(ExchangeRecipient other) throws AligoExchangeException {
        try {
            return (Boolean)this._ocxRecipient.isSameAs(other.getRecipientHandle());
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getMeetingResponseStatus() throws AligoExchangeException {
        try {
            return (Integer)this._ocxRecipient.getMeetingResponseStatus();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setMeetingResponseStatus(int status) throws AligoExchangeException {
        try {
            this._ocxRecipient.setMeetingResponseStatus(new Integer(status));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getName() throws AligoExchangeException {
        try {
            return (String)this._ocxRecipient.getName();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setName(String value) throws AligoExchangeException {
        try {
            this._ocxRecipient.setName(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getType() throws AligoExchangeException {
        try {
            return (Integer)this._ocxRecipient.getType();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setType(int type) throws AligoExchangeException {
        if (type < 1 || type > 3) {
            type = 1;
        }
        try {
            this._ocxRecipient.setType(new Integer(type));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeRecipients getParent() throws AligoExchangeException {
        try {
            RecipientsProxy resultHandle = new RecipientsProxy(this._ocxRecipient.getParent());
            return new ExchangeRecipients(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }
}

