/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeFolders;
import com.aligo.messaging.exchange.ExchangeInfoStore;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.Folder;
import com.aligo.messaging.exchange.cdo.FoldersProxy;
import com.aligo.messaging.exchange.cdo.InfoStoreProxy;
import com.aligo.messaging.exchange.cdo.MessagesProxy;
import com.aligo.messaging.exchange.cdo.Session;

public class ExchangeFolder {
    private Folder _ocxFolder;
    private Session _ocxSession;
    private int folderType;

    public ExchangeFolder(Folder handle) {
        this._ocxFolder = handle;
    }

    ExchangeFolder() {
    }

    private void setHandle(Folder handle) {
        this._ocxFolder = handle;
    }

    public Folder getFolder() {
        return this._ocxFolder;
    }

    public ExchangeFolders getFolders() throws AligoExchangeException {
        try {
            return new ExchangeFolders(new FoldersProxy(this._ocxFolder.getFolders()));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setFolders(ExchangeFolders folders) throws AligoExchangeException {
        try {
            this._ocxFolder.setFolders(folders);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeMessages getMessages() throws AligoExchangeException {
        try {
            return new ExchangeMessages(new MessagesProxy(this._ocxFolder.getMessages()));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setMessages(ExchangeMessages messages) throws AligoExchangeException {
        try {
            this._ocxFolder.setMessages(messages);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeMessages getHiddenMessages() throws AligoExchangeException {
        try {
            return new ExchangeMessages(new MessagesProxy(this._ocxFolder.getHiddenMessages()));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setHiddenMessages(ExchangeMessages hiddens) throws AligoExchangeException {
        try {
            this._ocxFolder.setHiddenMessages(hiddens);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeFields getFields() throws AligoExchangeException {
        try {
            return new ExchangeFields(new FieldsProxy(this._ocxFolder.getFields()));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setFields(ExchangeFields fields) throws AligoExchangeException {
        try {
            this._ocxFolder.setFields(fields);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeInfoStore getParent() throws AligoExchangeException {
        try {
            return new ExchangeInfoStore(new InfoStoreProxy(this._ocxFolder.getParent()));
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setParent(ExchangeInfoStore parent) throws AligoExchangeException {
        try {
            this._ocxFolder.setParent(parent);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public ExchangeFolder update(boolean makePermanent, boolean refreshObject) throws AligoExchangeException {
        Boolean makePerm = new Boolean(makePermanent);
        Boolean refresh = new Boolean(refreshObject);
        try {
            Folder f = (Folder)this._ocxFolder.update(makePerm, refresh);
            return new ExchangeFolder(f);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder copyTo(String folderId, String storeId, String name, boolean doSubs) throws AligoExchangeException {
        Boolean copySubs = new Boolean(doSubs);
        try {
            Folder f = (Folder)this._ocxFolder.copyTo(folderId, storeId, name, copySubs);
            return new ExchangeFolder(f);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeFolder moveTo(String folderId, String storeId) throws AligoExchangeException {
        try {
            Folder f = (Folder)this._ocxFolder.moveTo(folderId, storeId);
            return new ExchangeFolder(f);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        try {
            Object result = this._ocxFolder.delete();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isSameAs(Folder oFolder) throws AligoExchangeException {
        try {
            Boolean isSame = (Boolean)this._ocxFolder.isSameAs(oFolder);
            return isSame;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getName() throws AligoExchangeException {
        try {
            return (String)this._ocxFolder.getName();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setName(String name) throws AligoExchangeException {
        try {
            this._ocxFolder.setName(name);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public String getId() throws AligoExchangeException {
        try {
            return (String)this._ocxFolder.getID();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setId(String id) throws AligoExchangeException {
        try {
            this._ocxFolder.setID(id);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public String getFolderId() throws AligoExchangeException {
        try {
            return (String)this._ocxFolder.getFolderID();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setFolderId(String folderId) throws AligoExchangeException {
        try {
            this._ocxFolder.setFolderID(folderId);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public String getStoreId() throws AligoExchangeException {
        try {
            return (String)this._ocxFolder.getStoreID();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public void setStoreId(String storeId) throws AligoExchangeException {
        try {
            this._ocxFolder.setStoreID(storeId);
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    public String getApplication() throws AligoExchangeException {
        try {
            return (String)this._ocxFolder.getApplication();
        }
        catch (Exception ex) {
            throw new AligoExchangeException(ex);
        }
    }

    protected void setFolderType(int type) {
        this.folderType = type;
    }

    protected int getFolderType() {
        return this.folderType;
    }
}

