/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;

public class SitesListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
DeletingModel {
    private RobotConfig rc = CSConfig.getRobotConfig();
    public static final String FIELD_ENABLE = "Enable";
    public static final String FIELD_SITEID = "SiteID";
    public static final String FIELD_TYPEIMAGE = "TypeImage";
    public static final String FIELD_NICKNAME = "NickName";
    public static final String FIELD_DELETE = "Delete";
    public static final String[] ENABLE_VALUES = new String[]{"true", "false"};
    static String SECURE_SERVER_IMAGE = "../ps/searchadmin/images/key_on.gif";
    static String OPEN_SERVER_IMAGE = "../ps/searchadmin/images/key_off.gif";
    static String DOMAIN_IMAGE = "../ps/searchadmin/images/domain.gif";
    static String FILE_IMAGE = "../ps/searchadmin/images/file.gif";
    static String BLANK_IMAGE = "../ps/searchadmin/images/blank.gif";

    public String getImage(FilterRuleset filterRuleset) {
        if (filterRuleset != null) {
            if (filterRuleset.getType() == 1 && filterRuleset.numOfServers() == 1) {
                if (filterRuleset.getServerByIndex(0).startsWith("https")) {
                    return SECURE_SERVER_IMAGE;
                }
                if (filterRuleset.getServerByIndex(0).startsWith("file")) {
                    return FILE_IMAGE;
                }
                return OPEN_SERVER_IMAGE;
            }
            return DOMAIN_IMAGE;
        }
        return BLANK_IMAGE;
    }

    public boolean delRuleset(String string) {
        return this.rc.delRuleset(string);
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("ImportListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.beforeFirst();
        while (this.next()) {
            FilterRuleset filterRuleset = this.rc.GetRuleSet(this.getLocation());
            if (filterRuleset == null) continue;
            String string = (String)this.getValue(FIELD_ENABLE);
            filterRuleset.setEnabled(string.compareTo(ENABLE_VALUES[0]) == 0);
        }
        this.rc.updateFile();
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        int n;
        CSDebug.logln("SitesListModel.delete");
        this.beforeFirst();
        String[] stringArray = new String[this.getSize()];
        while (this.next()) {
            FilterRuleset filterRuleset;
            n = this.getLocation();
            String string = (String)this.getValue(FIELD_DELETE);
            stringArray[n] = null;
            if (string.compareTo("true") != 0 || (filterRuleset = this.rc.GetRuleSet(n)) == null) continue;
            stringArray[n] = filterRuleset.id;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) continue;
            this.rc.delRuleset(stringArray[n]);
        }
        this.rc.updateFile();
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("SitesModel.retrieve");
        this.clear();
        int n = this.rc.numRuleset();
        for (int i = 0; i < n; ++i) {
            FilterRuleset filterRuleset = this.rc.GetRuleSet(i);
            if (filterRuleset == null) continue;
            this.appendRow();
            this.setValue(FIELD_ENABLE, filterRuleset.isEnabled() ? ENABLE_VALUES[0] : ENABLE_VALUES[1]);
            this.setValue(FIELD_TYPEIMAGE, this.getImage(filterRuleset));
            this.setValue(FIELD_SITEID, filterRuleset.id);
            this.setValue(FIELD_NICKNAME, filterRuleset.nickname);
            this.setValue(FIELD_DELETE, "false");
        }
        this.beforeFirst();
        return null;
    }
}

