/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.model.SearchModel;
import com.sun.portal.search.util.OrderedMap;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class SearchModelImpl
extends AMModelBase
implements SearchModel {
    private static boolean needSrvRestart = false;
    private static final String COMMENT = "__configComment_";
    public static Map csidMap;
    public static final String csidFileRelativPath;
    public String ServerStatus;
    public String ServerInstanceName;
    public String ServerName;
    public String ServerPort;
    public String ServerRoot;
    public String ServerErrorLog;
    public String ServerTmpFiles;
    private OrderedMap config;

    public SearchModelImpl(HttpServletRequest httpServletRequest, String string) {
        super(httpServletRequest, string);
        this.init(httpServletRequest);
    }

    protected void init(HttpServletRequest httpServletRequest) {
        this.load();
    }

    public String getServerStatus() {
        return "ON";
    }

    public void setServerStatus(String string) {
    }

    public String getServerInstanceName() {
        return (String)this.config.get((Object)"instance-name");
    }

    public void setServerInstanceName(String string) {
        this.config.put((Object)"instance-name", (Object)string);
    }

    public String getServerRoot() {
        return (String)this.config.get((Object)"server-root");
    }

    private void checkFileAccess(String string, String string2) throws Exception {
        if (string2.trim().length() == 0) {
            throw new Exception(string + this.getLocalizedString("server.error.not_empty"));
        }
        File file = new File(string2);
        if (file.exists()) {
            if (!file.isFile()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_file"));
            }
            if (!file.canRead()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_readible"));
            }
            if (!file.canWrite()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_writable"));
            }
        } else {
            File file2 = file.getParentFile();
            if (file2 != null) {
                String string3 = file2.getAbsolutePath();
                this.checkDirectoryAccess(string, string3);
            }
        }
    }

    private void checkDirectoryAccess(String string, String string2) throws Exception {
        if (string2.trim().length() == 0) {
            throw new Exception(string + " " + this.getLocalizedString("server.error.not_empty"));
        }
        File file = new File(string2);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_directory"));
            }
            if (!file.canRead()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_readible"));
            }
            if (!file.canWrite()) {
                throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.not_writable"));
            }
        } else {
            throw new Exception(string + " : '" + string2 + "' " + this.getLocalizedString("server.error.inexistant"));
        }
    }

    public void setServerRoot(String string) throws Exception {
        this.checkDirectoryAccess(this.getLocalizedString("server.error.root_path"), string);
        this.config.put((Object)"server-root", (Object)string);
    }

    public String getServerTmpFiles() {
        return (String)this.config.get((Object)"tmpdir");
    }

    public void setServerTmpFiles(String string) throws Exception {
        this.checkDirectoryAccess(this.getLocalizedString("server.error.tmp_files"), string);
        this.config.put((Object)"tmpdir", (Object)string);
    }

    public String getServerDocSecurityMode() {
        return (String)this.config.get((Object)"security-mode");
    }

    public void setServerDocSecurityMode(String string) {
        this.config.put((Object)"security-mode", (Object)string);
    }

    public String getServerDocSecurityMgr() {
        return (String)this.config.get((Object)"security-manager");
    }

    public void setServerDocSecurityMgr(String string) throws Exception {
        Class.forName(string);
        this.config.put((Object)"security-manager", (Object)string);
    }

    public String getSearchRDMLog() {
        return (String)this.config.get((Object)"logfile");
    }

    public void setSearchRDMLog(String string) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.searchLog"), string);
        this.config.put((Object)"logfile", (Object)string);
    }

    public boolean getSearchLogState() {
        String string = (String)this.config.get((Object)"disable-rdm-log");
        return string != null && string.equals("true");
    }

    public void setSearchLogState(boolean bl) {
        if (bl) {
            this.config.put((Object)"disable-rdm-log", (Object)"true");
        } else {
            this.config.put((Object)"disable-rdm-log", (Object)"false");
        }
    }

    public String getIndexMaintenanceLog() {
        return (String)this.config.get((Object)"search-logfile");
    }

    public void setIndexMaintenanceLog(String string) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.indexMaintenance"), string);
        this.config.put((Object)"search-logfile", (Object)string);
    }

    public String getRdMgrLog() {
        return (String)this.config.get((Object)"rdmgr-logfile");
    }

    public void setRdMgrLog(String string) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.rdManager"), string);
        this.config.put((Object)"rdmgr-logfile", (Object)string);
    }

    public String getRdmDebugLog() {
        return (String)this.config.get((Object)"debug-logfile");
    }

    public void setRdmDebugLog(String string) throws Exception {
        this.checkFileAccess(this.getLocalizedString("advancedLog.rdmDebug"), string);
        this.config.put((Object)"debug-logfile", (Object)string);
    }

    public String getRdmDebugLevel() {
        return (String)this.config.get((Object)"debug-loglevel");
    }

    public void setRdmDebugLevel(String string) {
        this.config.put((Object)"debug-loglevel", (Object)string);
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        }
        return object;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.load();
        return null;
    }

    public void load() {
        String string = CSConfig.getServerRoot();
        if (string == null) {
            string = ".";
        }
        String string2 = string + csidFileRelativPath;
        try {
            String string3;
            this.config = new OrderedMap();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
            int n = 1;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() != 0) {
                    String string4;
                    String string5;
                    if (string3.charAt(0) == '#') {
                        this.config.put((Object)(COMMENT + String.valueOf(n)), (Object)string3);
                        ++n;
                        continue;
                    }
                    int n2 = string3.indexOf("=");
                    if (n2 != -1) {
                        string5 = string3.substring(0, n2);
                        string4 = string3.substring(n2 + 1).trim();
                        if (string4.startsWith("\"") && string4.endsWith("\"")) {
                            string4 = string4.substring(1, string4.length() - 1);
                        }
                    } else {
                        string5 = string3;
                        string4 = null;
                    }
                    this.config.put((Object)string5, string4);
                    continue;
                }
                this.config.put((Object)(COMMENT + String.valueOf(n)), (Object)string3);
                ++n;
            }
            ++n;
        }
        catch (IOException iOException) {
            CSDebug.log("SearchModelImpl.laod() IOexception trying to read search.conf : " + iOException.getMessage());
        }
        catch (Exception exception) {
            CSDebug.log("SearchModelImpl.load() exception trying to read search.conf : " + exception.getMessage());
        }
    }

    public void store() {
        String string = CSConfig.getServerRoot();
        String string2 = string + csidFileRelativPath;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8")));
            String[] stringArray = this.config.getOrderedKeys();
            String string3 = null;
            String string4 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string3 = stringArray[i];
                string4 = (String)this.config.get((Object)string3);
                if (!string3.startsWith(COMMENT)) {
                    printWriter.print(string3 + "=" + PBlock.quotedString((String)string4) + "\n");
                    continue;
                }
                printWriter.print(string4 + "\n");
            }
            printWriter.close();
            SearchConfig.init((String)string2);
            needSrvRestart = true;
        }
        catch (IOException iOException) {
            CSDebug.logln("SearchModelImpl - store() - caught IOException e=" + iOException.getMessage() + " [" + string2 + "]");
        }
        catch (Exception exception) {
            CSDebug.logln("SearchModelImpl - store() - can't write file [" + string2 + "]");
        }
    }

    public boolean needSrvRestart() {
        return needSrvRestart;
    }

    public String getStringValue(String string) {
        return (String)this.config.get((Object)string);
    }

    public void setStringValue(String string, String string2) {
        this.config.put((Object)string, (Object)string2);
    }

    static {
        csidFileRelativPath = File.separator + "config" + File.separator + "search.conf";
    }
}

