/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.util.Encoder;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

public class SchemaListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
DeletingModel {
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_DELNAME = "DelName";
    public static final String FIELD_DESC = "Desc";
    public static final String FIELD_ALIAS = "Alias";
    public static final String FIELD_DATATYPE = "Datatype";
    public static final String FIELD_EDITABLE = "Editable";
    public static final String FIELD_INDEXABLE = "Indexable";
    public static final String FIELD_DELETE = "Delete";
    public static final String FIELD_ENCODED_NAME = "EncodedName";
    static final String[] FIELDS = new String[]{"Name", "Desc", "Alias"};
    public Locale userLocale = Locale.getDefault();
    public static final String[] DATA_TYPES = new String[]{"date", "int", "string"};
    public boolean showInternal = false;
    private String schfn = "";

    public SchemaListModel() {
        CSDebug.logln("SchemaListModel()");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("SchemaistModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string;
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        RDMSchema rDMSchema = null;
        try {
            rDMSchema = this.loadSchema();
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
        if (rDMSchema == null) {
            throw new ModelControlException("Error on loading Schema");
        }
        this.beforeFirst();
        while (this.next()) {
            string = (String)this.getValue(FIELD_DELETE);
            if (string == null || !string.equalsIgnoreCase("true")) continue;
            String string2 = (String)this.getValue(FIELD_DELNAME);
            CSDebug.logln("Deleting schema " + string2);
            if (string2 == null) continue;
            String string3 = null;
            try {
                string3 = new String(Encoder.decodeBase64((String)string2), "UTF-8");
                rDMSchema.deleteColumn(string3);
            }
            catch (Exception exception) {
                throw new ModelControlException("Schema failed to delete column: " + string3 + ": " + exception);
            }
        }
        try {
            string = new SOIFOutputStream(this.schfn);
            string.write(rDMSchema.getSOIF());
            string.close();
        }
        catch (Exception exception) {
            throw new ModelControlException("Unable to write SOIF to " + this.schfn + ": " + exception);
        }
        return null;
    }

    private RDMSchema loadSchema() throws Exception {
        RDMSchema rDMSchema = null;
        String string = CSConfig.getServerRoot() + File.separator + "config" + File.separator + "search.conf";
        try {
            SearchConfig.init((String)string);
        }
        catch (Exception exception) {
            throw new Exception("Unable to initialize SearchConfig: " + string);
        }
        this.schfn = SearchConfig.getValue((String)"schema-description");
        if (this.schfn == null) {
            throw new Exception("Missing SearchConfig.SCHEMA parameter");
        }
        CSDebug.logln("loadSchema(): location: " + this.schfn);
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream(this.schfn);
            rDMSchema = new RDMSchema(sOIFInputStream.readSOIF());
        }
        catch (Exception exception) {
            throw new Exception("Schema Unavailable: " + this.schfn);
        }
        return rDMSchema;
    }

    public String[] getSchemaList() {
        try {
            RDMSchema rDMSchema = this.loadSchema();
            return rDMSchema.schema_nonInternal_attrs();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".retrieve()");
        this.clear();
        try {
            int n;
            int n2;
            RDMSchema rDMSchema = this.loadSchema();
            String[] stringArray = new String[]{};
            if (this.showInternal) {
                boolean bl = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                Object var10_8 = null;
                n2 = rDMSchema.getMaxIndex();
                for (n = 0; n <= n2; ++n) {
                    String string = rDMSchema.getSOIFAttribute(n);
                    if (string == null) continue;
                    arrayList.add(string);
                }
                stringArray = arrayList.toArray(new String[0]);
            } else {
                stringArray = rDMSchema.schema_nonInternal_attrs();
            }
            for (n = 0; n < stringArray.length; ++n) {
                this.appendRow();
                String string = stringArray[n];
                this.setValue(FIELD_NAME, string);
                try {
                    String string2 = Encoder.encodeBase64((byte[])string.getBytes("UTF-8"));
                    this.setValue(FIELD_ENCODED_NAME, string2);
                    this.setValue(FIELD_DELNAME, string2);
                }
                catch (Exception exception) {
                    CSDebug.logln("Exception:" + exception);
                    this.setValue(FIELD_ENCODED_NAME, string);
                    this.setValue(FIELD_DELNAME, string);
                }
                n2 = rDMSchema.getColumnNumber(string);
                this.setValue(FIELD_DESC, rDMSchema.getDescription(n2));
                String string3 = rDMSchema.getAliases(n2);
                if (string3 != null) {
                    this.setValue(FIELD_ALIAS, string3);
                }
                if ((string3 = rDMSchema.getDataType(n2)) != null) {
                    this.setValue(FIELD_DATATYPE, string3);
                }
                if ((string3 = rDMSchema.getEditAttribute(n2)) != null && string3.equals("1")) {
                    this.setValue(FIELD_EDITABLE, "true");
                } else {
                    this.setValue(FIELD_EDITABLE, "false");
                }
                string3 = rDMSchema.getIndexAttribute(n2);
                if (string3 != null && string3.equals("1")) {
                    this.setValue(FIELD_INDEXABLE, "true");
                    continue;
                }
                this.setValue(FIELD_INDEXABLE, "false");
            }
        }
        catch (Exception exception) {
            throw new ModelControlException((Throwable)exception);
        }
        this.beforeFirst();
        return null;
    }
}

