/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.util.PBlock;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PopularSearchModel
extends DefaultModel {
    String serverRoot = null;
    Date firstDate = null;
    Date lastUpdated = null;
    HashMap logs = new HashMap();
    ArrayList sortedSearch = new ArrayList();
    int numberOfQuery = 0;
    public Locale userLocale = Locale.getDefault();
    static final String DELIMITER = " -->  ";

    public static void main(String[] stringArray) {
        CSConfig.init(stringArray[0]);
        PopularSearchModel popularSearchModel = new PopularSearchModel();
        SearchConfig searchConfig = SearchConfig.getSearchConfig();
        if (searchConfig == null) {
            try {
                SearchConfig.init((String)(popularSearchModel.serverRoot + File.separator + "config" + File.separator + "search.conf"));
                searchConfig = SearchConfig.getSearchConfig();
            }
            catch (Exception exception) {
                System.out.println("Error on SearchConfig.init():" + exception.getMessage());
                return;
            }
        }
        popularSearchModel.execute(true);
        System.out.println(popularSearchModel.getReport());
    }

    public PopularSearchModel() {
        this.serverRoot = CSConfig.getServerRoot();
        try {
            this.readFromCache();
        }
        catch (Exception exception) {
            CSDebug.logln("No cache, update now");
            this.execute(false);
        }
    }

    public PopularSearchModel(String string) {
        this.serverRoot = CSConfig.getServerRoot();
    }

    public void execute(boolean bl) {
        Object object;
        String string;
        Object object2;
        String string2 = SearchConfig.getValue((String)"logfile");
        BufferedReader bufferedReader = null;
        String string3 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                Object object3;
                boolean bl2;
                object2 = new HashMap();
                try {
                    PBlock.str2pblock((String)string3, (Map)object2);
                }
                catch (Exception exception) {
                    continue;
                }
                String string5 = (String)object2.get("scope");
                if (string5 == null) continue;
                string = (String)object2.get("RDM");
                object = (String)object2.get("ql");
                boolean bl3 = string != null && string.equalsIgnoreCase("tax");
                boolean bl4 = string != null && string.equalsIgnoreCase("RD");
                boolean bl5 = object != null && ((String)object).equalsIgnoreCase("taxonomy-basic");
                boolean bl6 = bl2 = object != null && ((String)object).equalsIgnoreCase("search");
                if (bl && bl5) continue;
                int n = string3.indexOf("RDM=tax");
                int n2 = -1;
                int n3 = string3.indexOf("ql=search");
                int n4 = string3.indexOf("ql=taxonomy-basic");
                if (n < 0) {
                    n2 = string3.indexOf("RDM=rd");
                }
                if (n > 0 && (n3 > 0 || bl && n4 > 0)) continue;
                if (this.firstDate == null) {
                    int n5 = string3.indexOf(91);
                    int n6 = string3.indexOf(93);
                    if (n5 >= 0 && n6 > 0) {
                        object3 = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
                        string4 = string3.substring(n5 + 1, n6);
                        try {
                            this.firstDate = ((DateFormat)object3).parse(string4);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                String string6 = null;
                String string7 = null;
                object3 = string5.toUpperCase();
                if (n2 > 0 && n3 > 0 && (((String)object3).startsWith("(CLASSIFICATION") || ((String)object3).startsWith("<NOT> (CLASSIFICATION"))) continue;
                if (bl5 && string5.startsWith("children* ")) {
                    string4 = string5.substring(10);
                    if (string4.equals("ROOT")) continue;
                    string6 = SearchResource.geti18nString("popsearch.browse", this.userLocale) + " " + string4;
                } else if (n3 > 0 && string5.startsWith("(Classification <STARTS> ")) {
                    int n7;
                    int n8 = string5.indexOf(41);
                    if (n8 > 0 && (n7 = string5.indexOf("<AND>", n8)) > 0) {
                        int n9 = string5.indexOf(40, n7);
                        int n10 = string5.lastIndexOf(41);
                        if (n10 > n9) {
                            string7 = string5.substring(n9 + 1, n10) + SearchResource.geti18nString("within", this.userLocale) + string5.substring(25, n8);
                        }
                    }
                } else if (n3 > 0) {
                    string7 = string5;
                }
                string4 = null;
                if (string6 != null) {
                    string4 = string6;
                } else if (string7 != null) {
                    string4 = string7;
                }
                if (string4 == null) continue;
                SearchFreq searchFreq = (SearchFreq)this.logs.get(string4);
                if (searchFreq == null) {
                    searchFreq = new SearchFreq(string4, 1, string6 != null);
                    this.logs.put(string4, searchFreq);
                    continue;
                }
                searchFreq.inc();
            }
        }
        catch (IOException iOException) {
            CSDebug.logln("Exception:" + iOException.getMessage());
        }
        this.sortedSearch.clear();
        this.numberOfQuery = 0;
        object2 = this.logs.keySet().iterator();
        while (object2.hasNext()) {
            int n;
            string = (String)object2.next();
            object = (SearchFreq)this.logs.get(string);
            this.numberOfQuery += ((SearchFreq)object).freq;
            for (n = 0; n < this.sortedSearch.size(); ++n) {
                SearchFreq searchFreq = (SearchFreq)this.sortedSearch.get(n);
                if (((SearchFreq)object).freq > searchFreq.freq) break;
            }
            this.sortedSearch.add(n, object);
        }
        this.lastUpdated = new Date();
        try {
            this.writeToCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readFromCache() throws Exception {
        String string;
        String string2 = this.serverRoot + File.separator + "logs" + File.separator + "popularsearch.cache";
        File file = new File(string2);
        long l = file.lastModified();
        this.lastUpdated = new Date(l);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
        boolean bl = false;
        this.sortedSearch.clear();
        while ((string = bufferedReader.readLine()) != null) {
            String string3 = null;
            String string4 = null;
            int n = string.indexOf(DELIMITER);
            if (n < 0) continue;
            string3 = string.substring(0, n);
            string4 = string.substring(n + DELIMITER.length());
            CSDebug.logln("name=" + string3 + " value=" + string4);
            if (!bl && string3.equals("firstDate")) {
                this.firstDate = DateFormat.getDateInstance().parse(string4);
                bl = true;
                continue;
            }
            SearchFreq searchFreq = new SearchFreq(string3, Integer.parseInt(string4), false);
            this.numberOfQuery += Integer.parseInt(string4);
            this.sortedSearch.add(searchFreq);
        }
    }

    private void writeToCache() throws Exception {
        String string = this.serverRoot + File.separator + "logs" + File.separator + "popularsearch.cache";
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8")), true);
        printWriter.println("firstDate -->  " + DateFormat.getDateInstance().format(this.firstDate));
        for (int i = 0; i < this.getSize(); ++i) {
            printWriter.println(this.getScope(i) + DELIMITER + this.getFreq(i));
        }
        printWriter.close();
    }

    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<p><pre>\n");
        stringBuffer.append("Most popular user searches. \n");
        if (this.numberOfQuery == 1) {
            stringBuffer.append("1 query");
        } else if (this.numberOfQuery > 1) {
            stringBuffer.append(Integer.toString(this.numberOfQuery) + " queries");
        } else {
            stringBuffer.append("No queries");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d, yyyy");
        if (this.firstDate != null) {
            String string = simpleDateFormat.format(this.firstDate);
            stringBuffer.append(" examined since " + string);
        }
        stringBuffer.append("\n\n");
        for (int i = 0; i < this.sortedSearch.size(); ++i) {
            SearchFreq searchFreq = (SearchFreq)this.sortedSearch.get(i);
            stringBuffer.append(Integer.toString(searchFreq.freq) + "- " + searchFreq.scope + "\n");
        }
        stringBuffer.append("</pre>");
        return stringBuffer.toString();
    }

    public int getSize() {
        return this.sortedSearch.size();
    }

    public int getFreq(int n) {
        try {
            SearchFreq searchFreq = (SearchFreq)this.sortedSearch.get(n);
            if (searchFreq != null) {
                return searchFreq.freq;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public String getScope(int n) {
        try {
            SearchFreq searchFreq = (SearchFreq)this.sortedSearch.get(n);
            if (searchFreq != null) {
                return searchFreq.scope;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Date getFirstDate() {
        return this.firstDate;
    }

    public int getNumberOfQuery() {
        return this.numberOfQuery;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    class SearchFreq {
        String scope;
        int freq;
        boolean isBrowse;

        SearchFreq(String string, int n, boolean bl) {
            this.scope = string;
            this.freq = n;
            this.isBrowse = bl;
        }

        void inc() {
            ++this.freq;
        }
    }
}

