/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.search.admin.resources.SearchResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;

public class FilterSimulator {
    static String[] h_errmsg = new String[]{"simulator.successdns", "simulator.namenotfound", "simulator.dnsserverfail", "simulator.norecovery", "simulator.dns.noaddress", "simulator.unknownerror"};
    Locale locale = Locale.getDefault();

    public FilterSimulator(Locale locale) {
        this.locale = locale;
    }

    public FilterSimulator() {
    }

    String getI18n(String string) {
        return SearchResource.geti18nString(string, this.locale);
    }

    String accepted() {
        return this.font("green", this.getI18n("simulator.accepted"));
    }

    String rejected() {
        return this.font("red", this.getI18n("simulator.reject"));
    }

    String warning() {
        return this.font("brown", this.getI18n("simulator.warning"));
    }

    String href(String string) {
        return "<a target=_blank href = \"" + string + "\">" + string + "</a>";
    }

    String font(String string, String string2) {
        return "<font color=" + string + ">" + string2 + "</font>";
    }

    String trim_fr(String string) {
        if ((string = string.trim()).startsWith("<URL:")) {
            String string2 = string.substring(5, string.length() - 1);
            string = this.href(string2);
        } else {
            int n = string.indexOf(" -- ");
            if (n > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    String format(String string, String string2) {
        return "<tr><td>" + string + "</td>\n<td>" + string2 + "</td></tr>\n";
    }

    int getInt(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    String[] increaseArray(String[] stringArray) {
        if (stringArray == null) {
            return new String[10];
        }
        String[] stringArray2 = new String[stringArray.length + 10];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    boolean sameHost(String string, String string2) {
        if (string.charAt(0) == '/') {
            return true;
        }
        return string.indexOf("://" + string2) > 0;
    }

    public void getDomainByName(String string, String string2) throws Exception {
        HostResult hostResult = this.doGetHostByName(string, string2);
        switch (hostResult.h_errno) {
            case 0: {
                throw new Exception(this.getI18n("simulator.sameashostname"));
            }
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new Exception(this.getI18n("simulator.namenotfound"));
            }
            default: {
                throw new Exception(this.getI18n("simulator.unknownerror"));
            }
        }
    }

    public String getHostByName(String string, String string2) throws Exception {
        HostResult hostResult = this.doGetHostByName(string, string2);
        if (hostResult.h_errno != 0) {
            if (hostResult.h_errno > 0 && hostResult.h_errno < h_errmsg.length) {
                throw new Exception(this.getI18n(h_errmsg[hostResult.h_errno]));
            }
            throw new Exception(this.getI18n("simulator.unknownerror"));
        }
        return hostResult.h_cname;
    }

    public HostResult doGetHostByName(String string, String string2) throws Exception {
        String string3;
        String string4 = string + File.separator + "run-cs-cli hostinfo " + string2;
        Process process = Runtime.getRuntime().exec(string4);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string5 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        n3 = this.getInt(bufferedReader);
        if (n3 != 0) {
            String string6;
            if (n3 == 4) {
                string5 = string2;
            }
            while ((string6 = bufferedReader.readLine()) != null) {
            }
            bufferedReader.close();
            return new HostResult(string2, n3, string5, 0, 0, null, null);
        }
        string5 = bufferedReader.readLine();
        n = this.getInt(bufferedReader);
        n2 = this.getInt(bufferedReader);
        int n4 = 0;
        int n5 = 0;
        while ((string3 = bufferedReader.readLine()) != null && !string3.equalsIgnoreCase("ALIASES")) {
            if (n5 < ++n4) {
                stringArray2 = this.increaseArray(stringArray2);
                n5 = stringArray2.length;
            }
            stringArray2[n4 - 1] = string3;
        }
        if (string3 == null) {
            return new HostResult(string2, n3, string5, n, n2, stringArray2, null);
        }
        n4 = 0;
        n5 = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (n5 < ++n4) {
                stringArray = this.increaseArray(stringArray);
                n5 = stringArray.length;
            }
            stringArray[n4 - 1] = string3;
        }
        return new HostResult(string2, n3, string5, n, n2, stringArray2, stringArray);
    }

    public RedirectResult doRedirect(String string, boolean bl, String string2) throws Exception {
        String string3;
        String string4 = string + File.separator + "run-cs-cli ufetch ";
        if (!bl) {
            string4 = string4 + "-d ";
        }
        string4 = string4 + string2;
        Process process = Runtime.getRuntime().exec(string4);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string5 = null;
        String string6 = null;
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string3 = bufferedReader.readLine()) != null) {
            bl2 = true;
            if (!bl) {
                if (string3.length() > 7 && string3.substring(0, 7).equalsIgnoreCase("Server:")) {
                    string6 = string3.substring(7).trim();
                }
                if (string3.length() > 15 && string3.substring(0, 15).equalsIgnoreCase("Content-length:")) {
                    try {
                        n2 = Integer.parseInt(string3.substring(7).trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string3.length() > 9 && string3.substring(0, 9).equalsIgnoreCase("Location:") && !(string5 = string3.substring(9).trim()).equals(string2 + "/") && !string2.equals(string5 + "/")) {
                    bl3 = true;
                }
            }
            n += string3.length();
        }
        bufferedReader.close();
        if (n2 == 0) {
            n2 = n;
        }
        if (!bl2) {
            return new RedirectResult(-1, "", "", n2);
        }
        if (bl3) {
            return new RedirectResult(1, string5, string6, n2);
        }
        return new RedirectResult(0, null, string6, n2);
    }

    public String runProb(boolean bl, String string, boolean bl2, String string2) throws Exception {
        int n;
        int n2;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        int n3 = 0;
        try {
            URL uRL = new URL(string2);
            string4 = uRL.getHost();
            string5 = uRL.getProtocol();
            string6 = uRL.getFile();
            n3 = uRL.getPort();
        }
        catch (Exception exception) {
            string3 = this.warning() + " " + this.getI18n("simulator.malformed");
            return string3;
        }
        if (n3 < 1) {
            n3 = 80;
        }
        string3 = string3 + this.getI18n("simulator.checkingurl");
        string3 = string3 + "\n<br>";
        HostResult hostResult = this.doGetHostByName(string, string4);
        if (bl2) {
            string3 = string3 + "<pre>\n";
            string3 = string3 + hostResult.toString();
            string3 = string3 + "</pre>\n";
        }
        string3 = string3 + this.getI18n("simulator.result") + " &nbsp;";
        if (hostResult.h_errno != 0) {
            String string7 = hostResult.h_errno == 1 ? "<b>" + string4 + "</b>:&nbsp;" + this.getI18n("simulator.hostnotfound") : (hostResult.h_errno == 2 ? "<b>" + string4 + "</b>:&nbsp;" + this.getI18n("simulator.dnsfailure") : (hostResult.h_errno == 3 ? "<b>" + string4 + "</b>:&nbsp;" + this.getI18n("simulator.dnsfailnorecovery") : (hostResult.h_errno == 4 ? "<b>" + string4 + "</b>&nbsp;" + this.getI18n("simulator.isdomain") : "<b>" + string4 + "</b>:&nbsp;" + this.getI18n("simulator.unknownerror"))));
            string3 = string3 + string7;
            return string3;
        }
        string3 = string3 + "<b>" + string4 + "</b>&nbsp;" + this.getI18n("simulator.validname");
        string3 = string3 + "<br>\n";
        boolean bl3 = false;
        if (hostResult.h_aliases != null) {
            for (n2 = 0; n2 < hostResult.h_aliases.length; ++n2) {
                if (hostResult.h_aliases[n2].indexOf(string4) <= -1) continue;
                bl3 = true;
                break;
            }
        }
        if (bl3) {
            string3 = string3 + this.getI18n("simulator.note");
            string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;" + this.getI18n("simulator.aliasnamefor") + "&nbsp;<b>" + hostResult.h_cname + "</b>";
            string3 = string3 + "<br>\n";
        } else {
            string3 = string3 + this.getI18n("simulator.note");
            string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;" + this.getI18n("simulator.cnamefor");
            string3 = string3 + "<br>\n";
            string3 = string3 + this.getI18n("simulator.note");
            string3 = string3 + this.getI18n("simulator.nodnstrans");
            string3 = string3 + "<br>\n";
            if (!string4.equalsIgnoreCase(hostResult.h_cname)) {
                string3 = string3 + this.getI18n("simulator.refername");
                string3 = string3 + "&nbsp;<b>" + hostResult.h_cname + "</b>";
                string3 = string3 + "<br>\n";
            }
        }
        n2 = 0;
        if (bl3 && string4.startsWith("www.") && hostResult.h_cname.startsWith("www")) {
            for (n = 3; n < hostResult.h_cname.length() && Character.isDigit(hostResult.h_cname.charAt(n)); ++n) {
            }
            if (n < hostResult.h_cname.length() && hostResult.h_cname.charAt(n) == '.') {
                n2 = 1;
            }
        }
        n = 0;
        String string8 = "";
        if (bl3 && string4.startsWith("www")) {
            int n4;
            for (n4 = 3; n4 < string4.length() && Character.isDigit(string4.charAt(n4)); ++n4) {
            }
            if (n4 < string4.length() && string4.charAt(n4) == '.') {
                n = 1;
                string8 = "www" + string4.substring(n4);
            }
        }
        if (n2 != 0) {
            if (bl) {
                string3 = string3 + this.getI18n("simulator.note");
                string3 = string3 + this.getI18n("simulator.smarthoston");
                string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;";
                string3 = string3 + "<br>\n";
            } else {
                string3 = string3 + this.getI18n("simulator.note");
                string3 = string3 + this.getI18n("simulator.ifsmarthoston");
                string3 = string3 + "&nbsp;<b>" + hostResult.h_cname + "</b>&nbsp;";
                string3 = string3 + this.getI18n("simulator.automapto");
                string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;";
                string3 = string3 + "<br>\n";
            }
            string3 = string3 + this.getI18n("simulator.note");
            string3 = string3 + this.getI18n("simulator.ifhostlike");
            string3 = string3 + "&nbsp;<b>" + hostResult.h_cname + "</b>&nbsp;";
            string3 = string3 + this.getI18n("simulator.hasunique");
            string3 = string3 + "<br>\n";
        } else if (n != 0) {
            if (bl) {
                string3 = string3 + this.getI18n("simulator.actionsmarthostison");
                string3 = string3 + "&nbsp;'<b>" + string8 + "</b>'.";
            } else {
                string3 = string3 + this.getI18n("simulator.note");
                string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;";
                string3 = string3 + this.getI18n("simulator.dnsmirror");
                string3 = string3 + "<br>\n";
                string3 = string3 + this.getI18n("simulator.heavilyload");
                string3 = string3 + "&nbsp;<b>" + string8 + "</b>.&nbsp;";
                string3 = string3 + this.getI18n("simulator.enablesmarthost");
                string3 = string3 + "&nbsp;<b>" + string4 + "</b>&nbsp;";
                string3 = string3 + "<br>\n";
            }
            string3 = string3 + this.getI18n("simulator.note");
            string3 = string3 + this.getI18n("simulator.ifhostlike");
            string3 = string3 + "&nbsp;<b>" + hostResult.h_cname + "</b>&nbsp;";
            string3 = string3 + this.getI18n("simulator.hasunique");
            string3 = string3 + "<br>\n";
        }
        if (!string5.startsWith("http")) {
            return string3;
        }
        string3 = string3 + "\n<hr>\n";
        string3 = string3 + this.getI18n("simulator.checkredirect");
        string3 = string3 + "<br>\n";
        RedirectResult redirectResult = this.doRedirect(string, false, string2);
        if (redirectResult.return_code < 0) {
            string3 = string3 + this.getI18n("simulator.failconnect");
            string3 = string3 + "&nbsp;" + this.href(string2) + "<br>";
            string3 = string3 + this.getI18n("simulator.noservice");
            return string3;
        }
        if (redirectResult.return_code == 0) {
            string3 = string3 + this.getI18n("simulator.noredirectat");
            string3 = string3 + "&nbsp;" + this.href(string2) + "<br>";
        } else {
            string3 = string3 + this.href(string2) + "&nbsp;";
            string3 = string3 + this.getI18n("simulator.isredirect") + "&nbsp;";
            string3 = redirectResult.redirect_url.indexOf("://") > 0 ? string3 + this.href(redirectResult.redirect_url) : string3 + this.href(string5 + "://" + string4 + ":" + n3 + (redirectResult.redirect_url.charAt(0) == '/' ? "/" : "") + redirectResult.redirect_url);
            string3 = string3 + "<br>\n";
            if (this.sameHost(redirectResult.redirect_url, string4)) {
                string3 = string3 + this.getI18n("simulator.redirect2same");
            } else {
                string3 = string3 + this.getI18n("simulator.needsite4redirect");
                string3 = string3 + "&nbsp;<b>" + this.href(redirectResult.redirect_url) + "</b>";
            }
            string3 = string3 + "<br>\n";
        }
        string3 = string3 + "<hr>\n";
        string3 = string3 + this.getI18n("simulator.servertype") + "&nbsp;" + (redirectResult.server_type == null ? this.getI18n("simulator.unknowntype") : redirectResult.server_type) + "<br>\n";
        if (redirectResult.return_code >= 0) {
            string3 = string3 + "<hr>\n";
            string3 = string3 + this.getI18n("simulator.checkvirtual");
            string3 = string3 + "<br>\n";
            RedirectResult redirectResult2 = this.doRedirect(string, true, string2);
            String string9 = string5 + "://" + hostResult.h_cname + ":" + n3 + string6;
            RedirectResult redirectResult3 = this.doRedirect(string, true, string9);
            if (redirectResult2.return_code < 0) {
                string3 = string3 + this.getI18n("simulator.failconnect");
                string3 = string3 + "&nbsp;" + this.href(string2) + "<br>";
                string3 = string3 + this.getI18n("simulator.noservice");
            }
            if (redirectResult3.return_code < 0) {
                string3 = string3 + this.getI18n("simulator.failconnect");
                string3 = string3 + "&nbsp;" + this.href(string9) + "<br>";
                string3 = string3 + this.getI18n("simulator.noservice");
            }
            if (redirectResult2.content_length < 0) {
                string3 = string3 + this.getI18n("simulator.failconnect");
                string3 = string3 + "&nbsp;" + this.href(string9) + "<br>";
                string3 = string3 + this.getI18n("simulator.noservice");
            }
            if (redirectResult3.return_code < 0 || redirectResult2.return_code < 0) {
                return string3;
            }
            if (redirectResult3.content_length == 0) {
                string3 = string3 + this.getI18n("simulator.failcontentlength");
                string3 = string3 + "&nbsp;" + this.href(string9) + "<br>";
                string3 = string3 + this.getI18n("simulator.nocontentlength");
            }
            if (redirectResult2.content_length == 0) {
                string3 = string3 + this.getI18n("simulator.failcontentlength");
                string3 = string3 + "&nbsp;" + this.href(string2) + "<br>";
                string3 = string3 + this.getI18n("simulator.nocontentlength");
            }
            if (redirectResult2.content_length == 0 || redirectResult3.content_length == 0) {
                return string3;
            }
            if (redirectResult2.content_length == redirectResult3.content_length) {
                string3 = string3 + this.getI18n("simulator.novirtual");
                string3 = string3 + "&nbsp;" + this.href(string2);
            } else {
                string3 = string3 + this.href(string9) + "&nbsp;";
                string3 = string3 + this.getI18n("simulator.isvirtual");
                string3 = string3 + "&nbsp;" + this.href(string9);
            }
            string3 = string3 + "<br>\n";
        }
        return string3;
    }

    public String runSimulator(boolean bl, String string, String[] stringArray, boolean bl2, boolean bl3) throws Exception {
        String string2 = string + File.separator + "run-cs-cli frsim -l " + string + File.separator + "config" + File.separator + "filterrules.conf";
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string4;
            boolean bl4 = false;
            Process process = Runtime.getRuntime().exec(string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            PrintWriter printWriter = new PrintWriter(process.getOutputStream());
            printWriter.println(stringArray[i]);
            printWriter.flush();
            printWriter.close();
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.substring(0, 9).equalsIgnoreCase("Accepted:")) {
                    bl4 = true;
                    string3 = string3 + this.format(this.accepted(), this.trim_fr(string4.substring(9)));
                    continue;
                }
                if (string4.substring(0, 9).equalsIgnoreCase("Rejected:")) {
                    string3 = string3 + this.format(this.rejected(), this.trim_fr(string4.substring(9)));
                    continue;
                }
                if (string4.substring(0, 8).equalsIgnoreCase("Skipping")) {
                    string3 = string3 + this.format(this.warning(), this.trim_fr(string4));
                    continue;
                }
                string3 = string3 + this.format(this.warning(), string4);
            }
            bufferedReader.close();
            String string5 = "";
            try {
                URL uRL = new URL(stringArray[i]);
                string5 = uRL.getHost();
            }
            catch (Exception exception) {
                string3 = string3 + this.format(this.warning(), this.getI18n("simulator.malformed"));
                bl4 = false;
            }
            if (bl4 && bl2) {
                object = this.doGetHostByName(string, string5);
                if (((HostResult)object).h_errno != 0) {
                    String string6 = ((HostResult)object).h_errno == 1 ? this.getI18n("simulator.invalidhost") + string5 : (((HostResult)object).h_errno == 2 || ((HostResult)object).h_errno == 3 ? this.getI18n("simulator.dnsreterror") : (((HostResult)object).h_errno == 4 ? this.getI18n("simulator.donmainnothost") : this.getI18n("simulator.unknownerror")));
                    string3 = string3 + this.format(this.rejected(), string6);
                } else if (((HostResult)object).h_aliases != null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    char c = '\u0000';
                    while (i < ((HostResult)object).h_aliases.length) {
                        if (((HostResult)object).h_aliases[c].indexOf(string5) > -1) {
                            bl5 = true;
                            break;
                        }
                        ++c;
                    }
                    if (bl5 && bl && ((HostResult)object).h_cname.length() > 4) {
                        c = ((HostResult)object).h_cname.charAt(4);
                        if (((HostResult)object).h_cname.startsWith("www") && (c == '.' || Character.isDigit(c))) {
                            bl6 = true;
                        }
                    }
                    string3 = bl6 ? string3 + this.format(this.accepted(), this.getI18n("simulator.alias") + " " + ((HostResult)object).h_cname + " " + this.getI18n("simulator.aliasallow")) : string3 + this.format(this.rejected(), this.getI18n("simulator.alias4") + " " + ((HostResult)object).h_cname);
                } else {
                    string3 = string3 + this.format(this.accepted(), this.getI18n("simulator.validhostname"));
                }
            }
            if (!bl4 || !bl3) continue;
            object = this.doRedirect(string, false, stringArray[i]);
            if (((RedirectResult)object).return_code < 0) {
                string3 = string3 + this.format(this.warning(), this.getI18n("simulator.failconnect"));
            }
            string3 = ((RedirectResult)object).return_code == 0 ? string3 + this.format(this.accepted(), this.getI18n("simulator.noredirect")) : (this.sameHost(((RedirectResult)object).redirect_url, string5) ? string3 + this.format(this.warning(), this.getI18n("simulator.rejectbyrule") + string5) : string3 + this.format(this.rejected(), this.getI18n("simulator.redirect2") + this.href(((RedirectResult)object).redirect_url)));
        }
        return string3;
    }

    static void main(String[] stringArray) throws Exception {
        FilterSimulator filterSimulator = new FilterSimulator();
        System.out.println("<html><body>\n");
        String string = filterSimulator.runSimulator(true, stringArray[0], stringArray, true, true);
        System.out.println("\n<hr>Simulator Result is:<hr><table>\n ");
        System.out.println(string);
        System.out.println("</table>\n");
        string = filterSimulator.runProb(true, stringArray[0], true, stringArray[1]);
        System.out.println("\n<hr>Site Prob Result is:<hr><table>\n ");
        System.out.println(string);
        System.out.println("</table>\n");
        System.out.println("</body></html>\n");
    }

    class RedirectResult {
        String redirect_url;
        String server_type;
        int content_length;
        int return_code;

        public RedirectResult(int n, String string, String string2, int n2) {
            this.redirect_url = string;
            this.server_type = string2;
            this.content_length = n2;
            this.return_code = n;
        }
    }

    class HostResult {
        String h_cname;
        int h_type;
        int h_errno;
        int h_length;
        String[] h_ips;
        String[] h_aliases;
        String org_url;

        public HostResult(String string, int n, String string2, int n2, int n3, String[] stringArray, String[] stringArray2) {
            this.org_url = string;
            this.h_cname = string2;
            this.h_length = n2;
            this.h_type = n3;
            this.h_ips = stringArray;
            this.h_aliases = stringArray2;
            this.h_errno = n;
        }

        public String toString() {
            int n;
            String string = "";
            string = string + "GetHostByname() " + FilterSimulator.this.getI18n("simulator.resultfor") + " '" + this.org_url + "'\n";
            string = string + "h_error: " + this.h_errno + " - ";
            switch (this.h_errno) {
                case 0: {
                    string = string + FilterSimulator.this.getI18n("simulator.successdns");
                    break;
                }
                case 1: {
                    string = string + FilterSimulator.this.getI18n("simulator.namenotfound");
                    break;
                }
                case 2: {
                    string = string + FilterSimulator.this.getI18n("simulator.dnsserverfail");
                    break;
                }
                case 3: {
                    string = string + FilterSimulator.this.getI18n("simulator.norecovery");
                    break;
                }
                case 4: {
                    string = string + FilterSimulator.this.getI18n("simulator.samename");
                    break;
                }
                default: {
                    string = string + FilterSimulator.this.getI18n("simulator.unknownerror");
                }
            }
            string = string + "\nName:     " + (this.h_cname != null ? this.h_cname : "");
            if (this.h_aliases != null) {
                for (n = 0; n < this.h_aliases.length && this.h_aliases[n] != null; ++n) {
                    string = string + "\nAliase:   " + this.h_aliases[n];
                }
            }
            string = string + "\naddrtype: " + this.h_type;
            string = string + "\nlength:   " + this.h_length;
            if (this.h_ips != null) {
                for (n = 0; n < this.h_ips.length && this.h_ips[n] != null; ++n) {
                    string = string + "\nip:       " + this.h_ips[n];
                }
            }
            string = string + "\n";
            return string;
        }
    }
}

