/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xml.utils.DOM2Helper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;
    private int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public int getCurrentPos() {
        return this.m_next;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public int getWhatToShow() {
        return -17;
    }

    public int size() {
        return this.m_firstFree;
    }

    public NodeSet() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public void detach() {
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            this.m_map[i] = null;
            ++i;
        }
        this.m_firstFree = 0;
    }

    public void reset() {
        this.m_next = 0;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public NodeSet(int blocksize) {
        this.m_blocksize = blocksize;
        this.m_mapSize = 0;
    }

    public void removeElementAt(int i) {
        if (null == this.m_map) {
            return;
        }
        if (i >= this.m_firstFree) {
            throw new ArrayIndexOutOfBoundsException(i + " >= " + this.m_firstFree);
        }
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        if (i < this.m_firstFree - 1) {
            System.arraycopy(this.m_map, i + 1, this.m_map, i, this.m_firstFree - i - 1);
        }
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public void runTo(int index) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = index >= 0 && this.m_next < this.m_firstFree ? index : this.m_firstFree - 1;
    }

    public void setCurrentPos(int i) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = i;
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public void setShouldCacheNodes(boolean b) {
        if (!this.isFresh()) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = b;
        this.m_mutable = true;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)super.clone();
        if (null != this.m_map && this.m_map == clone.m_map) {
            clone.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, clone.m_map, 0, this.m_map.length);
        }
        return clone;
    }

    public NodeSet(NodeSet nodelist) {
        this(32);
        this.addNodes((NodeIterator)nodelist);
    }

    public void addNodes(NodeSet ns) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addNodes((NodeIterator)ns);
    }

    public void appendNodes(NodeSet nodes) {
        int nNodes = nodes.size();
        if (null == this.m_map) {
            this.m_mapSize = nNodes + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + nNodes >= this.m_mapSize) {
            this.m_mapSize += nNodes + this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + nNodes);
            this.m_map = newMap;
        }
        System.arraycopy(nodes.m_map, 0, this.m_map, this.m_firstFree, nNodes);
        this.m_firstFree += nNodes;
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        int saved = this.m_next;
        Node n = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : null;
        this.m_next = saved;
        return n;
    }

    public Node getRoot() {
        return null;
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node next = this.elementAt(this.m_next);
            ++this.m_next;
            return next;
        }
        return null;
    }

    public final Node peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node n = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return n;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public Node elementAt(int i) {
        if (null == this.m_map) {
            return null;
        }
        return this.m_map[i];
    }

    public Node item(int index) {
        this.runTo(index);
        return this.elementAt(index);
    }

    public int indexOf(Node elem) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (null != node && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public NodeSet(Node node) {
        this(32);
        this.addNode(node);
    }

    public void addElement(Node value) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[this.m_firstFree] = value;
        ++this.m_firstFree;
    }

    public void addNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addElement(n);
    }

    public final void push(Node value) {
        int ff = this.m_firstFree;
        if (ff + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] newMap = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, newMap, 0, ff + 1);
                this.m_map = newMap;
            }
        }
        this.m_map[ff] = value;
        this.m_firstFree = ++ff;
    }

    public void removeNode(Node n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.removeElement(n);
    }

    public final void setTail(Node n) {
        this.m_map[this.m_firstFree - 1] = n;
    }

    public final void setTailSub1(Node n) {
        this.m_map[this.m_firstFree - 2] = n;
    }

    public boolean contains(Node s) {
        this.runTo(-1);
        if (null == this.m_map) {
            return false;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (null != node && node.equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean removeElement(Node s) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            return false;
        }
        int i = 0;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (null != node && node.equals(s)) {
                if (i < this.m_firstFree - 1) {
                    System.arraycopy(this.m_map, i + 1, this.m_map, i, this.m_firstFree - i - 1);
                }
                --this.m_firstFree;
                this.m_map[this.m_firstFree] = null;
                return true;
            }
            ++i;
        }
        return false;
    }

    public int indexOf(Node elem, int index) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        int i = index;
        while (i < this.m_firstFree) {
            Node node = this.m_map[i];
            if (null != node && node.equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insertElementAt(Node value, int at) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree + 1);
            this.m_map = newMap;
        }
        if (at <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, at, this.m_map, at + 1, this.m_firstFree - at);
        }
        this.m_map[at] = value;
        ++this.m_firstFree;
    }

    public void insertNode(Node n, int pos) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.insertElementAt(n, pos);
    }

    public void setElementAt(Node node, int index) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[index] = node;
    }

    public NodeSet(NodeList nodelist) {
        this(32);
        this.addNodes(nodelist);
    }

    public void addNodes(NodeList nodelist) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != nodelist) {
            int nChildren = nodelist.getLength();
            int i = 0;
            while (i < nChildren) {
                Node obj = nodelist.item(i);
                if (null != obj) {
                    this.addElement(obj);
                }
                ++i;
            }
        }
    }

    public NodeFilter getFilter() {
        return null;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet clone = (NodeSet)this.clone();
        clone.reset();
        return clone;
    }

    public NodeSet(NodeIterator ni) {
        this(32);
        this.addNodes(ni);
    }

    /*
     * WARNING - void declaration
     */
    public void addNodes(NodeIterator iterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != iterator) {
            Node obj;
            while (null != (obj = iterator.nextNode())) {
                void var2_2;
                this.addElement((Node)var2_2);
            }
        }
    }

    public int addNodeInDocOrder(Node node, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        return this.addNodeInDocOrder(node, true, support);
    }

    public int addNodeInDocOrder(Node node, boolean test, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int insertIndex = -1;
        if (test) {
            int size = this.size();
            int i = size - 1;
            while (i >= 0) {
                Node child = this.elementAt(i);
                if (child == node) {
                    i = -2;
                    break;
                }
                if (!DOM2Helper.isNodeAfter(node, child)) break;
                --i;
            }
            if (i != -2) {
                insertIndex = i + 1;
                this.insertElementAt(node, insertIndex);
            }
        } else {
            insertIndex = this.size();
            boolean foundit = false;
            int i = 0;
            while (i < insertIndex) {
                if (this.item(i).equals(node)) {
                    foundit = true;
                    break;
                }
                ++i;
            }
            if (!foundit) {
                this.addElement(node);
            }
        }
        return insertIndex;
    }

    private boolean addNodesInDocOrder(int start, int end, int testIndex, NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        boolean foundit = false;
        Node node = nodelist.item(testIndex);
        int i = end;
        while (i >= start) {
            Node child = this.elementAt(i);
            if (child == node) {
                i = -2;
                break;
            }
            if (!DOM2Helper.isNodeAfter(node, child)) {
                boolean foundPrev;
                this.insertElementAt(node, i + 1);
                if (--testIndex <= 0 || (foundPrev = this.addNodesInDocOrder(0, i, testIndex, nodelist, support))) break;
                this.addNodesInDocOrder(i, this.size() - 1, testIndex, nodelist, support);
                break;
            }
            --i;
        }
        if (i == -1) {
            this.insertElementAt(node, 0);
        }
        return foundit;
    }

    public void addNodesInDocOrder(NodeList nodelist, XPathContext support) {
        if (!this.m_mutable) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int nChildren = nodelist.getLength();
        int i = 0;
        while (i < nChildren) {
            Node node = nodelist.item(i);
            if (null != node) {
                this.addNodeInDocOrder(node, support);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addNodesInDocOrder(NodeIterator iterator, XPathContext support) {
        if (this.m_mutable) ** GOTO lbl5
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
lbl-1000:
        // 1 sources

        {
            this.addNodeInDocOrder((Node)var3_3, support);
lbl5:
            // 2 sources

            ** while (null != (node = iterator.nextNode()))
        }
lbl6:
        // 1 sources

    }

    public final void pushPair(Node v1, Node v2) {
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] newMap = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, newMap, 0, this.m_firstFree);
            this.m_map = newMap;
        }
        this.m_map[this.m_firstFree] = v1;
        this.m_map[this.m_firstFree + 1] = v2;
        this.m_firstFree += 2;
    }
}

