/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemAttributeSet;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;

public class ElemUse
extends ElemTemplateElement {
    private QName[] m_attributeSetsNames = null;

    public void setUseAttributeSets(Vector v) {
        int n = v.size();
        this.m_attributeSetsNames = new QName[n];
        int i = 0;
        while (i < n) {
            this.m_attributeSetsNames[i] = (QName)v.elementAt(i);
            ++i;
        }
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        if (null != this.m_attributeSetsNames) {
            this.applyAttrSets(transformer, this.getStylesheetRoot(), this.m_attributeSetsNames);
        }
    }

    public QName[] getUseAttributeSets() {
        return this.m_attributeSetsNames;
    }

    public void setUseAttributeSets(QName[] v) {
        this.m_attributeSetsNames = v;
    }

    public void applyAttrSets(TransformerImpl transformer, StylesheetRoot stylesheet) throws TransformerException {
        this.applyAttrSets(transformer, stylesheet, this.m_attributeSetsNames);
    }

    private void applyAttrSets(TransformerImpl transformer, StylesheetRoot stylesheet, QName[] attributeSetsNames) throws TransformerException {
        if (null != attributeSetsNames) {
            int nNames = attributeSetsNames.length;
            int i = 0;
            while (i < nNames) {
                QName qname = attributeSetsNames[i];
                Vector attrSets = stylesheet.getAttributeSetComposed(qname);
                if (null != attrSets) {
                    int nSets = attrSets.size();
                    int k = nSets - 1;
                    while (k >= 0) {
                        ElemAttributeSet attrSet = (ElemAttributeSet)attrSets.elementAt(k);
                        attrSet.execute(transformer);
                        --k;
                    }
                } else {
                    throw new TransformerException(XSLMessages.createMessage("ER_NO_ATTRIB_SET", new Object[]{qname}), this);
                }
                ++i;
            }
        }
    }
}

