/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.util.AttributeHTML;
import org.apache.bcel.util.CodeHTML;
import org.apache.bcel.util.ConstantHTML;
import org.apache.bcel.util.MethodHTML;

public class Class2HTML
implements Constants {
    private JavaClass java_class;
    private String dir;
    private static String class_package;
    private static String class_name;
    private static ConstantPool constant_pool;

    static String referenceClass(int index) {
        String str = constant_pool.getConstantString(index, (byte)7);
        str = Utility.compactClassName(str);
        str = Utility.compactClassName(str, class_package + ".", true);
        return "<A HREF=\"" + class_name + "_cp.html#cp" + index + "\" TARGET=ConstantPool>" + str + "</A>";
    }

    public static void main(String[] argv) {
        String[] file_name = new String[argv.length];
        int files = 0;
        ClassParser parser = null;
        JavaClass java_class = null;
        String zip_file = null;
        char sep = System.getProperty("file.separator").toCharArray()[0];
        String dir = "." + sep;
        try {
            int i = 0;
            while (i < argv.length) {
                if (argv[i].charAt(0) == '-') {
                    if (argv[i].equals("-d")) {
                        if (!(dir = argv[++i]).endsWith("" + sep)) {
                            dir = dir + sep;
                        }
                        new File(dir).mkdirs();
                    } else if (argv[i].equals("-zip")) {
                        zip_file = argv[++i];
                    } else {
                        System.out.println("Unknown option " + argv[i]);
                    }
                } else {
                    file_name[files++] = argv[i];
                }
                ++i;
            }
            if (files == 0) {
                System.err.println("Class2HTML: No input files specified.");
            } else {
                int i2 = 0;
                while (i2 < files) {
                    System.out.print("Processing " + file_name[i2] + "...");
                    parser = zip_file == null ? new ClassParser(file_name[i2]) : new ClassParser(zip_file, file_name[i2]);
                    java_class = parser.parse();
                    new Class2HTML(java_class, dir);
                    System.out.println("Done.");
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    private void writeMainHTML(AttributeHTML attribute_html) throws IOException {
        PrintWriter file = new PrintWriter(new FileOutputStream(this.dir + class_name + ".html"));
        Attribute[] attributes = this.java_class.getAttributes();
        file.println("<HTML>\n<HEAD><TITLE>Documentation for " + class_name + "</TITLE>" + "</HEAD>\n" + "<FRAMESET BORDER=1 cols=\"30%,*\">\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"ConstantPool\" SRC=\"" + class_name + "_cp.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Attributes\" SRC=\"" + class_name + "_attributes.html" + "\"\n MARGINWIDTH=\"0\" " + "MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n" + "</FRAMESET>\n" + "<FRAMESET BORDER=1 rows=\"80%,*\">\n" + "<FRAME NAME=\"Code\" SRC=\"" + class_name + "_code.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "<FRAME NAME=\"Methods\" SRC=\"" + class_name + "_methods.html\"\n MARGINWIDTH=0 " + "MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n" + "</FRAMESET></FRAMESET></HTML>");
        file.close();
        int i = 0;
        while (i < attributes.length) {
            attribute_html.writeAttribute(attributes[i], "class" + i);
            ++i;
        }
    }

    static final String referenceType(String type) {
        String short_type = Utility.compactClassName(type);
        short_type = Utility.compactClassName(short_type, class_package + ".", true);
        int index = type.indexOf(91);
        if (index > -1) {
            type = type.substring(0, index);
        }
        if (type.equals("int") || type.equals("short") || type.equals("boolean") || type.equals("void") || type.equals("char") || type.equals("byte") || type.equals("long") || type.equals("double") || type.equals("float")) {
            return "<FONT COLOR=\"#00FF00\">" + type + "</FONT>";
        }
        return "<A HREF=\"" + type + ".html\" TARGET=_top>" + short_type + "</A>";
    }

    static String toHTML(String str) {
        StringBuffer buf = new StringBuffer();
        try {
            int i = 0;
            while (i < str.length()) {
                char ch = str.charAt(i);
                switch (ch) {
                    case '<': {
                        buf.append("&lt;");
                        break;
                    }
                    case '>': {
                        buf.append("&gt;");
                        break;
                    }
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
                ++i;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            // empty catch block
        }
        return buf.toString();
    }

    public Class2HTML(JavaClass java_class, String dir) throws IOException {
        Method[] methods = java_class.getMethods();
        this.java_class = java_class;
        this.dir = dir;
        class_name = java_class.getClassName();
        constant_pool = java_class.getConstantPool();
        int index = class_name.lastIndexOf(46);
        class_package = index > -1 ? class_name.substring(0, index) : "";
        ConstantHTML constant_html = new ConstantHTML(dir, class_name, class_package, methods, constant_pool);
        AttributeHTML attribute_html = new AttributeHTML(dir, class_name, constant_pool, constant_html);
        MethodHTML method_html = new MethodHTML(dir, class_name, methods, java_class.getFields(), constant_html, attribute_html);
        this.writeMainHTML(attribute_html);
        new CodeHTML(dir, class_name, methods, constant_pool, constant_html);
        attribute_html.close();
    }
}

