/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class PDWarUpdater {
    private File warFile = null;
    private JarFile jar = null;
    private Properties configProps = null;
    private static final String PAE_LOCATION = "PAEJarLocation";
    private static final String TLD_LOCATION = "tldLocation";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String WEB_XML = "web.xml";
    private static final String WEB_XML_NAME = "WEB-INF/web.xml";
    private static final String PAE_PREFIX = "WEB-INF/lib/";
    private static final String DD_LOCATION = "DDFileLocation";

    public PDWarUpdater(File warFile, Properties props) throws IOException {
        this.warFile = warFile;
        this.jar = new JarFile(warFile);
        this.configProps = props;
    }

    public JarFile getJarFile() {
        return this.jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getUpdatedWarFile(File webXMLFile) throws IOException {
        String PAEFilename = this.configProps.getProperty(PAE_LOCATION);
        File paeFile = new File(PAEFilename);
        String tldFileName = this.configProps.getProperty(TLD_LOCATION);
        File tldFile = new File(tldFileName);
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        File tempJarFile = new File(ddLocation, this.warFile.getName() + ".tmp");
        tempJarFile.deleteOnExit();
        boolean jarUpdated = false;
        try {
            Manifest jarManifest = this.jar.getManifest();
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                FileInputStream file = new FileInputStream(paeFile);
                try {
                    JarEntry entry = new JarEntry(PAE_PREFIX + paeFile.getName());
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = file.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    file.close();
                }
                FileInputStream webXMLin = new FileInputStream(webXMLFile);
                try {
                    JarEntry entry = new JarEntry(WEB_XML_NAME);
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = webXMLin.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    webXMLin.close();
                }
                FileInputStream tldin = new FileInputStream(tldFile);
                try {
                    JarEntry entry = new JarEntry(WEB_INF_PREFIX + tldFile.getName());
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = tldin.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    tldin.close();
                }
                Enumeration<JarEntry> entries = this.jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().equals(WEB_XML_NAME) || entry.getName().equals(PAE_PREFIX + paeFile.getName()) || entry.getName().equals(WEB_INF_PREFIX + tldFile.getName())) continue;
                    InputStream entryStream = this.jar.getInputStream(entry);
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = entryStream.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                jarUpdated = true;
            }
            catch (Exception ex) {
                PortletDeployerLocalizer.error(ex.toString());
                tempJar.putNextEntry(new JarEntry("stub"));
            }
            finally {
                tempJar.close();
            }
            Object var21_24 = null;
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            this.jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
            throw throwable;
        }
        this.jar.close();
        if (!jarUpdated) {
            tempJarFile.delete();
        }
        if (jarUpdated) {
            return tempJarFile;
        }
        return null;
    }
}

