/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.providers;

import com.sun.portal.search.demo.Search;
import com.sun.portal.search.util.Encoder;
import java.util.ArrayList;
import java.util.HashMap;

public class SearchContext
extends Search {
    public static final String OPERAND = "1";
    public static final String OPERATION = "2";
    public static final String VALUE = "3";
    public static final String CONTAIN = "contain";
    public static final String NOTCONTAIN = "notcontain";
    public static final String NOT = "not";
    public static final String ANY = "any";
    public static final String EXACT = "exact";
    public static final String ALL = "all";
    public static final String PASSAGE = "passage";
    public static final String GREATER = "greater";
    public static final String LESS = "less";
    public static final String EQUAL = "equal";
    public static final String NOTEQUAL = "notequal";
    private StringBuffer scopebuf = null;
    private boolean searchAllCategories = true;
    private ArrayList criteria;
    private int page = 0;
    private String browseCategory = "ROOT";
    private int totalPages = 0;

    public void setPage(int n) {
        this.page = n;
    }

    public int getPage() {
        if (this.page == 0) {
            this.page = this.firstHit >= 0 && this.viewHits > 0 ? this.firstHit / this.viewHits + 1 : 1;
        }
        return this.page;
    }

    public String getCategory() {
        return this.browseCategory;
    }

    public void setCategory(String string) {
        if (string != null && !string.equals("")) {
            this.browseCategory = string;
        }
    }

    public void setSearchAllCategories(boolean bl) {
        this.searchAllCategories = bl;
    }

    public void setScope(ArrayList arrayList) {
        this.criteria = arrayList;
        String string = "";
        this.scopebuf = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)((HashMap)arrayList.get(i)).get(OPERAND);
            String string3 = (String)((HashMap)arrayList.get(i)).get(OPERATION);
            String string4 = (String)((HashMap)arrayList.get(i)).get(VALUE);
            if (string4 != null && !string4.equals("")) {
                string = this.getRightOperator(string3, string4);
                if (i == arrayList.size() - 1) {
                    this.parse(string2, string3, string, true);
                } else {
                    this.parse(string2, string3, string, false);
                }
            }
            this.scope = this.scopebuf.toString();
            if (!this.scope.endsWith(" <AND> ")) continue;
            this.scope = this.scope.substring(0, this.scope.length() - 7);
        }
    }

    public void execute() throws Exception {
        if (this.viewHits == 0 || this.viewHits > 500) {
            this.viewHits = 8;
        }
        if (this.firstHit == 0) {
            this.firstHit = this.viewHits * (this.getPage() - 1) + 1;
        }
        if (this.RDMType.equals("taxonomy-request") && this.queryLanguage.equals("taxonomy-basic")) {
            this.scope = "children* " + this.browseCategory;
        } else if (this.RDMType.equals("taxonomy-request") && this.scope.equals("")) {
            this.scope = "(id <STARTS> \"" + Encoder.quotedEscape((String)this.browseCategory) + "\")";
        } else if (this.RDMType.equals("taxonomy-request") && !this.scope.equals("")) {
            if (!this.searchAllCategories) {
                this.scope = "(" + this.scope + ") <AND> (id <STARTS> \"" + Encoder.quotedEscape((String)this.browseCategory) + "\")";
            }
        } else if (this.RDMType.equals("rd-request") && this.scope.equals("")) {
            this.scope = "(classification = \"" + Encoder.quotedEscape((String)this.browseCategory) + "\")";
        } else if (this.RDMType.equals("rd-request") && !this.scope.equals("") && !this.searchAllCategories) {
            this.scope = "(" + this.scope + ") <AND> (classification <STARTS> \"" + Encoder.quotedEscape((String)this.browseCategory) + "\")";
        }
        this.doQuery(this.firstHit, this.viewHits);
        if (this.getResultStream() == null) {
            throw new Exception("Search server error.");
        }
        int n = this.getHitCount();
        this.totalPages = (n + this.viewHits - 1) / this.viewHits;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    private String getRightOperator(String string, String string2) {
        String string3 = "";
        string3 = string.equals(ALL) || string.equals(PASSAGE) || string2.equals(" ") ? string2 : (string.equals(EXACT) ? "\"" + string2 + "\"" : (string.equals(ANY) ? "<SOR> " + string2 : string2));
        return string3;
    }

    private void parse(String string, String string2, String string3, boolean bl) {
        if (string2.equals(CONTAIN)) {
            this.scopebuf.append("(" + string + " <CONTAINS> " + string3 + ")");
        } else if (string2.equals(NOTCONTAIN)) {
            this.scopebuf.append("<NOT> (" + string + " <CONTAINS> " + string3 + ")");
        } else if (string2.equals(EQUAL)) {
            this.scopebuf.append("(" + string + " = " + string3 + ")");
        } else if (string2.equals(NOTEQUAL)) {
            this.scopebuf.append("<NOT> (" + string + " = " + string3 + ")");
        } else if (string2.equals(LESS)) {
            this.scopebuf.append("(" + string + " < " + string3 + ")");
        } else if (string2.equals(GREATER)) {
            this.scopebuf.append("(" + string + " > " + string3 + ")");
        } else if (string2.equals(NOT)) {
            this.scopebuf.append("<NOT> (" + string3 + ")");
        } else if (string2.equals(ALL)) {
            this.scopebuf.append("(" + string3 + ")");
        } else if (string2.equals(ANY)) {
            this.scopebuf.append("(" + string3 + ")");
        } else if (string2.equals(EXACT)) {
            this.scopebuf.append("(" + string3 + ")");
        } else if (string2.equals(PASSAGE)) {
            this.scopebuf.append("(<PASSAGE> " + string3 + ")");
        } else {
            this.scopebuf.append("(" + string3 + ")");
        }
        if (!bl) {
            this.scopebuf.append(" <AND> ");
        }
    }

    public static String htmlEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

