/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.db.RDMSecurityManager;
import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdmserver.RDMConfig;
import com.sun.portal.search.rdmserver.RDMContext;
import com.sun.portal.search.rdmserver.RDMServer;
import com.sun.portal.search.rdmserver.RDMServletContext;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.Decoder;
import com.sun.portal.search.util.SearchConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RDMServlet
extends HttpServlet {
    RDMContext rdmcontext;
    RDMServer rdmserver;
    RDMConfig rdmconfig;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            this.rdmcontext = new RDMServletContext(servletConfig);
            this.rdmconfig = this.rdmcontext.getRDMConfig();
            this.rdmserver = new RDMServer(this.rdmcontext);
            this.rdmserver.init(this.rdmconfig);
            RDMSecurityManager rDMSecurityManager = RDMSecurityManager.getInstance();
            String string = SearchConfig.getValue("security-mode");
            if (string != null && string.equalsIgnoreCase("ON")) {
                String string2 = SearchConfig.getValue("security-manager");
                RDMSecurityManager rDMSecurityManager2 = (RDMSecurityManager)Class.forName(string2).newInstance();
                RDMSecurityManager.setInstance(rDMSecurityManager2);
            }
        }
        catch (Exception exception) {
            try {
                this.rdmcontext.log("RDM Server failed to start", exception);
                CSLog.error(1, 1, "RDM server failed to start", exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new ServletException((Throwable)exception);
        }
        this.rdmcontext.log("RDM Server is on-line: " + this.rdmserver.getVersion());
        CSLog.log(1, 1, "RDM Server is on-line: " + this.rdmserver.getVersion());
        if (CSLog.getLogLevel() >= 5) {
            this.dumpProps(servletConfig);
        }
    }

    void dumpProps(ServletConfig servletConfig) {
        String string;
        String string2 = "\nSystem Properties\n";
        Enumeration enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + string + ":" + System.getProperty(string) + "\n";
        }
        string2 = string2 + "\nContext attributes\n";
        enumeration = servletConfig.getServletContext().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + string + ":" + servletConfig.getServletContext().getAttribute(string) + "\n";
        }
        string2 = string2 + "\nContext initparms\n";
        enumeration = servletConfig.getServletContext().getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + string + ":" + servletConfig.getServletContext().getInitParameter(string) + "\n";
        }
        string2 = string2 + "\nServlet initparms\n";
        enumeration = servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = string2 + string + ":" + servletConfig.getInitParameter(string) + "\n";
        }
        CSLog.log(1, 1, "Props: " + string2);
    }

    public void destroy() {
        try {
            this.rdmserver.shutdown();
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "RDMServlet.destroy()", exception);
        }
    }

    public static RDMRequest buildRDMRequest(String string) throws IOException {
        String string2;
        String string3;
        HashMap hashMap = new HashMap();
        Decoder.decodeQueryString(string, "UTF-8", hashMap);
        String string4 = (String)hashMap.get("type");
        String string5 = (String)hashMap.get("ql");
        String string6 = (String)hashMap.get("csid");
        RDMHeader rDMHeader = new RDMHeader(string4, string6, string5, null);
        String string7 = (String)hashMap.get("stoken");
        if (string7 != null) {
            rDMHeader.setAccessToken(string7);
        }
        if ((string3 = (String)hashMap.get("user")) != null) {
            rDMHeader.setUser(string3);
        }
        if ((string2 = (String)hashMap.get("pw")) != null) {
            rDMHeader.setPassword(string2);
        }
        String string8 = (String)hashMap.get("scope");
        String string9 = (String)hashMap.get("mode");
        String string10 = (String)hashMap.get("view-attributes");
        String string11 = (String)hashMap.get("view-hits");
        String string12 = (String)hashMap.get("view-order");
        String string13 = (String)hashMap.get("search-category");
        String string14 = (String)hashMap.get("database");
        String string15 = (String)hashMap.get("highlight");
        String string16 = (String)hashMap.get("highlight-tags");
        String string17 = (String)hashMap.get("highlight-tags-field");
        String string18 = (String)hashMap.get("passage-context");
        String string19 = (String)hashMap.get("max-passags");
        if (string10 == null) {
            string10 = (String)hashMap.get("va");
        }
        if (string11 == null) {
            string11 = (String)hashMap.get("vh");
        }
        if (string12 == null) {
            string12 = (String)hashMap.get("vo");
        }
        if (string15 == null) {
            string15 = (String)hashMap.get("hl");
        }
        if (string16 == null) {
            string16 = (String)hashMap.get("hlt");
        }
        if (string17 == null) {
            string17 = (String)hashMap.get("hltf");
        }
        if (string18 == null) {
            string18 = (String)hashMap.get("pc");
        }
        if (string19 == null) {
            string19 = (String)hashMap.get("mp");
        }
        RDMQuery rDMQuery = new RDMQuery(string8);
        if (string9 != null && string9.length() > 0) {
            rDMQuery.setMode(string9);
        }
        if (string10 != null && string10.length() > 0) {
            rDMQuery.setViewAttr(string10);
        }
        if (string11 != null && string11.length() > 0) {
            rDMQuery.setViewHits(string11);
        }
        if (string12 != null && string12.length() > 0) {
            rDMQuery.setViewOrder(string12);
        }
        if (string13 != null && string13.length() > 0) {
            rDMQuery.setSearchCategory(string13);
        }
        if (string14 != null && string14.length() > 0) {
            rDMQuery.setDatabase(string14);
        }
        if (string15 != null && string15.length() > 0) {
            rDMQuery.setHighlight(string15);
        }
        if (string16 != null && string16.length() > 0) {
            rDMQuery.setHighlightTags(string16);
        }
        if (string17 != null && string17.length() > 0) {
            rDMQuery.setHighlightTagsField(string17);
        }
        if (string18 != null && string18.length() > 0) {
            rDMQuery.setPassageContext(string18);
        }
        if (string19 != null && string19.length() > 0) {
            rDMQuery.setMaxPassages(string19);
        }
        if (rDMQuery.getSOIF().getAttributeCount() == 0) {
            rDMQuery = null;
        }
        RDMRequest rDMRequest = new RDMRequest(rDMHeader, rDMQuery);
        return rDMRequest;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        RDMRequest rDMRequest = null;
        try {
            String string = httpServletRequest.getQueryString();
            rDMRequest = RDMServlet.buildRDMRequest(string);
        }
        catch (Exception exception) {
            CSLog.log(1, 1, "Did not receive valid RDM Request - GET method", exception);
            throw new ServletException("Did not receive valid RDM Request - GET method", (Throwable)exception);
        }
        this.processRDMRequest(httpServletRequest, httpServletResponse, rDMRequest);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        RDMRequest rDMRequest = null;
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream((InputStream)httpServletRequest.getInputStream());
            rDMRequest = new RDMRequest(sOIFInputStream);
        }
        catch (Exception exception) {
            CSLog.log(1, 1, "Did not receive valid RDM Request - POST method", exception);
            throw new ServletException("Did not receive valid RDM Request - POST method", (Throwable)exception);
        }
        this.processRDMRequest(httpServletRequest, httpServletResponse, rDMRequest);
    }

    protected void processRDMRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, RDMRequest rDMRequest) throws ServletException, IOException {
        try {
            httpServletResponse.setContentType("text/plain; charset=utf-8");
            RDMResponse rDMResponse = new RDMResponse(new SOIFOutputStream((OutputStream)httpServletResponse.getOutputStream()));
            rDMResponse.getHeader().setCSID(rDMRequest.getHeader().getCSID());
            if (!RDMSecurityManager.getInstance().initRDMSToken(httpServletRequest, rDMRequest)) {
                CSLog.error(1, 1, "Bad or missing security information: " + httpServletRequest.getRemoteAddr());
                rDMResponse.getHeader().setErrorMessage("Bad or missing security information");
                rDMResponse.getHeader().setResponseInterpret("0 results out of 0 hits across 0 documents");
                rDMResponse.sendHeader();
                return;
            }
            this.rdmserver.service(rDMRequest, rDMResponse);
        }
        catch (Exception exception) {
            this.rdmcontext.log("Exception: processRDMRequest", exception);
            throw new ServletException((Throwable)exception);
        }
    }

    public String getServletInfo() {
        return this.rdmserver.getVersion();
    }
}

