/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.db;

import com.sun.portal.search.db.Datum;
import com.sun.portal.search.db.NovaDb;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.db.SearchOnlyDb;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMClassification;
import com.sun.portal.search.rdm.RDMException;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.rdm.RDMTransaction;
import com.sun.portal.search.rdm.RDMView;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.util.Date;
import java.util.Set;

public class TaxonomyDb
extends SearchOnlyDb {
    public static final String CLASS_KEY = "statistics:classification";
    public static final String CLASS_NAME = "s_class";
    public static final String CLASS_NODES = "s_nodes";
    public static final String CLASS_THIS = "s_nodecnt";
    public static final String CLASS_IDXBATCH = "s_idxbatch";
    NovaDb searchengine = new NovaDb();
    RDMTaxonomy theTax = null;
    static Date theTax_lmt = null;
    static Date theTax_refresh = null;
    static int theTax_refresh_rate = 300;
    public static final String QL_TAX_BASIC = "taxonomy-basic";
    public static final String QL_SEARCH = "search";
    public static final String QL_CLASSIFICATION = "classification";

    protected void getTaxBasicResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLTaxQuery qLTaxQuery) throws Exception {
        RDMTaxonomy rDMTaxonomy = this.theTax;
        RDMClassification rDMClassification = null;
        rDMClassification = rDMTaxonomy.find(qLTaxQuery.class_id);
        if (rDMClassification == null) {
            CSLog.warn(1, 10, "Classification Mismatch: " + qLTaxQuery.class_id);
            rDMResponse.getHeader().setResponseInterpret("0 results");
            return;
        }
        if (qLTaxQuery.advise_doc_count) {
            this.checkTaxonomy(rDMRequest, rDMResponse, qLTaxQuery, rDMClassification);
            return;
        }
        RDMView rDMView = new RDMView(rDMRequest);
        if (rDMRequest.getQuery().getViewHits() == null) {
            rDMView.hits.max = 1000000;
        }
        SOIFBuffer sOIFBuffer = new SOIFBuffer();
        SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(sOIFBuffer);
        if (!qLTaxQuery.retrieve_rd) {
            sOIFOutputStream.write(rDMTaxonomy.getSOIF());
        }
        if (rDMView != null && rDMView.attr != null) {
            sOIFOutputStream.setAllowed(rDMView.attr);
        }
        QLTaxTraverse qLTaxTraverse = new QLTaxTraverse();
        qLTaxTraverse.t = rDMTaxonomy;
        qLTaxTraverse.qry = qLTaxQuery;
        qLTaxTraverse.n = 0;
        qLTaxTraverse.total = 0;
        qLTaxTraverse.max = rDMView.hits.max;
        qLTaxTraverse.depth_start = rDMTaxonomy.depth(rDMClassification);
        qLTaxTraverse.depth_max = qLTaxQuery.depth == -1 ? -1 : qLTaxQuery.depth + qLTaxTraverse.depth_start;
        qLTaxTraverse.ss = sOIFOutputStream;
        rDMClassification.apply(0, qLTaxTraverse);
        rDMResponse.getHeader().setResponseInterpret(qLTaxTraverse.n + " results out of " + qLTaxTraverse.n + " hits across " + qLTaxTraverse.total + " documents");
        rDMRequest.logRDM("xfer=" + qLTaxTraverse.n + " scope=\"" + rDMRequest.getQuery().getScope() + "\"");
        rDMResponse.sendHeader();
        rDMResponse.getOutputStream().write(sOIFBuffer.toByteArray());
    }

    protected void checkTaxonomy(RDMRequest rDMRequest, RDMResponse rDMResponse, QLTaxQuery qLTaxQuery, RDMClassification rDMClassification) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = qLTaxQuery.doc_count;
        n = rDMClassification.getNumDocs();
        n3 = n2 - n;
        if (n3 != 0) {
            RDMClassification rDMClassification2 = rDMClassification;
            rDMClassification2.setNumDocs(n2);
            rDMClassification2.getSOIF().replace("categorized-count", "" + rDMClassification2.getNumDocs());
            do {
                int n4;
                if ((n4 = rDMClassification2.getNumDescDocs() + n3) < 0) {
                    CSLog.warn(1, 1, "Count went -ve while adjusting classified doc counts");
                    break;
                }
                rDMClassification2.setNumDescDocs(n4);
                rDMClassification2.getSOIF().replace("subcategorized-count", "" + n4);
            } while ((rDMClassification2 = rDMClassification2.getParent()) != null);
        }
        rDMRequest.logRDM("taxonomy advise - old count=" + n + " scope=\"" + rDMRequest.getQuery().getScope() + "\"");
    }

    protected void loadTaxonomy(String string) throws Exception {
        Date date = new Date(new File(string).lastModified());
        if (theTax_lmt == date) {
            return;
        }
        SOIFInputStream sOIFInputStream = null;
        try {
            sOIFInputStream = new SOIFInputStream(string);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot read " + string);
            throw exception;
        }
        try {
            this.theTax = new RDMTaxonomy(sOIFInputStream);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Cannot parse Taxonomy: " + string);
            throw new Exception("Failed to parse taxonomy " + string);
        }
        SOIF sOIF = new SOIF();
        this.theTax.apply(2, new AddCatContent(sOIF));
        this.theTax.apply(0, new UpdateClassSOIF());
        theTax_lmt = date;
        theTax_refresh = new Date(new Date().getTime() + (long)(theTax_refresh_rate * 1000));
    }

    public void open(SToken sToken, String string, String string2, int n, int n2) throws RDMException {
        this.searchengine.open(sToken, string, string2, n, n2);
        this.refreshTaxonomy(string2);
    }

    protected synchronized void refreshTaxonomy(String string) throws RDMException {
        Date date = new Date();
        if (this.theTax == null || theTax_refresh.before(date)) {
            this.init(string);
            theTax_refresh = new Date(date.getTime() + (long)(theTax_refresh_rate * 1000));
        }
    }

    public void init(String string) throws RDMException {
        String string2 = SearchConfig.getValue("taxonomy-description");
        String string3 = SearchConfig.getValue("taxonomy-description-refresh-rate");
        theTax_lmt = new Date(0L);
        theTax_refresh = new Date(0L);
        if (string2 == null) {
            CSLog.error(1, 1, "Missing 'taxonomy-description' parameter");
            throw new RDMException("Failed to initialize");
        }
        if (string3 != null) {
            theTax_refresh_rate = Integer.parseInt(string3);
        }
        try {
            this.loadTaxonomy(string2);
        }
        catch (Exception exception) {
            CSLog.error(1, 1, "Failed to load " + string2);
            throw new RDMException(exception.getMessage());
        }
    }

    public void close(SToken sToken) throws RDMException {
        this.searchengine.close(sToken);
    }

    public int fetch(SToken sToken, Datum datum, Datum datum2, int n, RDMTransaction rDMTransaction) throws RDMException {
        throw new RDMException("not implemented");
    }

    public SOIF fetch(SToken sToken, String string, Set set, int n, RDMTransaction rDMTransaction) throws RDMException {
        throw new RDMException("not implemented");
    }

    public SOIF fetch(SToken sToken, String string, int n, RDMTransaction rDMTransaction) throws RDMException {
        throw new RDMException("not implemented");
    }

    public void recover(String string, boolean bl) throws RDMException {
    }

    class UpdateClassSOIF
    implements RDMCallback {
        UpdateClassSOIF() {
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            int n = 0;
            if (rDMClassification.getDepth() == 0) {
                return;
            }
            rDMClassification.getSOIF().replace("subclassification-count", "" + rDMClassification.getNumDescendant());
            rDMClassification.getSOIF().replace("categorized-count", "" + rDMClassification.getNumDocs());
            rDMClassification.getSOIF().replace("subcategorized-count", "" + rDMClassification.getNumDescDocs());
            if (rDMClassification.getChildren() != null) {
                for (n = 0; n < rDMClassification.nChildren(); ++n) {
                    String string = rDMClassification.nthChild(n).getId();
                    String string2 = string.substring(string.lastIndexOf(58) + 1);
                    rDMClassification.getSOIF().replace("child", string2, n);
                }
            }
        }
    }

    class AddCatContent
    implements RDMCallback {
        SOIF stats_soif;

        AddCatContent(SOIF sOIF) {
            this.stats_soif = sOIF;
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            if (rDMClassification.getDepth() == 0) {
                return;
            }
            if (this.stats_soif == null) {
                return;
            }
            rDMClassification.setNumDescDocs(rDMClassification.getNumDescDocs() + rDMClassification.getNumDocs());
            RDMClassification rDMClassification2 = rDMClassification.getParent();
            if (rDMClassification2 != null) {
                rDMClassification2.setNumDescDocs(rDMClassification2.getNumDescDocs() + rDMClassification.getNumDescDocs());
            }
        }
    }

    class QLTaxTraverse
    implements RDMCallback {
        RDMTaxonomy t;
        QLTaxQuery qry;
        SOIFOutputStream ss;
        int depth_max;
        int depth_start;
        int n;
        int max;
        int total;

        QLTaxTraverse() {
        }

        public void callback(Object object) throws Exception {
            RDMClassification rDMClassification = (RDMClassification)object;
            int n = 0;
            ++this.total;
            if (this.depth_max != -1 && (n = this.t.depth(rDMClassification)) > this.depth_max) {
                return;
            }
            if (this.max != 0 && this.n >= this.max) {
                return;
            }
            String string = rDMClassification.getId();
            if (!this.qry.retrieve_rd) {
                this.ss.write(rDMClassification.getSOIF());
            }
            ++this.n;
        }
    }

    class QLSearchQuery {
        String scope;

        QLSearchQuery() {
        }
    }

    class QLTaxQuery {
        String class_id;
        int depth;
        boolean retrieve_rd;
        boolean advise_doc_count;
        int doc_count;

        QLTaxQuery() {
        }
    }
}

