/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeMessage;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimMessageItemFilter;
import com.aligo.pim.exchange.ExchangePimMessageItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimTaskItem;
import com.aligo.pim.exchange.ExchangePimTaskItemFilter;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimTaskItem;
import com.aligo.pim.interfaces.PimTaskItemFilter;
import com.aligo.pim.interfaces.PimTaskItems;
import java.util.Date;

public class ExchangePimTaskItems
extends ExchangePimMessageItems
implements PimTaskItems {
    private ExchangePimMessageItemFilter m_oPimMessageItemFilter;
    private ExchangePimTaskItemFilter m_oPimTaskItemFilter;

    public ExchangePimTaskItems(ExchangeMessages _oMessages, ExchangePimSession pimSession) {
        super(_oMessages, pimSession);
    }

    public void setExchangeTaskItems(ExchangeMessages _oMessages) {
        this.setExchangeMessages(_oMessages);
    }

    public PimTaskItemFilter getTaskItemFilter() throws ExchangePimException {
        try {
            return this.getExchangeTaskItemFilter();
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangePimTaskItemFilter getExchangeTaskItemFilter() throws ExchangePimException {
        if (this.m_oPimTaskItemFilter == null) {
            this.m_oPimTaskItemFilter = new ExchangePimTaskItemFilter(this.getExchangeMessageFilter(), this.getPimSession());
        }
        return this.m_oPimTaskItemFilter;
    }

    public ExchangeMessages getExchangeTaskItems() {
        return this.getExchangeMessages();
    }

    public boolean checkValidity(ExchangePimTaskItem pimTaskItem) throws ExchangePimException {
        try {
            Date taskDueDate;
            Date taskStartDate;
            Date filterStartDate = this.getExchangeTaskItemFilter().getStartDate();
            Date filterDueDate = this.getExchangeTaskItemFilter().getDueDate();
            if (filterStartDate != null && (taskStartDate = pimTaskItem.getStartDate()) != null && filterStartDate != null && filterStartDate.after(taskStartDate)) {
                return false;
            }
            return filterDueDate == null || (taskDueDate = pimTaskItem.getDueDate()) == null || filterDueDate == null || !filterDueDate.before(taskDueDate);
        }
        catch (Exception e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getFirstTaskItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getFirst(null);
            if (_oMessage == null) {
                return null;
            }
            ExchangePimTaskItem pimTaskItem = new ExchangePimTaskItem(_oMessage, this.getPimSession());
            if (!this.checkValidity(pimTaskItem)) {
                return this.getNextTaskItem();
            }
            return pimTaskItem;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getNextTaskItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getNext();
            if (_oMessage == null) {
                return null;
            }
            ExchangePimTaskItem pimTaskItem = new ExchangePimTaskItem(_oMessage, this.getPimSession());
            if (!this.checkValidity(pimTaskItem)) {
                return this.getNextTaskItem();
            }
            return pimTaskItem;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getLastTaskItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getLast(null);
            if (_oMessage == null) {
                return null;
            }
            ExchangePimTaskItem pimTaskItem = new ExchangePimTaskItem(_oMessage, this.getPimSession());
            if (!this.checkValidity(pimTaskItem)) {
                return this.getPreviousTaskItem();
            }
            return pimTaskItem;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getPreviousTaskItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getPrevious();
            if (_oMessage == null) {
                return null;
            }
            ExchangePimTaskItem pimTaskItem = new ExchangePimTaskItem(_oMessage, this.getPimSession());
            if (!this.checkValidity(pimTaskItem)) {
                return this.getPreviousTaskItem();
            }
            return pimTaskItem;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getTaskItem(int itemNumber) throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getItem(itemNumber + 1);
            if (_oMessage == null) {
                return null;
            }
            ExchangePimTaskItem pimTaskItem = new ExchangePimTaskItem(_oMessage, this.getPimSession());
            if (!this.checkValidity(pimTaskItem)) {
                return this.getTaskItem(itemNumber + 1);
            }
            return pimTaskItem;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimTaskItem getTaskItem(String id) throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getFirst(null);
            while (_oMessage != null) {
                if (_oMessage.getId().equals(id)) {
                    return new ExchangePimTaskItem(_oMessage, this.getPimSession());
                }
                _oMessage = (ExchangeMessage)this.getExchangeTaskItems().getNext();
            }
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
        return null;
    }

    public PimTaskItem addTaskItem() throws ExchangePimException {
        try {
            ExchangeMessage _oMessage = this.getExchangeTaskItems().add();
            if (_oMessage == null) {
                return null;
            }
            return new ExchangePimTaskItem(_oMessage, this.getPimSession(), true);
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExchangePimException {
        return this.getTaskItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExchangePimException {
        return this.getTaskItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExchangePimException {
        return this.getFirstTaskItem();
    }

    public PimMessageItem getNextMessageItem() throws ExchangePimException {
        return this.getNextTaskItem();
    }

    public PimMessageItem getLastMessageItem() throws ExchangePimException {
        return this.getLastTaskItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExchangePimException {
        return this.getPreviousTaskItem();
    }

    public PimMessageItem addMessageItem() throws ExchangePimException {
        return this.addTaskItem();
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousMessageItem();
    }
}

