/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.pim.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntries;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeAddressEntryFilter;
import com.aligo.pim.PimFieldType;
import com.aligo.pim.PimSortType;
import com.aligo.pim.exchange.ExchangePimAddressEntryItem;
import com.aligo.pim.exchange.ExchangePimAddressEntryItemFilter;
import com.aligo.pim.exchange.ExchangePimException;
import com.aligo.pim.exchange.ExchangePimFilter;
import com.aligo.pim.exchange.ExchangePimGlobalAddressEntry;
import com.aligo.pim.exchange.ExchangePimGlobalAddressEntryItemsProxy;
import com.aligo.pim.exchange.ExchangePimItems;
import com.aligo.pim.exchange.ExchangePimSession;
import com.aligo.pim.exchange.ExchangePimSortTypeMapper;
import com.aligo.pim.interfaces.PimAddressEntryItem;
import com.aligo.pim.interfaces.PimAddressEntryItemFilter;
import com.aligo.pim.interfaces.PimAddressEntryItems;
import com.aligo.pim.interfaces.PimItem;
import com.aligo.pim.interfaces.PimMessageItem;
import com.aligo.pim.interfaces.PimMessageItemFilter;

public class ExchangePimAddressEntryItems
extends ExchangePimItems
implements PimAddressEntryItems {
    private ExchangeAddressEntries _oAddressEntries;
    private ExchangePimAddressEntryItemFilter m_oPimAddressEntryItemFilter;

    public ExchangePimAddressEntryItems(ExchangeAddressEntries _oAddressEntries, ExchangePimSession pimSession) {
        super(pimSession);
        this._oAddressEntries = _oAddressEntries;
    }

    public void setExchangeAddressEntries(ExchangeAddressEntries _oAddressEntries) {
        this._oAddressEntries = _oAddressEntries;
    }

    public PimAddressEntryItem addAddressEntryItem() throws ExchangePimException {
        throw new ExchangePimException(12L);
    }

    public void addAddressEntryItem(PimAddressEntryItem pimAddressEntryItem) throws ExchangePimException {
        throw new ExchangePimException(12L);
    }

    public void setOrderBy(PimFieldType[] pimFieldType) throws ExchangePimException {
    }

    public PimAddressEntryItemFilter getAddressEntryItemFilter() throws ExchangePimException {
        try {
            ExchangeAddressEntryFilter _oAddressEntryFilter = this.getExchangeAddressEntries().getFilter();
            if (_oAddressEntryFilter == null) {
                return null;
            }
            if (this.m_oPimAddressEntryItemFilter == null) {
                this.m_oPimAddressEntryItemFilter = new ExchangePimAddressEntryItemFilter(_oAddressEntryFilter, this.getPimSession());
            } else {
                this.m_oPimAddressEntryItemFilter.setExchangeAddressEntryFilter(_oAddressEntryFilter);
            }
            return this.m_oPimAddressEntryItemFilter;
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public ExchangeAddressEntries getExchangeAddressEntries() {
        return this._oAddressEntries;
    }

    public int getCount() throws ExchangePimException {
        try {
            return this.getExchangeAddressEntries().getCount();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(int itemNumber) throws ExchangePimException {
        try {
            ExchangeAddressEntry _oAddressEntry = this.getExchangeAddressEntries().getItem(itemNumber + 1);
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getAddressEntryItem(String id) throws ExchangePimException {
        try {
            ExchangePimSession pimSession = this.getPimSession();
            ExchangePimGlobalAddressEntry pimAddressBook = pimSession.getFreshAddressLists();
            ExchangePimAddressEntryItems pimAddressEntryItems = (ExchangePimAddressEntryItems)((ExchangePimGlobalAddressEntryItemsProxy)pimAddressBook.getAddressEntryItems()).getBackEndAddressEntryItems();
            ExchangePimFilter pimFilter = (ExchangePimFilter)pimAddressEntryItems.getAddressEntryItemFilter();
            pimFilter.setID(id);
            ExchangeAddressEntries exchangeAddressEntries = pimAddressEntryItems.getExchangeAddressEntries();
            ExchangeAddressEntry exchangeAddressEntry = exchangeAddressEntries.getFirst();
            while (exchangeAddressEntry != null) {
                if (exchangeAddressEntry.getId().equals(id)) {
                    return new ExchangePimAddressEntryItem(exchangeAddressEntry, this.getPimSession());
                }
                exchangeAddressEntry = exchangeAddressEntries.getNext();
            }
            return this.getAddressEntryItemBackUpStrategy(id);
        }
        catch (Exception e) {
            return this.getAddressEntryItemBackUpStrategy(id);
        }
    }

    public PimAddressEntryItem getAddressEntryItemBackUpStrategy(String id) throws ExchangePimException {
        try {
            ExchangePimSession pimSession = this.getPimSession();
            ExchangePimGlobalAddressEntry pimAddressBook = pimSession.getFreshAddressLists();
            PimAddressEntryItems pimAddressEntryItems = pimAddressBook.getAddressEntryItems();
            PimAddressEntryItem pimAddressEntryItem = pimAddressEntryItems.getFirstAddressEntryItem();
            while (pimAddressEntryItem != null) {
                if (pimAddressEntryItem.getID().equals(id)) {
                    return pimAddressEntryItem;
                }
                pimAddressEntryItem = pimAddressEntryItems.getNextAddressEntryItem();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public PimAddressEntryItem getFirstAddressEntryItem() throws ExchangePimException {
        try {
            if (this.getCount() == 0) {
                return null;
            }
            ExchangeAddressEntry _oAddressEntry = this.getExchangeAddressEntries().getFirst();
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getNextAddressEntryItem() throws ExchangePimException {
        try {
            ExchangeAddressEntry _oAddressEntry = this.getExchangeAddressEntries().getNext();
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getLastAddressEntryItem() throws ExchangePimException {
        try {
            ExchangeAddressEntry _oAddressEntry = this.getExchangeAddressEntries().getLast();
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimAddressEntryItem getPreviousAddressEntryItem() throws ExchangePimException {
        try {
            ExchangeAddressEntry _oAddressEntry = this.getExchangeAddressEntries().getPrevious();
            if (_oAddressEntry == null) {
                return null;
            }
            return new ExchangePimAddressEntryItem(_oAddressEntry, this.getPimSession());
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void delete() throws ExchangePimException {
        try {
            this.getExchangeAddressEntries().delete();
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public void sort(PimSortType type) throws ExchangePimException {
        try {
            this.getExchangeAddressEntries().sort(ExchangePimSortTypeMapper.getType(type));
        }
        catch (AligoExchangeException e) {
            throw new ExchangePimException(e);
        }
    }

    public PimMessageItemFilter getMessageItemFilter() throws ExchangePimException {
        return this.getAddressEntryItemFilter();
    }

    public PimMessageItem getMessageItem(int itemNumber) throws ExchangePimException {
        return this.getAddressEntryItem(itemNumber);
    }

    public PimMessageItem getMessageItem(String id) throws ExchangePimException {
        return this.getAddressEntryItem(id);
    }

    public PimMessageItem getFirstMessageItem() throws ExchangePimException {
        return this.getFirstAddressEntryItem();
    }

    public PimMessageItem getNextMessageItem() throws ExchangePimException {
        return this.getNextAddressEntryItem();
    }

    public PimMessageItem getLastMessageItem() throws ExchangePimException {
        return this.getLastAddressEntryItem();
    }

    public PimMessageItem getPreviousMessageItem() throws ExchangePimException {
        return this.getPreviousAddressEntryItem();
    }

    public PimMessageItem addMessageItem() throws ExchangePimException {
        return this.addAddressEntryItem();
    }

    public PimItem getItem(int itemNumber) throws ExchangePimException {
        return this.getMessageItem(itemNumber);
    }

    public PimItem getItem(String id) throws ExchangePimException {
        return this.getMessageItem(id);
    }

    public PimItem addItem() throws ExchangePimException {
        return this.addMessageItem();
    }

    public PimItem getFirstItem() throws ExchangePimException {
        return this.getFirstMessageItem();
    }

    public PimItem getNextItem() throws ExchangePimException {
        return this.getNextMessageItem();
    }

    public PimItem getLastItem() throws ExchangePimException {
        return this.getLastMessageItem();
    }

    public PimItem getPreviousItem() throws ExchangePimException {
        return this.getPreviousMessageItem();
    }
}

