/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.messaging.exchange;

import com.aligo.messaging.exchange.AligoExchangeException;
import com.aligo.messaging.exchange.ExchangeAddressEntry;
import com.aligo.messaging.exchange.ExchangeAttachments;
import com.aligo.messaging.exchange.ExchangeFields;
import com.aligo.messaging.exchange.ExchangeMessages;
import com.aligo.messaging.exchange.ExchangeRecipients;
import com.aligo.messaging.exchange.cdo.AddressEntryProxy;
import com.aligo.messaging.exchange.cdo.AttachmentsProxy;
import com.aligo.messaging.exchange.cdo.FieldsProxy;
import com.aligo.messaging.exchange.cdo.Message;
import com.aligo.messaging.exchange.cdo.MessageProxy;
import com.aligo.messaging.exchange.cdo.MessagesProxy;
import com.aligo.messaging.exchange.cdo.RecipientsProxy;
import com.aligo.messaging.exchange.cdo.Session;
import java.util.Date;

public class ExchangeMessage {
    private Message _ocxMessage;
    private Session _ocxSession;

    ExchangeMessage(Message messageHandle) {
        this._ocxMessage = messageHandle;
    }

    public ExchangeAddressEntry getSender() throws AligoExchangeException {
        try {
            Object sender = this._ocxMessage.getSender();
            if (sender == null) {
                System.err.println("Couldn't create AddressEntry from Sender.");
                return null;
            }
            AddressEntryProxy returnHandle = new AddressEntryProxy(sender);
            return new ExchangeAddressEntry(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSender(ExchangeAddressEntry sender) throws AligoExchangeException {
        try {
            if (sender != null) {
                System.err.println("Couldn't set Sender from AddressEntryHandle.");
                this._ocxMessage.setSender(sender.getAddressEntryHandle());
            }
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage reply() throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxMessage.reply());
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage replyAll() throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxMessage.replyAll());
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage forward() throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxMessage.forward());
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void send(boolean saveCopy) throws AligoExchangeException {
        try {
            this._ocxMessage.send(new Boolean(saveCopy), null, null);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void send() throws AligoExchangeException {
        this.send(true);
    }

    public String getId() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage moveTo(String folderId, String storeId) throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxMessage.moveTo(folderId, storeId));
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessage copyTo(String folderId, String storeId) throws AligoExchangeException {
        try {
            MessageProxy returnHandle = new MessageProxy(this._ocxMessage.copyTo(folderId, storeId));
            return new ExchangeMessage(returnHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void update() throws AligoExchangeException {
        try {
            this.update(true, false);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void update(boolean makePermanent, boolean refreshObject) throws AligoExchangeException {
        try {
            this._ocxMessage.update(new Boolean(makePermanent), new Boolean(refreshObject));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void delete() throws AligoExchangeException {
        this.delete(false);
    }

    public void delete(boolean moveToDeletedItems) throws AligoExchangeException {
        try {
            this._ocxMessage.delete(new Boolean(moveToDeletedItems));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean isSameAs(ExchangeMessage message) throws AligoExchangeException {
        try {
            Message otherHandle = message.getMessageHandle();
            return (Boolean)this._ocxMessage.isSameAs(otherHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    Message getMessageHandle() {
        return this._ocxMessage;
    }

    Session getSessionHandle() {
        return this._ocxSession;
    }

    void setSessionHandle(Session handle) {
        this._ocxSession = handle;
    }

    public ExchangeFields getFields() throws AligoExchangeException {
        try {
            FieldsProxy resultHandle = new FieldsProxy(this._ocxMessage.getFields());
            return new ExchangeFields(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeMessages getParent() throws AligoExchangeException {
        try {
            MessagesProxy resultHandle = new MessagesProxy(this._ocxMessage.getParent());
            return new ExchangeMessages(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeAttachments getAttachments() throws AligoExchangeException {
        try {
            AttachmentsProxy resultHandle = new AttachmentsProxy(this._ocxMessage.getAttachments());
            return new ExchangeAttachments(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public ExchangeRecipients getRecipients() throws AligoExchangeException {
        try {
            RecipientsProxy resultHandle = new RecipientsProxy(this._ocxMessage.getRecipients());
            return new ExchangeRecipients(resultHandle);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getCategories() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getCategories();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getConversationIndex() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getConversationIndex();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setConversationIndex(String value) throws AligoExchangeException {
        try {
            this._ocxMessage.setConversationIndex(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getConversationTopic() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getConversationTopic();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setConversationTopic(String value) throws AligoExchangeException {
        try {
            this._ocxMessage.setConversationTopic(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getDeliveryReceipt() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getDeliveryReceipt();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setDeliveryReceipt(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setDeliveryReceipt(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getEncrypted() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getEncrypted();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setEncrypted(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setEncrypted(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getImportance() throws AligoExchangeException {
        try {
            return (Integer)this._ocxMessage.getImportance();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setImportance(int value) throws AligoExchangeException {
        try {
            if (value < 0 || value > 2) {
                value = 1;
            }
            this._ocxMessage.setImportance(new Integer(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getReadReceipt() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getReadReceipt();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setReadReceipt(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setReadReceipt(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSent() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getSent();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSent(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setSent(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSigned() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getSigned();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSigned(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setSigned(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSubject(String value) throws AligoExchangeException {
        try {
            this._ocxMessage.setSubject(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getSubject() throws AligoExchangeException {
        try {
            String subj = (String)this._ocxMessage.getSubject();
            if (subj == null || subj.equals("")) {
                subj = "&nbsp;";
            }
            return subj;
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getSubmitted() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getSubmitted();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setSubmitted(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setSubmitted(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setText(String value) throws AligoExchangeException {
        try {
            this._ocxMessage.setText(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getText() throws AligoExchangeException {
        try {
            String messageBody = (String)this._ocxMessage.getText();
            if (messageBody == null || messageBody.equals("")) {
                messageBody = "&nbsp;";
            }
            return messageBody;
        }
        catch (Exception e) {
            System.err.println("Exception in getText: " + e.toString());
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeExpired(Date value) throws AligoExchangeException {
        try {
            this._ocxMessage.setTimeExpired(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeExpired() throws AligoExchangeException {
        try {
            return (Date)this._ocxMessage.getTimeExpired();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeReceived(Date value) throws AligoExchangeException {
        try {
            this._ocxMessage.setTimeReceived(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeReceived() throws AligoExchangeException {
        try {
            return (Date)this._ocxMessage.getTimeReceived();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setTimeSent(Date value) throws AligoExchangeException {
        try {
            this._ocxMessage.setTimeSent(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeSent() throws AligoExchangeException {
        try {
            return (Date)this._ocxMessage.getTimeSent();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setType(String value) throws AligoExchangeException {
        try {
            this._ocxMessage.setType(value);
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getType() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getType();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public void setUnread(boolean value) throws AligoExchangeException {
        try {
            this._ocxMessage.setUnread(new Boolean(value));
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public boolean getUnread() throws AligoExchangeException {
        try {
            return (Boolean)this._ocxMessage.getUnread();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getSize() throws AligoExchangeException {
        try {
            return (Integer)this._ocxMessage.getSize();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public int getClassType() throws AligoExchangeException {
        try {
            return (Integer)this._ocxMessage.zz_getClass();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getStoreId() throws AligoExchangeException {
        try {
            return (String)this._ocxMessage.getStoreID();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeCreated() throws AligoExchangeException {
        try {
            return (Date)this._ocxMessage.getTimeCreated();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public Date getTimeLastModified() throws AligoExchangeException {
        try {
            return (Date)this._ocxMessage.getTimeLastModified();
        }
        catch (Exception e) {
            throw new AligoExchangeException(e);
        }
    }

    public String getApplication() throws AligoExchangeException {
        return "Collaboration Data Objects";
    }
}

