/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.context;

import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import com.sun.portal.providers.context.PropertiesFilterFactory;
import com.sun.portal.providers.context.ProviderContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClientPropertiesFilter
extends PropertiesFilter {
    private static final String PARENTCLIENTS = "parentId";

    public String getCondition() {
        return "client";
    }

    public boolean match(String condition, String value) {
        return condition.toLowerCase().equals("client") && this.getValue().equals(value);
    }

    public static List getClientFilters(ProviderContext context, String clientType, boolean required) throws PropertiesFilterException {
        ArrayList<PropertiesFilter> filters = new ArrayList<PropertiesFilter>();
        filters.add(PropertiesFilterFactory.get("com.sun.portal.providers.context.ClientPropertiesFilter", clientType, required));
        Set parents = ClientPropertiesFilter.getClientParents(context, clientType);
        if (parents != null) {
            Iterator pi = parents.iterator();
            while (pi.hasNext()) {
                filters.add(PropertiesFilterFactory.get("com.sun.portal.providers.context.ClientPropertiesFilter", (String)pi.next(), required));
            }
        }
        Collections.reverse(filters);
        return filters;
    }

    public static List getClientFilters(ProviderContext context, boolean required) throws PropertiesFilterException {
        return ClientPropertiesFilter.getClientFilters(context, context.getClientType(), required);
    }

    public static Set getClientParents(ProviderContext context, String clientType) {
        return context.getClientTypeProperties(clientType, PARENTCLIENTS);
    }

    public static Set getClientParents(ProviderContext context) {
        return ClientPropertiesFilter.getClientParents(context, context.getClientType());
    }
}

