/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.test;

import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ProviderContextTest
extends TestCase {
    protected ProviderContext providerContext = null;

    public ProviderContextTest(ProviderContext pc, String test) {
        super(test);
        this.providerContext = pc;
    }

    public static TestSuite suite(ProviderContext pc) {
        TestSuite ts = new TestSuite();
        ts.addTest((Test)new ProviderContextTest(pc, "testProviderContextNotNull"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetLocaleString"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetStringPropertyFromChannel"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetStringPropertyFromProvider"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetSessionProperty"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetTemplateMostSpecificPath"));
        ts.addTest((Test)new ProviderContextTest(pc, "testGetTemplatePath"));
        return ts;
    }

    public void testProviderContextNotNull() {
        ProviderContextTest.assertNotNull((Object)this.providerContext);
    }

    public void testGetLocaleString() throws ProviderContextException {
        ProviderContextTest.assertEquals((String)this.providerContext.getLocaleString(), (String)"en_US");
    }

    public void testGetStringPropertyFromChannel() throws ProviderContextException {
        String a = this.providerContext.getStringProperty("test1", "a");
        ProviderContextTest.assertEquals((String)a, (String)"as");
        String b = this.providerContext.getStringProperty("test1", "b");
        ProviderContextTest.assertEquals((String)b, (String)"bs");
        String c = this.providerContext.getStringProperty("test1", "c");
        ProviderContextTest.assertEquals((String)c, (String)"cs");
    }

    public void testGetStringPropertyFromProvider() throws ProviderContextException {
        String ap = this.providerContext.getStringProperty("test1", "ap");
        ProviderContextTest.assertEquals((String)ap, (String)"asp");
        String bp = this.providerContext.getStringProperty("test1", "bp");
        ProviderContextTest.assertEquals((String)bp, (String)"bsp");
        String cp = this.providerContext.getStringProperty("test1", "cp");
        ProviderContextTest.assertEquals((String)cp, (String)"csp");
    }

    public void testGetSessionProperty() throws ProviderContextException {
        String x = "xxx";
        this.providerContext.setSessionProperty("x", x);
        String xt = (String)this.providerContext.getSessionProperty("x");
        ProviderContextTest.assertNotNull((Object)xt);
        ProviderContextTest.assertEquals((String)xt, (String)"xxx");
    }

    public void testGetTemplateMostSpecificPath() throws ProviderContextException {
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        String baseDir = dac.getTemplateBaseDir();
        String desktopType = this.providerContext.getDesktopType();
        String locale = this.providerContext.getLocaleString();
        String clientPath = this.providerContext.getClientPath();
        String name = "test1";
        String file = "test.html";
        File file1 = this.providerContext.getTemplateMostSpecificPath(name, file);
        File file2 = this.providerContext.getTemplateMostSpecificPath(desktopType, locale, name, clientPath, file, baseDir);
        ProviderContextTest.assertEquals((String)file1.getAbsolutePath(), (String)file2.getAbsolutePath());
    }

    public void testGetTemplatePath() throws ProviderContextException {
        DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();
        String baseDir = dac.getTemplateBaseDir();
        String desktopType = this.providerContext.getDesktopType();
        String locale = this.providerContext.getLocaleString();
        String clientPath = this.providerContext.getClientPath();
        String name = "test1";
        String file = "test.html";
        File file1 = this.providerContext.getTemplatePath(name, file);
        File file2 = this.providerContext.getTemplatePath(desktopType, locale, name, clientPath, file, baseDir);
        ProviderContextTest.assertEquals((String)file1.getAbsolutePath(), (String)file2.getAbsolutePath());
    }
}

