/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.DPUserContext;
import com.sun.portal.desktop.context.DSAMEConnection;
import com.sun.portal.desktop.context.DSAMEConstants;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class DSAMEDPUserContext
implements DPUserContext,
DSAMEConstants {
    protected DSAMEConnection dsameConn = null;
    protected Map dpDocumentsLastRead = new HashMap();
    protected long dpUserDocumentLastRead = -1L;
    private DesktopAppContext dac = DesktopAppContextThreadLocalizer.get();

    public synchronized void init(HttpServletRequest req) {
        this.dsameConn = new DSAMEConnection(req);
    }

    public void init(HttpServletRequest req, String uid, String pw) {
        this.dsameConn = new DSAMEConnection(uid, pw);
    }

    public byte[] getDPUserDocument() {
        byte[] userDP = this.dsameConn.getAttributeByteArrayFromROC("sunPortalDesktopDpDocumentUser");
        this.setDPUserDocumentLastRead();
        return userDP;
    }

    protected void setDPUserDocumentLastModified() {
        this.dsameConn.setAttribute("sunPortalDesktopDpLastModifiedUser", Long.toString(System.currentTimeMillis()));
    }

    public void storeDPUserDocument(String dp) {
        if (dp != null) {
            this.dsameConn.setAttribute("sunPortalDesktopDpDocumentUser", dp);
            this.setDPUserDocumentLastModified();
            this.setDPUserDocumentLastRead();
        }
    }

    public Set getDPDocumentNames() {
        Set names = this.dsameConn.getNodeNamesFromROC();
        return names;
    }

    protected void setDPUserDocumentLastRead() {
        long lastRead;
        this.dpUserDocumentLastRead = lastRead = System.currentTimeMillis();
    }

    protected void setDPDocumentLastRead(String name) {
        Long l = new Long(System.currentTimeMillis());
        this.dpDocumentsLastRead.put(name, l);
    }

    public String getDPDocument(String name) {
        String d = this.dsameConn.getAttributeByDNFromROC(name, "sunPortalDesktopDpDocument");
        this.setDPDocumentLastRead(name);
        return d;
    }

    public long getDPDocumentLastModified(String name) {
        long lastModified;
        String lm = this.dsameConn.getAttributeByDNFromROC(name, "sunPortalDesktopDpLastModified");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPUserDocumentLastModified() {
        long lastModified;
        String lm = this.dsameConn.getAttributeFromROC("sunPortalDesktopDpLastModifiedUser");
        if (lm == null) {
            lastModified = -1L;
        } else {
            try {
                lastModified = Long.parseLong(lm);
            }
            catch (NumberFormatException nfe) {
                lastModified = -1L;
            }
        }
        return lastModified;
    }

    public long getDPUserDocumentLastRead() {
        return this.dpUserDocumentLastRead;
    }

    public long getDPDocumentLastRead(String name) {
        Long l = (Long)this.dpDocumentsLastRead.get(name);
        long lastRead = -1L;
        if (l != null) {
            lastRead = l;
        }
        return lastRead;
    }
}

