/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.context;

import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DesktopContext;
import com.sun.portal.desktop.context.DesktopContextThreadLocalizer;
import com.sun.portal.desktop.context.PropertiesContext;
import com.sun.portal.desktop.dp.DPBoolean;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPContainerChannel;
import com.sun.portal.desktop.dp.DPInteger;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.DPString;
import com.sun.portal.desktop.dp.DPTypes;
import com.sun.portal.desktop.util.Integers;
import com.sun.portal.desktop.util.SmartList;
import com.sun.portal.desktop.util.SmartMap;
import com.sun.portal.providers.context.PropertiesFilter;
import com.sun.portal.providers.context.PropertiesFilterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

class DPPropertiesContext
implements PropertiesContext,
DPTypes {
    private static final String SELECTED = "_selected";
    private static final String AVAILABLE = "_available";
    private static final String CLASSNAME = "_classname";
    private static final String PROVIDERNAME = "_providername";
    private static final String PROVIDERVERSION = "_providerversion";
    private static final Object dpLock = new Object();
    protected Map dpChannels = new HashMap();
    protected Map properties = new HashMap();
    protected Map channelLists = new HashMap();
    protected DPRoot dpRoot = null;

    DPPropertiesContext() {
    }

    public synchronized void init(HttpServletRequest req) {
        this.dpRoot = this.getDesktopContext().getDPRoot();
    }

    public synchronized void refresh() {
        this.dpRoot = this.getDesktopContext().getDPRoot();
        this.dpChannels.clear();
        this.properties.clear();
        this.channelLists.clear();
    }

    protected void cloneIfNecessary() {
        if (!this.getDesktopContext().isDPRootCustomized()) {
            this.getDesktopContext().setDPRootCustomized(true);
            this.refresh();
        }
    }

    public synchronized boolean existsChannel(String channel) {
        DPChannel dpc = this.dpRoot.getChannel(channel);
        return dpc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChannel(String channelName, String providerName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.createChannel(channelName, providerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContainer(String channelName, String providerName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.createContainerChannel(channelName, providerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(String channelName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.removeChannel(channelName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyChannel(String srcName, String destName) {
        this.cloneIfNecessary();
        Object object = dpLock;
        synchronized (object) {
            this.dpRoot.copyChannel(srcName, destName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DPChannel getDPChannel(String name) {
        Object object;
        DPChannel dpc = (DPChannel)this.dpChannels.get(name);
        if (dpc == null) {
            object = dpLock;
            synchronized (object) {
                dpc = this.dpRoot.getChannel(name);
            }
        }
        if (dpc != null) {
            object = this;
            synchronized (object) {
                this.dpChannels.put(name, dpc);
            }
        } else {
            throw new ContextError("DPPropertiesContext.getDPChannel(): could not get dp channel=" + name);
        }
        return dpc;
    }

    protected DPContainerChannel getDPContainerChannel(String name) {
        DPChannel dpc = this.getDPChannel(name);
        if (dpc == null) {
            throw new ContextError("DPPropertiesContext.getDPContainerChannel(): could not get dp chanel for name=" + name);
        }
        if (dpc.getType() != 5) {
            throw new ContextError("DPPropertiesContext.getDPContainerChannel(): was not a container name=" + name);
        }
        DPContainerChannel dpcc = (DPContainerChannel)dpc;
        return dpcc;
    }

    protected DesktopContext getDesktopContext() {
        return DesktopContextThreadLocalizer.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getNames(String channel) {
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            Iterator i = dpc.getProperties().getNames().iterator();
            return i;
        }
    }

    public Map getCollectionProperty(String channel, String key) {
        return this.getCollectionProperty(channel, key, null, null);
    }

    public Map getCollectionProperty(String channel, String key, List pflist) {
        return this.getCollectionProperty(channel, key, null, pflist);
    }

    public Map getCollectionProperty(String channel, String key, Map def) {
        return this.getCollectionProperty(channel, key, def, null);
    }

    public Map getCollectionProperty(String channel, String key, Map def, List pflist) {
        Map m = this.getCollectionPropertyNE(channel, key, pflist, false);
        if (m == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getCollectionProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            m = def;
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getCollectionPropertyNE(String channel, String key, List pflist, boolean exact) {
        SmartMap m = null;
        if (!exact) {
            m = (SmartMap)this.getCachedProperty(channel, key, pflist);
        }
        if (m == null) {
            DPChannel dpc = this.getDPChannel(channel);
            DPCollection val = null;
            Object object = dpLock;
            synchronized (object) {
                val = dpc.getProperties().getCollection(key, pflist, exact);
                if (val != null) {
                    Map n = val.getCollectionValue();
                    m = new SmartMap(n);
                }
            }
            if (!exact) {
                object = this;
                synchronized (object) {
                    this.putCachedProperty(channel, key, pflist, m);
                }
            }
        } else {
            if (m.isCopied()) {
                return m.cloneOriginalMap();
            }
            m.revert();
        }
        return m;
    }

    public void setCollectionProperty(String channel, String key, Map val) {
        this.setCollectionProperty(channel, key, val, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollectionProperty(String channel, String key, Map val, List pflist) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setCollection(key, val, pflist);
        }
        if (val instanceof SmartMap) {
            Map cached = (Map)this.getCachedProperty(channel, key, pflist);
            if (cached == val) {
                SmartMap m = (SmartMap)val;
                m.evolve();
            } else {
                SmartMap sm = (SmartMap)val;
                Map m = sm.getMap();
                val = new SmartMap(m);
            }
        } else {
            val = new SmartMap(val);
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, pflist);
            this.putCachedProperty(channel, key, pflist, val);
        }
    }

    public void setCollectionProperty(String channel, String key, List val) {
        this.setCollectionProperty(channel, key, val, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCollectionProperty(String channel, String key, List val, List pflist) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setCollection(key, val, pflist);
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, pflist);
        }
    }

    public boolean getBooleanProperty(String channel, String key) {
        return this.getBooleanProperty(channel, key, null);
    }

    public boolean getBooleanProperty(String channel, String key, List pflist) {
        Boolean b = this.getBooleanPropertyNE(channel, key, pflist, false);
        if (b == null) {
            throw new ContextError("DPPropertiesContext.getBooleanProperty(): property not found in profile for channel=" + channel + ", key=" + key + ", pflist=" + pflist);
        }
        return b;
    }

    public boolean getBooleanProperty(String channel, String key, boolean def) {
        return this.getBooleanProperty(channel, key, def, null);
    }

    public boolean getBooleanProperty(String channel, String key, boolean def, List pflist) {
        Boolean b = this.getBooleanPropertyNE(channel, key, pflist, false);
        boolean c = b == null ? def : b;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean getBooleanPropertyNE(String channel, String key, List pflist, boolean exact) {
        Boolean b = null;
        if (!exact) {
            b = (Boolean)this.getCachedProperty(channel, key, pflist);
        }
        if (b == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPBoolean val = dpc.getProperties().getBoolean(key, pflist, exact);
                if (val != null) {
                    boolean c = val.getBooleanValue();
                    b = c ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            if (!exact) {
                object = this;
                synchronized (object) {
                    this.putCachedProperty(channel, key, pflist, b);
                }
            }
        }
        return b;
    }

    public void setBooleanProperty(String channel, String key, boolean val) {
        this.setBooleanProperty(channel, key, val, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBooleanProperty(String channel, String key, boolean val, List pflist) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Boolean b = null;
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setBoolean(key, val, pflist);
            b = val ? Boolean.TRUE : Boolean.FALSE;
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, pflist);
            this.putCachedProperty(channel, key, pflist, b);
        }
    }

    public int getIntegerProperty(String channel, String key) {
        return this.getIntegerProperty(channel, key, null);
    }

    public int getIntegerProperty(String channel, String key, List pflist) {
        Integer i = this.getIntegerPropertyNE(channel, key, pflist, false);
        if (i == null) {
            throw new ContextError("DPPropertiesContext.getIntegerProperty(): property not found in profile for channel=" + channel + ", key=" + key);
        }
        return i;
    }

    public int getIntegerProperty(String channel, String key, int def) {
        return this.getIntegerProperty(channel, key, def, null);
    }

    public int getIntegerProperty(String channel, String key, int def, List pflist) {
        Integer i = this.getIntegerPropertyNE(channel, key, pflist, false);
        int j = i == null ? def : i;
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getIntegerPropertyNE(String channel, String key, List pflist, boolean exact) {
        Integer j = null;
        if (!exact) {
            j = (Integer)this.getCachedProperty(channel, key, pflist);
        }
        if (j == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPInteger val = dpc.getProperties().getInteger(key, pflist, exact);
                if (val != null) {
                    j = Integers.get(val.getIntValue());
                }
            }
            if (!exact) {
                object = this;
                synchronized (object) {
                    this.putCachedProperty(channel, key, pflist, j);
                }
            }
        }
        return j;
    }

    public void setIntegerProperty(String channel, String key, int val) {
        this.setIntegerProperty(channel, key, val, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntegerProperty(String channel, String key, int val, List pflist) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setInteger(key, val, pflist);
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, pflist);
            this.putCachedProperty(channel, key, pflist, Integers.get(val));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName(String channel) {
        String classname = (String)this.getCachedProperty(channel, CLASSNAME, null);
        if (classname == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPProvider dpp = dpc.getProvider();
                classname = dpp == null ? null : dpp.getClassName();
            }
            object = this;
            synchronized (object) {
                this.putCachedProperty(channel, CLASSNAME, null, classname);
            }
        }
        return classname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProviderName(String channel) {
        String provider = (String)this.getCachedProperty(channel, PROVIDERNAME, null);
        if (provider == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                provider = dpc.getProviderName();
            }
            object = this;
            synchronized (object) {
                this.putCachedProperty(channel, PROVIDERNAME, null, provider);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProviderVersion(String channel) {
        int version = 0;
        Integer cachedVersion = (Integer)this.getCachedProperty(channel, PROVIDERVERSION, null);
        if (cachedVersion == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPProvider dpp = dpc.getProvider();
                if (dpp == null) {
                    throw new ContextError("DPPropertiesContext.getProviderVersion(): provider was null or channel=" + channel);
                }
                version = dpp.getProviderVersion();
            }
            object = this;
            synchronized (object) {
                this.putCachedProperty(channel, PROVIDERVERSION, null, new Integer(version));
            }
        }
        version = cachedVersion;
        return version;
    }

    public Object getProperty(String channel, String key) {
        return this.getProperty(channel, key, null);
    }

    public Object getProperty(String channel, String key, Object def) {
        Object o = this.getPropertyNE(channel, key);
        if (o == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            o = def;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPropertyNE(String channel, String key) {
        Object o = this.getCachedProperty(channel, key, null);
        if (o == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPProperty val = dpc.getProperties().get(key);
                if (val != null) {
                    o = val.getValue();
                }
            }
            if (o instanceof Map) {
                o = new SmartMap((Map)o);
            }
            object = this;
            synchronized (object) {
                this.putCachedProperty(channel, key, null, o);
            }
        }
        if (o instanceof Map) {
            SmartMap sm = (SmartMap)o;
            if (sm.isCopied()) {
                return sm.cloneOriginalMap();
            }
            sm.revert();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String channel, String key, Object val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().set(key, val, null);
        }
        if (val instanceof Map) {
            if (val instanceof SmartMap) {
                SmartMap m = (SmartMap)val;
                m.evolve();
            } else {
                val = new SmartMap((Map)val);
            }
        }
        object = this;
        synchronized (object) {
            this.putCachedProperty(channel, key, null, val);
        }
    }

    public String getStringProperty(String channel, String key) {
        return this.getStringProperty(channel, key, null, null);
    }

    public String getStringProperty(String channel, String key, String def) {
        return this.getStringProperty(channel, key, def, null);
    }

    public String getStringProperty(String channel, String key, List pflist) {
        return this.getStringProperty(channel, key, null, pflist);
    }

    public String getStringProperty(String channel, String key, String def, List pflist) {
        String s = this.getStringPropertyNE(channel, key, pflist, false);
        if (s == null) {
            if (def == null) {
                throw new ContextError("DPPropertiesContext.getStringProperty(): property not found in profile for channel=" + channel + ", key=" + key);
            }
            s = def;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringPropertyNE(String channel, String key, List pflist, boolean exact) {
        String s = null;
        if (!exact) {
            s = (String)this.getCachedProperty(channel, key, pflist);
        }
        if (s == null) {
            DPChannel dpc = this.getDPChannel(channel);
            Object object = dpLock;
            synchronized (object) {
                DPString val = dpc.getProperties().getString(key, pflist, exact);
                if (val != null) {
                    s = val.getStringValue();
                }
            }
            if (!exact) {
                object = this;
                synchronized (object) {
                    this.putCachedProperty(channel, key, pflist, s);
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringProperty(String channel, String key, String val) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setString(key, val);
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, null);
            this.putCachedProperty(channel, key, null, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringProperty(String channel, String key, String val, List pflist) {
        this.cloneIfNecessary();
        DPChannel dpc = this.getDPChannel(channel);
        Object object = dpLock;
        synchronized (object) {
            dpc.getProperties().setString(key, val, pflist);
        }
        object = this;
        synchronized (object) {
            this.removeCachedProperty(channel, key, pflist);
            this.putCachedProperty(channel, key, pflist, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedChannels(String container) {
        SmartList sl = (SmartList)this.getCachedChannelList(container, SELECTED);
        if (sl == null) {
            DPContainerChannel dpc = this.getDPContainerChannel(container);
            Object object = dpLock;
            synchronized (object) {
                sl = new SmartList(new ArrayList(dpc.getSelected().getCollectionValue().values()));
            }
            object = this;
            synchronized (object) {
                this.putCachedChannelList(container, SELECTED, sl);
            }
        }
        if (sl.isCopied()) {
            return sl.cloneOriginalList();
        }
        sl.revert();
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAvailableChannels(String container) {
        SmartList sl = (SmartList)this.getCachedChannelList(container, AVAILABLE);
        if (sl == null) {
            DPContainerChannel dpc = this.getDPContainerChannel(container);
            Object object = dpLock;
            synchronized (object) {
                sl = new SmartList(new ArrayList(dpc.getAvailable().getCollectionValue().values()));
            }
            object = this;
            synchronized (object) {
                this.putCachedChannelList(container, AVAILABLE, sl);
            }
        }
        if (sl.isCopied()) {
            return sl.cloneOriginalList();
        }
        sl.revert();
        return sl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedChannels(String container, List sel) {
        this.cloneIfNecessary();
        DPContainerChannel dpc = this.getDPContainerChannel(container);
        Object object = dpLock;
        synchronized (object) {
            dpc.setSelected(sel);
        }
        if (sel instanceof SmartList) {
            List cached = this.getCachedChannelList(container, SELECTED);
            if (cached == sel) {
                SmartList sm = (SmartList)sel;
                sm.evolve();
            } else {
                SmartList sl = (SmartList)sel;
                List l = sl.getList();
                sel = new SmartList(l);
            }
        } else {
            sel = new SmartList(sel);
        }
        object = this;
        synchronized (object) {
            this.putCachedChannelList(container, SELECTED, sel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableChannels(String container, List avail) {
        this.cloneIfNecessary();
        DPContainerChannel dpc = this.getDPContainerChannel(container);
        Object object = dpLock;
        synchronized (object) {
            dpc.setAvailable(avail);
        }
        if (avail instanceof SmartList) {
            List cached = this.getCachedChannelList(container, AVAILABLE);
            if (cached == avail) {
                SmartList sm = (SmartList)avail;
                sm.evolve();
            } else {
                SmartList sl = (SmartList)avail;
                List l = sl.getList();
                avail = new SmartList(l);
            }
        } else {
            avail = new SmartList(avail);
        }
        object = this;
        synchronized (object) {
            this.putCachedChannelList(container, AVAILABLE, avail);
        }
    }

    public boolean existsStringProperty(String channel, String name) {
        String s = this.getStringPropertyNE(channel, name, null, false);
        return s != null;
    }

    public boolean existsStringProperty(String channel, String name, List pflist) {
        String s = this.getStringPropertyNE(channel, name, pflist, false);
        return s != null;
    }

    public boolean existsBooleanProperty(String channel, String name) {
        Boolean b = this.getBooleanPropertyNE(channel, name, null, false);
        return b != null;
    }

    public boolean existsBooleanProperty(String channel, String name, List pflist) {
        Boolean b = this.getBooleanPropertyNE(channel, name, pflist, false);
        return b != null;
    }

    public boolean existsIntegerProperty(String channel, String name) {
        Integer i = this.getIntegerPropertyNE(channel, name, null, false);
        return i != null;
    }

    public boolean existsIntegerProperty(String channel, String name, List pflist) {
        Integer i = this.getIntegerPropertyNE(channel, name, pflist, false);
        return i != null;
    }

    public boolean existsCollectionProperty(String channel, String name) {
        Map m = this.getCollectionPropertyNE(channel, name, null, false);
        return m != null;
    }

    public boolean existsCollectionProperty(String channel, String name, List pflist) {
        Map m = this.getCollectionPropertyNE(channel, name, pflist, false);
        return m != null;
    }

    protected void putCachedProperty(String channel, String key, List pflist, Object o) {
        HashMap perKey;
        Map perFilter = null;
        boolean filtered = pflist != null && pflist.size() > 0;
        perFilter = filtered ? (HashMap)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perFilter == null) {
            perFilter = new HashMap();
            if (filtered) {
                this.properties.put(Boolean.TRUE, perFilter);
            } else {
                this.properties.put(Boolean.FALSE, perFilter);
            }
        }
        if ((perKey = (HashMap)perFilter.get(key)) == null) {
            perKey = new HashMap();
            perFilter.put(key, perKey);
        }
        Map<String, Object> perChannel = null;
        if (filtered) {
            String filterKey = this.getFilterKey(pflist);
            HashMap<String, HashMap<String, Object>> perPF = (HashMap<String, HashMap<String, Object>>)perKey.get(filterKey);
            if (perPF == null) {
                perPF = new HashMap<String, HashMap<String, Object>>();
                perKey.put(filterKey, perPF);
            }
            if ((perChannel = (Map)perPF.get(channel)) == null) {
                perChannel = new HashMap();
                perPF.put(channel, (HashMap<String, Object>)perChannel);
            }
        } else {
            perChannel = (HashMap<String, Object>)perKey.get(channel);
            if (perChannel == null) {
                perChannel = new HashMap<String, Object>();
                perKey.put(channel, perChannel);
            }
        }
        perChannel.put(channel, o);
    }

    protected Object removeCachedProperty(String channel, String key, List pflist) {
        Map perFilter = null;
        perFilter = (Map)this.properties.get(Boolean.FALSE);
        this.removeCachedPropertyInternal(channel, key, pflist, perFilter);
        perFilter = (Map)this.properties.get(Boolean.TRUE);
        return this.removeCachedPropertyInternal(channel, key, pflist, perFilter);
    }

    private Object removeCachedPropertyInternal(String channel, String key, List pflist, Map perFilter) {
        if (perFilter == null) {
            return null;
        }
        Map perKey = (Map)perFilter.remove(key);
        if (perKey == null) {
            return null;
        }
        boolean filtered = pflist != null && pflist.size() > 0;
        Map perChannel = null;
        if (filtered) {
            Map perPF = (Map)perKey.remove(this.getFilterKey(pflist));
            if (perPF == null) {
                return null;
            }
            perChannel = (Map)perPF.remove(channel);
        } else {
            perChannel = (Map)perKey.remove(channel);
        }
        if (perChannel == null) {
            return null;
        }
        return perChannel.remove(channel);
    }

    protected Object getCachedProperty(String channel, String key, List pflist) {
        Map perFilter = null;
        boolean filtered = pflist != null && pflist.size() > 0;
        perFilter = filtered ? (Map)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perFilter == null) {
            return null;
        }
        Map perKey = (Map)perFilter.get(key);
        if (perKey == null) {
            return null;
        }
        Map perChannel = null;
        if (filtered) {
            Map perPF = (Map)perKey.get(this.getFilterKey(pflist));
            if (perPF == null) {
                return null;
            }
            perChannel = (Map)perPF.get(channel);
        } else {
            perChannel = (Map)perKey.get(channel);
        }
        if (perChannel == null) {
            return null;
        }
        return perChannel.get(channel);
    }

    protected boolean existsCachedProperty(String channel, String key, List pflist) {
        Map perFilter = null;
        boolean filtered = pflist != null && pflist.size() > 0;
        perFilter = filtered ? (Map)this.properties.get(Boolean.TRUE) : (Map)this.properties.get(Boolean.FALSE);
        if (perFilter == null) {
            return false;
        }
        Map perKey = (Map)perFilter.get(key);
        if (perKey == null) {
            return false;
        }
        Map perChannel = null;
        if (filtered) {
            Map perPF = (Map)perKey.get(this.getFilterKey(pflist));
            if (perPF == null) {
                return false;
            }
            perChannel = (Map)perPF.get(channel);
        } else {
            perChannel = (Map)perKey.get(channel);
        }
        if (perChannel == null) {
            return false;
        }
        return perChannel.containsKey(channel);
    }

    protected void putCachedChannelList(String channel, String type, List l) {
        HashMap<String, List> perChannel;
        HashMap<String, HashMap<String, List>> perType = (HashMap<String, HashMap<String, List>>)this.channelLists.get(type);
        if (perType == null) {
            perType = new HashMap<String, HashMap<String, List>>();
            this.channelLists.put(type, perType);
        }
        if ((perChannel = (HashMap<String, List>)perType.get(channel)) == null) {
            perChannel = new HashMap<String, List>();
            perType.put(channel, perChannel);
        }
        perChannel.put(channel, l);
    }

    protected List getCachedChannelList(String channel, String type) {
        Map perType = (Map)this.channelLists.get(type);
        if (perType == null) {
            return null;
        }
        Map perChannel = (Map)perType.get(channel);
        if (perChannel == null) {
            return null;
        }
        return (List)perChannel.get(channel);
    }

    private String getFilterKey(List pflist) {
        StringBuffer b = new StringBuffer();
        Iterator i = pflist.iterator();
        while (i.hasNext()) {
            PropertiesFilter pf = (PropertiesFilter)i.next();
            if (pf == null) {
                return "null";
            }
            String condition = null;
            String value = null;
            try {
                condition = pf.getCondition();
                value = pf.getValue();
            }
            catch (PropertiesFilterException pfe) {
                throw new ContextError("DPPropertiesContext.getFilterKey(): " + pfe);
            }
            b.append(condition);
            b.append("=");
            b.append(value);
            if (pf.isRequired()) {
                b.append("*");
            }
            if (!i.hasNext()) continue;
            b.append("|");
        }
        return b.toString();
    }
}

