/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.admin;

import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.TiledViewRequestInvocationEvent;
import com.sun.portal.desktop.admin.BrowseContainerViewBean;
import com.sun.portal.desktop.admin.DesktopAdminConstants;
import com.sun.portal.desktop.admin.model.DABrowseContainerModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ExternalModulesButtonTiledView
extends RequestHandlingTiledViewBase {
    public static final String MODULE_BUTTON = "ModuleButton";
    private static final String BUTTON_KEY = "ButtonKey";
    private static final String RESOURCE_BUNDLE_NAME = "BundleName";
    private static final String VIEW_BEAN_NAME = "ViewBeanName";
    public static final String I18NKEY_IMPORT_ERROR = "browsecontainer.error.import";
    public static final String I18NKEY_GENERIC_ERROR_TITLE = "generic.error.title";
    protected Set externalModules = null;
    protected Iterator it = null;
    public static final String CLASS_NAME = "ExternalModulesButtonTiledView.";
    private DABrowseContainerModel model = null;
    public static final String CONTAINER_PATH_SEPARATOR = "|";
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$IPlanetButton;

    public ExternalModulesButtonTiledView(View parent, String name) {
        super(parent, name);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(MODULE_BUTTON, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = ExternalModulesButtonTiledView.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
    }

    protected View createChild(String name) {
        IPlanetButton child = null;
        if (!name.equals(MODULE_BUTTON)) {
            throw new IllegalArgumentException("Invalid child name " + name);
        }
        child = new IPlanetButton((ContainerView)this, MODULE_BUTTON, (Object)"");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        this.externalModules = this.getExternalModules();
        if (this.externalModules != null) {
            this.getPrimaryModel().setSize(this.externalModules.size());
            this.it = this.externalModules.iterator();
        } else {
            this.getPrimaryModel().setSize(0);
        }
        super.beginDisplay(event);
        this.resetTileIndex();
    }

    protected DABrowseContainerModel getModel() {
        if (this.model == null) {
            BrowseContainerViewBean parentVB = (BrowseContainerViewBean)this.getParentViewBean();
            this.model = parentVB.getModel();
        }
        return this.model;
    }

    public void handleModuleButtonRequest(RequestInvocationEvent event) throws ModelControlException {
        DABrowseContainerModel m = this.getModel();
        BrowseContainerViewBean parentVB = (BrowseContainerViewBean)this.getParentViewBean();
        int index = ((TiledViewRequestInvocationEvent)event).getTileNumber();
        this.externalModules = this.getExternalModules();
        Object[] extModArray = this.externalModules.toArray();
        Map moduleInfo = this.getModuleInfo((String)extModArray[index]);
        Class clazz = this.getModuleViewBeanClass(moduleInfo);
        if (clazz == null) {
            parentVB.showMessage(0, m.getLocalizedString(I18NKEY_GENERIC_ERROR_TITLE), m.getLocalizedString(I18NKEY_IMPORT_ERROR));
            parentVB.forwardTo(this.getRequestContext());
        } else {
            ViewBean vb = this.getViewBean(clazz);
            parentVB.passPgSessionMap(vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    public boolean nextTile() throws ModelControlException {
        boolean movedToRow = super.nextTile();
        int index = this.getTileIndex();
        if (movedToRow && this.externalModules != null && this.it.hasNext()) {
            String module = (String)this.it.next();
            Map moduleInfo = this.getModuleInfo(module);
            this.setDisplayFieldValue(MODULE_BUTTON, this.getModuleBtnLabel(moduleInfo));
        }
        return movedToRow;
    }

    protected Set getExternalModules() {
        return this.getModel().getExternalModules();
    }

    private Class getModuleViewBeanClass(Map moduleInfo) {
        String beanClassName = (String)moduleInfo.get(VIEW_BEAN_NAME);
        Class<?> clazz = null;
        if (beanClassName != null) {
            try {
                clazz = Class.forName(beanClassName);
            }
            catch (ClassNotFoundException cnfe) {
                DABrowseContainerModel m = this.getModel();
                m.debugError("ExternalModulesButtonTiledView..getModuleViewBeanClass: " + cnfe);
            }
        }
        return clazz;
    }

    private String getModuleBtnLabel(Map moduleInfo) {
        String btnKey = (String)moduleInfo.get(BUTTON_KEY);
        String bdlName = (String)moduleInfo.get(RESOURCE_BUNDLE_NAME);
        DABrowseContainerModel m = this.getModel();
        String label = btnKey;
        if (bdlName != null && bdlName.length() != 0 && btnKey != null && btnKey.length() != 0) {
            if (bdlName.endsWith(".properties")) {
                int index = bdlName.lastIndexOf(".properties");
                bdlName = bdlName.substring(0, index);
            }
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle(bdlName, m.getUserLocale());
            }
            catch (MissingResourceException mre) {
                m.debugError("ExternalModulesButtonTiledView.getModuleBtnLabel: ", mre);
            }
            if (rb != null) {
                label = Locale.getString((ResourceBundle)rb, (String)btnKey, (Debug)DesktopAdminConstants.debug);
            }
        }
        return label == null ? btnKey : label;
    }

    private Map getModuleInfo(String moduleAttr) {
        HashMap<String, String> moduleInfo = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(moduleAttr, CONTAINER_PATH_SEPARATOR);
        if (tokenizer.hasMoreTokens()) {
            moduleInfo.put(BUTTON_KEY, tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            moduleInfo.put(RESOURCE_BUNDLE_NAME, tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            moduleInfo.put(VIEW_BEAN_NAME, tokenizer.nextToken());
        }
        return moduleInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

