/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.robot.FilterRule;
import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.robot.RuleSet;
import com.sun.portal.search.util.PBlock;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FilterRuleset {
    public String id;
    boolean enable = false;
    public boolean onMatch = false;
    public boolean onExit = false;
    public String nickname;
    ArrayList servers = null;
    ArrayList domains = null;
    public String ports = "";
    ArrayList starting_points = null;
    ArrayList protocols = null;
    ArrayList rules = new ArrayList();
    ArrayList dns_cnames = null;
    RobotConfig config = null;
    public static final int TYPE_SERVERS = 1;
    public static final int TYPE_DOMAINS = 2;
    public static String[] Types = new String[]{"Site", "http", "https", "ftp", "file", "domain"};
    public static String[] ProtocolTypes = new String[]{"http", "file", "ftp", "https"};
    public static String[] ProtocolType_Labels = new String[]{"Web Server", "File Server", "FTP Server", "Secure Web Server"};
    ArrayList comments = null;
    ArrayList pre_comments = null;

    ArrayList stringToArrayList(String string, String string2) {
        ArrayList<String> arrayList = null;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList;
    }

    ArrayList stringToArrayList1(String string, String string2) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        while ((n = string.indexOf(string2)) > 0) {
            if (arrayList == null) {
                // empty if block
            }
            arrayList.add(string.substring(0, n));
            string = string.substring(n + string2.length());
        }
        if (string.trim().length() > 0) {
            arrayList.add(string.trim());
        }
        return arrayList;
    }

    String arrayListToString(ArrayList arrayList, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public FilterRuleset(String string) {
        HashMap hashMap = new HashMap();
        String string2 = null;
        try {
            PBlock.str2pblock((String)string, hashMap);
        }
        catch (Exception exception) {
            System.out.println("PBlockstr2pblock:Exception:" + exception.getMessage());
        }
        string2 = (String)hashMap.get("id");
        if (string2 != null) {
            this.id = string2;
        }
        if ((string2 = (String)hashMap.get("enable")) != null && string2.compareToIgnoreCase("TRUE") == 0) {
            this.enable = true;
        }
        if ((string2 = (String)hashMap.get("onMatch")) != null && string2.compareToIgnoreCase("ALLOW") == 0) {
            this.onMatch = true;
        }
        if ((string2 = (String)hashMap.get("onExit")) != null && string2.compareToIgnoreCase("ALLOW") == 0) {
            this.onExit = true;
        }
        if ((string2 = (String)hashMap.get("nickname")) != null) {
            this.nickname = string2;
        }
        if ((string2 = (String)hashMap.get("servers")) != null) {
            this.servers = this.stringToArrayList(string2, ",");
        }
        if ((string2 = (String)hashMap.get("domains")) != null) {
            this.domains = this.stringToArrayList(string2, ",");
        }
        if ((string2 = (String)hashMap.get("ports")) != null) {
            this.ports = string2;
        }
        if ((string2 = (String)hashMap.get("protocols")) != null) {
            this.protocols = this.stringToArrayList(string2, ",");
        }
        if ((string2 = (String)hashMap.get("starting-points")) != null) {
            this.starting_points = this.stringToArrayList1(string2, ", ");
        }
        if ((string2 = (String)hashMap.get("dns-alias-to-cname")) != null) {
            this.dns_cnames = this.stringToArrayList(string2, ",");
        }
    }

    FilterRuleset(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4, String string5, String string6) {
        this.id = string;
        this.enable = bl;
        this.onMatch = bl2;
        this.onExit = bl3;
        this.nickname = string2;
        this.domains = new ArrayList();
        this.domains.add(string3);
        this.ports = string4;
        this.protocols = this.stringToArrayList(string5, ",");
        this.starting_points = new ArrayList();
        this.starting_points.add(string6);
    }

    FilterRuleset(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4) {
        this.id = string;
        this.enable = bl;
        this.onMatch = bl2;
        this.onExit = bl3;
        this.nickname = string2;
        this.servers = new ArrayList();
        this.servers.add(string3);
        this.starting_points = new ArrayList();
        this.starting_points.add(string4);
    }

    public String toXMLString() {
        StringBuffer stringBuffer = new StringBuffer("<Ruleset id=\"" + this.id + "\" enable=\"" + RobotConfig.BtoString(this.enable) + "\" onMatch=\"" + RobotConfig.ADtoString(this.onMatch) + "\" onExit=\"" + RobotConfig.ADtoString(this.onExit) + "\" \nnickname=\"" + this.nickname + "\" servers=\"" + this.servers + "\" starting-points=\"" + this.starting_points + "\">\n");
        ListIterator listIterator = this.rules.listIterator(0);
        try {
            while (true) {
                RuleSet ruleSet = (RuleSet)listIterator.next();
                stringBuffer.append(ruleSet.toXMLString());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return stringBuffer.toString();
        }
    }

    public String toConfigString() {
        Object object;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.pre_comments != null) {
            stringBuffer.append("#\n");
            for (n = 0; n < this.pre_comments.size(); ++n) {
                object = (String)this.pre_comments.get(n);
                stringBuffer.append("# " + (String)object + "\n");
            }
            stringBuffer.append("#\n");
        }
        stringBuffer.append("<Ruleset id=" + this.id + " enable=" + RobotConfig.BtoString(this.enable) + " onMatch=" + RobotConfig.ADtoString(this.onMatch) + " onExit=" + RobotConfig.ADtoString(this.onExit) + "\n" + "      nickname=\"" + this.nickname + "\"\n");
        if (this.servers != null) {
            stringBuffer.append("      servers=\"" + this.servers.toString().substring(1, this.servers.toString().length() - 1) + "\"\n");
        } else if (this.domains != null) {
            stringBuffer.append("      domains=\"" + this.domains.toString().substring(1, this.domains.toString().length() - 1) + "\"\n");
            if (this.ports.length() > 0) {
                stringBuffer.append("      ports=\"" + this.ports + "\"\n");
            }
            if (this.protocols != null) {
                stringBuffer.append("      protocols=\"" + this.protocols.toString().substring(1, this.protocols.toString().length() - 1) + "\"\n");
            }
        }
        if (this.dns_cnames != null && this.dns_cnames.size() > 0) {
            stringBuffer.append("      dns-alias-to-cname=\"" + this.dns_cnames.toString().substring(1, this.dns_cnames.toString().length() - 1) + "\"\n");
        }
        if (this.starting_points != null) {
            stringBuffer.append("      starting-points=\"" + this.arrayListToString(this.starting_points, ", ") + "\"");
        }
        stringBuffer.append(">\n");
        if (this.comments != null) {
            stringBuffer.append("#\n");
            for (n = 0; n < this.comments.size(); ++n) {
                object = (String)this.comments.get(n);
                stringBuffer.append("# " + (String)object + "\n");
            }
            stringBuffer.append("#\n");
        }
        ListIterator listIterator = this.rules.listIterator(0);
        while (listIterator.hasNext()) {
            try {
                object = (RuleSet)listIterator.next();
                stringBuffer.append(((RuleSet)object).toConfigString());
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
                break;
            }
        }
        stringBuffer.append("</Ruleset>\n");
        return stringBuffer.toString();
    }

    public void AddFilterbyString(String string) {
        HashMap hashMap = new HashMap();
        String string2 = null;
        boolean bl = false;
        String string3 = null;
        try {
            PBlock.str2pblock((String)string, hashMap);
        }
        catch (Exception exception) {
            System.out.println("[AddFilterbyString]PBlockstr2pblock:Exception:" + exception.getMessage());
        }
        string3 = (String)hashMap.get("id");
        if (string3 != null) {
            string2 = string3;
        }
        if ((string3 = (String)hashMap.get("onMatch")) != null && string3.compareToIgnoreCase("ALLOW") == 0) {
            bl = true;
        }
        if (this.id != null) {
            this.AddFilter(string2, bl);
        }
    }

    public void AddFilter(String string, boolean bl) {
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleSet ruleSet = (RuleSet)this.rules.get(i);
            if (!ruleSet.rule_id.equals(string)) continue;
            return;
        }
        RuleSet ruleSet = new RuleSet(string, bl);
        this.rules.add(ruleSet);
    }

    public boolean Filter(String string) {
        ListIterator listIterator = this.rules.listIterator(0);
        try {
            RuleSet ruleSet;
            FilterRule filterRule;
            do {
                ruleSet = (RuleSet)listIterator.next();
            } while (!(filterRule = this.config.GetRule(ruleSet.rule_id)).Match(string));
            return ruleSet.onMatch;
        }
        catch (NoSuchElementException noSuchElementException) {
            return !this.onExit;
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public void setEnabled(boolean bl) {
        this.enable = bl;
    }

    public void addDNSTranslations(String string) {
        ArrayList arrayList = this.stringToArrayList(string, ",");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string2.trim().length() <= 0) continue;
            this.addDNSTranslation(string2.trim());
        }
    }

    public void addDNSTranslation(String string) {
        if (this.dns_cnames == null) {
            this.dns_cnames = new ArrayList();
        }
        this.dns_cnames.add(string);
    }

    public void addComments(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            this.addComment(string2);
        }
    }

    public void addComment(String string) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(string);
    }

    public void addPreComment(ArrayList arrayList) {
        this.pre_comments = arrayList;
    }

    public int numOfServers() {
        if (this.servers == null) {
            return 0;
        }
        return this.servers.size();
    }

    public int numOfDomains() {
        if (this.domains == null) {
            return 0;
        }
        return this.domains.size();
    }

    public String getDomainByIndex(int n) {
        try {
            String string = (String)this.domains.get(n);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public String getServerByIndex(int n) {
        try {
            String string = (String)this.servers.get(n);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int numOfStartingPoints() {
        return this.starting_points.size();
    }

    public String getStartingPointByIndex(int n) {
        try {
            String string = (String)this.starting_points.get(n);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public int numOfFilters() {
        return this.rules.size();
    }

    public String getFiltersIDByIndex(int n) {
        try {
            RuleSet ruleSet = (RuleSet)this.rules.get(n);
            return ruleSet.rule_id;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean isFilterInUsed(String string) {
        try {
            for (int i = 0; i < this.rules.size(); ++i) {
                RuleSet ruleSet = (RuleSet)this.rules.get(i);
                if (ruleSet.rule_id.compareTo(string) != 0) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public String getFiltersonMatchByIndex(int n) {
        try {
            RuleSet ruleSet = (RuleSet)this.rules.get(n);
            return RobotConfig.ADtoString(ruleSet.onMatch);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public boolean deleteFilterByIndex(int n) {
        boolean bl = false;
        try {
            if (this.rules.remove(n) != null) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return bl;
    }

    public boolean deleteFilterByID(String string) {
        boolean bl = false;
        for (int i = 0; i < this.rules.size(); ++i) {
            RuleSet ruleSet = (RuleSet)this.rules.get(i);
            if (ruleSet.rule_id.compareTo(string) != 0) continue;
            this.rules.remove(i);
            return true;
        }
        return false;
    }

    public void removeFilters() {
        this.rules = new ArrayList();
    }

    public void addStartingPoint(URL uRL, int n) {
        String string = uRL.toString();
        int n2 = -1;
        if (this.starting_points == null) {
            this.starting_points = new ArrayList();
        }
        for (int i = 0; i < this.starting_points.size(); ++i) {
            String string2 = (String)this.starting_points.get(i);
            String string3 = string2.substring(0, string2.indexOf(" depth="));
            if (!string.equalsIgnoreCase(string3)) continue;
            n2 = i;
            break;
        }
        if (n2 >= 0) {
            this.deleteStartingPointByIndex(n2);
        }
        String string4 = string + " depth=" + n;
        this.starting_points.add(string4);
    }

    public void removeStartingPoints() {
        if (this.starting_points != null) {
            this.starting_points = new ArrayList();
        }
    }

    public boolean deleteStartingPointByIndex(int n) {
        boolean bl = false;
        try {
            if (this.starting_points.remove(n) != null) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return bl;
    }

    public void removeProtocol() {
        this.protocols = new ArrayList();
    }

    public void addProtocol(String string) {
        if (this.protocols == null) {
            this.protocols = new ArrayList();
        }
        this.protocols.add(string);
    }

    public boolean isProtocolChecked(String string) {
        if (this.protocols == null) {
            return false;
        }
        for (int i = 0; i < this.protocols.size(); ++i) {
            String string2 = (String)this.protocols.get(i);
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    void addStringToListUnique(ArrayList arrayList, String string) {
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2.compareToIgnoreCase(string) != 0) continue;
                return;
            }
            arrayList.add(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addServer(String string) {
        if (this.servers == null) {
            this.servers = new ArrayList();
        }
        this.addStringToListUnique(this.servers, string);
    }

    public void removeServers() {
        this.servers = new ArrayList();
    }

    public boolean deleteServerByIndex(int n) {
        boolean bl = false;
        try {
            if (this.servers.remove(n) != null) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return bl;
    }

    public void addDomain(String string) {
        if (this.domains == null) {
            this.domains = new ArrayList();
        }
        this.addStringToListUnique(this.domains, string);
    }

    public void removeDomains() {
        this.domains = new ArrayList();
    }

    public void removeComment() {
        this.comments = new ArrayList();
    }

    public void removeDNSTranslation() {
        this.dns_cnames = new ArrayList();
    }

    public boolean deleteDomainByIndex(int n) {
        boolean bl = false;
        try {
            if (this.domains.remove(n) != null) {
                bl = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return bl;
    }

    public int getType() {
        if (this.servers != null) {
            return 1;
        }
        return 2;
    }

    public boolean isForMe(URL uRL) {
        if (this.servers != null) {
            String string = uRL.getProtocol() + "://" + uRL.getHost() + (uRL.getPort() > 0 ? ":" + Integer.toString(uRL.getPort()) : "") + "/";
            for (int i = 0; i < this.servers.size(); ++i) {
                String string2 = (String)this.servers.get(i);
                if (string.compareToIgnoreCase(string2) != 0) continue;
                return true;
            }
        } else {
            for (int i = 0; this.domains != null && i < this.domains.size(); ++i) {
                String string = (String)this.domains.get(i);
                if (!uRL.getHost().endsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    public String getComments() {
        if (this.comments == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.comments.size(); ++i) {
            stringBuffer.append((String)this.comments.get(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public String getDNSTranslation() {
        if (this.dns_cnames == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.dns_cnames.size(); ++i) {
            stringBuffer.append((String)this.dns_cnames.get(i));
            if (i + 1 >= this.dns_cnames.size()) continue;
            stringBuffer.append(",\n");
        }
        return stringBuffer.toString();
    }
}

