/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.robot;

import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.DocType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConverterConfig {
    ArrayList docs = null;
    String converter_conf = null;
    ArrayList pre_comment = null;

    public static void main(String[] stringArray) {
        ConverterConfig converterConfig = new ConverterConfig(stringArray[0]);
        converterConfig.updateFile();
    }

    public ConverterConfig(String string) {
        this.converter_conf = string + File.separator + "convert.conf";
        this.docs = new ArrayList();
        this.parse_converter(this.converter_conf);
    }

    void parse_converter(String string) {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            System.out.println("Exception:" + iOException.getMessage());
            return;
        }
        boolean bl = false;
        while (string2 != null) {
            String string3 = string2.trim();
            if (string3.length() == 0) {
                try {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (string3.startsWith("#")) {
                this.addPreComment(string3);
                try {
                    string2 = bufferedReader.readLine();
                    continue;
                }
                catch (IOException iOException) {
                    break;
                }
            }
            if (!string3.startsWith("DocType=")) {
                CSDebug.logln("Invalid String:" + string3);
            } else {
                DocType docType = new DocType();
                StringTokenizer stringTokenizer = new StringTokenizer(string3.substring(8), "@@");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    switch (n) {
                        case 0: {
                            docType.desc = stringTokenizer.nextToken();
                            break;
                        }
                        case 1: {
                            docType.type_nums = stringTokenizer.nextToken();
                            break;
                        }
                        case 2: {
                            if (stringTokenizer.nextToken().trim().compareTo("1") != 0) break;
                            docType.enabled = true;
                            break;
                        }
                        case 3: {
                            docType.module = stringTokenizer.nextToken();
                            break;
                        }
                        case 4: {
                            docType.args = stringTokenizer.nextToken();
                        }
                    }
                    ++n;
                }
                this.docs.add(docType);
            }
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                break;
            }
        }
    }

    public void updateFile() {
        int n;
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.converter_conf);
            printWriter = new PrintWriter(fileOutputStream, true);
        }
        catch (Exception exception) {
            System.out.println("[updateFile]Exception:" + exception.getMessage());
            return;
        }
        for (n = 0; this.pre_comment != null && n < this.pre_comment.size(); ++n) {
            printWriter.println("#" + (String)this.pre_comment.get(n));
        }
        for (n = 0; n < this.docs.size(); ++n) {
            DocType docType = (DocType)this.docs.get(n);
            printWriter.print("DocType=" + docType.desc + "@@" + docType.type_nums + "@@");
            if (docType.enabled) {
                printWriter.print("1@@");
            } else {
                printWriter.print("0@@");
            }
            if (docType.module != null) {
                printWriter.print(docType.module + "@@");
                if (docType.args != null) {
                    printWriter.print(docType.args + "@@");
                }
            }
            printWriter.println("");
        }
        printWriter.close();
    }

    public int numOfDocs() {
        return this.docs.size();
    }

    public void addPreComment(String string) {
        if (this.pre_comment == null) {
            this.pre_comment = new ArrayList();
        }
        String string2 = string.substring(1);
        this.pre_comment.add(string2);
    }

    public String getDocLabel(int n) {
        if (n >= 0 && n < this.docs.size()) {
            DocType docType = (DocType)this.docs.get(n);
            return docType.desc;
        }
        return null;
    }

    public void setDocEnable(int n, boolean bl) {
        if (n >= 0 && n < this.docs.size()) {
            DocType docType = (DocType)this.docs.get(n);
            docType.enabled = bl;
        }
    }

    public boolean getDocEnable(int n) {
        if (n >= 0 && n < this.docs.size()) {
            DocType docType = (DocType)this.docs.get(n);
            return docType.enabled;
        }
        return false;
    }
}

