/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.autoclassify;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;

public class RemoteSearch {
    String scope = null;
    String viewAttributes = null;
    String queryLanguage = null;
    String database = null;
    String RDMServer = null;
    String user = null;
    String password = null;
    AMStoreConnection sConnection = null;
    String adminUID = null;
    String adminPWD = null;
    SSOToken ssoToken = null;

    public RemoteSearch(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.scope = string;
        this.viewAttributes = string2;
        this.queryLanguage = string3;
        this.database = string4;
        this.RDMServer = string5;
        this.user = string6;
        this.password = string7;
        this.init();
    }

    private AMStoreConnection getSSOStoreConnection() {
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            if (this.sConnection == null) {
                if (this.ssoToken == null) {
                    this.ssoToken = sSOTokenManager.createSSOToken(new Principal(){

                        public String getName() {
                            return AdminUtils.getAdminDN();
                        }
                    }, this.adminPWD);
                }
                this.sConnection = new AMStoreConnection(this.ssoToken);
            }
            return this.sConnection;
        }
        catch (Exception exception) {
            System.err.println("failed to get Store Connection" + exception);
            return null;
        }
    }

    private void init() {
        try {
            this.adminUID = AdminUtils.getAdminDN();
            this.adminPWD = new String(AdminUtils.getAdminPassword());
            this.sConnection = this.getSSOStoreConnection();
        }
        catch (Exception exception) {
            System.err.println("init(): exception:" + exception.getMessage());
        }
    }

    public SOIFInputStream getResult() throws Exception {
        SOIFInputStream sOIFInputStream = null;
        RDMHeader rDMHeader = null;
        RDMQuery rDMQuery = new RDMQuery(this.scope);
        String string = "rd-request";
        RDMHeader rDMHeader2 = null;
        SOIFBuffer sOIFBuffer = new SOIFBuffer();
        rDMHeader = new RDMHeader(string, null, this.queryLanguage, null);
        if (this.user != null) {
            rDMHeader.setUser(this.user);
            if (this.password != null) {
                rDMHeader.setPassword(this.password);
            }
        }
        rDMQuery.setViewHits("1..99999");
        if (this.viewAttributes != null) {
            rDMQuery.setViewAttr(this.viewAttributes);
        }
        if (this.database != null) {
            rDMQuery.setDatabase(this.database);
        }
        SOIFOutputStream sOIFOutputStream = new SOIFOutputStream((OutputStream)sOIFBuffer);
        sOIFOutputStream.write(rDMHeader.getSOIF());
        sOIFOutputStream.write(rDMQuery.getSOIF());
        URLConnection uRLConnection = new URL(this.RDMServer).openConnection();
        uRLConnection.setAllowUserInteraction(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.addRequestProperty("proxyDN", "uid=amAdmin,ou=People,dc=red,dc=iplanet,dc=com");
        uRLConnection.getOutputStream().write(sOIFBuffer.toByteArray());
        sOIFInputStream = new SOIFInputStream(uRLConnection.getInputStream());
        rDMHeader2 = new RDMHeader(sOIFInputStream);
        String string2 = rDMHeader2.getErrorMessage();
        if (string2 != null && !string2.equalsIgnoreCase("0 results")) {
            System.out.println("RDM Error: " + string2);
            return null;
        }
        return sOIFInputStream;
    }
}

