/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.util;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class DBUtil {
    static String getListCmd = "run-cs-cli rdmgr -y root -U";
    static String getRDCountCmd = "/run-cs-cli rdmgr -n -y ";
    static List dbList = null;
    static Date lastUpdated = null;
    public static SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    public static final String STAT_LAST_MODIFIED = "DbStat-LastModified";
    public static final String STAT_NB_SERVER = "DbStat-NbServer";
    public static final String STAT_HREF = "DbStat-Href";
    public static final String STAT_HREF_COUNT = "DbStat-Href-count";
    public static final String STAT_NB_PROTOCOL = "DbStat-NbProtocol";
    public static final String STAT_PROTOCOL = "DbStat-Protocol";
    public static final String STAT_PROTOCOL_COUNT = "DbStat-Protocol-count";
    static String RUN_CS_CLI = "run-cs-cli";
    static String RUN_CS_CLI_BAT = "run-cs-cli.bat";

    public static List getDBList(String string) throws Exception {
        Serializable serializable;
        boolean bl = true;
        bl = lastUpdated != null ? !lastUpdated.after(new Date(((File)(serializable = new File(SearchConfig.getValue((String)"database-directory") + File.separator + "root" + File.separator + "rd.db"))).lastModified())) : true;
        if (bl) {
            serializable = new ArrayList();
            String string2 = string + File.separator + getListCmd;
            Runtime runtime = Runtime.getRuntime();
            Process process = DBUtil.exec(string2);
            SOIFInputStream sOIFInputStream = new SOIFInputStream(process.getInputStream(), "UTF-8");
            while (!sOIFInputStream.isEOS()) {
                SOIF sOIF;
                int n;
                SOIF sOIF2 = sOIFInputStream.readSOIF();
                if (sOIF2 == null || sOIF2.getURL().equals("root")) continue;
                for (n = 0; n < ((ArrayList)serializable).size() && (sOIF = (SOIF)((ArrayList)serializable).get(n)).getURL().compareTo(sOIF2.getURL()) <= 0; ++n) {
                }
                ((ArrayList)serializable).add(n, sOIF2);
            }
            lastUpdated = new Date();
            dbList = serializable;
        }
        return dbList;
    }

    public static String[] getDBStringArray(String string) throws Exception {
        List list = DBUtil.getDBList(string);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SOIF sOIF = (SOIF)list.get(i);
            stringArray[i] = sOIF.getURL();
        }
        return stringArray;
    }

    public static boolean updateSoif(String string, SOIF sOIF) {
        try {
            String string2 = string + File.separator + "tmp" + File.separator + "_tmpDBUtil." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(string2);
            sOIFOutputStream.write(sOIF);
            sOIFOutputStream.close();
            String string3 = string + "/run-cs-cli rdmgr -D -y root -m -P -q " + string2;
            Runtime runtime = Runtime.getRuntime();
            Process process = DBUtil.exec(string3);
            process.waitFor();
            if (process.exitValue() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean replaceSoif(String string, SOIF sOIF) {
        try {
            String string2 = string + File.separator + "tmp" + File.separator + "_tmpDBUtil." + Long.toString(System.currentTimeMillis());
            SOIFOutputStream sOIFOutputStream = new SOIFOutputStream(string2);
            sOIFOutputStream.write(sOIF);
            sOIFOutputStream.close();
            String string3 = string + "/run-cs-cli rdmgr -D -y root -u -P -q " + string2;
            Runtime runtime = Runtime.getRuntime();
            Process process = DBUtil.exec(string3);
            process.waitFor();
            if (process.exitValue() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static synchronized boolean isDBExist(String string, String string2) throws Exception {
        List list = DBUtil.getDBList(string);
        for (int i = 0; i < list.size(); ++i) {
            SOIF sOIF = (SOIF)list.get(i);
            if (sOIF.getURL().compareToIgnoreCase(string2) != 0) continue;
            return true;
        }
        return false;
    }

    public static synchronized boolean addNewDB(String string, String string2, String string3, String string4) throws Exception {
        Object object;
        List list = DBUtil.getDBList(string);
        for (int i = 0; i < list.size(); ++i) {
            object = (SOIF)list.get(i);
            if (object.getURL().compareToIgnoreCase(string2) != 0) continue;
            return false;
        }
        String string5 = string + "/run-cs-cli rdmgr -y " + string2 + " -n";
        object = Runtime.getRuntime();
        Process process = DBUtil.exec(string5);
        process.waitFor();
        if (process.exitValue() != 0) {
            return false;
        }
        SOIF sOIF = new SOIF("Database", string2);
        sOIF.insert("description", string4);
        sOIF.insert("Title", string3);
        return DBUtil.updateSoif(string, sOIF);
    }

    public static SOIF getDBSoif(String string, String string2) {
        try {
            List list = DBUtil.getDBList(string);
            for (int i = 0; i < list.size(); ++i) {
                SOIF sOIF = (SOIF)list.get(i);
                if (!sOIF.getURL().equals(string2)) continue;
                return sOIF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static synchronized boolean updateDB(String string, String string2, String string3, String string4) throws Exception {
        SOIF sOIF = DBUtil.getDBSoif(string, string2);
        if (sOIF != null) {
            sOIF.replace("description", string4);
            sOIF.replace("Title", string3);
            return DBUtil.updateSoif(string, sOIF);
        }
        return false;
    }

    public static synchronized boolean updateDB(String string, String string2, Date date, Hashtable hashtable, Hashtable hashtable2) throws Exception {
        SOIF sOIF = DBUtil.getDBSoif(string, string2);
        if (sOIF != null) {
            try {
                int n;
                String string3 = sOIF.getValue(STAT_NB_SERVER);
                if (string3 != null) {
                    for (n = 0; n < Integer.parseInt(string3); ++n) {
                        sOIF.remove(STAT_HREF, n);
                        sOIF.remove(STAT_HREF_COUNT, n);
                    }
                }
                if ((string3 = sOIF.getValue(STAT_NB_PROTOCOL)) != null) {
                    for (n = 0; n < Integer.parseInt(string3); ++n) {
                        sOIF.remove(STAT_PROTOCOL, n);
                        sOIF.remove(STAT_PROTOCOL_COUNT, n);
                    }
                }
                sOIF.replace(STAT_LAST_MODIFIED, date != null ? df.format(date) : df.format(new Date()));
                sOIF.replace(STAT_NB_SERVER, hashtable != null ? Integer.toString(hashtable.size()) : Integer.toString(0));
                sOIF.replace(STAT_NB_PROTOCOL, hashtable2 != null ? Integer.toString(hashtable2.size()) : Integer.toString(0));
                Enumeration<Object> enumeration = null;
                Object var9_10 = null;
                if (hashtable != null) {
                    enumeration = hashtable.keys();
                    n = 0;
                    while (enumeration.hasMoreElements()) {
                        sOIF.insert(STAT_HREF, (String)enumeration.nextElement(), n);
                        ++n;
                    }
                    enumeration = hashtable.elements();
                    n = 0;
                    while (enumeration.hasMoreElements()) {
                        sOIF.insert(STAT_HREF_COUNT, (String)enumeration.nextElement(), n);
                        ++n;
                    }
                }
                if (hashtable2 != null) {
                    enumeration = hashtable2.keys();
                    n = 0;
                    while (enumeration.hasMoreElements()) {
                        sOIF.insert(STAT_PROTOCOL, (String)enumeration.nextElement(), n);
                        ++n;
                    }
                    enumeration = hashtable2.elements();
                    n = 0;
                    while (enumeration.hasMoreElements()) {
                        sOIF.insert(STAT_PROTOCOL_COUNT, (String)enumeration.nextElement(), n);
                        ++n;
                    }
                }
                return DBUtil.replaceSoif(string, sOIF);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static int getRDCount(String string, String string2) throws Exception {
        int n = 0;
        String string3 = string + File.separator + getRDCountCmd + string2;
        Runtime runtime = Runtime.getRuntime();
        Process process = DBUtil.exec(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string4 = bufferedReader.readLine();
        NumberFormat numberFormat = NumberFormat.getInstance();
        n = numberFormat.parse(string4).intValue();
        return n;
    }

    static synchronized boolean executeRDMgr(String string, Writer writer) {
        boolean bl = false;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (writer == null) continue;
                writer.write(string2 + "\n");
                writer.flush();
            }
            bl = process.waitFor() == 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    static synchronized BufferedReader executeRDMgr(String string) {
        BufferedReader bufferedReader = null;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = DBUtil.exec(string);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bufferedReader;
    }

    public static boolean purgeDatabase(String string, String string2, Writer writer) {
        String string3 = string + File.separator + "run-cs-cli rdmgr -X -p stdout -y " + string2;
        return DBUtil.executeRDMgr(string3, writer);
    }

    public static boolean reindexDatabase(String string, String string2, Writer writer) {
        String string3 = string + File.separator + "run-cs-cli rdmgr -I -p stdout -y " + string2;
        return DBUtil.executeRDMgr(string3, writer);
    }

    public static boolean expireDatabase(String string, String string2, Writer writer) {
        String string3 = string + File.separator + "run-cs-cli rdmgr -E -p stdout -y " + string2;
        return DBUtil.executeRDMgr(string3, writer);
    }

    public static boolean deleteDatabase(String string, String string2, Writer writer) {
        String string3 = string + File.separator + "run-cs-cli rdmgr -B -p stdout -y " + string2;
        return DBUtil.executeRDMgr(string3, writer);
    }

    public static BufferedReader urlStatDatabase(String string, String string2) {
        String string3 = string + File.separator + "run-cs-cli rdmgr -L -a url -y " + string2;
        return DBUtil.executeRDMgr(string3);
    }

    public static boolean dbStatOnFile(String string, String string2) {
        boolean bl = false;
        try {
            bl = DBUtil.getDBSoif(string, string2).getValue(STAT_LAST_MODIFIED) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean indexCategories(String string) {
        boolean bl = true;
        String[] stringArray = new String[]{string + File.separator + "run-cs-cli rdmgr -p stdout -T -X", string + File.separator + "run-cs-cli rdmgr -TV -p stdout " + SearchConfig.getValue((String)"taxonomy-description")};
        for (int i = 0; i < 2 && (bl = DBUtil.executeRDMgr(stringArray[i], null)); ++i) {
        }
        return bl;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static Process exec(String string) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        if (DBUtil.isWindows()) {
            string = string.replace('\\', '/');
            int n = string.indexOf(RUN_CS_CLI);
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append(RUN_CS_CLI_BAT);
            stringBuffer.append(string.substring(n + RUN_CS_CLI.length()));
            string = stringBuffer.toString();
            process = runtime.exec(string);
        } else {
            process = runtime.exec(string);
        }
        return process;
    }
}

