/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.robot.FilterRuleset;
import com.sun.portal.search.robot.RobotConfig;
import java.util.Locale;
import java.util.StringTokenizer;

public class StartPointsListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel {
    public static final String FIELD_ENABLE = "enable";
    public static final String FIELD_STARTPOINT = "startpoint";
    public static final String FIELD_DEPTH = "depth";
    public static final String FIELD_SITENAME = "sitename";
    public static final String FIELD_SITEID = "siteid";
    public Locale userLocale = Locale.getDefault();

    public StartPointsListModel() {
        CSDebug.logln("StartPointsListModel()");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("StartPointsListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        }
        return object;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("StartPointsListModel.retrieve");
        this.clear();
        RobotConfig robotConfig = CSConfig.getRobotConfig();
        int n = robotConfig.numRuleset();
        CSDebug.logln("size=" + n);
        for (int i = 0; i < n; ++i) {
            FilterRuleset filterRuleset = robotConfig.GetRuleSet(i);
            int n2 = filterRuleset.numOfStartingPoints();
            for (int j = 0; j < n2; ++j) {
                String string = filterRuleset.getStartingPointByIndex(j);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = null;
                int n3 = -1;
                for (int k = 0; stringTokenizer.hasMoreTokens() && k < 2; ++k) {
                    String string3 = stringTokenizer.nextToken();
                    if (k == 0) {
                        string2 = string3;
                        continue;
                    }
                    n3 = Integer.parseInt(string3.substring(6));
                }
                this.appendRow();
                this.setValue(FIELD_ENABLE, filterRuleset.isEnabled() ? this.getLocalizedString("robot.sp.yes") : this.getLocalizedString("robot.sp.no"));
                this.setValue(FIELD_STARTPOINT, string2);
                this.setValue(FIELD_DEPTH, n3 == -1 ? this.getLocalizedString("robot.sp.unlimited") : Integer.toString(n3));
                this.setValue(FIELD_SITENAME, filterRuleset.nickname);
                this.setValue(FIELD_SITEID, filterRuleset.id);
            }
        }
        return null;
    }

    public String getLocalizedString(String string) {
        return SearchResource.geti18nString(string, this.userLocale);
    }
}

