/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.model;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.DeletingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.UpdatingModel;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.robot.FilterRuleset;
import java.util.ArrayList;

public class DomainGroupListModel
extends DefaultModel
implements DatasetModel,
RetrievingModel,
UpdatingModel,
InsertingModel,
DeletingModel {
    private String rulesetID = null;
    private int delIndex = -1;
    public static final String FIELD_DOMAIN = "DomainAlias";
    public static final String FIELD_VERIFIED_TEXT = "VerifiedText";
    public static final String FIELD_DELETE = "Delete";

    public DomainGroupListModel() {
        CSDebug.logln("DomainGroupListModel()");
    }

    public void setID(String string) {
        this.rulesetID = string;
    }

    public void setDelIndex(int n) {
        this.delIndex = n;
    }

    private void removeNullList() throws ModelControlException {
        if (this.getSize() == 1 && this.getValue(FIELD_DOMAIN) == null) {
            this.getCurrentContext().getValueList().clear();
        }
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("DomainGroupListModel.execute");
        String string = null;
        string = modelExecutionContext != null ? modelExecutionContext.getOperationName() : "retrieve";
        Object object = null;
        if (string.equals("retrieve")) {
            object = this.retrieve(modelExecutionContext);
        } else if (string.equals("insert")) {
            object = this.insert(modelExecutionContext);
        } else if (string.equals("update")) {
            object = this.update(modelExecutionContext);
        } else if (string.equals("delete")) {
            object = this.delete(modelExecutionContext);
        }
        return object;
    }

    public Object update(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln("DomainGroupListModel.update()");
        this.beforeFirst();
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            filterRuleset.removeDomains();
            while (this.next()) {
                String string = (String)this.getValue(FIELD_DOMAIN);
                if (string == null || string.trim().length() <= 0) continue;
                filterRuleset.addDomain(string.trim());
            }
        }
        return null;
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        this.appendRow();
        return null;
    }

    public Object delete(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.removeNullList();
        CSDebug.logln(((Object)((Object)this)).getClass().getName() + ".delete()");
        if (this.delIndex != -1) {
            this.getCurrentContext().getValueList().remove(this.delIndex);
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.beforeFirst();
        while (this.next()) {
            String string = (String)this.getValue(FIELD_DELETE);
            if (string == null || string.compareTo("true") != 0) continue;
            int n = this.getRowIndex();
            arrayList.add(this.getCurrentContext().getValueList().get(n));
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            this.getCurrentContext().getValueList().remove(arrayList.get(i));
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        CSDebug.logln("DomainGroupModel.retrieve");
        FilterRuleset filterRuleset = null;
        if (this.rulesetID != null) {
            filterRuleset = CSConfig.getRobotConfig().GetRuleSet(this.rulesetID);
        }
        if (filterRuleset != null) {
            this.clear();
            int n = filterRuleset.numOfDomains();
            for (int i = 0; i < n; ++i) {
                String string = filterRuleset.getDomainByIndex(i);
                if (string == null) continue;
                this.appendRow();
                this.setValue(FIELD_DOMAIN, filterRuleset.getDomainByIndex(i));
                this.setValue(FIELD_VERIFIED_TEXT, filterRuleset.getDomainByIndex(i));
                this.setValue(FIELD_DELETE, "false");
            }
        }
        this.beforeFirst();
        return null;
    }
}

