/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.search.admin.CSDebug;
import com.sun.portal.search.admin.Rule;
import com.sun.portal.search.util.PBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class CnConfig {
    public static String CLASSIFICATION_CONF = "classification.conf";
    public static final String SRC_URL = "URL";
    public static final String SRC_HOST = "host";
    public static final String SRC_PROTOCOL = "protocol";
    public static final String SRC_URI = "uri";
    public static final String SRC_IP = "ip";
    public static final String SRC_TYPE = "type";
    public static final String SRC_ATTRIBUTE = "attribute";
    public static final String METHOD_EXACT = "by-exact";
    public static final String METHOD_PREFIX = "by-prefix";
    public static final String METHOD_SUFFIX = "by-suffix";
    public static final String METHOD_SUBSTR = "by-substr";
    public static final String METHOD_REGEX = "by-regex";
    public static final String[] METHOD_LIST = new String[]{"by-exact", "by-prefix", "by-suffix", "by-substr", "by-regex"};
    private StringBuffer filename;
    private StringBuffer rulesHeader = new StringBuffer();
    private StringBuffer rulesFooter = new StringBuffer();
    ArrayList rulesList;

    public CnConfig(String string) {
        this.filename = new StringBuffer();
        this.filename.append(string + File.separator);
        this.filename.append("config" + File.separator);
        this.filename.append(CLASSIFICATION_CONF);
        this.parseClassificationFile(this.filename.toString());
    }

    public ArrayList getRulesList() {
        return this.rulesList;
    }

    public boolean isExist(String string, String string2, String string3, String string4) {
        return this.isExist(string, string2, string3, string4, -1);
    }

    public boolean isExist(String string, String string2, String string3, String string4, int n) {
        for (int i = 0; i < this.rulesList.size(); ++i) {
            Rule rule;
            if (i == n || !(rule = (Rule)this.rulesList.get(i)).getSrc().equalsIgnoreCase(string) || !rule.getMethod().equalsIgnoreCase(string2) || !rule.getName().equals(string3) || !rule.getAction().equals(string4)) continue;
            return true;
        }
        return false;
    }

    public boolean add(String string, String string2, String string3, String string4, boolean bl) {
        if (this.isExist(string, string2, string3, string4)) {
            return false;
        }
        Rule rule = new Rule(string, string2, string3, string4, bl);
        this.addSortedBySrc(rule);
        return true;
    }

    void addSortedBySrc(Rule rule) {
        for (int i = 0; i < this.rulesList.size(); ++i) {
            Rule rule2 = (Rule)this.rulesList.get(i);
            if (rule.getSrc().compareTo(rule2.getSrc()) >= 0) continue;
            this.rulesList.add(i, rule);
            return;
        }
        this.rulesList.add(rule);
    }

    public void delete(int n) {
        this.rulesList.remove(n);
    }

    public void removeAll() {
        this.rulesList.clear();
    }

    public void update(int n, String string, String string2, String string3, String string4) {
        Rule rule = (Rule)this.rulesList.get(n);
        rule.setSrc(string);
        rule.setMethod(string2);
        rule.setName(string3);
        rule.setAction(string4);
    }

    public void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename.toString());
            PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8")), true);
            printWriter.println(this.rulesHeader);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.rulesList.size(); ++i) {
                Rule rule = (Rule)this.rulesList.get(i);
                stringBuffer.append("Classification");
                stringBuffer.append(" ");
                stringBuffer.append("src=");
                stringBuffer.append("\"" + rule.getSrc() + "\"");
                stringBuffer.append(" ");
                stringBuffer.append(rule.getMethod());
                stringBuffer.append("=");
                stringBuffer.append(PBlock.quotedString((String)rule.getName()));
                stringBuffer.append(" ");
                if (!rule.isCaseSensitive()) {
                    stringBuffer.append("case=" + (rule.isCaseSensitive() ? "true" : "false"));
                }
                stringBuffer.append(" ");
                stringBuffer.append("action=");
                stringBuffer.append(PBlock.quotedString((String)rule.getAction()));
                stringBuffer.append("\n");
            }
            printWriter.println(stringBuffer.toString());
            printWriter.print(this.rulesFooter);
            printWriter.close();
        }
        catch (Exception exception) {
            CSDebug.logln("Failed to save changes to " + this.filename + ": " + exception);
        }
    }

    public void parseClassificationFile(String string) {
        this.rulesHeader = new StringBuffer("");
        this.rulesFooter = new StringBuffer("");
        this.rulesList = new ArrayList();
        boolean bl = true;
        boolean bl2 = false;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("Classification")) {
                    this.addRule(string2);
                    continue;
                }
                if (string2.startsWith("<Preprocess directive=\"Generate\">")) {
                    this.rulesHeader.append(string2 + "\n");
                    bl = false;
                    continue;
                }
                if (string2.startsWith("</Preprocess>")) {
                    this.rulesFooter.append(string2 + "\n");
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    this.rulesHeader.append(string2 + "\n");
                    continue;
                }
                if (!bl2) continue;
                this.rulesFooter.append(string2 + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            CSDebug.logln("Exception in parsing classification.conf");
        }
    }

    public void addRule(String string) {
        HashMap hashMap = new HashMap();
        try {
            PBlock.str2pblock((String)string, hashMap);
            Rule rule = new Rule();
            String string2 = (String)hashMap.get("src");
            if (string2 != null) {
                int n;
                rule.setSrc(string2);
                for (n = 0; n < METHOD_LIST.length && (string2 = (String)hashMap.get(METHOD_LIST[n])) == null; ++n) {
                }
                if (string2 != null) {
                    rule.setMethod(METHOD_LIST[n]);
                    rule.setName(string2);
                    string2 = (String)hashMap.get("action");
                    if (string2 != null) {
                        rule.setAction(string2);
                        string2 = (String)hashMap.get("case");
                        if (string2 != null && string2.equals("false")) {
                            rule.setCaseSensitive(false);
                        }
                        if (!this.isExist(rule.getSrc(), rule.getMethod(), rule.getName(), rule.getAction())) {
                            this.addSortedBySrc(rule);
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CSDebug.logln("Invalid classification rule found: " + string);
    }

    public int getNumberOfRules() {
        return this.rulesList.size();
    }
}

