/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.profiler.cli;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.desktop.dp.cli.CLIPException;
import com.sun.portal.desktop.dp.cli.CLIPParser;
import com.sun.portal.subscriptions.profiler.NotificationQueue;
import com.sun.portal.subscriptions.profiler.NotificationWorker;
import com.sun.portal.subscriptions.profiler.ProfilerException;
import com.sun.portal.subscriptions.profiler.ProfilerWorker;
import com.sun.portal.subscriptions.profiler.UserQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ProfilerCmd {
    public static final String OPT_DEFAULT = "*";
    public static final String LOCALE_DEFAULT = Locale.getDefault().toString();
    protected static final String STOP = "stop";
    protected static final String RUN = "run";
    protected static final int SUBCMD_STOP = 1;
    protected static final int SUBCMD_RUN = 2;
    protected static final String HELP = "help";
    protected static final String UID = "uid";
    protected static final String ORGANIZATION = "organization";
    protected static final String NAME = "name";
    protected static final String PARENT = "parent";
    protected static final String TYPE = "type";
    protected static final String VERBOSE = "verbose";
    protected static final String VERSION = "version";
    protected static final String LOCALE = "locale";
    protected static final String CONT = "continue";
    protected static final String FILE = "file";
    protected int subcmd = -1;
    protected String uid = null;
    protected String dn = null;
    protected String organization = null;
    protected boolean verbose = false;
    protected boolean version = false;
    protected String name = null;
    protected String parent = null;
    protected String type = null;
    protected boolean cont = false;
    Properties profilerProps = null;
    Properties notifierProps = null;
    AMStoreConnection sConnection = null;
    SSOToken ssoToken = null;
    Set subsUserSet = null;
    String adminUID = null;
    String adminPWD = null;
    public static Debug debug = null;
    public static final String RESOURCE_BASE = "Profiler";
    public static ResourceBundle rb = PropertyResourceBundle.getBundle("Profiler", Locale.getDefault());

    public ProfilerCmd(CLIPParser clipp, String[] args) throws ProfilerException {
        debug = Debug.getInstance((String)"profiler.debug");
        this.parse(clipp, args);
    }

    protected static CLIPParser getCLIPParser() throws CLIPException {
        try {
            CLIPParser.Option[] optsRun = new CLIPParser.Option[]{new CLIPParser.Option(HELP, "?", 0, "false", ProfilerCmd.getLocalizedString("optHelp")), new CLIPParser.Option(UID, "u", 1, OPT_DEFAULT, ProfilerCmd.getLocalizedString("optArgUID")), new CLIPParser.Option(ORGANIZATION, "o", 1, null, ProfilerCmd.getLocalizedString("optOrganization")), new CLIPParser.Option(VERBOSE, "b", 0, "false", ProfilerCmd.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", ProfilerCmd.getLocalizedString("optVersion"))};
            CLIPParser.Option[] optsStop = new CLIPParser.Option[]{new CLIPParser.Option(HELP, "?", 0, "false", ProfilerCmd.getLocalizedString("optHelp")), new CLIPParser.Option(ORGANIZATION, "o", 1, null, ProfilerCmd.getLocalizedString("optOrganization")), new CLIPParser.Option(VERBOSE, "b", 0, "false", ProfilerCmd.getLocalizedString("optVerbose")), new CLIPParser.Option(VERSION, "V", 0, "false", ProfilerCmd.getLocalizedString("optVersion"))};
            CLIPParser.SubCommand scStop = new CLIPParser.SubCommand(STOP, optsStop, 0, 0, ProfilerCmd.getLocalizedString("helpStop"), "");
            CLIPParser.SubCommand scRun = new CLIPParser.SubCommand(RUN, optsRun, 0, 0, ProfilerCmd.getLocalizedString("helpRun"), "");
            CLIPParser.SubCommand[] subcmds = new CLIPParser.SubCommand[]{scStop, scRun};
            return new CLIPParser(RESOURCE_BASE, subcmds, ProfilerCmd.getLocalizedString("helpCmd"));
        }
        catch (Exception e) {
            throw new CLIPException("bad getClipparser", 0);
        }
    }

    private AMStoreConnection getSSOStoreConnection() {
        try {
            SSOTokenManager ssom = SSOTokenManager.getInstance();
            if (this.sConnection == null) {
                if (this.ssoToken == null) {
                    this.ssoToken = ssom.createSSOToken(new Principal(){

                        public String getName() {
                            return AdminUtils.getAdminDN();
                        }
                    }, this.adminPWD);
                }
                this.sConnection = new AMStoreConnection(this.ssoToken);
            }
            return this.sConnection;
        }
        catch (Exception e) {
            debug.error("ProfilerCmd: failed to get Store Connection", (Throwable)e);
            return null;
        }
    }

    protected void run() throws ProfilerException {
        this.profilerProps = new Properties();
        this.notifierProps = new Properties();
        try {
            this.profilerProps.load(new FileInputStream(System.getProperty("PS_CONFIG_DIR") + File.separator + "Profiler.properties"));
            this.notifierProps.load(new FileInputStream(System.getProperty("PS_CONFIG_DIR") + File.separator + "Profiler.properties"));
        }
        catch (IOException ioe) {
            throw new ProfilerException("failed to load Profiler Properties");
        }
        if (this.subcmd == 2) {
            try {
                Thread t;
                this.sConnection = this.getSSOStoreConnection();
                AMOrganization amOrg = this.sConnection.getOrganization(this.organization);
                AMPeopleContainer amPeople = this.sConnection.getPeopleContainer("ou=People," + this.organization);
                HashMap subsSrvHM = new HashMap();
                HashSet<String> subSrvHS = new HashSet<String>();
                subSrvHS.add("sunportalpksubscriptionsperson");
                subsSrvHM.put("objectClass", subSrvHS);
                AMSearchControl amSrchCtrl = new AMSearchControl();
                amSrchCtrl.setSearchScope(2);
                if (this.uid.equals(OPT_DEFAULT) || this.uid == null) {
                    AMSearchResults amSrchRslt = amPeople.searchUsers(OPT_DEFAULT, subsSrvHM, amSrchCtrl);
                    this.subsUserSet = Collections.synchronizedSet(amSrchRslt.getSearchResults());
                    if (amSrchRslt.getErrorCode() != 0) {
                        debug.error("Failed retrieving users from Org:" + this.organization);
                    }
                } else {
                    StringTokenizer st = new StringTokenizer(this.uid, ",");
                    this.subsUserSet = Collections.synchronizedSet(new HashSet());
                    while (st.hasMoreTokens()) {
                        String userDN = "uid=" + st.nextToken() + ",ou=People," + this.organization;
                        this.subsUserSet.add(userDN);
                    }
                }
                UserQueue uq = new UserQueue(this.subsUserSet);
                NotificationQueue nq = new NotificationQueue();
                int nbPWT = Integer.parseInt(this.profilerProps.getProperty("profilerThread", "1"));
                ArrayList<Thread> pt = new ArrayList<Thread>();
                for (int p = 0; p < nbPWT; ++p) {
                    ProfilerWorker pw = new ProfilerWorker(this.sConnection, this.ssoToken, this.adminUID, this.adminPWD, uq, nq, this.profilerProps, this.notifierProps);
                    Thread ptObj = new Thread(pw);
                    ptObj.start();
                    pt.add(ptObj);
                }
                int nbNWT = Integer.parseInt(this.profilerProps.getProperty("notifierThread", "1"));
                ArrayList<Thread> nt = new ArrayList<Thread>();
                for (int n = 0; n < nbNWT; ++n) {
                    NotificationWorker nw = new NotificationWorker(this.sConnection, uq, nq, this.profilerProps, this.notifierProps);
                    Thread ntObj = new Thread(nw);
                    ntObj.start();
                    nt.add(ntObj);
                }
                try {
                    Iterator ptIter = pt.iterator();
                    while (ptIter.hasNext()) {
                        t = (Thread)ptIter.next();
                        t.join();
                    }
                }
                catch (Exception e) {
                    debug.error("ProfilerCmd: failure in ProfilerWorker threads", (Throwable)e);
                }
                nq.setStatus(false);
                try {
                    Iterator ntIter = nt.iterator();
                    while (ntIter.hasNext()) {
                        t = (Thread)ntIter.next();
                        t.join();
                    }
                }
                catch (Exception e) {
                    debug.error("ProfilerCmd: failure in NotificationWorker threads", (Throwable)e);
                }
            }
            catch (SSOException se) {
                debug.error("failing SSO", (Throwable)se);
                System.exit(1);
            }
            catch (AMException ame) {
                debug.error("failing DSAME", (Throwable)ame);
                System.exit(1);
            }
        }
    }

    private String getVersionInfo() {
        ResourceBundle prodRB = PropertyResourceBundle.getBundle("PSversion");
        StringBuffer vinfo = new StringBuffer();
        vinfo.append(RESOURCE_BASE).append(" (").append(prodRB.getString("productname")).append(" ").append(prodRB.getString("productversion")).append(") ").append("1.0");
        vinfo.append("\n").append(prodRB.getString("copyright"));
        return vinfo.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(CLIPParser clipp, String[] argv) throws ProfilerException {
        if (clipp.needsVersion(argv)) {
            System.err.println(this.getVersionInfo());
            System.exit(0);
        }
        if (clipp.needsHelp(argv)) {
            debug.error("ProfilerCmd invalid cmdline");
            System.err.println(clipp.getHelp(argv));
            System.exit(0);
        }
        Map options = null;
        try {
            options = clipp.getOptions(argv);
        }
        catch (CLIPException ce) {
            throw new ProfilerException("errorCLIPParseError", ce);
        }
        try {
            clipp.verifyArguments(argv);
        }
        catch (CLIPException ce) {
            throw new ProfilerException("errorCLIPParseError", ce);
        }
        this.verbose = ((String[])options.get(VERBOSE))[0].equals("true");
        String sc = null;
        try {
            sc = clipp.getSubCommand(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{sc};
            throw new ProfilerException("errorInvalidSubCmd", ce, tokens);
        }
        if (sc.equals(STOP)) {
            this.subcmd = 1;
        } else if (sc.equals(RUN)) {
            this.subcmd = 2;
        }
        try {
            this.organization = ((String[])options.get(ORGANIZATION))[0];
            if (this.organization.trim().length() == 0) {
                debug.error("ProfilerCmd: organization is empty");
                throw new ProfilerException("errorNoDNOrganization");
            }
        }
        catch (NullPointerException npe) {
            debug.error("ProfilerCmd: failed reading organization from arguments");
            throw new ProfilerException("errorNoDNOrganization");
        }
        try {
            this.uid = ((String[])options.get(UID))[0];
            if (!this.uid.equals(OPT_DEFAULT) && this.uid != null && this.organization.trim().length() == 0) {
                // empty if block
            }
        }
        catch (Exception e) {
            throw new ProfilerException("failed to get the required argument");
        }
        this.adminUID = AdminUtils.getAdminDN();
        this.adminPWD = new String(AdminUtils.getAdminPassword());
    }

    public static void setLocale(Locale locale) {
        rb = PropertyResourceBundle.getBundle(RESOURCE_BASE, locale);
    }

    public static String getLocalizedString(String key) {
        return rb.getString(key);
    }

    public static String getLocalizedString(String key, Object[] objs) {
        if (objs != null && objs.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(rb.getLocale());
            mf.applyPattern(rb.getString(key));
            return mf.format(objs);
        }
        return rb.getString(key);
    }
}

