/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.subscriptions.profiler;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.sun.portal.subscriptions.profiler.Notification;
import com.sun.portal.subscriptions.profiler.NotificationQueue;
import com.sun.portal.subscriptions.profiler.UserQueue;
import com.sun.portal.subscriptions.profiler.cli.ProfilerCmd;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class NotificationWorker
implements Runnable {
    private AMStoreConnection dsameCon;
    private UserQueue uq;
    private NotificationQueue nq;
    private Properties profilerProps;
    private Properties notifierProps;

    public NotificationWorker(AMStoreConnection c, UserQueue uq, NotificationQueue nq, Properties pp, Properties np) {
        this.dsameCon = c;
        this.uq = uq;
        this.nq = nq;
        this.profilerProps = pp;
        this.notifierProps = np;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Notification n = null;
        try {
            block12: while ((n = (Notification)this.nq.get()) != null) {
                StringBuffer content = (StringBuffer)n.getContent();
                AMUser u = n.getUser();
                String uEmail = null;
                try {
                    uEmail = u.getStringAttribute("mail");
                }
                catch (AMException ame) {
                }
                catch (SSOException ssoe) {
                    // empty catch block
                }
                if (uEmail != null) {
                    switch (n.getMedium()) {
                        case 0: {
                            try {
                                Session session = Session.getDefaultInstance((Properties)this.notifierProps, null);
                                Date msgDate = new Date();
                                MimeMessage msg = new MimeMessage(session);
                                msg.setFrom((Address)new InternetAddress(this.notifierProps.getProperty("profilerFrom", "Portal-Profiler")));
                                msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)uEmail, (boolean)false));
                                msg.setSubject("Profiler output (" + msgDate + ")");
                                msg.setHeader("X-Mailer", "portal Profiler");
                                msg.setSentDate(msgDate);
                                MimeMultipart multipart = new MimeMultipart();
                                MimeBodyPart msgBodyHTMLPart = new MimeBodyPart();
                                msgBodyHTMLPart.setContent((Object)n.getContent().toString(), "text/html; charset=UTF-8");
                                multipart.addBodyPart((BodyPart)msgBodyHTMLPart);
                                msg.setContent((Multipart)multipart);
                                Transport.send((Message)msg);
                            }
                            catch (AddressException ae) {
                                ProfilerCmd.debug.error("user " + u.getDN() + " has an improper internetAddress [" + uEmail + "]");
                            }
                            catch (MessagingException me) {
                                ProfilerCmd.debug.error("setting up - Messaging exception for user " + u.getDN() + " : " + me.getMessage());
                            }
                            continue block12;
                        }
                        case 1: {
                            continue block12;
                        }
                    }
                    ProfilerCmd.debug.error("NotificationWorker " + Thread.currentThread() + " invalid type of notification");
                    continue;
                }
                ProfilerCmd.debug.error("NW-" + Thread.currentThread() + " users Email is NULL");
            }
            return;
        }
        catch (Exception e) {
            ProfilerCmd.debug.error("Notification failed to execute : " + e.getMessage());
        }
    }
}

