/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.Attach;
import com.sun.comclient.calendar.Attendee;
import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.Duration;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.comclient.calendar.VAlarm;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.socs.SOCSAlarm;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;

public class SOCSEvent
extends VEvent {
    public static final String ATTENDEE = "ATTENDEE";
    public static final String COMMENT = "COMMENT";
    public static final String CONTACT = "CONTACT";
    public static final String DTSTAMP = "DTSTAMP";
    public static final String DTSTART = "DTSTART";
    public static final String DURATION = "DURATION";
    public static final String ORGANIZER = "ORGANIZER";
    public static final String RSTATUS = "REQUEST-STATUS";
    public static final String UID = "UID";
    public static final String URL = "URL";
    public static final String CALID = "RELATIVE-CALID";
    public static final String ALARM_COMPONENT = "ALARM";
    public static final String ATTACHMENT = "ATTACH";
    public static final String CATEGORIES = "CATEGORIES";
    public static final String CLASSIFICATION = "CLASS";
    public static final String CREATED = "CREATED";
    public static final String DESCRIPTION = "DESCRIPTION";
    public static final String LAST_MODIFIED = "LAST-MODIFIED";
    public static final String LOCATION = "LOCATION";
    public static final String GEO = "GEO";
    public static final String PRIORITY = "PRIORITY";
    public static final String RECURRENCE_ID = "RECURRENCE-ID";
    public static final String RELATED_TO = "RELATED-TO";
    public static final String RESOURCES = "RESOURCES";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String STATUS = "STATUS";
    public static final String SUMMARY = "SUMMARY";
    public static final String EXCEPTION_DATES = "EXDATE";
    public static final String EXCEPTION_RULE = "EXRULE";
    public static final String RECURRENCE_DATES = "RDATE";
    public static final String RECURRENCE_RULE = "RRULE";
    public static final String TRANSP = "TRANSP";
    public static final String CLASSIFICATION_CONFIDENTIAL = "CONFIDENTIAL";
    public static final String CLASSIFICATION_PRIVATE = "PRIVATE";
    public static final String CLASSIFICATION_PUBLIC = "PUBLIC";
    public static final String STATUS_TENTATIVE = "TENTATIVE";
    public static final String STATUS_CONFIRMED = "CONFIRMED";
    public static final String STATUS_CANCELLED = "CANCELLED";
    public static String METHOD = "X-JCAPI-COMPONENTPROPS-METHOD";
    public static String TIMEZONE = "X-JCAPI-COMPONENTPROPS-TZID";
    public static String STORETYPE = "X-JCAPI-COMPONENTPROPS-STORETYPE";
    public static String REPLACE = "X-JCAPI-COMPONENTPROPS-REPLACE";
    public static int STORETYPE_NONE = 0;
    public static int STORETYPE_CREATE = 1;
    public static int STORETYPE_MODIFY = 2;
    public static int REPLACE_APPEND = 0;
    public static int REPLACE_UPDATE = 1;
    private static final Hashtable _statusValues = new Hashtable();
    private static final Hashtable _classificationValues = new Hashtable();
    private boolean hasAttendeeChanged;
    private boolean hasAttachmentChanged;
    private boolean hasAlarmChanged;
    private boolean hasCategoryChanged;
    private boolean hasContactChanged;
    private boolean hasDescriptionChanged;
    private boolean hasExceptionDateChanged;
    private boolean hasExceptionRuleChanged;
    private boolean hasLocationChanged;
    private boolean hasResourceChanged;
    private boolean hasRelatedToChanged;
    private boolean hasRecurrenceDateChanged;
    private boolean hasRecurrenceRuleChanged;
    private boolean hasSummaryChanged;
    private boolean hasUrlChanged;
    private int wcapVersionInUse;

    public SOCSEvent() {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        this.allDay = false;
    }

    public SOCSEvent(DateTime dateTime, DateTime dateTime2) {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        try {
            this.setStartTime(dateTime);
            this.setEndTime(dateTime2);
        }
        catch (Exception exception) {}
    }

    public SOCSEvent(DateTime dateTime, DateTime dateTime2, String string) {
        this(dateTime, dateTime2);
        this.setSummary(string);
    }

    public SOCSEvent(DateTime dateTime, String string) {
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasResourceChanged = false;
        this.hasRelatedToChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
        this.wcapVersionInUse = 0;
        try {
            this.setStartTime(dateTime);
            this.setSummary(string);
            this.setAllDay(true);
        }
        catch (Exception exception) {}
    }

    public SOCSEvent(String string, DateTime dateTime, DateTime dateTime2, String string2, String string3) {
        this(dateTime, dateTime2, string2);
        this.setID(string);
        this.setDescription(string3);
    }

    public SOCSEvent(DateTime dateTime, DateTime dateTime2, String string, String string2) {
        this(dateTime, dateTime2, string);
        this.setDescription(string2);
    }

    private String[] _split(String string, char c, int n) {
        String[] stringArray = new String[n];
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            if (string.charAt(n5) == c) {
                if (n4 >= n - 1) break;
                stringArray[n4] = string.substring(n3, n5);
                n3 = n5 + 1;
                ++n4;
            }
            ++n5;
        }
        if (n4 < n) {
            stringArray[n4] = string.substring(n3, n2);
        }
        return stringArray;
    }

    public SOCSEvent(String string) throws IllegalArgumentException, CalendarComponentException {
        block46: {
            this.hasAttendeeChanged = false;
            this.hasAttachmentChanged = false;
            this.hasAlarmChanged = false;
            this.hasCategoryChanged = false;
            this.hasContactChanged = false;
            this.hasDescriptionChanged = false;
            this.hasExceptionDateChanged = false;
            this.hasExceptionRuleChanged = false;
            this.hasLocationChanged = false;
            this.hasResourceChanged = false;
            this.hasRelatedToChanged = false;
            this.hasRecurrenceDateChanged = false;
            this.hasRecurrenceRuleChanged = false;
            this.hasSummaryChanged = false;
            this.hasUrlChanged = false;
            this.wcapVersionInUse = 0;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            try {
                StreamTokenizer streamTokenizer = null;
                String string2 = bufferedReader.readLine();
                streamTokenizer = new StreamTokenizer(new StringReader(string2));
                if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("BEGIN")) {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                if ((char)streamTokenizer.nextToken() != ':') {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                if (streamTokenizer.nextToken() != -3 || !streamTokenizer.sval.equalsIgnoreCase("VEVENT")) {
                    throw new IllegalArgumentException("Invalid VEVENT format,incorrect BEGIN block(RFC2445)");
                }
                boolean bl = false;
                String string3 = null;
                while (!(string2 = bufferedReader.readLine()).equalsIgnoreCase("END:VEVENT")) {
                    Object object;
                    Object object2;
                    streamTokenizer = new StreamTokenizer(new StringReader(string2));
                    streamTokenizer.nextToken();
                    String string4 = streamTokenizer.sval.toUpperCase();
                    String[] stringArray = this._split(string2, ':', 2);
                    if (stringArray.length != 2) {
                        throw new IllegalArgumentException("Invalid VEVENT format(check " + string4 + "tag)");
                    }
                    if (string4.equals(UID)) {
                        bl = false;
                        string3 = string4;
                        this.setID(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(DTSTART)) {
                        bl = false;
                        string3 = string4;
                        this.setStartTime(new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(SUMMARY)) {
                        bl = true;
                        string3 = string4;
                        this.setSummary(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(CALID)) {
                        bl = false;
                        string3 = string4;
                        this.setCalID(stringArray[1]);
                        continue;
                    }
                    if (string4.equals("DTEND")) {
                        bl = false;
                        string3 = string4;
                        this.setEndTime(new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(DURATION)) {
                        bl = false;
                        string3 = string4;
                        this.setDuration(new Duration(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(DESCRIPTION)) {
                        bl = true;
                        string3 = string4;
                        this.setDescription(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(LOCATION)) {
                        bl = false;
                        string3 = string4;
                        this.setLocation(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(CLASSIFICATION)) {
                        bl = false;
                        string3 = string4;
                        this.setClassification(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(DTSTAMP)) {
                        bl = false;
                        string3 = string4;
                        this.setStamp(new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(SEQUENCE)) {
                        bl = false;
                        string3 = string4;
                        this.setSequence(Integer.parseInt(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(PRIORITY)) {
                        bl = false;
                        string3 = string4;
                        this.setPriority(Integer.parseInt(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(RECURRENCE_ID)) {
                        bl = false;
                        string3 = string4;
                        this.setProperty(RECURRENCE_ID, new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(TRANSP)) {
                        bl = false;
                        string3 = string4;
                        this.setProperty(TRANSP, stringArray[1]);
                        continue;
                    }
                    if (string4.equals(ORGANIZER)) {
                        bl = false;
                        string3 = string4;
                        object2 = new Organizer(string2);
                        this.setOrganizer((Organizer)object2);
                        continue;
                    }
                    if (string4.equals(ATTENDEE)) {
                        bl = false;
                        string3 = string4;
                        object2 = new Attendee(string2);
                        this.addAttendee((Attendee)object2);
                        continue;
                    }
                    if (string4.equals(EXCEPTION_DATES)) {
                        bl = false;
                        string3 = string4;
                        this.addExceptionDate(new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(EXCEPTION_RULE)) {
                        bl = false;
                        string3 = string4;
                        object2 = new RecurrencePattern(stringArray[1]);
                        this.addExceptionRule((RecurrencePattern)object2);
                        continue;
                    }
                    if (string4.equals(RECURRENCE_DATES)) {
                        bl = false;
                        string3 = string4;
                        this.addRecurrenceDate(new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(RECURRENCE_RULE)) {
                        bl = false;
                        string3 = string4;
                        object2 = new RecurrencePattern(stringArray[1]);
                        this.addRecurrenceRule((RecurrencePattern)object2);
                        continue;
                    }
                    if (string4.equals(STATUS)) {
                        bl = false;
                        string3 = string4;
                        this.setStatus(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(GEO)) {
                        bl = false;
                        string3 = string4;
                        this.setGeo(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(CREATED)) {
                        bl = false;
                        string3 = string4;
                        this.setProperty(CREATED, new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(LAST_MODIFIED)) {
                        bl = false;
                        string3 = string4;
                        this.setProperty(LAST_MODIFIED, new DateTime(stringArray[1]));
                        continue;
                    }
                    if (string4.equals(ATTACHMENT)) {
                        bl = false;
                        string3 = string4;
                        object2 = new Attach("RFC", string2);
                        this.addAttachment((Attach)object2);
                        continue;
                    }
                    if (string4.equals(COMMENT)) {
                        bl = true;
                        string3 = string4;
                        this.addComment(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(CATEGORIES)) {
                        bl = false;
                        string3 = string4;
                        this.addCategory(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(CONTACT)) {
                        bl = false;
                        string3 = string4;
                        this.addContact(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(RSTATUS)) {
                        bl = false;
                        string3 = string4;
                        this.addRequestStatus(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(RELATED_TO)) {
                        bl = false;
                        string3 = string4;
                        this.addRelatedTo(stringArray[1]);
                        continue;
                    }
                    if (string4.equals(RESOURCES)) {
                        bl = false;
                        string3 = string4;
                        this.addResource(stringArray[1]);
                        continue;
                    }
                    if (string2.equals("BEGIN:VALARM")) {
                        bl = false;
                        string3 = string4;
                        object2 = new StringBuffer("BEGIN:VALARM\n");
                        while (!(string2 = bufferedReader.readLine()).equals("END:VALARM")) {
                            ((StringBuffer)object2).append(string2 + "\n");
                        }
                        ((StringBuffer)object2).append("END:VALARM");
                        object = new SOCSAlarm(this, ((StringBuffer)object2).toString());
                        this.addAlarmComponent((VAlarm)object);
                        continue;
                    }
                    if (string2.startsWith("X-") || !bl) continue;
                    object2 = null;
                    if (string3.equals(SUMMARY)) {
                        object2 = this.getSummary();
                        string2 = (String)object2 + "\n" + string2;
                        this.setSummary(string2);
                    } else if (string3.equals(DESCRIPTION)) {
                        object2 = this.getDescription();
                        string2 = (String)object2 + "\n" + string2;
                        this.setDescription(string2);
                    } else if (string3.equals(COMMENT)) {
                        object = this.getComments();
                        object2 = object[((String[])object).length - 1];
                        string2 = (String)object2 + "\n" + string2;
                        this.removeComment((String)object2);
                        this.addComment(string2);
                    }
                    bl = true;
                    string4 = string3;
                }
            }
            catch (Exception exception) {
                if (exception instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)exception;
                }
                if (!(exception instanceof CalendarComponentException)) break block46;
                throw (CalendarComponentException)exception;
            }
        }
    }

    public SOCSEvent(SOCSEvent sOCSEvent) throws IllegalArgumentException, OperationNotSupportedException, CalendarComponentException {
        this(sOCSEvent.toRFC2445());
        if (sOCSEvent.hasProperty(METHOD)) {
            this.setMethod((String)sOCSEvent.getProperty(METHOD));
        }
        if (sOCSEvent instanceof SOCSEvent) {
            this.hasRecurrenceRuleChanged = sOCSEvent.hasRecurrenceRuleChanged();
            this.hasRecurrenceDateChanged = sOCSEvent.hasRecurrenceDateChanged();
        } else {
            this.hasRecurrenceRuleChanged = false;
            this.hasRecurrenceDateChanged = false;
        }
    }

    public void removeProperty(String string) {
        block4: {
            if (null == string) {
                return;
            }
            super.removeProperty(string);
            if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
                Integer n = (Integer)this.getProperty("WCAP_VERSION_INT");
                this.wcapVersionInUse = n;
            }
            if (this.wcapVersionInUse < 300) break block4;
            try {
                this.setReplace(REPLACE_UPDATE);
            }
            catch (OperationNotSupportedException operationNotSupportedException) {}
        }
    }

    public boolean hasAttendee() {
        return this.hasProperty(ATTENDEE);
    }

    public Attendee getAttendee(String string) {
        if (null == string) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            return null;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Attendee attendee = (Attendee)arrayList.get(n);
            if (string.equals(attendee.getValue())) {
                return attendee;
            }
            ++n;
        }
        return null;
    }

    public Attendee[] getAttendees() {
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            return null;
        }
        Attendee[] attendeeArray = new Attendee[arrayList.size()];
        return arrayList.toArray(attendeeArray);
    }

    public void addAttendee(Attendee attendee) {
        ArrayList<Attendee> arrayList = (ArrayList<Attendee>)this.getProperty(ATTENDEE);
        if (null == arrayList) {
            arrayList = new ArrayList<Attendee>();
            arrayList.add(attendee);
            this.setProperty(ATTENDEE, arrayList);
            this.hasAttendeeChanged = true;
        } else {
            arrayList.add(attendee);
            this.hasAttendeeChanged = true;
        }
    }

    public void removeAttendee(Attendee attendee) {
        if (null == attendee) {
            return;
        }
        String string = attendee.getValue();
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(ATTENDEE);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                Attendee attendee2 = (Attendee)arrayList.get(n);
                if (string.equals(attendee2.getValue())) {
                    arrayList.remove(n);
                    if (arrayList.size() <= 0) {
                        this.removeProperty(ATTENDEE);
                    }
                    this.hasAttendeeChanged = true;
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllAttendees() {
        this.removeProperty(ATTENDEE);
        this.hasAttendeeChanged = true;
    }

    public void setAttendeeChange(boolean bl) {
        this.hasAttendeeChanged = bl;
    }

    public boolean hasAttendeeChanged() {
        return this.hasAttendeeChanged;
    }

    public int getAcceptedAttendeesCount() {
        int n = 0;
        Attendee[] attendeeArray = this.getAttendees();
        if (attendeeArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < attendeeArray.length) {
            if ("ACCEPTED".equals(attendeeArray[n2].getParticipantStatus())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getDeclinedAttendeesCount() {
        int n = 0;
        Attendee[] attendeeArray = this.getAttendees();
        if (attendeeArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < attendeeArray.length) {
            if ("DECLINED".equals(attendeeArray[n2].getParticipantStatus())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getTentativeAttendeesCount() {
        int n = 0;
        Attendee[] attendeeArray = this.getAttendees();
        if (attendeeArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < attendeeArray.length) {
            if (STATUS_TENTATIVE.equals(attendeeArray[n2].getParticipantStatus())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int getPendingAttendeesCount() {
        int n = 0;
        Attendee[] attendeeArray = this.getAttendees();
        if (attendeeArray == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < attendeeArray.length) {
            if ("NEEDS-ACTION".equals(attendeeArray[n2].getParticipantStatus())) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public String[] getContacts() {
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(CONTACT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(CONTACT, arrayList);
            this.hasContactChanged = true;
        } else {
            arrayList.add(string);
            this.hasContactChanged = true;
        }
    }

    public void removeContact(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(CONTACT);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equals((String)arrayList.get(n))) {
                    arrayList.remove(n);
                    if (arrayList.size() <= 0) {
                        this.removeProperty(CONTACT);
                    }
                    this.hasContactChanged = true;
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllContacts() {
        this.removeProperty(CONTACT);
        this.hasContactChanged = true;
    }

    public void setContactChange(boolean bl) {
        this.hasContactChanged = bl;
    }

    public boolean hasContactChanged() {
        return this.hasContactChanged;
    }

    public String[] getComments() {
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(COMMENT);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(COMMENT, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeComment(String string) {
        if (null == string) {
            return;
        }
        ArrayList arrayList = (ArrayList)this.getProperty(COMMENT);
        if (null != arrayList) {
            int n = 0;
            while (n < arrayList.size()) {
                if (string.equals((String)arrayList.get(n))) {
                    arrayList.remove(n);
                    if (arrayList.size() > 0) break;
                    this.removeProperty(COMMENT);
                    break;
                }
                ++n;
            }
        }
    }

    public void removeAllComments() {
        this.removeProperty(COMMENT);
    }

    public DateTime getStamp() {
        return (DateTime)this.getProperty(DTSTAMP);
    }

    public void setStamp(DateTime dateTime) {
        this.setProperty(DTSTAMP, dateTime);
    }

    public Duration getDuration() {
        return (Duration)this.getProperty(DURATION);
    }

    public Organizer getOrganizer() {
        return (Organizer)this.getProperty(ORGANIZER);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(ORGANIZER, organizer);
    }

    public boolean isCalIdTheOrganizer(String string) {
        if (this.hasProperty(ORGANIZER)) {
            String string2 = this.getOrganizer().getValue();
            if (string2 == null) {
                return false;
            }
            return string2.equals(string);
        }
        return false;
    }

    public String[] getRequestStatus() {
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addRequestStatus(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(RSTATUS);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(RSTATUS, arrayList);
        } else {
            arrayList.add(string);
        }
    }

    public void removeRequestStatus(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RSTATUS);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RSTATUS);
            }
        }
    }

    public void removeAllRequestStatus() {
        this.removeProperty(RSTATUS);
    }

    public String getID() {
        return (String)this.getProperty(UID);
    }

    public void setID(String string) {
        this.setProperty(UID, string);
    }

    public String getUrl() {
        return (String)this.getProperty(URL);
    }

    public void setUrl(String string) {
        this.setProperty(URL, string);
        this.hasUrlChanged = true;
    }

    public void setUrlChange(boolean bl) {
        this.hasUrlChanged = bl;
    }

    public boolean hasUrlChanged() {
        return this.hasUrlChanged;
    }

    public String getCalID() {
        return (String)this.getProperty(CALID);
    }

    public void setCalID(String string) {
        this.setProperty(CALID, string);
    }

    public DateTime getStart() {
        return (DateTime)this.getProperty(DTSTART);
    }

    public void setStart(DateTime dateTime) {
        this.setProperty(DTSTART, dateTime);
    }

    public DateTime getEnd() {
        return (DateTime)this.getProperty("DTEND");
    }

    public void setEnd(DateTime dateTime) throws CalendarComponentException {
        if (this.hasProperty(DURATION)) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property name", 111);
            throw calendarComponentException;
        }
        this.setProperty("DTEND", dateTime);
    }

    public void setDuration(Duration duration) throws CalendarComponentException {
        if (this.hasProperty("DTEND")) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property name ", 111);
            throw calendarComponentException;
        }
        this.setProperty(DURATION, duration);
    }

    public VAlarm[] getAlarmComponents() {
        ArrayList arrayList = (ArrayList)this.getProperty(ALARM_COMPONENT);
        if (arrayList == null) {
            return null;
        }
        VAlarm[] vAlarmArray = new VAlarm[arrayList.size()];
        return arrayList.toArray(vAlarmArray);
    }

    public void addAlarmComponent(VAlarm vAlarm) {
        ArrayList<VAlarm> arrayList = (ArrayList<VAlarm>)this.getProperty(ALARM_COMPONENT);
        if (null == arrayList) {
            arrayList = new ArrayList<VAlarm>();
            arrayList.add(vAlarm);
            this.setProperty(ALARM_COMPONENT, arrayList);
            this.hasAlarmChanged = true;
        } else {
            arrayList.add(vAlarm);
            this.hasAlarmChanged = true;
        }
    }

    public void removeAlarmComponent(VAlarm vAlarm) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(ALARM_COMPONENT);
        if (null != arrayList && -1 != (n = arrayList.indexOf(vAlarm))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(ALARM_COMPONENT);
            }
            this.hasAlarmChanged = true;
        }
    }

    public void removeAllAlarmComponents() {
        this.removeProperty(ALARM_COMPONENT);
        this.hasAlarmChanged = true;
    }

    public boolean hasAlarm() {
        return this.hasProperty(ALARM_COMPONENT);
    }

    public void setAlarmChange(boolean bl) {
        this.hasAlarmChanged = bl;
    }

    public boolean hasAlarmChanged() {
        return this.hasAlarmChanged;
    }

    public Attach[] getAttachments() {
        ArrayList arrayList = (ArrayList)this.getProperty(ATTACHMENT);
        if (arrayList == null) {
            return null;
        }
        Attach[] attachArray = new Attach[arrayList.size()];
        return arrayList.toArray(attachArray);
    }

    public void addAttachment(Attach attach) {
        ArrayList<Attach> arrayList = (ArrayList<Attach>)this.getProperty(ATTACHMENT);
        if (null == arrayList) {
            arrayList = new ArrayList<Attach>();
            arrayList.add(attach);
            this.setProperty(ATTACHMENT, arrayList);
            this.hasAttachmentChanged = true;
        } else {
            arrayList.add(attach);
            this.hasAttachmentChanged = true;
        }
    }

    public void removeAttachment(Attach attach) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(ATTACHMENT);
        if (null != arrayList && -1 != (n = arrayList.indexOf(attach))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(ATTACHMENT);
            }
            this.hasAttachmentChanged = true;
        }
    }

    public void removeAllAttachments() {
        this.removeProperty(ATTACHMENT);
        this.hasAttachmentChanged = true;
    }

    public void setAttachmentChange(boolean bl) {
        this.hasAttachmentChanged = bl;
    }

    public boolean hasAttachmentChanged() {
        return this.hasAttachmentChanged;
    }

    public String[] getCategories() {
        ArrayList arrayList = (ArrayList)this.getProperty(CATEGORIES);
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addCategory(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(CATEGORIES);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(CATEGORIES, arrayList);
            this.hasCategoryChanged = true;
        } else {
            arrayList.add(string);
            this.hasCategoryChanged = true;
        }
    }

    public void removeCategory(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(CATEGORIES);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(CATEGORIES);
            }
            this.hasCategoryChanged = true;
        }
    }

    public void removeAllCategories() {
        this.removeProperty(CATEGORIES);
        this.hasCategoryChanged = true;
    }

    public void setCategoryChange(boolean bl) {
        this.hasCategoryChanged = bl;
    }

    public boolean hasCategoryChanged() {
        return this.hasCategoryChanged;
    }

    public String getClassification() {
        return (String)this.getProperty(CLASSIFICATION);
    }

    public void setClassification(String string) throws CalendarComponentException {
        if (!string.toUpperCase().startsWith("X") && _classificationValues.get(string.toUpperCase()) == null) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property Value", 112);
            throw calendarComponentException;
        }
        this.setProperty(CLASSIFICATION, string.toUpperCase());
    }

    public boolean isPublic() {
        if (this.hasProperty(CLASSIFICATION)) {
            return CLASSIFICATION_PUBLIC.equals(this.getClassification());
        }
        return false;
    }

    public DateTime getCreated() {
        return (DateTime)this.getProperty(CREATED);
    }

    public String getDescription() {
        return (String)this.getProperty(DESCRIPTION);
    }

    public void setDescription(String string) {
        this.setProperty(DESCRIPTION, string);
        this.hasDescriptionChanged = true;
    }

    public void setDescriptionChange(boolean bl) {
        this.hasDescriptionChanged = bl;
    }

    public boolean hasDescriptionChanged() {
        return this.hasDescriptionChanged;
    }

    public DateTime getLastModified() {
        return (DateTime)this.getProperty(LAST_MODIFIED);
    }

    public void setLastModified(DateTime dateTime) {
        this.setProperty(LAST_MODIFIED, dateTime);
    }

    public String getLocation() {
        return (String)this.getProperty(LOCATION);
    }

    public void setLocation(String string) {
        this.setProperty(LOCATION, string);
        this.hasLocationChanged = true;
    }

    public void setLocationChange(boolean bl) {
        this.hasLocationChanged = bl;
    }

    public boolean hasLocationChanged() {
        return this.hasLocationChanged;
    }

    public String getGeo() {
        return (String)this.getProperty(GEO);
    }

    public void setGeo(String string) throws CalendarComponentException {
        int n = string.indexOf(";");
        if (n == -1) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property value", 112);
            throw calendarComponentException;
        }
        try {
            Float f = new Float(string.substring(0, n));
            Float f2 = new Float(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property value", 112);
            throw calendarComponentException;
        }
        this.setProperty(GEO, string);
    }

    public int getPriority() {
        Integer n = (Integer)this.getProperty(PRIORITY);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setPriority(int n) throws CalendarComponentException {
        if (n > 9 || n < 0) {
            CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property value", 112);
            throw calendarComponentException;
        }
        this.setProperty(PRIORITY, new Integer(n));
    }

    public DateTime getRecurrenceID() {
        return (DateTime)this.getProperty(RECURRENCE_ID);
    }

    public boolean isRecurring() {
        return this.hasProperty(RECURRENCE_ID);
    }

    public String[] getRelatedTos() {
        ArrayList arrayList = (ArrayList)this.getProperty(RELATED_TO);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addRelatedTo(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(RELATED_TO);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(RELATED_TO, arrayList);
            this.hasRelatedToChanged = true;
        } else {
            arrayList.add(string);
            this.hasRelatedToChanged = true;
        }
    }

    public void removeRelatedTo(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RELATED_TO);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RELATED_TO);
            }
            this.hasRelatedToChanged = true;
        }
    }

    public void removeAllRelatedTos() {
        this.removeProperty(RELATED_TO);
        this.hasRelatedToChanged = true;
    }

    public void setRelatedToChange(boolean bl) {
        this.hasRelatedToChanged = bl;
    }

    public boolean hasRelatedToChanged() {
        return this.hasRelatedToChanged;
    }

    public String[] getResources() {
        ArrayList arrayList = (ArrayList)this.getProperty(RESOURCES);
        if (null == arrayList) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public void addResource(String string) {
        ArrayList<String> arrayList = (ArrayList<String>)this.getProperty(RESOURCES);
        if (null == arrayList) {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            this.setProperty(RESOURCES, arrayList);
            this.hasResourceChanged = true;
        } else {
            arrayList.add(string);
            this.hasResourceChanged = true;
        }
    }

    public void removeResource(String string) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RESOURCES);
        if (null != arrayList && -1 != (n = arrayList.indexOf(string))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RESOURCES);
            }
            this.hasResourceChanged = true;
        }
    }

    public void removeAllResources() {
        this.removeProperty(RESOURCES);
        this.hasResourceChanged = true;
    }

    public void setResourceChange(boolean bl) {
        this.hasResourceChanged = bl;
    }

    public boolean hasResourceChanged() {
        return this.hasResourceChanged;
    }

    public int getSequence() {
        Integer n = (Integer)this.getProperty(SEQUENCE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setSequence(int n) {
        this.setProperty(SEQUENCE, new Integer(n));
    }

    public String getStatus() {
        return (String)this.getProperty(STATUS);
    }

    public void setStatus(String string) throws CalendarComponentException {
        if (_statusValues.get(string.toUpperCase()) != null) {
            this.setProperty(STATUS, string.toUpperCase());
            return;
        }
        CalendarComponentException calendarComponentException = new CalendarComponentException("Invalid Property value", 112);
        throw calendarComponentException;
    }

    public String getSummary() {
        return (String)this.getProperty(SUMMARY);
    }

    public void setSummary(String string) {
        this.setProperty(SUMMARY, string);
        this.hasSummaryChanged = true;
    }

    public void setSummaryChange(boolean bl) {
        this.hasSummaryChanged = bl;
    }

    public boolean hasSummaryChanged() {
        return this.hasSummaryChanged;
    }

    public DateTime[] getExceptionDates() {
        ArrayList arrayList = (ArrayList)this.getProperty(EXCEPTION_DATES);
        if (arrayList == null) {
            return null;
        }
        DateTime[] dateTimeArray = new DateTime[arrayList.size()];
        return arrayList.toArray(dateTimeArray);
    }

    public void addExceptionDate(DateTime dateTime) {
        ArrayList<DateTime> arrayList = (ArrayList<DateTime>)this.getProperty(EXCEPTION_DATES);
        if (null == arrayList) {
            arrayList = new ArrayList<DateTime>();
            arrayList.add(dateTime);
            this.setProperty(EXCEPTION_DATES, arrayList);
            this.hasExceptionDateChanged = true;
        } else {
            arrayList.add(dateTime);
            this.hasExceptionDateChanged = true;
        }
    }

    private void addExceptionDate(DateTime dateTime, boolean bl) {
        this.addExceptionDate(dateTime);
        this.hasExceptionDateChanged = bl;
    }

    public void removeExceptionDate(DateTime dateTime) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(EXCEPTION_DATES);
        if (null != arrayList && -1 != (n = arrayList.indexOf(dateTime))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(EXCEPTION_DATES);
            }
            this.hasExceptionDateChanged = true;
        }
    }

    public void removeAllExceptionDates() {
        this.removeProperty(EXCEPTION_DATES);
        this.hasExceptionDateChanged = true;
    }

    public boolean hasExceptionDateChanged() {
        return this.hasExceptionDateChanged;
    }

    public void setExceptionDateChange(boolean bl) {
        this.hasExceptionDateChanged = bl;
    }

    public RecurrencePattern[] getExceptionRules() {
        ArrayList arrayList = (ArrayList)this.getProperty(EXCEPTION_RULE);
        if (null == arrayList) {
            return null;
        }
        RecurrencePattern[] recurrencePatternArray = new RecurrencePattern[arrayList.size()];
        return arrayList.toArray(recurrencePatternArray);
    }

    public void addExceptionRule(RecurrencePattern recurrencePattern) {
        ArrayList<RecurrencePattern> arrayList = (ArrayList<RecurrencePattern>)this.getProperty(EXCEPTION_RULE);
        if (null == arrayList) {
            arrayList = new ArrayList<RecurrencePattern>();
            arrayList.add(recurrencePattern);
            this.setProperty(EXCEPTION_RULE, arrayList);
            this.hasExceptionRuleChanged = true;
        } else {
            arrayList.add(recurrencePattern);
            this.hasExceptionRuleChanged = true;
        }
    }

    private void addExceptionRule(RecurrencePattern recurrencePattern, boolean bl) {
        this.addExceptionRule(recurrencePattern);
        this.hasExceptionRuleChanged = bl;
    }

    public void removeExceptionRule(RecurrencePattern recurrencePattern) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(EXCEPTION_RULE);
        if (null != arrayList && -1 != (n = arrayList.indexOf(recurrencePattern))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(EXCEPTION_RULE);
            }
            this.hasExceptionRuleChanged = true;
        }
    }

    public void removeAllExceptionRules() {
        this.removeProperty(EXCEPTION_RULE);
        this.hasExceptionRuleChanged = true;
    }

    public boolean hasExceptionRuleChanged() {
        return this.hasExceptionRuleChanged;
    }

    public void setExceptionRuleChange(boolean bl) {
        this.hasExceptionRuleChanged = bl;
    }

    public DateTime[] getRecurrenceDates() {
        ArrayList arrayList = (ArrayList)this.getProperty(RECURRENCE_DATES);
        if (arrayList == null) {
            return null;
        }
        DateTime[] dateTimeArray = new DateTime[arrayList.size()];
        return arrayList.toArray(dateTimeArray);
    }

    public void addRecurrenceDate(DateTime dateTime) {
        ArrayList<DateTime> arrayList = (ArrayList<DateTime>)this.getProperty(RECURRENCE_DATES);
        if (null == arrayList) {
            arrayList = new ArrayList<DateTime>();
            arrayList.add(dateTime);
            this.setProperty(RECURRENCE_DATES, arrayList);
            this.hasRecurrenceDateChanged = true;
        } else {
            arrayList.add(dateTime);
            this.hasRecurrenceDateChanged = true;
        }
    }

    private void addRecurrenceDate(DateTime dateTime, boolean bl) {
        this.addRecurrenceDate(dateTime);
        this.hasRecurrenceDateChanged = bl;
    }

    public void removeRecurrenceDate(DateTime dateTime) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RECURRENCE_DATES);
        if (null != arrayList && -1 != (n = arrayList.indexOf(dateTime))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RECURRENCE_DATES);
            }
            this.hasRecurrenceDateChanged = true;
        }
    }

    public void removeAllRecurrenceDates() {
        this.removeProperty(RECURRENCE_DATES);
        this.hasRecurrenceDateChanged = true;
    }

    public boolean hasRecurrenceDateChanged() {
        return this.hasRecurrenceDateChanged;
    }

    public void setRecurrenceDateChange(boolean bl) {
        this.hasRecurrenceDateChanged = bl;
    }

    public RecurrencePattern[] getRecurrenceRules() {
        ArrayList arrayList = (ArrayList)this.getProperty(RECURRENCE_RULE);
        if (null == arrayList) {
            return null;
        }
        RecurrencePattern[] recurrencePatternArray = new RecurrencePattern[arrayList.size()];
        return arrayList.toArray(recurrencePatternArray);
    }

    public void addRecurrenceRule(RecurrencePattern recurrencePattern) {
        ArrayList<RecurrencePattern> arrayList = (ArrayList<RecurrencePattern>)this.getProperty(RECURRENCE_RULE);
        if (null == arrayList) {
            arrayList = new ArrayList<RecurrencePattern>();
            arrayList.add(recurrencePattern);
            this.setProperty(RECURRENCE_RULE, arrayList);
            this.hasRecurrenceRuleChanged = true;
        } else {
            arrayList.add(recurrencePattern);
            this.hasRecurrenceRuleChanged = true;
        }
    }

    private void addRecurrenceRule(RecurrencePattern recurrencePattern, boolean bl) {
        this.addRecurrenceRule(recurrencePattern);
        this.hasRecurrenceRuleChanged = bl;
    }

    public void removeRecurrenceRule(RecurrencePattern recurrencePattern) {
        int n;
        ArrayList arrayList = (ArrayList)this.getProperty(RECURRENCE_RULE);
        if (null != arrayList && -1 != (n = arrayList.indexOf(recurrencePattern))) {
            arrayList.remove(n);
            if (arrayList.size() <= 0) {
                this.removeProperty(RECURRENCE_RULE);
            }
            this.hasRecurrenceRuleChanged = true;
        }
    }

    public void removeAllRecurrenceRules() {
        this.removeProperty(RECURRENCE_RULE);
        this.hasRecurrenceRuleChanged = true;
    }

    public boolean hasRecurrenceRuleChanged() {
        return this.hasRecurrenceRuleChanged;
    }

    public void setRecurrenceRuleChange(boolean bl) {
        this.hasRecurrenceRuleChanged = bl;
    }

    public boolean isConfirmed() {
        return this.hasProperty(STATUS) && this.getStatus().equalsIgnoreCase(STATUS_CONFIRMED);
    }

    public void setMethod(String string) {
        this.setProperty(METHOD, string);
    }

    public String getMethod() {
        return (String)this.getProperty(METHOD);
    }

    public void setStoreType(int n) throws CalendarComponentException, OperationNotSupportedException {
        Serializable serializable;
        if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
            serializable = (Integer)this.getProperty("WCAP_VERSION_INT");
            this.wcapVersionInUse = serializable;
        }
        if (this.wcapVersionInUse < 300) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        if (n != STORETYPE_NONE && n != STORETYPE_CREATE && n != STORETYPE_MODIFY) {
            serializable = new CalendarComponentException("Invalid Property value", 112);
            throw serializable;
        }
        this.setProperty(STORETYPE, new Integer(n));
    }

    public int getStoreType() {
        Integer n = (Integer)this.getProperty(STORETYPE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setReplace(int n) throws OperationNotSupportedException {
        if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
            Integer n2 = (Integer)this.getProperty("WCAP_VERSION_INT");
            this.wcapVersionInUse = n2;
        }
        if (this.wcapVersionInUse < 300) {
            throw new OperationNotSupportedException("Operation Not Supported in this WCAP version", 115);
        }
        this.setProperty(REPLACE, new Integer(n));
    }

    public int getReplace() {
        Integer n = (Integer)this.getProperty(REPLACE);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public String toRFC2445() throws OperationNotSupportedException, CalendarComponentException {
        int n;
        Object[] objectArray;
        String string = "BEGIN:VEVENT";
        if (this.hasProperty(UID)) {
            string = string + "\nUID:" + this.getID();
        }
        if (this.hasProperty(DTSTART)) {
            string = this.isAllDay() ? string + "\nDTSTART:" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getStartTime()) : string + "\nDTSTART:" + this.getStartTime().toISO8601();
        }
        if (this.hasProperty(SUMMARY)) {
            string = string + "\nSUMMARY:" + this.getSummary();
        }
        if (this.hasProperty("DTEND")) {
            string = this.isAllDay() ? string + "\nDTEND:" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getEndTime()) : string + "\nDTEND:" + this.getEndTime().toISO8601();
        }
        if (this.hasProperty(DURATION)) {
            string = string + "\nDURATION:" + this.getDuration().toRFC2445();
        }
        if (this.hasProperty(CALID)) {
            string = string + "\nRELATIVE-CALID:" + this.getCalID();
        }
        if (this.hasProperty(DESCRIPTION)) {
            string = string + "\nDESCRIPTION:" + this.getDescription();
        }
        if (this.hasProperty(LOCATION)) {
            string = string + "\nLOCATION:" + this.getLocation();
        }
        if (this.hasProperty(CLASSIFICATION)) {
            string = string + "\nCLASS:" + this.getClassification();
        }
        if (this.hasProperty(DTSTAMP)) {
            string = string + "\nDTSTAMP:" + this.getStamp().toISO8601();
        }
        if (this.hasProperty(SEQUENCE)) {
            string = string + "\nSEQUENCE:" + Integer.toString(this.getSequence());
        }
        if (this.hasProperty(PRIORITY)) {
            string = string + "\nPRIORITY:" + Integer.toString(this.getPriority());
        }
        if (this.hasProperty(RECURRENCE_ID)) {
            string = string + "\nRECURRENCE-ID:" + this.getRecurrenceID().toISO8601();
        }
        if (this.hasProperty(TRANSP)) {
            string = string + "\nTRANSP:" + (String)this.getProperty(TRANSP);
        }
        if (this.hasProperty(ORGANIZER)) {
            string = string + "\n" + this.getOrganizer().toRFC2445();
        }
        if (this.hasAttendee()) {
            objectArray = this.getAttendees();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\n" + ((Attendee)objectArray[n]).toRFC2445();
                ++n;
            }
        }
        if (this.hasProperty(EXCEPTION_DATES)) {
            objectArray = this.getExceptionDates();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nEXDATE:" + ((DateTime)objectArray[n]).toISO8601();
                ++n;
            }
        }
        if (this.hasProperty(EXCEPTION_RULE)) {
            objectArray = this.getExceptionRules();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nEXRULE:" + ((RecurrencePattern)objectArray[n]).generatePattern();
                ++n;
            }
        }
        if (this.hasProperty(RECURRENCE_DATES)) {
            objectArray = this.getRecurrenceDates();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nRDATE:" + ((DateTime)objectArray[n]).toISO8601();
                ++n;
            }
        }
        if (this.hasProperty(RECURRENCE_RULE)) {
            objectArray = this.getRecurrenceRules();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nRRULE:" + ((RecurrencePattern)objectArray[n]).generatePattern();
                ++n;
            }
        }
        if (this.hasProperty(STATUS)) {
            string = string + "\nSTATUS:" + this.getStatus();
        }
        if (this.hasProperty(GEO)) {
            string = string + "\nGEO:" + this.getGeo();
        }
        if (this.hasProperty(CREATED)) {
            string = string + "\nCREATED:" + ((DateTime)this.getProperty(CREATED)).toISO8601();
        }
        if (this.hasProperty(LAST_MODIFIED)) {
            string = string + "\nLAST-MODIFIED:" + ((DateTime)this.getProperty(LAST_MODIFIED)).toISO8601();
        }
        if (this.hasProperty(ALARM_COMPONENT)) {
            objectArray = this.getAlarmComponents();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\n" + ((SOCSAlarm)objectArray[n]).toRFC2445();
                ++n;
            }
        }
        if (this.hasProperty(ATTACHMENT)) {
            objectArray = this.getAttachments();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\n" + ((Attach)objectArray[n]).toRFC2445();
                ++n;
            }
        }
        if (this.hasProperty(CATEGORIES)) {
            objectArray = this.getCategories();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nCATEGORIES:" + (String)objectArray[n];
                ++n;
            }
        }
        if (this.hasProperty(COMMENT)) {
            objectArray = this.getComments();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nCOMMENT:" + (String)objectArray[n];
                ++n;
            }
        }
        if (this.hasProperty(CONTACT)) {
            objectArray = this.getContacts();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nCONTACT:" + (String)objectArray[n];
                ++n;
            }
        }
        if (this.hasProperty(RSTATUS)) {
            objectArray = this.getRequestStatus();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nRSTATUS:" + (String)objectArray[n];
                ++n;
            }
        }
        if (this.hasProperty(RELATED_TO)) {
            objectArray = this.getRelatedTos();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nRELATED-TO:" + (String)objectArray[n];
                ++n;
            }
        }
        if (this.hasProperty(RESOURCES)) {
            objectArray = this.getResources();
            n = 0;
            while (n < objectArray.length) {
                string = string + "\nRESOURCES:" + (String)objectArray[n];
                ++n;
            }
        }
        string = string + "\nEND:VEVENT";
        return string;
    }

    public void loadFromStream(SOCSSession sOCSSession, Properties properties, Properties properties2) throws ParseException {
        String string;
        TimeZone timeZone = null;
        if (properties2 != null && (string = (String)properties2.get("cal.socs.preferredTimezone")) != null) {
            timeZone = TimeZone.getTimeZone(string);
        }
        if (timeZone == null) {
            timeZone = sOCSSession.getCalStore().getSession().getTimeZone();
        }
        if (timeZone == null) {
            timeZone = sOCSSession.getTimeZone();
        }
        this.wcapVersionInUse = sOCSSession.getCalStore().getProtocolVersionInt();
        this.setProperty("WCAP_VERSION_INT", new Integer(this.wcapVersionInUse));
        int n = 0;
        int n2 = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                Object object;
                Object object2;
                Cloneable cloneable;
                Object object3;
                if (string2.equals(CLASSIFICATION)) {
                    this.setClassification(string3);
                    continue;
                }
                if (string2.equals(CREATED)) {
                    this.setProperty(CREATED, new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals("DESC")) {
                    this.setDescription(string3);
                    continue;
                }
                if (string2.equals("START")) {
                    if (SOCSUtils.isDateAllDay(string3)) {
                        this.setAllDay(true);
                        this.setStartTime(SOCSUtils.parseToAllDayDateTime(string3, timeZone));
                        continue;
                    }
                    this.setStartTime(new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals(GEO)) {
                    this.setGeo(string3);
                    continue;
                }
                if (string2.equals("LAST-MOD")) {
                    this.setProperty(LAST_MODIFIED, new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals(LOCATION)) {
                    this.setLocation(string3);
                    continue;
                }
                if (string2.equals(ORGANIZER)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof Properties)) continue;
                    cloneable = (Properties)object3;
                    object2 = SOCSUtils.parseToOrganizer((Properties)cloneable);
                    this.setOrganizer((Organizer)object2);
                    continue;
                }
                if (string2.equals(PRIORITY)) {
                    this.setPriority(Integer.parseInt(string3));
                    continue;
                }
                if (string2.equals(DTSTAMP)) {
                    this.setStamp(new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals(SEQUENCE)) {
                    this.setSequence(Integer.parseInt(string3));
                    continue;
                }
                if (string2.equals(STATUS)) {
                    this.setStatus(string3);
                    continue;
                }
                if (string2.equals(SUMMARY)) {
                    this.setSummary(string3);
                    continue;
                }
                if (string2.equals(CALID)) {
                    this.setCalID(string3);
                    continue;
                }
                if (string2.equals(TRANSP)) {
                    this.setProperty(TRANSP, string3);
                    continue;
                }
                if (string2.equals(UID)) {
                    string3 = SOCSUtils.trim(string3);
                    this.setID(string3);
                    continue;
                }
                if (string2.equals(URL)) {
                    this.setProperty(URL, string3);
                    continue;
                }
                if (string2.equals("RECURID")) {
                    this.setProperty(RECURRENCE_ID, new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals("END")) {
                    if (SOCSUtils.isDateAllDay(string3)) {
                        this.setEndTime(SOCSUtils.parseToAllDayDateTime(string3, timeZone));
                        continue;
                    }
                    this.setEndTime(new DateTime(string3, timeZone));
                    continue;
                }
                if (string2.equals(DURATION)) {
                    this.setDuration(new Duration(string3));
                    continue;
                }
                if (string2.equals(ATTACHMENT)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (Properties)((ArrayList)cloneable).get(n);
                        object = SOCSUtils.parseToAttach((Properties)object2);
                        this.addAttachment((Attach)object);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(ATTENDEE)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (Properties)((ArrayList)cloneable).get(n);
                        object = SOCSUtils.parseToAttendee((Properties)object2);
                        this.addAttendee((Attendee)object);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(CATEGORIES)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addCategory((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(COMMENT)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addComment((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(CONTACT)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addContact((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(EXCEPTION_DATES)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        object = new DateTime((String)object2, timeZone);
                        this.addRecurrenceDate((DateTime)object, false);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(EXCEPTION_RULE)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        object = new RecurrencePattern((String)object2);
                        this.addExceptionRule((RecurrencePattern)object, false);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(RSTATUS)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addRequestStatus((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(RELATED_TO)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addRelatedTo((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(RESOURCES)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        this.addResource((String)object2);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(RECURRENCE_DATES)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        object = new DateTime((String)object2, timeZone);
                        this.addRecurrenceDate((DateTime)object, false);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals(RECURRENCE_RULE)) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (String)((ArrayList)cloneable).get(n);
                        object = new RecurrencePattern((String)object2);
                        this.addRecurrenceRule((RecurrencePattern)object, false);
                        ++n;
                    }
                    continue;
                }
                if (string2.equals("VALARM")) {
                    object3 = properties.get(string2);
                    if (!(object3 instanceof ArrayList)) continue;
                    cloneable = (ArrayList)object3;
                    n2 = ((ArrayList)cloneable).size();
                    n = 0;
                    while (n < n2) {
                        object2 = (Properties)((ArrayList)cloneable).get(n);
                        object = SOCSUtils.parseToVAlarm((Properties)object2);
                        this.addAlarmComponent((VAlarm)object);
                        ++n;
                    }
                    continue;
                }
                if (string3 == null) continue;
                this.setProperty(string2, string3);
            }
            catch (PropertiesException propertiesException) {
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
            }
            catch (CalendarComponentException calendarComponentException) {
                // empty catch block
            }
        }
        this.hasAttendeeChanged = false;
        this.hasAttachmentChanged = false;
        this.hasAlarmChanged = false;
        this.hasCategoryChanged = false;
        this.hasContactChanged = false;
        this.hasDescriptionChanged = false;
        this.hasExceptionDateChanged = false;
        this.hasExceptionRuleChanged = false;
        this.hasLocationChanged = false;
        this.hasRecurrenceDateChanged = false;
        this.hasRecurrenceRuleChanged = false;
        this.hasRelatedToChanged = false;
        this.hasResourceChanged = false;
        this.hasSummaryChanged = false;
        this.hasUrlChanged = false;
    }

    public VAlarm createAlarm() throws OperationNotSupportedException {
        return new SOCSAlarm();
    }

    public void parseToSOCS(ArrayList arrayList, String string) {
        block172: {
            String string2 = null;
            boolean bl = false;
            try {
                int n;
                int n2;
                StringBuffer stringBuffer;
                Object[] objectArray;
                if (this.wcapVersionInUse <= 0 && this.hasProperty("WCAP_VERSION_INT")) {
                    objectArray = (Integer)this.getProperty("WCAP_VERSION_INT");
                    this.wcapVersionInUse = objectArray.intValue();
                }
                if (this.wcapVersionInUse >= 300 && !(string2 = Integer.toString(this.getStoreType())).equals("-1")) {
                    arrayList.add("storetype=" + SOCSUtils.urlEncode(string2));
                    if (this.getStoreType() == STORETYPE_MODIFY) {
                        if (this.hasProperty(REPLACE)) {
                            string2 = Integer.toString(this.getReplace());
                            if (!string2.equals("-1")) {
                                arrayList.add("replace=" + SOCSUtils.urlEncode(string2));
                                if (this.getReplace() == REPLACE_UPDATE) {
                                    bl = true;
                                }
                            }
                        } else if (this.hasAlarmChanged || this.hasAttachmentChanged || this.hasAttendeeChanged || this.hasCategoryChanged || this.hasContactChanged || this.hasDescriptionChanged || this.hasExceptionDateChanged || this.hasExceptionRuleChanged || this.hasLocationChanged || this.hasRecurrenceDateChanged || this.hasRecurrenceRuleChanged || this.hasRelatedToChanged || this.hasResourceChanged || this.hasSummaryChanged || this.hasUrlChanged) {
                            arrayList.add("replace=" + REPLACE_UPDATE);
                            bl = true;
                        }
                    }
                }
                if (null != (string2 = this.getClassification())) {
                    arrayList.add("icsClass=" + string2);
                }
                if (null != (string2 = this.getDescription())) {
                    arrayList.add("desc=" + SOCSUtils.urlEncode(string2));
                } else if (bl && this.hasDescriptionChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("desc=");
                }
                string2 = this.getGeo();
                if (null != string2) {
                    arrayList.add("geo=" + SOCSUtils.urlEncode(string2));
                }
                if (null != (string2 = this.getLocation())) {
                    arrayList.add("location=" + SOCSUtils.urlEncode(string2));
                } else if (bl && this.hasLocationChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("location=");
                }
                if (this.hasProperty(ORGANIZER) && null != (string2 = (objectArray = this.getOrganizer()).getValue())) {
                    if (string2.toUpperCase().startsWith("MAILTO:")) {
                        string2 = string2.substring(7);
                        arrayList.add("orgEmail=" + SOCSUtils.urlEncode(string2));
                    } else if (this.wcapVersionInUse >= 300) {
                        arrayList.add("orgCalid=" + SOCSUtils.urlEncode(string2));
                    } else {
                        arrayList.add("orgUID=" + SOCSUtils.urlEncode(string2));
                    }
                    string2 = objectArray.getCommonName();
                    if (null != string2 && this.wcapVersionInUse >= 300) {
                        arrayList.add("orgCN=" + SOCSUtils.urlEncode(string2));
                    }
                }
                if (!(string2 = Integer.toString(this.getPriority())).equals("-1")) {
                    arrayList.add("priority=" + SOCSUtils.urlEncode(string2));
                }
                if (null != this.getRecurrenceID()) {
                    arrayList.add("rid=" + this.getRecurrenceID().toISO8601());
                }
                if (!(string2 = Integer.toString(this.getSequence())).equals("-1")) {
                    arrayList.add("sequence=" + SOCSUtils.urlEncode(string2));
                }
                if (null != (string2 = this.getStatus())) {
                    arrayList.add("status=" + SOCSUtils.getSOCSStatus(string2));
                }
                if (null != (string2 = this.getSummary())) {
                    arrayList.add("summary=" + SOCSUtils.urlEncode(string2));
                } else if (bl && this.hasSummaryChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("summary=");
                }
                string2 = this.getID();
                if (null != string2) {
                    arrayList.add("uid=" + SOCSUtils.urlEncode(string2));
                }
                if (null != (string2 = (String)this.getProperty(URL))) {
                    arrayList.add("icsUrl=" + SOCSUtils.urlEncode(string2));
                } else if (bl && this.hasUrlChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("icsUrl=");
                }
                string2 = (String)this.getProperty(TRANSP);
                if (null != string2 && this.wcapVersionInUse >= 300) {
                    arrayList.add("transparent=" + SOCSUtils.getSOCSTransp(string2));
                }
                if (this.isAllDay()) {
                    arrayList.add("isAllDay=1");
                } else {
                    arrayList.add("isAllDay=0");
                }
                if (this.getStartTime() != null) {
                    if (this.isAllDay()) {
                        arrayList.add("dtstart=" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getStartTime()));
                    } else {
                        arrayList.add("dtstart=" + this.getStartTime().toISO8601());
                    }
                }
                if (this.getEndTime() != null) {
                    if (this.isAllDay()) {
                        arrayList.add("dtend=" + SOCSUtils.parseAllDayDateTimeToSOCS(this.getEndTime()));
                    } else {
                        arrayList.add("dtend=" + this.getEndTime().toISO8601());
                    }
                }
                if (this.hasProperty(DURATION)) {
                    objectArray = this.getDuration();
                    string2 = objectArray.toRFC2445();
                    string2 = string2.substring(9);
                    arrayList.add("duration=" + string2);
                }
                if (this.hasProperty(ATTACHMENT)) {
                    objectArray = this.getAttachments();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(((Attach)objectArray[n]).getValue());
                            } else {
                                stringBuffer.append(((Attach)objectArray[n]).getValue() + ";");
                            }
                            ++n;
                        }
                        arrayList.add("attachments=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasAttachmentChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("attachments=");
                }
                if (this.hasProperty(ATTENDEE)) {
                    objectArray = this.getAttendees();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            try {
                                if (n == n2 - 1) {
                                    stringBuffer.append(SOCSUtils.parseAttendeeToSOCS((Attendee)objectArray[n]));
                                } else {
                                    stringBuffer.append(SOCSUtils.parseAttendeeToSOCS((Attendee)objectArray[n]) + ";");
                                }
                            }
                            catch (PropertiesException propertiesException) {
                                // empty catch block
                            }
                            ++n;
                        }
                        arrayList.add("attendees=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasAttendeeChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("attendees=");
                }
                if (this.hasProperty(CATEGORIES)) {
                    objectArray = this.getCategories();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("categories=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasCategoryChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("categories=");
                }
                if (this.hasProperty(COMMENT) && (objectArray = this.getComments()) != null) {
                    stringBuffer = new StringBuffer("");
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        if (n == n2 - 1) {
                            stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]));
                        } else {
                            stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]) + ";");
                        }
                        ++n;
                    }
                    arrayList.add("comments=" + stringBuffer.toString());
                    stringBuffer = null;
                }
                if (this.hasProperty(CONTACT)) {
                    objectArray = this.getContacts();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("contacts=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasContactChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("contacts=");
                }
                if (this.hasProperty(EXCEPTION_DATES)) {
                    objectArray = this.getExceptionDates();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(((DateTime)objectArray[n]).toISO8601());
                            } else {
                                stringBuffer.append(((DateTime)objectArray[n]).toISO8601() + ";");
                            }
                            ++n;
                        }
                        arrayList.add("exdates=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasExceptionDateChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("exdates=");
                }
                if (this.hasProperty(EXCEPTION_RULE)) {
                    objectArray = this.getExceptionRules();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.parseRecurrencePatternToSOCS((RecurrencePattern)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.parseRecurrencePatternToSOCS((RecurrencePattern)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("exrules=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasExceptionRuleChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("exrules=");
                }
                if (this.hasProperty(RELATED_TO)) {
                    objectArray = this.getRelatedTos();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("relatedTos=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasRelatedToChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("relatedTos=");
                }
                if (this.hasProperty(RESOURCES)) {
                    objectArray = this.getResources();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.urlEncode((String)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("resources=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasResourceChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("resources=");
                }
                if (this.hasProperty(RECURRENCE_DATES)) {
                    objectArray = this.getRecurrenceDates();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(((DateTime)objectArray[n]).toISO8601());
                            } else {
                                stringBuffer.append(((DateTime)objectArray[n]).toISO8601() + ";");
                            }
                            ++n;
                        }
                        arrayList.add("rdates=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasRecurrenceDateChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("rdates=");
                }
                if (this.hasProperty(RECURRENCE_RULE)) {
                    objectArray = this.getRecurrenceRules();
                    if (objectArray != null) {
                        stringBuffer = new StringBuffer("");
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            if (n == n2 - 1) {
                                stringBuffer.append(SOCSUtils.parseRecurrencePatternToSOCS((RecurrencePattern)objectArray[n]));
                            } else {
                                stringBuffer.append(SOCSUtils.parseRecurrencePatternToSOCS((RecurrencePattern)objectArray[n]) + ";");
                            }
                            ++n;
                        }
                        arrayList.add("rrules=" + stringBuffer.toString());
                        stringBuffer = null;
                    }
                } else if (bl && this.hasRecurrenceRuleChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("rrules=");
                }
                if (this.hasProperty(ALARM_COMPONENT)) {
                    objectArray = this.getAlarmComponents();
                    if (objectArray != null) {
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            Object object = objectArray[n];
                            string2 = ((VAlarm)object).getAction();
                            if (null != string2) {
                                if (string2.equals("EMAIL")) {
                                    Attendee[] attendeeArray = ((VAlarm)object).getAttendees();
                                    if (attendeeArray != null) {
                                        int n3 = attendeeArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            stringBuffer = new StringBuffer("");
                                            string2 = attendeeArray[n4].getValue();
                                            if (string2.toUpperCase().startsWith("MAILTO:")) {
                                                if (n4 == n3 - 1) {
                                                    stringBuffer.append(string2.substring(7));
                                                } else {
                                                    stringBuffer.append(string2.substring(7) + ";");
                                                }
                                            }
                                            arrayList.add("alarmEmails=" + stringBuffer.toString());
                                            ++n4;
                                        }
                                    }
                                    if (null != (string2 = ((VAlarm)object).getAbsTrigger())) {
                                        arrayList.add("alarmStart=" + string2);
                                    } else if (null != ((VAlarm)object).getTrigger()) {
                                        string2 = ((VAlarm)object).getTrigger().toRFC2445().substring(9);
                                        arrayList.add("alarmStart=" + string2);
                                    }
                                    string2 = ((VAlarm)object).getDescription();
                                    if (null != string2) {
                                        arrayList.add("alarmDescription=" + SOCSUtils.urlEncode(string2));
                                    }
                                } else if (string2.equals("AUDIO")) {
                                    string2 = ((VAlarm)object).getAbsTrigger();
                                    if (null != string2) {
                                        arrayList.add("alarmAudio=" + string2);
                                    } else if (null != ((VAlarm)object).getTrigger()) {
                                        string2 = ((VAlarm)object).getTrigger().toRFC2445().substring(9);
                                        arrayList.add("alarmAudio=" + string2);
                                    }
                                    string2 = ((VAlarm)object).getDescription();
                                    if (null != string2) {
                                        arrayList.add("alarmDescription=" + SOCSUtils.urlEncode(string2));
                                    }
                                } else if (string2.equals("DISPLAY")) {
                                    string2 = ((VAlarm)object).getAbsTrigger();
                                    if (null != string2) {
                                        arrayList.add("alarmPopup=" + string2);
                                    } else if (null != ((VAlarm)object).getTrigger()) {
                                        string2 = ((VAlarm)object).getTrigger().toRFC2445().substring(9);
                                        arrayList.add("alarmPopup=" + string2);
                                    }
                                    string2 = ((VAlarm)object).getDescription();
                                    if (null != string2) {
                                        arrayList.add("alarmDescription=" + SOCSUtils.urlEncode(string2));
                                    }
                                } else if (string2.equals("PROCEDURE")) {
                                    string2 = ((VAlarm)object).getAbsTrigger();
                                    if (null != string2) {
                                        arrayList.add("alarmFlashing=" + string2);
                                    } else if (null != ((VAlarm)object).getTrigger()) {
                                        string2 = ((VAlarm)object).getTrigger().toRFC2445().substring(9);
                                        arrayList.add("alarmFlashing=" + string2);
                                    }
                                    string2 = ((VAlarm)object).getDescription();
                                    if (null != string2) {
                                        arrayList.add("alarmDescription=" + SOCSUtils.urlEncode(string2));
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                } else if (bl && this.hasAlarmChanged && this.wcapVersionInUse >= 300) {
                    arrayList.add("alarmStart=");
                }
                if (null != (string2 = this.getMethod())) {
                    if (string2.equalsIgnoreCase("PUBLISH")) {
                        arrayList.add("method=1");
                    } else if (string2.equalsIgnoreCase("REQUEST")) {
                        arrayList.add("method=2");
                    } else if (string2.equalsIgnoreCase("REPLY")) {
                        arrayList.add("method=4");
                    } else if (string2.equalsIgnoreCase("CANCEL")) {
                        arrayList.add("method=8");
                    } else if (string2.equalsIgnoreCase("MOVE")) {
                        arrayList.add("method=16");
                    } else if (string2.equalsIgnoreCase("COUNTER")) {
                        arrayList.add("method=32");
                    } else if (SOCSUtils.isUserOrganizer(string, this.getOrganizer())) {
                        arrayList.add("method=2");
                    } else {
                        arrayList.add("method=4");
                    }
                    break block172;
                }
                if (string == null || this.getOrganizer() == null) break block172;
                if (SOCSUtils.isUserOrganizer(string, this.getOrganizer())) {
                    arrayList.add("method=2");
                    break block172;
                }
                arrayList.add("method=4");
            }
            catch (OperationNotSupportedException operationNotSupportedException) {
            }
            catch (CalendarComponentException calendarComponentException) {}
        }
    }

    static {
        _statusValues.put(STATUS_TENTATIVE, "Dummy1");
        _statusValues.put(STATUS_CONFIRMED, "Dummy2");
        _statusValues.put(STATUS_CANCELLED, "Dummy3");
        _classificationValues.put(CLASSIFICATION_CONFIDENTIAL, "Dummy1");
        _classificationValues.put(CLASSIFICATION_PRIVATE, "Dummy2");
        _classificationValues.put(CLASSIFICATION_PUBLIC, "Dummy3");
    }
}

