/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar.socs;

import com.sun.comclient.calendar.CalendarException;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.URLName;
import com.sun.comclient.calendar.socs.SOCSCalendar;
import com.sun.comclient.calendar.socs.SOCSException;
import com.sun.comclient.calendar.socs.SOCSRequest;
import com.sun.comclient.calendar.socs.SOCSResponse;
import com.sun.comclient.calendar.socs.SOCSSession;
import com.sun.comclient.calendar.socs.SOCSUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class SOCSCalendarStore
extends CalendarStore {
    public static final int CONTAINS = 0;
    public static final int BEGINS_WITH = 1;
    public static final int ENDS_WITH = 2;
    public static final int EXACT = 3;
    public static final String MIN_SUPPORTED_VERSION_STRING = "2.0.0";
    public static final String WCAP_VERSION_3_0_0 = "3.0.0";
    public static final String WCAP_VERSION_3_1_0 = "3.1.0";
    public static final int WCAP_VERSION_3_0_0_INT = 300;
    public static final int WCAP_VERSION_3_1_0_INT = 310;
    SOCSSession socsSession = null;
    private URL serverURL = null;
    private String protoVersion = null;
    private int protoVersionInt = 0;
    private static String ICAL_FORMAT_TYPE = "text/calendar";
    private static String XML_FORMAT_TYPE = "text/xml";

    public SOCSCalendarStore(CalendarSession calendarSession) {
        super(calendarSession);
    }

    protected void connectURL(URLName uRLName) throws CalendarStoreException {
        CalendarSession calendarSession = this.getSession();
        try {
            this.serverURL = uRLName.getURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new CalendarStoreException(malformedURLException.toString(), 103);
        }
        this.makeValidSOCSSession();
        calendarSession.setProperty("cal.host", uRLName.getHost());
        calendarSession.setProperty("cal.port", Integer.toString(uRLName.getPort()));
        TimeZone timeZone = calendarSession.getTimeZone();
        if (timeZone == null && this.getSOCSSession().getPreference("icsTimezone") != null) {
            String string = this.getSOCSSession().getPreference("icsTimezone").trim();
            if (string.length() > 0) {
                calendarSession.setTimeZone(TimeZone.getTimeZone(string));
            } else {
                calendarSession.setTimeZone(TimeZone.getDefault());
            }
        }
        if (this.getSOCSSession().getPreference("ceDefaultAlarmEmail") != null) {
            this.getSession().setProperty("cal.reminderAddresses", this.getSOCSSession().getPreference("ceDefaultAlarmEmail"));
        }
        if (this.getSOCSSession().getPreference("ceClock") != null) {
            this.getSession().setProperty("cal.clock", this.getSOCSSession().getPreference("ceClock"));
        }
        if (this.getSOCSSession().getPreference("ceDefaultAlarmStart") != null) {
            this.getSession().setProperty("cal.defaultAlarmStart", this.getSOCSSession().getPreference("ceDefaultAlarmStart"));
        }
        if (this.getSOCSSession().getPreference("ceDateOrder") != null) {
            this.getSession().setProperty("cal.dateOrder", this.getSOCSSession().getPreference("ceDateOrder"));
        }
        if (this.getSOCSSession().getPreference("ceDateSeparator") != null) {
            this.getSession().setProperty("cal.dateSeparator", this.getSOCSSession().getPreference("ceDateSeparator"));
        }
        if (this.getSOCSSession().getPreference("ceDefaultView") != null) {
            this.getSession().setProperty("cal.defaultView", this.getSOCSSession().getPreference("ceDefaultView"));
        }
        if (this.getSOCSSession().getPreference("ceDayHead") != null) {
            this.getSession().setProperty("cal.dayStart", this.getSOCSSession().getPreference("ceDayHead"));
        }
        if (this.getSOCSSession().getPreference("ceDayTail") != null) {
            this.getSession().setProperty("cal.dayEnd", this.getSOCSSession().getPreference("ceDayTail"));
        }
        if (this.getSOCSSession().getPreference("icsFirstDay") != null) {
            this.getSession().setProperty("cal.firstDayOfWeek", this.getSOCSSession().getPreference("icsFirstDay"));
        }
    }

    public void disconnect() throws CalendarStoreException {
        if (this.socsSession != null) {
            this.socsSession.logout();
            this.socsSession = null;
            this.serverURL = null;
        }
    }

    public boolean isConnected() {
        if (this.socsSession == null) {
            return false;
        }
        return this.socsSession.isValid();
    }

    public ICalendar[] getCalendars() throws CalendarStoreException {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        String string = null;
        string = this.getDefaultCalendarId();
        Vector vector2 = this.getSOCSSession().getSubscribedCalendars();
        int n = 0;
        while (n < vector2.size()) {
            objectArray = (Object[])vector2.elementAt(n);
            if (objectArray.getCalID().startsWith(string.trim())) {
                if (objectArray.getCalID().equals(string)) {
                    vector.addElement(objectArray);
                } else if (objectArray.getCalID().startsWith(string + ":")) {
                    vector.addElement(objectArray);
                }
            }
            ++n;
        }
        objectArray = null;
        objectArray = new ICalendar[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getSubscribedCalenders() throws CalendarStoreException {
        String[] stringArray = null;
        Vector vector = this.getSOCSSession().getSubscribedCalendars();
        stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = new String(((ICalendar)vector.elementAt(n)).getCalID());
            ++n;
        }
        return stringArray;
    }

    public String verifyCalendarId(String string) throws CalendarStoreException {
        if (string == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        Vector vector = this.getSOCSSession().searchForCalendars(string, 0, 1);
        if (vector.size() > 0) {
            return ((ICalendar)vector.elementAt(0)).getCalID();
        }
        return null;
    }

    protected String getDefaultCalendarId() throws CalendarStoreException {
        return this.getSOCSSession().getDefaultCalendar();
    }

    protected ICalendar loadCalendar(String string) throws CalendarStoreException {
        if (string == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        return new SOCSCalendar(this, string);
    }

    public ICalendar[] searchCalendars(String string, Properties properties) throws CalendarStoreException {
        return this.searchCalendars(string, 0, 200, properties);
    }

    public ICalendar[] searchCalendars(String string) throws CalendarStoreException {
        return this.searchCalendars(string, 0, 200);
    }

    public ICalendar[] searchCalendars(String string, int n, int n2) throws CalendarStoreException {
        return this.searchCalendars(string, n, n2, null);
    }

    public ICalendar[] searchCalendars(String string, int n, int n2, Properties properties) throws CalendarStoreException {
        Vector vector = this.getSOCSSession().searchForCalendars(string, n, n2, properties);
        Object[] objectArray = null;
        if (vector != null) {
            objectArray = new ICalendar[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    protected void unloadCalendar(ICalendar iCalendar) throws CalendarStoreException {
        if (iCalendar == null) {
            throw new CalendarStoreException("Invalid Calendar object: null", 110);
        }
    }

    public ICalendar createCalendar(String string) throws CalendarStoreException {
        return this.createCalendar(string, null);
    }

    public ICalendar createCalendar(String string, Properties properties) throws CalendarStoreException {
        SOCSCalendar sOCSCalendar = null;
        if (string == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        sOCSCalendar = this.getSOCSSession().createCalendar(string, properties);
        return sOCSCalendar;
    }

    public void deleteCalendar(String string) throws CalendarStoreException {
        if (string == null) {
            throw new CalendarStoreException("Invalid Calendar ID: null", 110);
        }
        this.getSOCSSession().deleteCalendar(string);
        this.closeCalendar(string);
    }

    public BufferedReader exportCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2) throws CalendarStoreException {
        return this.exportCalendar(string, dateTime, dateTime2, string2, null, -1);
    }

    public BufferedReader exportCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2, String string3, int n) throws CalendarStoreException {
        SOCSRequest sOCSRequest = null;
        BufferedReader bufferedReader = null;
        if (string == null) {
            throw new CalendarStoreException("Illegal Calendar ID: null ", 110);
        }
        sOCSRequest = this.createAnonOrSessionReq(string3, n);
        if (sOCSRequest == null) {
            throw new CalendarStoreException("Unable to export calendar  because, either a valid session doesnot exist or could not connect to backend service", 104);
        }
        if (string2 == null) {
            string2 = ICAL_FORMAT_TYPE;
        } else if (!string2.equalsIgnoreCase(ICAL_FORMAT_TYPE) && !string2.equalsIgnoreCase(XML_FORMAT_TYPE)) {
            throw new CalendarStoreException("Invalid Content Format specified: " + string2, 105);
        }
        try {
            bufferedReader = sOCSRequest.exportCalendar(string, dateTime, dateTime2, string2);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarStoreException("Failed to export calendar. " + sOCSException.getMessage(), sOCSException.getError());
        }
        return bufferedReader;
    }

    public void importCalendar(String string, String string2, InputStream inputStream) throws CalendarStoreException {
        this.importCalendar(string, null, null, string2, inputStream);
    }

    public void importCalendar(String string, DateTime dateTime, DateTime dateTime2, String string2, InputStream inputStream) throws CalendarStoreException {
        SOCSRequest sOCSRequest = null;
        SOCSSession sOCSSession = null;
        if (string == null) {
            throw new CalendarStoreException("Illegal Calendar ID: null ", 110);
        }
        if (!this.isConnected()) {
            throw new CalendarStoreException("No Valid Session. Cannot Import data.", 109);
        }
        sOCSSession = this.getSOCSSession();
        sOCSRequest = new SOCSRequest(sOCSSession);
        if (string2 == null) {
            string2 = ICAL_FORMAT_TYPE;
        } else if (!string2.equalsIgnoreCase(ICAL_FORMAT_TYPE) && !string2.equalsIgnoreCase(XML_FORMAT_TYPE)) {
            throw new CalendarStoreException("Invalid Content Format specified: " + string2, 105);
        }
        try {
            sOCSRequest.importCalendar(string, dateTime, dateTime2, string2, inputStream);
        }
        catch (SOCSException sOCSException) {
            throw new CalendarStoreException(sOCSException.getMessage(), sOCSException.getError());
        }
    }

    public URL getServiceURL() {
        return this.serverURL;
    }

    public SOCSSession getSOCSSession() throws CalendarStoreException {
        if (this.socsSession == null) {
            this.makeValidSOCSSession();
        }
        return this.socsSession;
    }

    private SOCSSession makeValidSOCSSession() throws CalendarStoreException {
        try {
            if (!this.isConnected()) {
                URLName uRLName = this.getServiceUrl();
                String string = uRLName.getUsername();
                String string2 = uRLName.getPassword();
                CalendarSession calendarSession = this.getSession();
                if (string == null || string.length() == 0) {
                    string = calendarSession.getProperty("cal.user");
                }
                if (string2 == null || string2.length() == 0) {
                    string2 = calendarSession.getProperty("cal.password");
                }
                this.setProtocolVersionToUse();
                this.socsSession = SOCSSession.login(this, string, string2, calendarSession.getProperty("cal.proxyauth"));
            }
            return this.socsSession;
        }
        catch (CalendarException calendarException) {
            throw new CalendarStoreException(calendarException.getMessage(), calendarException.getError());
        }
    }

    private SOCSRequest createAnonOrSessionReq(String string, int n) throws CalendarStoreException {
        SOCSSession sOCSSession = null;
        SOCSRequest sOCSRequest = null;
        URLName uRLName = null;
        URLName uRLName2 = null;
        if (this.socsSession != null) {
            if (string != null) {
                if (n <= 0) {
                    n = -1;
                }
                if ((uRLName = this.getServiceUrl()) != null && string.equalsIgnoreCase(uRLName.getHost()) && n == uRLName.getPort() && this.isConnected()) {
                    sOCSSession = this.getSOCSSession();
                    sOCSRequest = new SOCSRequest(sOCSSession);
                }
                if (uRLName == null || sOCSSession == null && sOCSRequest == null) {
                    uRLName2 = new URLName(this.getSession().getProperty("cal.protocol", "http"), string, n, "", null, null);
                    sOCSSession = SOCSSession.getInstance(this);
                    try {
                        sOCSRequest = new SOCSRequest(uRLName2.getURL(), sOCSSession);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new CalendarStoreException("Incorrect Service URL", 103);
                    }
                }
            } else if (this.isConnected()) {
                sOCSSession = this.getSOCSSession();
                sOCSRequest = new SOCSRequest(sOCSSession);
            }
        }
        if (this.socsSession == null || sOCSRequest == null && sOCSSession == null) {
            if (string == null) {
                throw new CalendarStoreException("Invalid Host: null", 105);
            }
            n = Integer.parseInt(this.getSession().getProperty("cal.port", "-1"));
            if (n <= 0) {
                n = -1;
            }
            uRLName2 = new URLName(this.getSession().getProperty("cal.protocol", "http"), string, n, "", null, null);
            sOCSSession = SOCSSession.getInstance(this);
            try {
                sOCSRequest = new SOCSRequest(uRLName2.getURL(), sOCSSession);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CalendarStoreException("Incorrect Service URL", 103);
            }
        }
        return sOCSRequest;
    }

    public void setProtocolVersion(String string) {
        this.protoVersion = string;
    }

    public String getProtocolVersion() {
        return this.protoVersion;
    }

    public int getProtocolVersionInt() {
        return this.protoVersionInt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProtocolVersionToUse() throws CalendarStoreException {
        Properties properties;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        SOCSRequest sOCSRequest = new SOCSRequest(this);
        SOCSResponse sOCSResponse = null;
        try {
            sOCSResponse = sOCSRequest.getProtoVersion();
        }
        catch (SOCSException sOCSException) {
            throw new CalendarStoreException(sOCSException.getMessage(), sOCSException.getError());
        }
        if (sOCSResponse != null && (properties = sOCSResponse.getProperties(0)) != null && (string = properties.getProperty("X-NSCP-WCAPVERSION")) != null) {
            int n = 0;
            string.trim();
            try {
                n = SOCSUtils.versionToInt(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                try {
                    n = SOCSUtils.versionToInt(MIN_SUPPORTED_VERSION_STRING);
                }
                catch (NumberFormatException numberFormatException2) {
                    n = 200;
                }
            }
            if (this.protoVersion != null) {
                this.protoVersion.trim();
                int n2 = 0;
                try {
                    n2 = SOCSUtils.versionToInt(this.protoVersion);
                    bl2 = true;
                }
                catch (NumberFormatException numberFormatException) {
                    bl2 = false;
                    try {
                        n2 = SOCSUtils.versionToInt(MIN_SUPPORTED_VERSION_STRING);
                    }
                    catch (NumberFormatException numberFormatException3) {
                        n2 = 200;
                    }
                }
                if (n2 > n) throw new CalendarStoreException("Unsupported Protocol version", 114);
                if (!bl2) {
                    this.protoVersion = MIN_SUPPORTED_VERSION_STRING;
                }
                this.protoVersionInt = n2;
            } else {
                this.protoVersion = bl ? string : MIN_SUPPORTED_VERSION_STRING;
                this.protoVersionInt = n;
            }
        }
        sOCSRequest = null;
        sOCSResponse = null;
        if (this.protoVersion != null) return;
        this.protoVersion = MIN_SUPPORTED_VERSION_STRING;
        this.protoVersionInt = 200;
    }
}

