/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.desktop.taglib;

import com.sun.portal.desktop.taglib.DesktopTaglibContext;
import com.sun.portal.desktop.taglib.DesktopTaglibException;
import com.sun.portal.providers.Provider;
import com.sun.portal.providers.containers.ContainerProvider;
import java.io.IOException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class BaseDesktopTagSupport
extends TagSupport {
    private static final String VARIABLE_PREFIX = "$";
    protected DesktopTaglibContext mdttlContext = null;
    protected String mId = null;
    protected int mScope = 1;
    protected boolean m_silentException = false;
    public static final int UNDEFINED = 0;
    public static final int PROVIDER = 1;
    public static final int CONTAINER = 2;

    protected static boolean toBoolean(String name) {
        return name != null && name.toLowerCase().equals("true");
    }

    public void setId(String id) {
        if (id != null && id.length() > 0) {
            this.mId = id;
        }
    }

    public void setSilentException(String silentException) {
        this.m_silentException = BaseDesktopTagSupport.toBoolean(silentException);
    }

    public void setScope(String scope) {
        if (scope != null) {
            if (scope.equalsIgnoreCase("request")) {
                this.mScope = 2;
            } else if (scope.equalsIgnoreCase("session")) {
                this.mScope = 3;
            } else if (scope.equalsIgnoreCase("application")) {
                this.mScope = 4;
            }
        }
    }

    public void setParent(Tag t) {
        super.setParent(t);
        this.mdttlContext = null;
        this.mId = null;
        boolean mScope = true;
        boolean m_silentException = false;
    }

    protected void processResult(Object result) throws DesktopTaglibException {
        if (this.mId != null) {
            this.pageContext.setAttribute(this.mId, result, this.mScope);
        } else {
            try {
                this.pageContext.getOut().print(result);
            }
            catch (IOException e) {
                throw new DesktopTaglibException(e);
            }
        }
    }

    protected int processException(DesktopTaglibException t) throws DesktopTaglibException {
        return this.processException(t, 0, null);
    }

    protected int processException(DesktopTaglibException t, Object retObj) throws DesktopTaglibException {
        return this.processException(t, 0, retObj);
    }

    protected int processException(DesktopTaglibException t, int returnVal, Object retObj) throws DesktopTaglibException {
        if (this.m_silentException) {
            if (this.mId != null && retObj != null) {
                this.pageContext.setAttribute(this.mId, retObj, this.mScope);
            }
            return returnVal;
        }
        throw t;
    }

    protected boolean isContextVariable(String parameter) {
        if (parameter != null) {
            return parameter.startsWith(VARIABLE_PREFIX);
        }
        return false;
    }

    protected Object resolveParameter(String parameter) throws DesktopTaglibException {
        if (this.isContextVariable(parameter)) {
            String var = this.getVariable(parameter);
            Object obj = this.pageContext.findAttribute(var);
            if (obj == null) {
                throw new DesktopTaglibException(3, var);
            }
            return obj;
        }
        return parameter;
    }

    protected String getVariable(String parameter) {
        if (this.isContextVariable(parameter)) {
            return parameter.substring(VARIABLE_PREFIX.length());
        }
        return parameter;
    }

    protected void loadDesktopTaglibContext() {
        if (this.mdttlContext == null) {
            this.mdttlContext = (DesktopTaglibContext)this.pageContext.getAttribute("__PROVIDER_STACK__");
            if (this.mdttlContext == null) {
                // empty if block
            }
        }
    }

    protected void saveDesktopTaglibContext() {
        this.pageContext.setAttribute("__PROVIDER_STACK__", (Object)this.mdttlContext);
    }

    protected Provider getProvider() throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        Provider p = this.mdttlContext.getCurrentProvider();
        if (p == null) {
            throw new DesktopTaglibException(4);
        }
        return p;
    }

    protected void setCurrentProvider(Provider p) throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        this.mdttlContext.setCurrentProvider(p);
    }

    protected ContainerProvider getContainer() throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        ContainerProvider c = this.mdttlContext.getContainer();
        if (c == null) {
            throw new DesktopTaglibException(4);
        }
        return c;
    }

    protected void setCurrentContainer(ContainerProvider cp) throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        this.mdttlContext.setContainer(cp);
    }

    protected void setParentCurrent() throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        this.mdttlContext.setParentCurrent();
    }

    protected void unsetParentCurrent() throws DesktopTaglibException {
        this.loadDesktopTaglibContext();
        this.mdttlContext.unsetParentCurrent();
    }

    protected int getCurrentObjType() {
        this.loadDesktopTaglibContext();
        return this.mdttlContext.getCurrentObjType();
    }

    protected Provider getCurrentObj() throws DesktopTaglibException {
        switch (this.getCurrentObjType()) {
            case 1: {
                return this.getProvider();
            }
            case 2: {
                return (Provider)this.getContainer();
            }
        }
        throw new DesktopTaglibException(4);
    }

    protected void cacheObj(String key, Object obj) {
        this.pageContext.setAttribute(key, obj, 2);
    }

    protected Object getCachedObj(String key) {
        return this.pageContext.findAttribute(key);
    }

    protected void clearCache(String key) {
    }

    protected void clearCache() {
    }
}

