/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.DefaultErrorHandler;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionNode;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.XPathParser;
import org.apache.xpath.functions.Function;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;
import org.w3c.dom.Node;

public class XPath
implements Serializable,
ExpressionOwner {
    private Expression m_mainExp;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    private static final boolean DEBUG_MATCHES = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    public String getPatternString() {
        return this.m_patternString;
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_mainExp.fixupVariables(vars, globalsSize);
    }

    public SourceLocator getLocator() {
        return this.m_mainExp;
    }

    public Expression getExpression() {
        return this.m_mainExp;
    }

    public XPath(Expression expr) {
        this.setExpression(expr);
    }

    public void setExpression(Expression exp) {
        if (null != this.m_mainExp) {
            exp.exprSetParent(this.m_mainExp.exprGetParent());
        }
        this.m_mainExp = exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.m_mainExp.execute(xctxt);
            double d = score.num();
            Object var7_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bool(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        try {
            try {
                var4_4 = this.m_mainExp.bool(xctxt);
                var10_6 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                return var4_4;
            }
            catch (TransformerException te) {
                te.setLocator(this.getLocator());
                el = xctxt.getErrorListener();
                if (null == el) throw te;
                el.error(te);
                var10_7 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                return false;
            }
            catch (Exception e) {
                if (true) ** GOTO lbl30
            }
        }
        catch (Throwable var9_16) {
            var10_9 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw var9_16;
        }
        do {
            e = ((WrappedRuntimeException)e).getException();
lbl30:
            // 2 sources

        } while (e instanceof WrappedRuntimeException);
        msg = e.getMessage();
        if (msg == null || msg.length() == 0) {
            msg = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
        }
        te = new TransformerException(msg, this.getLocator(), e);
        el = xctxt.getErrorListener();
        if (null == el) throw te;
        el.fatalError(te);
        var10_8 = null;
        xctxt.popNamespaceContext();
        xctxt.popCurrentNodeAndExpression();
        return false;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        this.m_mainExp.callVisitors(this, visitor);
    }

    public void installFunction(String name, int funcIndex, Function func) {
        FunctionTable.installFunction(func, funcIndex);
    }

    public void error(XPathContext xctxt, int sourceNode, String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.fatalError(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        } else {
            SourceLocator slocator = xctxt.getSAXLocator();
            System.out.println(fmsg + "; file " + slocator.getSystemId() + "; line " + slocator.getLineNumber() + "; column " + slocator.getColumnNumber());
        }
    }

    public void warn(XPathContext xctxt, int sourceNode, String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.warning(new TransformerException(fmsg, (SAXSourceLocator)xctxt.getSAXLocator()));
        }
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, locator, prefixResolver, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XObject execute(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        xctxt.pushNamespaceContext(namespaceContext);
        xctxt.pushCurrentNodeAndExpression(contextNode, contextNode);
        XObject xobj = null;
        try {
            String msg;
            Exception e2;
            block8: {
                try {
                    xobj = this.m_mainExp.execute(xctxt);
                }
                catch (TransformerException te) {
                    te.setLocator(this.getLocator());
                    ErrorListener el = xctxt.getErrorListener();
                    if (null == el) throw te;
                    el.error(te);
                    Object var11_6 = null;
                    xctxt.popNamespaceContext();
                    xctxt.popCurrentNodeAndExpression();
                    return xobj;
                }
                catch (Exception e2) {
                    break block8;
                }
                Object var11_5 = null;
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
                return xobj;
            }
            while (true) {
                if (!(e2 instanceof WrappedRuntimeException)) {
                    msg = e2.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                    }
                    break;
                }
                e2 = ((WrappedRuntimeException)e2).getException();
            }
            TransformerException te = new TransformerException(msg, this.getLocator(), e2);
            ErrorListener el = xctxt.getErrorListener();
            if (null == el) throw te;
            el.fatalError(te);
            Object var11_7 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            return xobj;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            xctxt.popNamespaceContext();
            xctxt.popCurrentNodeAndExpression();
            throw throwable;
        }
    }

    public XPath(String exprString, SourceLocator locator, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener, locator);
        Compiler compiler = new Compiler(errorListener, locator);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
        if (null != locator && locator instanceof ExpressionNode) {
            expr.exprSetParent((ExpressionNode)locator);
        }
    }

    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        return this.execute(xctxt, xctxt.getDTMHandleFromNode(contextNode), namespaceContext);
    }
}

