/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.dom;

import java.util.Vector;
import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.dom.Axis;
import org.apache.xml.dtm.DTMAxisIterator;

public abstract class NodeCounter
implements Axis {
    public static final int END = -1;
    protected int _node = -1;
    protected int _nodeType = -1;
    protected int _value = Integer.MIN_VALUE;
    public final DOM _document;
    public final DTMAxisIterator _iterator;
    public final Translet _translet;
    protected String _format;
    protected String _lang;
    protected String _letterValue;
    protected String _groupSep;
    protected int _groupSize;
    private boolean separFirst = true;
    private boolean separLast = false;
    private Vector separToks = null;
    private Vector formatToks = null;
    private int nSepars = 0;
    private int nFormats = 0;
    private static String[] Thousands = new String[]{"", "m", "mm", "mmm"};
    private static String[] Hundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] Tens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] Ones = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};

    public boolean matchesCount(int node) {
        return this._nodeType == this._document.getExpandedTypeID(node);
    }

    public boolean matchesFrom(int node) {
        return false;
    }

    public abstract String getCounter();

    protected String formatNumbers(int value) {
        return this.formatNumbers(new int[]{value});
    }

    private String romanValue(int n) {
        if (n <= 0 || n > 4000) {
            return "" + n;
        }
        return Thousands[n / 1000] + Hundreds[n / 100 % 10] + Tens[n / 10 % 10] + Ones[n % 10];
    }

    private String alphaValue(int value, int min, int max) {
        if (value <= 0) {
            return "" + value;
        }
        int range = max - min + 1;
        char last = (char)((value - 1) % range + min);
        if (value > range) {
            return this.alphaValue((value - 1) / range, min, max) + last;
        }
        return "" + last;
    }

    protected String formatNumbers(int[] values) {
        int nValues = values.length;
        int length = this._format.length();
        boolean isEmpty = true;
        int i = 0;
        while (i < nValues) {
            if (values[i] != Integer.MIN_VALUE) {
                isEmpty = false;
            }
            ++i;
        }
        if (isEmpty) {
            return "";
        }
        boolean isFirst = true;
        int t = 0;
        int n = 0;
        int s = 1;
        StringBuffer buffer = new StringBuffer();
        if (this.separFirst) {
            buffer.append((String)this.separToks.elementAt(0));
        }
        while (n < nValues) {
            int value = values[n];
            if (value != Integer.MIN_VALUE) {
                if (!isFirst) {
                    buffer.append((String)this.separToks.elementAt(s++));
                }
                this.formatValue(value, (String)this.formatToks.elementAt(t++), buffer);
                if (t == this.nFormats) {
                    --t;
                }
                if (s >= this.nSepars) {
                    --s;
                }
                isFirst = false;
            }
            ++n;
        }
        if (this.separLast) {
            buffer.append((String)this.separToks.lastElement());
        }
        return buffer.toString();
    }

    public NodeCounter setDefaultFormatting() {
        this.setFormatting("1", "en", "alphabetic", null, null);
        return this;
    }

    public abstract NodeCounter setStartNode(int var1);

    public NodeCounter setValue(int value) {
        this._value = value;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private void formatValue(int value, String format, StringBuffer buffer) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            c = format.charAt(0);
                            if (!Character.isDigit((char)c)) break block7;
                            zero = (char)(c - Character.getNumericValue((char)c));
                            temp = buffer;
                            if (this._groupSize > 0) {
                                temp = new StringBuffer();
                            }
                            s = "";
                            n = value;
                            while (n > 0) {
                                s = (char)(zero + n % 10) + s;
                                n /= 10;
                            }
                            i = 0;
                            while (i < format.length() - s.length()) {
                                temp.append(zero);
                                ++i;
                            }
                            temp.append(s);
                            if (this._groupSize > 0) {
                                i = 0;
                                while (i < temp.length()) {
                                    if (i != 0 && (temp.length() - i) % this._groupSize == 0) {
                                        buffer.append(this._groupSep);
                                    }
                                    buffer.append(temp.charAt(i));
                                    ++i;
                                }
                            }
                            break block8;
                        }
                        if (c != 105 || this._letterValue.equals("alphabetic")) break block9;
                        buffer.append(this.romanValue(value));
                        break block8;
                    }
                    if (c != 73 || this._letterValue.equals("alphabetic")) break block10;
                    buffer.append(this.romanValue(value).toUpperCase());
                    break block8;
                }
                min = c;
                max = c;
                if (c < 945 || c > 969) ** GOTO lbl49
                max = 969;
                break block11;
lbl-1000:
                // 1 sources

                {
                    ++max;
lbl49:
                    // 2 sources

                    ** while (Character.isLetterOrDigit((char)((char)(max + '\u0001'))))
                }
            }
            buffer.append(this.alphaValue(value, min, max));
        }
    }

    protected NodeCounter(Translet translet, DOM document, DTMAxisIterator iterator) {
        this._translet = translet;
        this._document = document;
        this._iterator = iterator;
    }

    protected void setFormatting(String format, String lang, String letterValue, String groupSep, String groupSize) {
        this._lang = lang;
        this._format = format;
        this._groupSep = groupSep;
        this._letterValue = letterValue;
        try {
            this._groupSize = Integer.parseInt(groupSize);
        }
        catch (NumberFormatException e) {
            this._groupSize = 0;
        }
        int length = this._format.length();
        boolean isFirst = true;
        this.separFirst = true;
        this.separLast = false;
        this.separToks = new Vector();
        this.formatToks = new Vector();
        int j = 0;
        int i = 0;
        while (i < length) {
            char c = this._format.charAt(i);
            j = i;
            while (Character.isLetterOrDigit(c)) {
                if (++i == length) break;
                c = this._format.charAt(i);
            }
            if (i > j) {
                if (isFirst) {
                    this.separToks.addElement(".");
                    this.separFirst = false;
                    isFirst = false;
                }
                this.formatToks.addElement(this._format.substring(j, i));
            }
            if (i == length) break;
            c = this._format.charAt(i);
            j = i;
            while (!Character.isLetterOrDigit(c)) {
                if (++i == length) break;
                c = this._format.charAt(i);
                isFirst = false;
            }
            if (i <= j) continue;
            this.separToks.addElement(this._format.substring(j, i));
        }
        this.nSepars = this.separToks.size();
        this.nFormats = this.formatToks.size();
        if (this.nSepars > this.nFormats) {
            this.separLast = true;
        }
        if (this.separFirst) {
            --this.nSepars;
        }
        if (this.separLast) {
            --this.nSepars;
        }
        if (this.nSepars == 0) {
            this.separToks.insertElementAt(".", 1);
            ++this.nSepars;
        }
        if (this.separFirst) {
            ++this.nSepars;
        }
    }

    public String getCounter(String format, String lang, String letterValue, String groupSep, String groupSize) {
        this.setFormatting(format, lang, letterValue, groupSep, groupSize);
        return this.getCounter();
    }
}

