/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.VariableLengthInstruction;
import org.apache.bcel.generic.Visitor;

public class GOTO
extends GotoInstruction
implements VariableLengthInstruction {
    GOTO() {
    }

    protected int updatePosition(int offset, int max_offset) {
        int i = this.getTargetOffset();
        this.position += offset;
        if (Math.abs(i) >= Short.MAX_VALUE - max_offset) {
            this.opcode = (short)200;
            this.length = (short)5;
            return 2;
        }
        return 0;
    }

    public void dump(DataOutputStream out) throws IOException {
        this.index = this.getTargetOffset();
        if (this.opcode == 167) {
            super.dump(out);
        } else {
            this.index = this.getTargetOffset();
            out.writeByte(this.opcode);
            out.writeInt(this.index);
        }
    }

    public GOTO(InstructionHandle target) {
        super((short)167, target);
    }

    public void accept(Visitor v) {
        v.visitVariableLengthInstruction(this);
        v.visitUnconditionalBranch(this);
        v.visitBranchInstruction(this);
        v.visitGotoInstruction(this);
        v.visitGOTO(this);
    }
}

