/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

public abstract class FieldInstruction
extends FieldOrMethod
implements TypedInstruction {
    FieldInstruction() {
    }

    protected FieldInstruction(short opcode, int index) {
        super(opcode, index);
    }

    protected int getFieldSize(ConstantPoolGen cpg) {
        return this.getType(cpg).getSize();
    }

    public String toString(ConstantPool cp) {
        return Constants.OPCODE_NAMES[this.opcode] + " " + cp.constantToString(this.index, (byte)9);
    }

    public String getFieldName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getFieldType(ConstantPoolGen cpg) {
        return Type.getType(this.getSignature(cpg));
    }

    public Type getType(ConstantPoolGen cpg) {
        return this.getFieldType(cpg);
    }
}

